/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine.process;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.CachedNodeSupplier;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.engine.process.BufferedRows;

public class CountableSequence
extends NodeSequence {
    private final NodeSequence original;
    private final BufferedRows.BufferedRowFactory<? extends BufferedRows.BufferedRow> rowFactory;
    private final BufferManager.QueueBuffer<BufferedRows.BufferedRow> buffer;
    protected final AtomicLong remainingRowCount = new AtomicLong();
    protected final String workspaceName;
    protected final int width;
    private Iterator<BufferedRows.BufferedRow> bufferedRows;
    private final AtomicLong batchSize = new AtomicLong();
    private long totalSize = -1L;

    public CountableSequence(String workspaceName, NodeSequence original, BufferManager bufferMgr, CachedNodeSupplier nodeCache, boolean useHeap) {
        this.original = original;
        this.workspaceName = workspaceName;
        this.width = original.width();
        assert (!original.isEmpty());
        assert (original.getRowCount() == -1L);
        assert (original.width() != 0);
        this.rowFactory = BufferedRows.serializer(nodeCache, this.width);
        BufferedRows.BufferedRowFactory<? extends BufferedRows.BufferedRow> rowSerializer = BufferedRows.serializer(nodeCache, this.width);
        this.buffer = bufferMgr.createQueueBuffer(rowSerializer).useHeap(useHeap).make();
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public long getRowCount() {
        this.initialize();
        assert (this.totalSize >= 0L);
        return this.totalSize;
    }

    @Override
    public final NodeSequence.Batch nextBatch() {
        this.initialize();
        return this.doNextBatch();
    }

    protected NodeSequence.Batch doNextBatch() {
        return this.batchFrom(this.bufferedRows, this.batchSize.get());
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public final void initialize() {
        if (this.bufferedRows == null) {
            this.doInitialize();
        }
    }

    protected void doInitialize() {
        this.totalSize = this.loadAll(this.original, this.buffer, this.batchSize);
        this.remainingRowCount.set(this.totalSize);
        this.original.close();
        this.bufferedRows = this.buffer.iterator();
    }

    protected long loadAll(NodeSequence sequence, BufferManager.QueueBuffer<BufferedRows.BufferedRow> buffer, AtomicLong batchSize) {
        return this.loadAll(sequence, buffer, batchSize, null, 0);
    }

    protected long loadAll(NodeSequence sequence, BufferManager.QueueBuffer<BufferedRows.BufferedRow> buffer, AtomicLong batchSize, Queue<NodeSequence.Batch> inMemoryBatches, int numRowsInMemory) {
        NodeSequence.Batch copy;
        NodeSequence.Batch batch = sequence.nextBatch();
        boolean loadIntoMemory = numRowsInMemory > 0 && inMemoryBatches != null;
        long numInMemory = 0L;
        while (batch != null && batchSize.get() == 0L) {
            if (loadIntoMemory) {
                copy = NodeSequence.batchWithCount(batch);
                inMemoryBatches.add(copy);
                batchSize.set(copy.rowCount());
                numInMemory += copy.rowCount();
                numRowsInMemory = (int)((long)numRowsInMemory - batchSize.get());
                if (numRowsInMemory <= 0) {
                    loadIntoMemory = false;
                }
            } else {
                while (batch.hasNext()) {
                    batch.nextRow();
                    buffer.append(this.createRow(batch));
                    batchSize.incrementAndGet();
                }
            }
            batch = sequence.nextBatch();
        }
        while (batch != null) {
            if (loadIntoMemory) {
                copy = NodeSequence.batchWithCount(batch);
                inMemoryBatches.add(copy);
                numInMemory += copy.rowCount();
                numRowsInMemory = (int)((long)numRowsInMemory - copy.rowCount());
                if (numRowsInMemory <= 0) {
                    loadIntoMemory = false;
                }
            } else {
                while (batch.hasNext()) {
                    batch.nextRow();
                    buffer.append(this.createRow(batch));
                }
            }
            batch = sequence.nextBatch();
        }
        return buffer.size() + numInMemory;
    }

    protected BufferedRows.BufferedRow createRow(NodeSequence.Batch currentRow) {
        return this.rowFactory.createRow(currentRow);
    }

    protected NodeSequence.Batch batchFrom(final Iterator<BufferedRows.BufferedRow> rows, long maxBatchSize) {
        if (this.remainingRowCount.get() <= 0L || !rows.hasNext()) {
            return null;
        }
        if (maxBatchSize == 0L) {
            return NodeSequence.emptyBatch(this.workspaceName, this.width);
        }
        final long rowsInBatch = Math.min(maxBatchSize, this.remainingRowCount.get());
        return new NodeSequence.Batch(){
            private BufferedRows.BufferedRow current;

            @Override
            public int width() {
                return CountableSequence.this.width;
            }

            @Override
            public long rowCount() {
                return rowsInBatch;
            }

            @Override
            public String getWorkspaceName() {
                return CountableSequence.this.workspaceName;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean hasNext() {
                return CountableSequence.this.remainingRowCount.get() > 0L && rows.hasNext();
            }

            @Override
            public void nextRow() {
                this.current = (BufferedRows.BufferedRow)rows.next();
                CountableSequence.this.remainingRowCount.decrementAndGet();
            }

            @Override
            public CachedNode getNode() {
                return this.current.getNode();
            }

            @Override
            public CachedNode getNode(int index) {
                return this.current.getNode(index);
            }

            @Override
            public float getScore() {
                return this.current.getScore();
            }

            @Override
            public float getScore(int index) {
                return this.current.getScore(index);
            }
        };
    }
}

