/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.jcr.query.model.ArithmeticOperator;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.query.model.Visitors;

@Immutable
public class ArithmeticOperand
implements DynamicOperand,
org.modeshape.jcr.api.query.qom.ArithmeticOperand {
    private static final long serialVersionUID = 1L;
    private final Set<SelectorName> selectorNames;
    private final ArithmeticOperator operator;
    private final DynamicOperand left;
    private final DynamicOperand right;
    private final int hc;

    public ArithmeticOperand(DynamicOperand left, ArithmeticOperator operator, DynamicOperand right) {
        CheckArg.isNotNull((Object)((Object)operator), (String)"operator");
        this.selectorNames = SelectorName.nameSetFrom(left.selectorNames(), right.selectorNames());
        this.operator = operator;
        this.left = left;
        this.right = right;
        this.hc = HashCode.compute((Object[])new Object[]{left, operator, right});
    }

    @Override
    public Set<SelectorName> selectorNames() {
        return this.selectorNames;
    }

    public ArithmeticOperator operator() {
        return this.operator;
    }

    public DynamicOperand getLeft() {
        return this.left;
    }

    public DynamicOperand getRight() {
        return this.right;
    }

    public String getOperator() {
        switch (this.operator()) {
            case ADD: {
                return "jcr.arithmetic.operator.add";
            }
            case DIVIDE: {
                return "jcr.arithmetic.operator.divide";
            }
            case MULTIPLY: {
                return "jcr.arithmetic.operator.multiply";
            }
            case SUBTRACT: {
                return "jcr.arithmetic.operator.subtract";
            }
        }
        assert (false);
        return null;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArithmeticOperand) {
            ArithmeticOperand that = (ArithmeticOperand)obj;
            return this.operator() == that.operator() && this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

