/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.txn;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.txn.Transactions;

public final class SynchronizedTransactions
extends Transactions {
    private static final ThreadLocal<Transactions.NestableThreadLocalTransaction> LOCAL_TRANSACTION = new ThreadLocal();
    private final Cache localCache;
    private final AtomicReference<TransactionListener> transactionListener = new AtomicReference();
    private final TransactionTable transactionTable;
    private final ConcurrentHashMap<Long, SynchronizedTransaction> activeTransactionsByISPNGlobalTxId = new ConcurrentHashMap();
    protected static final Set<String> ACTIVE_TRACE_SYNCHRONIZATIONS = new HashSet<String>();

    public SynchronizedTransactions(TransactionManager txnMgr, Cache localCache) {
        super(txnMgr);
        assert (this.txnMgr != null);
        this.localCache = localCache;
        assert (this.localCache != null);
        this.transactionTable = localCache.getAdvancedCache().getComponentRegistry().getTransactionTable();
        assert (this.transactionTable != null);
    }

    @Override
    public Transactions.Transaction currentTransaction() {
        Transactions.Transaction localTx = LOCAL_TRANSACTION.get();
        if (localTx != null) {
            return localTx;
        }
        try {
            Transaction txn = this.txnMgr.getTransaction();
            if (txn == null) {
                return null;
            }
            GlobalTransaction ispnTx = this.transactionTable.getGlobalTransaction(txn);
            return ispnTx != null ? this.activeTransactionsByISPNGlobalTxId.get(ispnTx.getId()) : null;
        }
        catch (SystemException e) {
            this.logger.debug((Throwable)e, "Cannot determine if there is an active transaction or not", new Object[0]);
            return null;
        }
    }

    @Override
    public Transactions.Transaction begin() throws NotSupportedException, SystemException {
        GlobalTransaction globalTransaction;
        Transactions.NestableThreadLocalTransaction localTx = LOCAL_TRANSACTION.get();
        if (localTx != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Found active ModeShape transaction '{0}' ", new Object[]{localTx});
            }
            return localTx.begin();
        }
        Transaction txn = this.txnMgr.getTransaction();
        if (txn == null) {
            this.txnMgr.begin();
            localTx = new Transactions.NestableThreadLocalTransaction(this, this.txnMgr, LOCAL_TRANSACTION).begin();
            return this.logTransactionInformation(localTx);
        }
        if (this.transactionListener.get() == null && this.transactionListener.compareAndSet(null, new TransactionListener())) {
            this.localCache.addListener((Object)this.transactionListener.get());
        }
        if ((globalTransaction = this.transactionTable.getGlobalTransaction(txn)) == null) {
            this.logger.debug("Active transaction detected, but the Infinispan cache isn't aware of it. Suspending it for the duration of the ModeShape transaction...", new Object[0]);
            final Transaction suspended = this.txnMgr.suspend();
            assert (suspended != null);
            this.txnMgr.begin();
            localTx = new Transactions.NestableThreadLocalTransaction(this, this.txnMgr, LOCAL_TRANSACTION).begin();
            localTx.uponCompletion(new Transactions.TransactionFunction(){

                @Override
                public void execute() {
                    try {
                        SynchronizedTransactions.this.txnMgr.resume(suspended);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return this.logTransactionInformation(localTx);
        }
        long ispnTxId = globalTransaction.getId();
        SynchronizedTransaction userTx = this.activeTransactionsByISPNGlobalTxId.get(ispnTxId);
        if (userTx != null) {
            return userTx;
        }
        userTx = new SynchronizedTransaction(this.txnMgr, globalTransaction);
        SynchronizedTransaction activeTx = this.activeTransactionsByISPNGlobalTxId.putIfAbsent(ispnTxId, userTx);
        return activeTx != null ? activeTx : this.logTransactionInformation(userTx);
    }

    private Transactions.Transaction logTransactionInformation(Transactions.Transaction transaction) throws SystemException {
        if (!this.logger.isTraceEnabled()) {
            return transaction;
        }
        this.logger.trace("Created & stored new ModeShape synchronized transaction '{0}' ", new Object[]{transaction});
        Transaction txn = this.txnMgr.getTransaction();
        assert (txn != null);
        String id = txn.toString();
        if (!ACTIVE_TRACE_SYNCHRONIZATIONS.contains(id)) {
            if (transaction instanceof SynchronizedTransaction) {
                this.logger.trace("Found user transaction {0}", new Object[]{txn});
            } else {
                this.logger.trace("Begin transaction {0}", new Object[]{id});
            }
            try {
                txn.registerSynchronization((Synchronization)new TransactionTracer(id));
            }
            catch (RollbackException e) {
                return new RollbackOnlyTransaction();
            }
        } else {
            this.logger.trace("Tracer already registered for transaction {0}", new Object[]{id});
        }
        return transaction;
    }

    protected SynchronizedTransaction clearActiveTx(long ispnTxId) {
        return this.activeTransactionsByISPNGlobalTxId.remove(ispnTxId);
    }

    protected boolean hasTxFor(long ispnTxId) {
        return this.activeTransactionsByISPNGlobalTxId.containsKey(ispnTxId);
    }

    @Override
    public void updateCache(final WorkspaceCache workspace, final ChangeSet changes, Transactions.Transaction transaction) {
        if (changes != null && !changes.isEmpty()) {
            if (transaction instanceof SynchronizedTransaction) {
                transaction.uponCommit(new Transactions.TransactionFunction(){

                    @Override
                    public void execute() {
                        workspace.changed(changes);
                    }
                });
                if (workspace instanceof TransactionalWorkspaceCache) {
                    ((TransactionalWorkspaceCache)workspace).changedWithinTransaction(changes);
                }
            } else if (!(transaction instanceof RollbackOnlyTransaction)) {
                workspace.changed(changes);
            }
        }
    }

    protected final class TransactionTracer
    implements Synchronization {
        private String txnId;

        protected TransactionTracer(String id) {
            this.txnId = id;
            ACTIVE_TRACE_SYNCHRONIZATIONS.add(id);
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            ACTIVE_TRACE_SYNCHRONIZATIONS.remove(this.txnId);
            switch (status) {
                case 3: {
                    SynchronizedTransactions.this.logger.trace("Commit transaction '{0}'", new Object[]{this.txnId});
                    break;
                }
                case 4: {
                    SynchronizedTransactions.this.logger.trace("Roll back transaction '{0}'", new Object[]{this.txnId});
                    break;
                }
            }
        }
    }

    protected class RollbackOnlyTransaction
    implements Transactions.Transaction {
        @Override
        public int status() {
            return 5;
        }

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }

        @Override
        public void uponCompletion(Transactions.TransactionFunction function) {
        }

        @Override
        public void uponCommit(Transactions.TransactionFunction function) {
        }
    }

    @Listener
    protected final class TransactionListener {
        protected TransactionListener() {
        }

        @TransactionCompleted
        public void transactionCompleted(TransactionCompletedEvent event) {
            if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                SynchronizedTransactions.this.logger.trace("Received transaction completed event: '{0}'", new Object[]{event});
            }
            if (!event.isOriginLocal()) {
                if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                    SynchronizedTransactions.this.logger.trace("Ignoring event '{0}' because it did not originate on this cluster node", new Object[]{event});
                }
                return;
            }
            GlobalTransaction eventIspnTransaction = event.getGlobalTransaction();
            if (eventIspnTransaction == null) {
                if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                    SynchronizedTransactions.this.logger.trace("Ignoring event '{0}' because there is no mapped active user transaction", new Object[]{event});
                }
                return;
            }
            long ispnTxId = eventIspnTransaction.getId();
            if (SynchronizedTransactions.this.hasTxFor(ispnTxId)) {
                SynchronizedTransaction synchronizedTransaction = SynchronizedTransactions.this.clearActiveTx(ispnTxId);
                if (synchronizedTransaction != null) {
                    if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                        SynchronizedTransactions.this.logger.trace("ISPN transaction {0} has been committed by ISPN. Running ModeShape-specific post-commit functions...", new Object[]{eventIspnTransaction});
                    }
                    if (event.isTransactionSuccessful()) {
                        synchronizedTransaction.executeFunctionsUponCommit();
                    }
                    synchronizedTransaction.executeFunctionsUponCompletion();
                } else if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                    SynchronizedTransactions.this.logger.trace("Unable to locate ModeShape transaction corresponding to ISPN transaction {0}", new Object[]{eventIspnTransaction});
                }
            } else if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                SynchronizedTransactions.this.logger.trace("Ignoring event '{0}' because the transaction '{1}' is  a local, not a user transaction", new Object[]{event, ispnTxId});
            }
        }
    }

    public final class SynchronizedTransaction
    extends Transactions.BaseTransaction {
        private final GlobalTransaction ispnTransaction;

        protected SynchronizedTransaction(TransactionManager txnMgr, GlobalTransaction ispnTransaction) {
            super(SynchronizedTransactions.this, txnMgr);
            this.ispnTransaction = ispnTransaction;
        }

        @Override
        public void commit() {
            if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                SynchronizedTransactions.this.logger.trace("'{0}' ignoring commit call coming from ModeShape. Waiting to be notified by Infinispan'", new Object[]{this});
            }
        }

        @Override
        public void rollback() {
            if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                SynchronizedTransactions.this.logger.trace("'{0}' ignoring rollback call coming from ModeShape. Waiting to be notified by Infinispan'", new Object[]{this});
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SynchronizedTransaction{");
            sb.append("infinispanTransaction=").append(this.ispnTransaction);
            sb.append('}');
            return sb.toString();
        }

        public GlobalTransaction ispnTransaction() {
            return this.ispnTransaction;
        }
    }
}

