/*
 * ModeShape (http://www.modeshape.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.modeshape.jcr.cache.change;

import java.util.Set;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;

/**
 * A change event which is generated by a {@link javax.jcr.Node#orderBefore(String, String)} operation.
 * 
 * @author Horia Chiorean
 */
public class NodeReordered extends AbstractNodeChange {

    private static final long serialVersionUID = 1L;

    private final Path oldPath;
    private final NodeKey parent;
    private final Path reorderedBeforePath;

    public NodeReordered( NodeKey key,
                          Name primaryType,
                          Set<Name> mixinTypes,
                          NodeKey parent,
                          Path newPath,
                          Path oldPath,
                          Path reorderedBeforePath ) {
        super(key, newPath, primaryType, mixinTypes);
        this.oldPath = oldPath;
        this.parent = parent;
        this.reorderedBeforePath = reorderedBeforePath;
    }

    public Path getOldPath() {
        return oldPath;
    }

    public NodeKey getParent() {
        return parent;
    }

    /**
     * Gets the path of the node at the "destination" of the reordering.
     * 
     * @return either a node path or <code>null</code>, in case a reordering has happened at the end of the children list
     */
    public Path getReorderedBeforePath() {
        return reorderedBeforePath;
    }
}
