/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.jcr.RepositoryException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.spi.ObjectFactory;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;
import org.xml.sax.SAXException;

public class JndiRepositoryFactory
implements ObjectFactory {
    protected static final Logger LOG = Logger.getLogger(JndiRepositoryFactory.class);
    private static final String CONFIG_FILE = "configFile";
    private static final String CONFIG_FILES = "configFiles";
    private static final String REPOSITORY_NAME = "repositoryName";
    private static final ModeShapeEngine ENGINE = new ModeShapeEngine();

    static Future<Boolean> shutdown() {
        return ENGINE.shutdown();
    }

    private static synchronized JcrRepository getRepository(String configFileName, String repositoryName, Context nameCtx, Name jndiName) throws IOException, RepositoryException, NamingException {
        block13: {
            if (!StringUtil.isBlank((String)repositoryName)) {
                ENGINE.start();
                try {
                    JcrRepository repository = ENGINE.getRepository(repositoryName);
                    switch (repository.getState()) {
                        case STARTING: 
                        case RUNNING: {
                            return repository;
                        }
                    }
                    LOG.error((I18nResource)JcrI18n.repositoryIsNotRunningOrHasBeenShutDown, new Object[]{repositoryName});
                    return null;
                }
                catch (NoSuchRepositoryException e) {
                    if (configFileName != null) break block13;
                    throw e;
                }
            }
        }
        RepositoryConfiguration config = RepositoryConfiguration.read(configFileName);
        if (repositoryName == null) {
            repositoryName = config.getName();
        } else if (!repositoryName.equals(config.getName())) {
            LOG.warn((I18nResource)JcrI18n.repositoryNameDoesNotMatchConfigurationName, new Object[]{repositoryName, config.getName(), configFileName});
        }
        ENGINE.start();
        JcrRepository repository = ENGINE.deploy(config);
        try {
            ENGINE.startRepository(repository.getName()).get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RepositoryException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RepositoryException(e.getCause());
        }
        if (nameCtx instanceof EventContext) {
            JndiRepositoryFactory.registerNamingListener((EventContext)nameCtx, jndiName);
        }
        return repository;
    }

    private static void registerNamingListener(EventContext evtCtx, final Name jndiName) throws NamingException {
        NamespaceChangeListener listener = new NamespaceChangeListener(){

            @Override
            public void namingExceptionThrown(NamingExceptionEvent evt) {
                evt.getException().printStackTrace();
            }

            @Override
            public void objectAdded(NamingEvent evt) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void objectRemoved(NamingEvent evt) {
                Object oldObject = evt.getOldBinding().getObject();
                if (!(oldObject instanceof JcrRepository)) {
                    return;
                }
                JcrRepository repository = (JcrRepository)oldObject;
                String repoName = repository.getName();
                try {
                    ENGINE.shutdownRepository(repoName).get();
                }
                catch (NoSuchRepositoryException noSuchRepositoryException) {
                }
                catch (InterruptedException ie) {
                    LOG.error((Throwable)ie, (I18nResource)JcrI18n.errorWhileShuttingDownRepositoryInJndi, new Object[]{repoName, jndiName});
                }
                catch (ExecutionException e) {
                    LOG.error(e.getCause(), (I18nResource)JcrI18n.errorWhileShuttingDownRepositoryInJndi, new Object[]{repoName, jndiName});
                }
                finally {
                    ENGINE.shutdown(false);
                }
            }

            @Override
            public void objectRenamed(NamingEvent evt) {
            }
        };
        evtCtx.addNamingListener(jndiName, 0, (NamingListener)listener);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws IOException, SAXException, RepositoryException, NamingException {
        Set<String> configFiles;
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        RefAddr repositoryName = ref.get(REPOSITORY_NAME);
        String repoName = repositoryName != null ? repositoryName.getContent().toString() : null;
        RefAddr configFileRef = ref.get(CONFIG_FILE);
        String configFile = configFileRef != null ? configFileRef.getContent().toString() : null;
        RefAddr configFilesRef = ref.get(CONFIG_FILES);
        Set<String> set = configFiles = configFilesRef != null ? this.parseStrings(configFilesRef.getContent().toString()) : null;
        if (!StringUtil.isBlank((String)repoName) && !StringUtil.isBlank((String)configFile)) {
            return JndiRepositoryFactory.getRepository(configFile, repoName, nameCtx, name);
        }
        if (configFiles != null) {
            for (String file : configFiles) {
                JndiRepositoryFactory.getRepository(file, null, nameCtx, name);
            }
            return ENGINE;
        }
        return null;
    }

    protected Set<String> parseStrings(String value) {
        if (StringUtil.isBlank((String)value)) {
            return Collections.emptySet();
        }
        value = value.trim();
        HashSet<String> result = new HashSet<String>();
        for (String strValue : value.split(",")) {
            if (StringUtil.isBlank((String)strValue)) continue;
            result.add(strValue.trim());
        }
        return result;
    }
}

