/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.NoOpEncoder;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.RepositoryEnvironment;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.document.BucketId;
import org.modeshape.jcr.cache.document.BucketedChildReferences;
import org.modeshape.jcr.cache.document.DocumentConstants;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.ImmutableChildReferences;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.value.BinaryFactory;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.basic.NodeKeyReference;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.EmptyBinaryValue;
import org.modeshape.jcr.value.binary.ExternalBinaryValue;
import org.modeshape.jcr.value.binary.InMemoryBinaryValue;
import org.modeshape.schematic.DocumentFactory;
import org.modeshape.schematic.Schematic;
import org.modeshape.schematic.SchematicEntry;
import org.modeshape.schematic.document.Array;
import org.modeshape.schematic.document.Binary;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableArray;
import org.modeshape.schematic.document.EditableDocument;
import org.modeshape.schematic.document.Null;

public class DocumentTranslator
implements DocumentConstants {
    private final DocumentStore documentStore;
    private final AtomicLong largeStringSize = new AtomicLong();
    private final ExecutionContext context;
    private final PropertyFactory propertyFactory;
    private final ValueFactories factories;
    private final PathFactory paths;
    private final NameFactory names;
    private final DateTimeFactory dates;
    private final BinaryFactory binaries;
    private final ValueFactory<Long> longs;
    private final ValueFactory<Double> doubles;
    private final ValueFactory<URI> uris;
    private final ValueFactory<BigDecimal> decimals;
    private final ValueFactory<String> strings;
    private final ReferenceFactory refs;
    private final ReferenceFactory weakrefs;
    private final ReferenceFactory simplerefs;
    private final TextEncoder encoder = NoOpEncoder.getInstance();
    private final TextDecoder decoder = NoOpEncoder.getInstance();

    public DocumentTranslator(ExecutionContext context, DocumentStore documentStore, long largeStringSize) {
        this.documentStore = documentStore;
        this.largeStringSize.set(largeStringSize);
        this.context = context;
        this.propertyFactory = this.context.getPropertyFactory();
        this.factories = this.context.getValueFactories();
        this.paths = this.factories.getPathFactory();
        this.names = this.factories.getNameFactory();
        this.dates = this.factories.getDateFactory();
        this.binaries = this.factories.getBinaryFactory();
        this.longs = this.factories.getLongFactory();
        this.doubles = this.factories.getDoubleFactory();
        this.uris = this.factories.getUriFactory();
        this.decimals = this.factories.getDecimalFactory();
        this.refs = this.factories.getReferenceFactory();
        this.weakrefs = this.factories.getWeakReferenceFactory();
        this.simplerefs = this.factories.getSimpleReferenceFactory();
        this.strings = this.factories.getStringFactory();
        assert (this.largeStringSize.get() >= 0L);
    }

    public DocumentTranslator withLargeStringSize(long largeStringSize) {
        return new DocumentTranslator(this.context, this.documentStore, largeStringSize);
    }

    public final ValueFactory<String> getStringFactory() {
        return this.strings;
    }

    public final NameFactory getNameFactory() {
        return this.names;
    }

    public final ReferenceFactory getReferenceFactory() {
        return this.refs;
    }

    public final PropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }

    void setMinimumStringLengthForBinaryStorage(long largeValueSize) {
        assert (largeValueSize > -1L);
        this.largeStringSize.set(largeValueSize);
    }

    public NodeKey getParentKey(Document document, String primaryWorkspaceKey, String secondaryWorkspaceKey) {
        Object value = document.get("parent");
        return this.keyFrom(value, primaryWorkspaceKey, secondaryWorkspaceKey);
    }

    public Set<NodeKey> getAdditionalParentKeys(Document document) {
        Object value = document.get("parent");
        if (value instanceof String) {
            return Collections.emptySet();
        }
        if (value instanceof List) {
            List values = (List)value;
            if (values.size() == 1) {
                return Collections.emptySet();
            }
            LinkedHashSet<NodeKey> keys = new LinkedHashSet<NodeKey>();
            Iterator iter = values.iterator();
            iter.next();
            while (iter.hasNext()) {
                Object v = iter.next();
                if (v == null) continue;
                String key = (String)v;
                keys.add(new NodeKey(key));
            }
            return keys;
        }
        return Collections.emptySet();
    }

    private final NodeKey keyFrom(Object value, String primaryWorkspaceKey, String secondaryWorkspaceKey) {
        if (value instanceof String) {
            return new NodeKey((String)value);
        }
        if (value instanceof List) {
            List values = (List)value;
            if (values.size() == 1) {
                return this.keyFrom(values.get(0), primaryWorkspaceKey, secondaryWorkspaceKey);
            }
            NodeKey keyWithSecondaryWorkspaceKey = null;
            for (Object v : values) {
                if (v == null) continue;
                NodeKey key = new NodeKey((String)v);
                if (key.getWorkspaceKey().equals(primaryWorkspaceKey)) {
                    return key;
                }
                if (keyWithSecondaryWorkspaceKey != null || secondaryWorkspaceKey == null || !key.getWorkspaceKey().equals(secondaryWorkspaceKey)) continue;
                keyWithSecondaryWorkspaceKey = key;
            }
            return keyWithSecondaryWorkspaceKey;
        }
        return null;
    }

    public void getProperties(Document document, Map<Name, Property> result) {
        Document properties = document.getDocument("properties");
        if (properties != null) {
            for (Document.Field nsField : properties.fields()) {
                String namespaceUri = nsField.getName();
                Document nsDoc = nsField.getValueAsDocument();
                for (Document.Field propField : nsDoc.fields()) {
                    String localName = propField.getName();
                    Name propertyName = this.names.create(namespaceUri, localName);
                    if (result.containsKey(propertyName)) continue;
                    Object fieldValue = propField.getValue();
                    Property property = this.propertyFor(propertyName, fieldValue);
                    result.put(propertyName, property);
                }
            }
        }
    }

    public int countProperties(Document document) {
        Document properties = document.getDocument("properties");
        if (properties == null) {
            return 0;
        }
        int count = 0;
        for (Document.Field nsField : properties.fields()) {
            Document urlProps = nsField.getValueAsDocument();
            if (urlProps == null) continue;
            for (Document.Field propField : urlProps.fields()) {
                if (Null.matches((Object)propField.getValue())) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean hasProperties(Document document) {
        Document properties = document.getDocument("properties");
        if (properties == null) {
            return false;
        }
        for (Document.Field nsField : properties.fields()) {
            Document urlProps = nsField.getValueAsDocument();
            if (urlProps == null) continue;
            for (Document.Field propField : urlProps.fields()) {
                if (Null.matches((Object)propField.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasProperty(Document document, Name propertyName) {
        Document properties = document.getDocument("properties");
        if (properties == null) {
            return false;
        }
        Document urlProps = properties.getDocument(propertyName.getNamespaceUri());
        if (urlProps == null) {
            return false;
        }
        Object fieldValue = urlProps.get(propertyName.getLocalName());
        return !Null.matches((Object)fieldValue);
    }

    public Property getProperty(Document document, String propertyName) {
        return this.getProperty(document, (Name)this.names.create(propertyName));
    }

    public Property getProperty(Document document, Name propertyName) {
        Document properties = document.getDocument("properties");
        if (properties == null) {
            return null;
        }
        Document urlProps = properties.getDocument(propertyName.getNamespaceUri());
        if (urlProps == null) {
            return null;
        }
        Object fieldValue = urlProps.get(propertyName.getLocalName());
        return fieldValue == null ? null : this.propertyFor(propertyName, fieldValue);
    }

    public Name getPrimaryType(Document document) {
        Property primaryType = this.getProperty(document, JcrLexicon.PRIMARY_TYPE);
        return primaryType != null ? (Name)this.names.create(primaryType.getFirstValue()) : null;
    }

    public String getPrimaryTypeName(Document document) {
        return this.strings.create(this.getProperty(document, JcrLexicon.PRIMARY_TYPE).getFirstValue());
    }

    public Set<Name> getMixinTypes(Document document) {
        Property prop = this.getProperty(document, JcrLexicon.MIXIN_TYPES);
        if (prop == null || prop.size() == 0) {
            return Collections.emptySet();
        }
        if (prop.size() == 1) {
            Name name = (Name)this.names.create(prop.getFirstValue());
            return Collections.singleton(name);
        }
        HashSet<Name> result = new HashSet<Name>();
        for (Object value : prop) {
            Name name = (Name)this.names.create(value);
            result.add(name);
        }
        return result;
    }

    public Set<String> getMixinTypeNames(Document document) {
        Property prop = this.getProperty(document, JcrLexicon.MIXIN_TYPES);
        if (prop == null || prop.size() == 0) {
            return Collections.emptySet();
        }
        if (prop.size() == 1) {
            String name = this.strings.create(prop.getFirstValue());
            return Collections.singleton(name);
        }
        HashSet<String> result = new HashSet<String>();
        for (Object value : prop) {
            String name = this.strings.create(value);
            result.add(name);
        }
        return result;
    }

    protected Property propertyFor(Name propertyName, Object fieldValue) {
        Object value = this.valueFromDocument(fieldValue);
        if (value instanceof List) {
            List values = (List)value;
            return this.propertyFactory.create(propertyName, values);
        }
        return this.propertyFactory.create(propertyName, value);
    }

    public void setProperty(EditableDocument document, Property property, Set<BinaryKey> unusedBinaryKeys, Set<BinaryKey> usedBinaryKeys) {
        Name propertyName;
        String namespaceUri;
        EditableDocument urlProps;
        EditableDocument properties = document.getDocument("properties");
        if (properties == null) {
            properties = document.setDocument("properties");
        }
        if ((urlProps = properties.getDocument(namespaceUri = (propertyName = property.getName()).getNamespaceUri())) == null) {
            urlProps = properties.setDocument(namespaceUri);
        }
        String localName = propertyName.getLocalName();
        Object oldValue = urlProps.get(localName);
        this.decrementBinaryReferenceCount(oldValue, unusedBinaryKeys, usedBinaryKeys);
        if (property.isEmpty()) {
            urlProps.setArray(localName);
        } else if (property.isMultiple()) {
            EditableArray values = Schematic.newArray((int)property.size());
            for (Object v : property) {
                values.add(this.valueToDocument(v, unusedBinaryKeys, usedBinaryKeys));
            }
            urlProps.setArray(localName, (Array)values);
        } else {
            assert (property.isSingle());
            Object value = this.valueToDocument(property.getFirstValue(), unusedBinaryKeys, usedBinaryKeys);
            if (value == null) {
                urlProps.remove(localName);
            } else {
                urlProps.set(localName, value);
            }
        }
    }

    public Property removeProperty(EditableDocument document, Name propertyName, Set<BinaryKey> unusedBinaryKeys, Set<BinaryKey> usedBinaryKeys) {
        EditableDocument properties = document.getDocument("properties");
        if (properties == null) {
            return null;
        }
        String namespaceUri = propertyName.getNamespaceUri();
        EditableDocument urlProps = properties.getDocument(namespaceUri);
        if (urlProps == null) {
            return null;
        }
        String localName = propertyName.getLocalName();
        Object fieldValue = urlProps.remove(localName);
        this.decrementBinaryReferenceCount(fieldValue, unusedBinaryKeys, usedBinaryKeys);
        if (urlProps.isEmpty()) {
            properties.remove(namespaceUri);
        }
        return fieldValue == null ? null : this.propertyFor(propertyName, fieldValue);
    }

    public void addPropertyValues(EditableDocument document, Name propertyName, boolean isMultiple, Collection<?> values, Set<BinaryKey> unusedBinaryKeys, Set<BinaryKey> usedBinaryKeys) {
        String localName;
        Object propValue;
        String namespaceUri;
        EditableDocument urlProps;
        assert (values != null);
        int numValues = values.size();
        if (numValues == 0) {
            return;
        }
        EditableDocument properties = document.getDocument("properties");
        if (properties == null) {
            properties = document.setDocument("properties");
        }
        if ((urlProps = properties.getDocument(namespaceUri = propertyName.getNamespaceUri())) == null) {
            urlProps = properties.setDocument(namespaceUri);
        }
        if ((propValue = urlProps.get(localName = propertyName.getLocalName())) == null) {
            if (isMultiple || numValues > 1) {
                EditableArray array = Schematic.newArray((int)numValues);
                for (Object value : values) {
                    array.addValue(this.valueToDocument(value, unusedBinaryKeys, usedBinaryKeys));
                }
                urlProps.setArray(localName, (Array)array);
            } else {
                urlProps.set(localName, this.valueToDocument(values.iterator().next(), unusedBinaryKeys, usedBinaryKeys));
            }
        } else if (propValue instanceof List) {
            this.decrementBinaryReferenceCount(propValue, unusedBinaryKeys, usedBinaryKeys);
            EditableArray array = urlProps.getArray(localName);
            for (Object value : values) {
                value = this.valueToDocument(value, unusedBinaryKeys, usedBinaryKeys);
                array.addValueIfAbsent(value);
            }
        } else {
            this.decrementBinaryReferenceCount(propValue, unusedBinaryKeys, usedBinaryKeys);
            if (numValues == 1) {
                Object value = this.valueToDocument(values.iterator().next(), unusedBinaryKeys, usedBinaryKeys);
                if (!value.equals(propValue)) {
                    EditableArray array = Schematic.newArray((Object[])new Object[]{value, propValue});
                    urlProps.setArray(localName, (Array)array);
                }
            } else {
                EditableArray array = Schematic.newArray((int)numValues);
                for (Object value : values) {
                    if ((value = this.valueToDocument(value, unusedBinaryKeys, usedBinaryKeys)).equals(propValue)) continue;
                    array.addValue(value);
                }
                assert (!array.isEmpty());
                urlProps.setArray(localName, (Array)array);
            }
        }
    }

    public void removePropertyValues(EditableDocument document, Name propertyName, Collection<?> values, Set<BinaryKey> unusedBinaryKeys, Set<BinaryKey> usedBinaryKeys) {
        assert (values != null);
        int numValues = values.size();
        if (numValues == 0) {
            return;
        }
        EditableDocument properties = document.getDocument("properties");
        if (properties == null) {
            return;
        }
        String namespaceUri = propertyName.getNamespaceUri();
        EditableDocument urlProps = properties.getDocument(namespaceUri);
        if (urlProps == null) {
            return;
        }
        String localName = propertyName.getLocalName();
        Object propValue = urlProps.get(localName);
        this.decrementBinaryReferenceCount(propValue, unusedBinaryKeys, usedBinaryKeys);
        if (propValue instanceof List) {
            EditableArray array = urlProps.getArray(localName);
            for (Object value : values) {
                value = this.valueToDocument(value, null, null);
                array.remove(value);
            }
        } else if (propValue != null) {
            for (Object value : values) {
                if (!(value = this.valueToDocument(value, unusedBinaryKeys, usedBinaryKeys)).equals(propValue)) continue;
                urlProps.remove(localName);
                break;
            }
        }
        if (urlProps.isEmpty()) {
            properties.remove(namespaceUri);
        }
    }

    public void setParents(EditableDocument document, NodeKey parent, NodeKey oldParent, SessionNode.ChangedAdditionalParents additionalParents) {
        Object existingParent = document.get("parent");
        if (existingParent == null) {
            if (parent != null) {
                if (additionalParents == null || additionalParents.isEmpty()) {
                    document.setString("parent", parent.toString());
                } else {
                    EditableArray parents = Schematic.newArray((int)(additionalParents.additionCount() + 1));
                    parents.add((Object)parent.toString());
                    for (NodeKey added : additionalParents.getAdditions()) {
                        parents.add((Object)added.toString());
                    }
                    document.set("parent", (Object)parents);
                }
            } else if (additionalParents != null && !additionalParents.isEmpty()) {
                EditableArray parents = Schematic.newArray((int)additionalParents.additionCount());
                for (NodeKey added : additionalParents.getAdditions()) {
                    parents.add((Object)added.toString());
                }
                document.set("parent", (Object)parents);
            }
            return;
        }
        if (existingParent instanceof List) {
            EditableArray parents = document.getArray("parent");
            if (parent != null && !parent.equals(oldParent)) {
                parents.addStringIfAbsent(parent.toString());
                if (oldParent != null) {
                    parents.remove((Object)oldParent.toString());
                }
            }
            if (additionalParents != null) {
                for (NodeKey removedParent : additionalParents.getRemovals()) {
                    if (removedParent.equals(parent)) continue;
                    parents.remove((Object)removedParent.toString());
                }
                for (NodeKey added : additionalParents.getAdditions()) {
                    parents.addStringIfAbsent(added.toString());
                }
            }
        } else if (existingParent instanceof String) {
            String existing = (String)existingParent;
            if (parent != null && (additionalParents == null || additionalParents.isEmpty())) {
                String oldParentStr;
                String string = oldParentStr = oldParent != null ? oldParent.toString() : null;
                if (existing.equals(oldParentStr)) {
                    document.set("parent", (Object)parent.toString());
                } else {
                    EditableArray parents = Schematic.newArray((int)2);
                    parents.add((Object)existing);
                    parents.add((Object)parent.toString());
                    document.set("parent", (Object)parents);
                }
            } else {
                int totalNumber = additionalParents.additionCount() - additionalParents.removalCount() + 1;
                assert (totalNumber >= 0);
                EditableArray parents = Schematic.newArray((int)totalNumber);
                if (parent != null && !existingParent.equals(parent.toString())) {
                    parents.add((Object)parent.toString());
                } else {
                    parents.add(existingParent);
                }
                for (NodeKey removed : additionalParents.getRemovals()) {
                    parents.remove((Object)removed.toString());
                }
                for (NodeKey added : additionalParents.getAdditions()) {
                    parents.add((Object)added.toString());
                }
                document.set("parent", (Object)parents);
            }
        }
    }

    public void setKey(EditableDocument document, NodeKey key) {
        assert (document.getString("key") == null);
        document.setString("key", key.toString());
    }

    public void setKey(EditableDocument document, String key) {
        assert (key != null);
        document.setString("key", key);
    }

    public String getKey(Document document) {
        return document.getString("key");
    }

    public void changeChildren(EditableDocument document, SessionNode.ChangedChildren changedChildren, ChildReferences appended) {
        assert (changedChildren != null || appended != null);
        ChildReferencesInfo info = this.getChildReferencesInfo((Document)document);
        long newTotalSize = 0L;
        EditableDocument doc = document;
        EditableDocument lastDoc = document;
        String lastDocKey = null;
        if (changedChildren != null && !changedChildren.isEmpty()) {
            Map<NodeKey, SessionNode.Insertions> insertionsByBeforeKey = changedChildren.getInsertionsByBeforeKey();
            Set<NodeKey> removals = changedChildren.getRemovals();
            Map<NodeKey, Name> newNames = changedChildren.getNewNames();
            while (doc != null) {
                ChildReferencesInfo docInfo;
                if (this.isFederatedDocument((Document)doc) && !removals.isEmpty()) {
                    HashSet<String> removalsStrings = new HashSet<String>();
                    for (NodeKey key : removals) {
                        if (key.toString().startsWith(this.documentStore.getLocalSourceKey())) continue;
                        removalsStrings.add(key.toString());
                    }
                    this.removeFederatedSegments(doc, removalsStrings);
                }
                long blockCount = this.insertChildren(doc, insertionsByBeforeKey, removals, newNames);
                newTotalSize += blockCount;
                SchematicEntry nextEntry = null;
                ChildReferencesInfo childReferencesInfo = docInfo = doc == document ? info : this.getChildReferencesInfo((Document)doc);
                if (docInfo != null && docInfo.nextKey != null) {
                    nextEntry = this.documentStore.get(docInfo.nextKey);
                }
                if (nextEntry != null) {
                    assert (docInfo != null && docInfo.nextKey != null);
                    doc.getDocument("childrenInfo").setNumber("blockSize", blockCount);
                    lastDoc = doc = this.documentStore.edit(docInfo.nextKey, true);
                    assert (docInfo != null);
                    lastDocKey = docInfo.nextKey;
                    continue;
                }
                if (doc == document && doc.containsField("childrenInfo")) {
                    EditableDocument childInfo = doc.getDocument("childrenInfo");
                    childInfo.remove("blockSize");
                    childInfo.set("count", (Object)newTotalSize);
                }
                doc = null;
            }
        } else {
            long l = newTotalSize = info != null ? info.totalSize : 0L;
        }
        if (appended != null && appended.size() != 0L) {
            String lastKey;
            String string = lastKey = info != null ? info.lastKey : null;
            if (lastKey != null && !lastKey.equals(lastDocKey)) {
                lastDoc = this.documentStore.edit(lastKey, true);
            } else {
                lastKey = null;
            }
            EditableArray lastChildren = lastDoc.getOrCreateArray("children");
            for (ChildReference ref : appended) {
                lastChildren.add((Object)this.fromChildReference(ref));
            }
            if (lastDoc != document) {
                EditableDocument lastDocInfo = lastDoc.getOrCreateDocument("childrenInfo");
                lastDocInfo.setNumber("blockSize", lastChildren.size());
            }
            EditableDocument childInfo = document.getOrCreateDocument("childrenInfo");
            childInfo.setNumber("count", newTotalSize += appended.size());
            if (lastKey != null) {
                childInfo.setString("lastBlock", lastKey);
            }
        }
    }

    protected long insertChildren(EditableDocument document, Map<NodeKey, SessionNode.Insertions> insertionsByBeforeKey, Set<NodeKey> removals, Map<NodeKey, Name> newNames) {
        EditableArray children = document.getArray("children");
        LinkedHashSet<ChildReference> newChildren = new LinkedHashSet<ChildReference>();
        if (children != null) {
            for (Object value : children) {
                ChildReference ref = this.childReferenceFrom(value);
                if (ref == null) continue;
                NodeKey childKey = ref.getKey();
                SessionNode.Insertions insertions = insertionsByBeforeKey.remove(childKey);
                if (insertions != null) {
                    for (ChildReference inserted : insertions.inserted()) {
                        newChildren.add(inserted);
                    }
                }
                if (removals.remove(childKey)) continue;
                Name newName = newNames.get(childKey);
                if (newName != null) {
                    ref = ref.with(newName, 1);
                }
                newChildren.add(ref);
            }
        }
        if (!insertionsByBeforeKey.isEmpty()) {
            LinkedList<ChildReference> toBeInsertedInOrder = new LinkedList<ChildReference>();
            for (SessionNode.Insertions insertion : insertionsByBeforeKey.values()) {
                for (ChildReference activeReference : insertion.inserted()) {
                    if (toBeInsertedInOrder.contains(activeReference)) continue;
                    SessionNode.Insertions insertionsBeforeActive = insertionsByBeforeKey.get(activeReference.getKey());
                    if (insertionsBeforeActive == null) {
                        toBeInsertedInOrder.addFirst(activeReference);
                        continue;
                    }
                    for (ChildReference referenceBeforeActive : insertionsBeforeActive.inserted()) {
                        if (toBeInsertedInOrder.contains(referenceBeforeActive)) continue;
                        toBeInsertedInOrder.add(referenceBeforeActive);
                    }
                    toBeInsertedInOrder.add(activeReference);
                }
            }
            newChildren.addAll(toBeInsertedInOrder);
        }
        EditableArray newChildrenArray = Schematic.newArray((int)newChildren.size());
        for (ChildReference childReference : newChildren) {
            newChildrenArray.add((Object)this.fromChildReference(childReference));
        }
        document.set("children", (Object)newChildrenArray);
        return newChildren.size();
    }

    public ChildReferences getChildReferences(WorkspaceCache cache, Document document) {
        boolean isUnorderedCollection;
        Name primaryType = this.getPrimaryType(document);
        Set<Name> mixinTypes = this.getMixinTypes(document);
        NodeTypes nodeTypes = this.getNodeTypes(cache);
        boolean bl = isUnorderedCollection = nodeTypes != null && nodeTypes.isUnorderedCollection(primaryType, mixinTypes);
        if (isUnorderedCollection) {
            return new BucketedChildReferences(document, this);
        }
        boolean hasChildren = document.containsField("children");
        boolean hasFederatedSegments = document.containsField("federatedSegments");
        if (!hasChildren && !hasFederatedSegments) {
            return ImmutableChildReferences.EMPTY_CHILD_REFERENCES;
        }
        boolean allowsSNS = nodeTypes == null || nodeTypes.allowsNameSiblings(primaryType, mixinTypes);
        ChildReferences internalChildRefs = hasChildren ? ImmutableChildReferences.create(this, document, "children", allowsSNS) : ImmutableChildReferences.EMPTY_CHILD_REFERENCES;
        ChildReferences externalChildRefs = hasFederatedSegments ? ImmutableChildReferences.create(this, document, "federatedSegments", allowsSNS) : ImmutableChildReferences.EMPTY_CHILD_REFERENCES;
        ChildReferencesInfo info = this.getChildReferencesInfo(document);
        if (!hasChildren) {
            return ImmutableChildReferences.create(externalChildRefs, info, cache, allowsSNS);
        }
        if (!hasFederatedSegments) {
            return ImmutableChildReferences.create(internalChildRefs, info, cache, allowsSNS);
        }
        return ImmutableChildReferences.create(internalChildRefs, info, externalChildRefs, cache, allowsSNS);
    }

    protected NodeTypes getNodeTypes(WorkspaceCache cache) {
        RepositoryEnvironment repositoryEnvironment = cache.repositoryEnvironment();
        if (repositoryEnvironment == null) {
            return null;
        }
        return repositoryEnvironment.nodeTypes();
    }

    protected ChildReferences getChildReferencesFromBlock(Document block, boolean allowsSNS) {
        if (!block.containsField("children")) {
            return ImmutableChildReferences.EMPTY_CHILD_REFERENCES;
        }
        return ImmutableChildReferences.create(this, block, "children", allowsSNS);
    }

    public ChildReferencesInfo getChildReferencesInfo(Document document) {
        Document childrenInfo = document.getDocument("childrenInfo");
        if (childrenInfo != null) {
            long totalSize = childrenInfo.getLong("count", 0L);
            long blockSize = childrenInfo.getLong("blockSize", 0L);
            String nextBlockKey = childrenInfo.getString("nextBlock");
            String lastBlockKey = childrenInfo.getString("lastBlock", nextBlockKey);
            return new ChildReferencesInfo(totalSize, blockSize, nextBlockKey, lastBlockKey);
        }
        return null;
    }

    protected ChildReference childReferenceFrom(Object value) {
        if (value instanceof Document) {
            Document doc = (Document)value;
            String keyStr = doc.getString("key");
            NodeKey key = new NodeKey(keyStr);
            String nameStr = doc.getString("name");
            Name name = (Name)this.names.create(nameStr, this.decoder);
            return new ChildReference(key, name, 1);
        }
        return null;
    }

    public EditableDocument fromChildReference(ChildReference ref) {
        return this.childReferenceDocument(ref.getKey(), ref.getName());
    }

    public EditableDocument childReferenceDocument(NodeKey key, Name name) {
        return Schematic.newDocument((String)"key", (Object)this.valueToDocument(key, null, null), (String)"name", (Object)this.strings.create(name));
    }

    public Set<NodeKey> getReferrers(Document document, CachedNode.ReferenceType type) {
        Document weak;
        Document strong;
        Document referrers = document.getDocument("referrers");
        if (referrers == null) {
            return new HashSet<NodeKey>();
        }
        HashSet<NodeKey> result = new HashSet<NodeKey>();
        if (type != CachedNode.ReferenceType.WEAK && (strong = referrers.getDocument("strong")) != null) {
            for (String keyString : strong.keySet()) {
                result.add(new NodeKey(keyString));
            }
        }
        if (type != CachedNode.ReferenceType.STRONG && (weak = referrers.getDocument("weak")) != null) {
            for (String keyString : weak.keySet()) {
                result.add(new NodeKey(keyString));
            }
        }
        return result;
    }

    public Map<NodeKey, Integer> getReferrerCounts(Document document, CachedNode.ReferenceType type) {
        Document weak;
        Document strong;
        Document referrers = document.getDocument("referrers");
        if (referrers == null) {
            return Collections.emptyMap();
        }
        HashMap<NodeKey, Integer> result = new HashMap<NodeKey, Integer>();
        if ((type == CachedNode.ReferenceType.STRONG || type == CachedNode.ReferenceType.BOTH) && (strong = referrers.getDocument("strong")) != null) {
            for (String keyString : strong.keySet()) {
                result.put(new NodeKey(keyString), strong.getInteger(keyString));
            }
        }
        if ((type == CachedNode.ReferenceType.WEAK || type == CachedNode.ReferenceType.BOTH) && (weak = referrers.getDocument("weak")) != null) {
            for (String keyString : weak.keySet()) {
                result.put(new NodeKey(keyString), weak.getInteger(keyString));
            }
        }
        return result;
    }

    public void changeReferrers(EditableDocument document, SessionNode.ReferrerChanges changes) {
        List<NodeKey> weakRemoved;
        Map<NodeKey, Integer> weakCount;
        if (changes.isEmpty()) {
            return;
        }
        EditableDocument referrers = document.getDocument("referrers");
        List<NodeKey> strongAdded = changes.getAddedReferrers(CachedNode.ReferenceType.STRONG);
        List<NodeKey> weakAdded = changes.getAddedReferrers(CachedNode.ReferenceType.WEAK);
        if (referrers == null) {
            referrers = document.setDocument("referrers");
            if (!strongAdded.isEmpty()) {
                HashSet<NodeKey> strongAddedSet = new HashSet<NodeKey>(strongAdded);
                EditableDocument strong = referrers.setDocument("strong");
                for (NodeKey key : strongAddedSet) {
                    strong.set(key.toString(), (Object)Collections.frequency(strongAdded, key));
                }
            }
            if (!weakAdded.isEmpty()) {
                HashSet<NodeKey> weakAddedSet = new HashSet<NodeKey>(weakAdded);
                EditableDocument weak = referrers.setDocument("weak");
                for (NodeKey key : weakAddedSet) {
                    weak.set(key.toString(), (Object)Collections.frequency(weakAdded, key));
                }
            }
            return;
        }
        List<NodeKey> strongRemoved = changes.getRemovedReferrers(CachedNode.ReferenceType.STRONG);
        Map<NodeKey, Integer> strongCount = this.computeReferrersCountDelta(strongAdded, strongRemoved);
        if (!strongCount.isEmpty()) {
            EditableDocument strong = referrers.getOrCreateDocument("strong");
            this.updateReferrers(strong, strongCount);
        }
        if (!(weakCount = this.computeReferrersCountDelta(weakAdded, weakRemoved = changes.getRemovedReferrers(CachedNode.ReferenceType.WEAK))).isEmpty()) {
            EditableDocument weak = referrers.getOrCreateDocument("weak");
            this.updateReferrers(weak, weakCount);
        }
    }

    private void updateReferrers(EditableDocument owningDocument, Map<NodeKey, Integer> referrersCountDelta) {
        for (NodeKey strongKey : referrersCountDelta.keySet()) {
            int newCount = referrersCountDelta.get(strongKey);
            String keyString = strongKey.toString();
            Integer existingCount = (Integer)owningDocument.get(keyString);
            if (existingCount != null) {
                int actualCount = existingCount + newCount;
                if (actualCount <= 0) {
                    owningDocument.remove(keyString);
                    continue;
                }
                owningDocument.set(keyString, (Object)actualCount);
                continue;
            }
            if (newCount <= 0) continue;
            owningDocument.set(keyString, (Object)newCount);
        }
    }

    private Map<NodeKey, Integer> computeReferrersCountDelta(List<NodeKey> addedReferrers, List<NodeKey> removedReferrers) {
        HashMap<NodeKey, Integer> referrersCountDelta = new HashMap<NodeKey, Integer>(0);
        HashSet<NodeKey> addedReferrersUnique = new HashSet<NodeKey>(addedReferrers);
        for (NodeKey addedReferrer : addedReferrersUnique) {
            int referrersCount = Collections.frequency(addedReferrers, addedReferrer) - Collections.frequency(removedReferrers, addedReferrer);
            referrersCountDelta.put(addedReferrer, referrersCount);
        }
        HashSet<NodeKey> removedReferrersUnique = new HashSet<NodeKey>(removedReferrers);
        for (NodeKey removedReferrer : removedReferrersUnique) {
            if (referrersCountDelta.containsKey(removedReferrer)) continue;
            referrersCountDelta.put(removedReferrer, -1 * Collections.frequency(removedReferrers, removedReferrer));
        }
        return referrersCountDelta;
    }

    protected Object valueToDocument(Object value, Set<BinaryKey> unusedBinaryKeys, Set<BinaryKey> usedBinaryKeys) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String valueStr = (String)value;
            if ((long)valueStr.length() < this.largeStringSize.get()) {
                return value;
            }
            value = this.binaries.create(valueStr);
        }
        if (value instanceof NodeKey) {
            return ((NodeKey)value).toString();
        }
        if (value instanceof UUID) {
            return Schematic.newDocument((String)"$uuid", (Object)this.strings.create((UUID)value));
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Integer) {
            return new Long(((Integer)value).intValue());
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Name) {
            Name name = (Name)value;
            return Schematic.newDocument((String)"$name", (Object)name.getString(this.encoder));
        }
        if (value instanceof Path) {
            Path path = (Path)value;
            EditableArray segments = Schematic.newArray((int)path.size());
            for (Path.Segment segment : path) {
                String str = segment.getString(this.encoder);
                segments.add(str);
            }
            boolean relative = !path.isAbsolute();
            return Schematic.newDocument((String)"$path", (Object)segments, (String)"$relative", (Object)relative);
        }
        if (value instanceof DateTime) {
            return Schematic.newDocument((String)"$date", (Object)this.strings.create((DateTime)value));
        }
        if (value instanceof BigDecimal) {
            return Schematic.newDocument((String)"$dec", (Object)this.strings.create((BigDecimal)value));
        }
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            String key = null;
            key = ref.isSimple() ? "$sref" : (ref.isWeak() ? "$wref" : "$ref");
            String refString = ref instanceof NodeKeyReference ? ((NodeKeyReference)ref).getNodeKey().toString() : this.strings.create(ref);
            boolean isForeign = ref.isForeign();
            return Schematic.newDocument((String)key, (Object)refString, (String)"$foreign", (Object)isForeign);
        }
        if (value instanceof URI) {
            return Schematic.newDocument((String)"$uri", (Object)this.strings.create((URI)value));
        }
        if (value instanceof ExternalBinaryValue) {
            ExternalBinaryValue externalBinaryValue = (ExternalBinaryValue)value;
            return Schematic.newDocument((String)"$externalBinaryId", (Object)externalBinaryValue.getId(), (String)"$sourceName", (Object)externalBinaryValue.getSourceName());
        }
        if (value instanceof BinaryValue) {
            BinaryValue binary = (BinaryValue)value;
            if (binary instanceof InMemoryBinaryValue) {
                return new Binary(((InMemoryBinaryValue)binary).getBytes());
            }
            String sha1 = binary.getHexHash();
            long size = binary.getSize();
            EditableDocument ref = Schematic.newDocument((String)"$sha1", (Object)sha1, (String)"$len", (Object)size);
            this.incrementBinaryReferenceCount(binary.getKey(), unusedBinaryKeys, usedBinaryKeys);
            return ref;
        }
        assert (false) : "Unexpected property value \"" + value + "\" of type " + value.getClass().getSimpleName();
        return null;
    }

    protected final String keyForBinaryReferenceDocument(String sha1) {
        return sha1 + "-ref";
    }

    protected void incrementBinaryReferenceCount(BinaryKey binaryKey, Set<BinaryKey> unusedBinaryKeys, Set<BinaryKey> usedBinaryKeys) {
        String sha1 = binaryKey.toString();
        String key = this.keyForBinaryReferenceDocument(sha1);
        EditableDocument entry = this.documentStore.edit(key, false);
        if (entry == null) {
            EditableDocument content = Schematic.newDocument((String)"sha1", (Object)sha1, (String)"refCount", (Object)1L);
            this.documentStore.localStore().put(key, (Document)content);
        } else {
            Long countValue = entry.getLong("refCount");
            entry.setNumber("refCount", countValue != null ? countValue + 1L : 1L);
        }
        if (unusedBinaryKeys != null) {
            unusedBinaryKeys.remove(binaryKey);
        }
        if (usedBinaryKeys != null) {
            usedBinaryKeys.add(binaryKey);
        }
    }

    protected void decrementBinaryReferenceCount(Object fieldValue, Set<BinaryKey> unusedBinaryKeys, Set<BinaryKey> usedBinaryKeys) {
        if (fieldValue instanceof List) {
            for (Object value : (List)fieldValue) {
                this.decrementBinaryReferenceCount(value, unusedBinaryKeys, usedBinaryKeys);
            }
        } else if (fieldValue instanceof Object[]) {
            for (Object value : (Object[])fieldValue) {
                this.decrementBinaryReferenceCount(value, unusedBinaryKeys, usedBinaryKeys);
            }
        } else {
            String sha1 = null;
            if (fieldValue instanceof Document) {
                Document docValue = (Document)fieldValue;
                sha1 = docValue.getString("$sha1");
            } else if (fieldValue instanceof BinaryKey) {
                sha1 = fieldValue.toString();
            } else if (fieldValue instanceof org.modeshape.jcr.api.Binary && !(fieldValue instanceof InMemoryBinaryValue)) {
                sha1 = ((org.modeshape.jcr.api.Binary)fieldValue).getHexHash();
            }
            if (sha1 != null) {
                BinaryKey binaryKey = new BinaryKey(sha1);
                EditableDocument sha1Usage = this.documentStore.edit(this.keyForBinaryReferenceDocument(sha1), false);
                if (sha1Usage != null) {
                    Long countValue = sha1Usage.getLong("refCount");
                    assert (countValue != null);
                    long count = countValue - 1L;
                    assert (count >= 0L);
                    if (count == 0L) {
                        if (unusedBinaryKeys != null) {
                            unusedBinaryKeys.add(binaryKey);
                        }
                        if (usedBinaryKeys != null) {
                            usedBinaryKeys.remove(binaryKey);
                        }
                    }
                    sha1Usage.setNumber("refCount", count);
                } else {
                    if (unusedBinaryKeys != null) {
                        unusedBinaryKeys.add(binaryKey);
                    }
                    if (usedBinaryKeys != null) {
                        usedBinaryKeys.remove(binaryKey);
                    }
                }
            }
        }
    }

    public Object valueFromDocument(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Binary) {
            Binary binary = (Binary)value;
            return this.binaries.create(binary.getBytes());
        }
        if (value instanceof URI) {
            URI uri = (URI)value;
            return this.uris.create(uri);
        }
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            if (size == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> result = new ArrayList<Object>(values.size());
            for (Object val : values) {
                result.add(this.valueFromDocument(val));
            }
            return result;
        }
        if (value instanceof Document) {
            Document doc = (Document)value;
            String valueStr = null;
            List array = null;
            valueStr = doc.getString("$name");
            if (!Null.matches((Object)valueStr)) {
                return this.names.create(valueStr, this.decoder);
            }
            array = doc.getArray("$path");
            if (!Null.matches((Object)array)) {
                List<Path.Segment> segments = this.segmentsFrom(array);
                boolean relative = doc.getBoolean("$relative");
                return relative ? this.paths.createRelativePath(segments) : this.paths.createAbsolutePath(segments);
            }
            valueStr = doc.getString("$date");
            if (!Null.matches((Object)valueStr)) {
                return this.dates.create(valueStr);
            }
            valueStr = doc.getString("$dec");
            if (!Null.matches((Object)valueStr)) {
                return this.decimals.create(valueStr);
            }
            valueStr = doc.getString("$ref");
            if (!Null.matches((Object)valueStr)) {
                return this.createReferenceFromString(this.refs, doc, valueStr);
            }
            valueStr = doc.getString("$wref");
            if (!Null.matches((Object)valueStr)) {
                return this.createReferenceFromString(this.weakrefs, doc, valueStr);
            }
            valueStr = doc.getString("$sref");
            if (!Null.matches((Object)valueStr)) {
                return this.createReferenceFromString(this.simplerefs, doc, valueStr);
            }
            valueStr = doc.getString("$uuid");
            if (!Null.matches((Object)valueStr)) {
                return UUID.fromString(valueStr);
            }
            valueStr = doc.getString("$uri");
            if (!Null.matches((Object)valueStr)) {
                return this.uris.create(valueStr);
            }
            valueStr = doc.getString("$externalBinaryId");
            if (!Null.matches((Object)valueStr)) {
                String sourceName = doc.getString("$sourceName");
                ExternalBinaryValue externalBinaryValue = this.documentStore.getExternalBinary(sourceName, valueStr);
                return externalBinaryValue != null ? externalBinaryValue : EmptyBinaryValue.INSTANCE;
            }
            valueStr = doc.getString("$sha1");
            if (!Null.matches((Object)valueStr)) {
                long size = doc.getLong("$len");
                try {
                    return this.binaries.find(new BinaryKey(valueStr), size);
                }
                catch (BinaryStoreException e) {
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
        }
        if (value instanceof Integer) {
            return this.longs.create(((Integer)value).longValue());
        }
        if (value instanceof Float) {
            return this.doubles.create(((Float)value).doubleValue());
        }
        assert (false) : "Unexpected document value \"" + value + "\" of type " + value.getClass().getSimpleName();
        return null;
    }

    private Object createReferenceFromString(ReferenceFactory referenceFactory, Document doc, String valueStr) {
        boolean isForeign = doc.getBoolean("$foreign");
        if (!NodeKey.isValidFormat(valueStr)) {
            throw new IllegalStateException("The reference " + valueStr + " is corrupt: expected a node-key reference");
        }
        return referenceFactory.create(new NodeKey(valueStr), isForeign);
    }

    protected List<Path.Segment> segmentsFrom(List<?> segmentValues) {
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(segmentValues.size());
        for (Object value : segmentValues) {
            Path.Segment segment = this.paths.createSegment(value.toString(), this.decoder);
            segments.add(segment);
        }
        return segments;
    }

    public boolean isLocked(EditableDocument doc) {
        return this.hasProperty((Document)doc, JcrLexicon.LOCK_OWNER) || this.hasProperty((Document)doc, JcrLexicon.LOCK_IS_DEEP);
    }

    protected boolean isFederatedDocument(Document document) {
        return document.containsField("federatedSegments");
    }

    protected void removeFederatedSegments(EditableDocument federatedDocument, Set<String> externalNodeKeys) {
        if (!federatedDocument.containsField("federatedSegments")) {
            return;
        }
        EditableArray federatedSegments = federatedDocument.getArray("federatedSegments");
        for (int i = 0; i < federatedSegments.size(); ++i) {
            Object federatedSegment = federatedSegments.get(i);
            assert (federatedSegment instanceof Document);
            String segmentKey = this.getKey((Document)federatedSegment);
            if (!externalNodeKeys.contains(segmentKey)) continue;
            federatedSegments.remove(i);
        }
        if (federatedSegments.isEmpty()) {
            federatedDocument.remove("federatedSegments");
        }
    }

    protected boolean isQueryable(Document document) {
        return document.getBoolean("$queryable", true);
    }

    public void setQueryable(EditableDocument document, boolean queryable) {
        document.set("$queryable", (Object)queryable);
    }

    public void setCacheable(EditableDocument document, boolean cacheable) {
        document.set("$cacheable", (Object)cacheable);
    }

    protected boolean isCacheable(Document document) {
        return document.getBoolean("$cacheable", true);
    }

    protected void addFederatedSegment(EditableDocument document, String externalNodeKey, String name) {
        EditableArray federatedSegmentsArray = document.getArray("federatedSegments");
        if (federatedSegmentsArray == null) {
            federatedSegmentsArray = Schematic.newArray();
            document.set("federatedSegments", (Object)federatedSegmentsArray);
        }
        if (!StringUtil.isBlank((String)externalNodeKey)) {
            EditableDocument federatedSegment = DocumentFactory.newDocument((String)"key", (Object)externalNodeKey, (String)"name", (Object)name);
            federatedSegmentsArray.add((Object)federatedSegment);
        }
    }

    protected String bucketKey(String parentKey, String bucketId) {
        return parentKey + "/" + bucketId;
    }

    protected BucketedChildReferences.Bucket loadBucket(String parentKey, BucketId bucketId) {
        String bucketKey = this.bucketKey(parentKey, bucketId.toString());
        SchematicEntry schematicEntry = this.documentStore.get(bucketKey);
        if (schematicEntry == null) {
            return null;
        }
        return new BucketedChildReferences.Bucket(bucketId, schematicEntry.content(), this);
    }

    protected void addChildrenToBuckets(EditableDocument parentDoc, ChildReferences appended) {
        assert (appended != null);
        long totalAdditions = 0L;
        Integer bucketIdLength = parentDoc.getInteger("$bucketIdLen");
        assert (bucketIdLength != null);
        String parentKey = this.getKey((Document)parentDoc);
        HashMap<BucketId, HashSet<ChildReference>> additionsPerBucket = new HashMap<BucketId, HashSet<ChildReference>>((int)appended.size());
        for (ChildReference childReference : appended) {
            Name insertedName = childReference.getName();
            BucketId bucketId = new BucketId(insertedName, (int)bucketIdLength);
            HashSet<ChildReference> additions = (HashSet<ChildReference>)additionsPerBucket.get(bucketId);
            if (additions == null) {
                additions = new HashSet<ChildReference>();
                additionsPerBucket.put(bucketId, additions);
            }
            additions.add(childReference);
            ++totalAdditions;
        }
        for (Map.Entry entry : additionsPerBucket.entrySet()) {
            BucketId bucketId = (BucketId)entry.getKey();
            String bucketKey = this.bucketKey(parentKey, bucketId.toString());
            boolean newBucket = !this.documentStore.containsKey(bucketKey);
            EditableDocument bucketDoc = this.documentStore.edit(bucketKey, true);
            assert (bucketDoc != null);
            for (ChildReference ref : (Set)entry.getValue()) {
                String key = ref.getKey().toString();
                String name = this.strings.create(ref.getName());
                bucketDoc.setString(key, name);
            }
            if (!newBucket) continue;
            parentDoc.getOrCreateArray("$buckets").add((Object)bucketId.toString());
        }
        Long currentSize = parentDoc.getLong("$size");
        if (currentSize == null) {
            parentDoc.setNumber("$size", totalAdditions);
        } else {
            parentDoc.setNumber("$size", currentSize + totalAdditions);
        }
    }

    protected Map<BucketId, Set<NodeKey>> preRemoveChildrenFromBuckets(WorkspaceCache wsCache, EditableDocument parentDoc, Set<NodeKey> removals) {
        assert (removals != null && !removals.isEmpty());
        Integer bucketIdLength = parentDoc.getInteger("$bucketIdLen");
        assert (bucketIdLength != null);
        long totalRemovals = 0L;
        HashMap<BucketId, Set<NodeKey>> removalsPerBucket = new HashMap<BucketId, Set<NodeKey>>(removals.size());
        for (NodeKey removedKey : removals) {
            Name removedName = wsCache.getNode(removedKey).getName(wsCache);
            BucketId bucketId = new BucketId(removedName, (int)bucketIdLength);
            HashSet<NodeKey> bucketRemovals = (HashSet<NodeKey>)removalsPerBucket.get(bucketId);
            if (bucketRemovals == null) {
                bucketRemovals = new HashSet<NodeKey>();
                removalsPerBucket.put(bucketId, bucketRemovals);
            }
            bucketRemovals.add(removedKey);
            ++totalRemovals;
        }
        Long currentSize = parentDoc.getLong("$size");
        if (totalRemovals > 0L && currentSize != null) {
            parentDoc.setNumber("$size", currentSize - totalRemovals);
        }
        return removalsPerBucket;
    }

    protected void persistBucketRemovalChanges(NodeKey parentKey, Map<BucketId, Set<NodeKey>> removalsPerBucket) {
        EditableDocument parentDoc = this.documentStore.edit(parentKey.toString(), false);
        for (Map.Entry<BucketId, Set<NodeKey>> entry : removalsPerBucket.entrySet()) {
            BucketId bucketId = entry.getKey();
            Set<NodeKey> removalsFromBucket = entry.getValue();
            String bucketIdString = bucketId.toString();
            String bucketKey = this.bucketKey(parentKey.toString(), bucketIdString);
            EditableDocument bucketDoc = this.documentStore.edit(bucketKey, false);
            assert (bucketDoc != null);
            for (NodeKey toRemove : removalsFromBucket) {
                bucketDoc.remove(toRemove.toString());
            }
            if (!bucketDoc.isEmpty()) continue;
            this.documentStore.remove(bucketKey);
            parentDoc.getArray("$buckets").remove((Object)bucketIdString);
        }
    }

    protected void removeAllBucketsFromUnorderedCollection(NodeKey parentDocKey) {
        EditableDocument parentDoc = this.documentStore.edit(parentDocKey.toString(), false);
        assert (parentDoc != null);
        EditableArray bucketsIds = parentDoc.getArray("$buckets");
        if (bucketsIds == null || bucketsIds.isEmpty()) {
            return;
        }
        for (Object bucketId : bucketsIds) {
            String bucketKey = this.bucketKey(parentDocKey.toString(), bucketId.toString());
            this.documentStore.remove(bucketKey);
        }
    }

    protected void addInternalProperties(EditableDocument doc, Map<String, Object> properties) {
        if (properties.isEmpty()) {
            return;
        }
        doc.putAll(properties);
    }

    protected void removeInteralProperties(EditableDocument doc, Set<String> properties) {
        if (properties.isEmpty()) {
            return;
        }
        for (String propertyName : properties) {
            doc.remove(propertyName);
        }
    }

    @Immutable
    public static class ChildReferencesInfo {
        public final long totalSize;
        public final long blockSize;
        public final String nextKey;
        public final String lastKey;

        public ChildReferencesInfo(long totalSize, long blockSize, String nextKey, String lastKey) {
            this.totalSize = totalSize;
            this.blockSize = blockSize;
            this.nextKey = nextKey;
            this.lastKey = lastKey;
        }

        public String toString() {
            return "totalSize: " + this.totalSize + "; blockSize: " + this.blockSize + "; nextKey: " + this.nextKey + "; lastKey: " + this.lastKey;
        }
    }
}

