/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.document.AbstractChildReferences;
import org.modeshape.jcr.value.Name;

@ThreadSafe
public class MutableChildReferences
extends AbstractChildReferences {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<Name, List<NodeKey>> childReferenceKeysByName = new HashMap<Name, List<NodeKey>>();
    private final Map<NodeKey, ChildReference> childReferencesByKey = new LinkedHashMap<NodeKey, ChildReference>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            long l = this.childReferencesByKey.size();
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildCount(Name name) {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            List<NodeKey> nodeKeys = this.childReferenceKeysByName.get(name);
            int n = nodeKeys != null ? nodeKeys.size() : 0;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChildReference getChild(Name name, int snsIndex, ChildReferences.Context context) {
        if (context == null) {
            context = new ChildReferences.SingleNameContext();
        }
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            List<NodeKey> childrenKeysWithSameName = this.childReferenceKeysByName.get(name);
            if (childrenKeysWithSameName == null || childrenKeysWithSameName.isEmpty()) {
                ChildReference childReference = null;
                return childReference;
            }
            if (snsIndex > childrenKeysWithSameName.size()) {
                ChildReference childReference = null;
                return childReference;
            }
            NodeKey nodeKey = childrenKeysWithSameName.get(snsIndex - 1);
            ChildReference childReference = this.childReferencesByKey.get(nodeKey).with(snsIndex);
            return childReference;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChildReference getChild(NodeKey key, ChildReferences.Context context) {
        if (context == null) {
            context = new ChildReferences.SingleNameContext();
        }
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            ChildReference ref = this.childReferencesByKey.get(key);
            if (ref != null) {
                List<NodeKey> childrenKeysWithSameName = this.childReferenceKeysByName.get(ref.getName());
                assert (childrenKeysWithSameName != null);
                assert (childrenKeysWithSameName.size() != 0);
                int index = childrenKeysWithSameName.indexOf(key);
                ChildReference childReference = ref.with(index + 1);
                return childReference;
            }
            ChildReference childReference = null;
            return childReference;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ChildReference getChild(NodeKey key) {
        return this.getChild(key, new ChildReferences.BasicContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChild(NodeKey key) {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            boolean bl = this.childReferencesByKey.containsKey(key);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<ChildReference> iterator() {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            Iterator<ChildReference> iterator = new ArrayList<ChildReference>(this.childReferencesByKey.values()).iterator();
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ChildReference> iterator(Name name) {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            List<NodeKey> nodeKeys = this.childReferenceKeysByName.get(name);
            if (nodeKeys == null || nodeKeys.isEmpty()) {
                Iterator<ChildReference> iterator = Collections.emptyIterator();
                return iterator;
            }
            ArrayList<ChildReference> childReferences = new ArrayList<ChildReference>(nodeKeys.size());
            for (ChildReference childReference : this.childReferencesByKey.values()) {
                if (!name.equals(childReference.getName())) continue;
                childReferences.add(childReference);
            }
            Iterator<ChildReference> iterator = childReferences.iterator();
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<NodeKey> getAllKeys() {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            Iterator<NodeKey> iterator = new ArrayList<NodeKey>(this.childReferencesByKey.keySet()).iterator();
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(NodeKey key, Name name) {
        ChildReference reference = new ChildReference(key, name, 1);
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            ChildReference old = this.childReferencesByKey.put(key, reference);
            if (old != null && old.getName().equals(name)) {
                return;
            }
            List<NodeKey> nodeKeysWithSameName = this.childReferenceKeysByName.get(name);
            if (nodeKeysWithSameName == null) {
                nodeKeysWithSameName = new ArrayList<NodeKey>();
                this.childReferenceKeysByName.put(name, nodeKeysWithSameName);
            }
            nodeKeysWithSameName.add(key);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Iterable<ChildReference> references) {
        Iterator<ChildReference> childReferenceIterator = references.iterator();
        if (!childReferenceIterator.hasNext()) {
            return;
        }
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            while (childReferenceIterator.hasNext()) {
                ChildReference reference = childReferenceIterator.next();
                ChildReference old = this.childReferencesByKey.put((reference = reference.with(1)).getKey(), reference);
                if (old != null && old.getName().equals(reference.getName())) continue;
                Name name = reference.getName();
                List<NodeKey> nodeKeysWithSameName = this.childReferenceKeysByName.get(name);
                if (nodeKeysWithSameName == null) {
                    nodeKeysWithSameName = new ArrayList<NodeKey>();
                    this.childReferenceKeysByName.put(name, nodeKeysWithSameName);
                }
                nodeKeysWithSameName.add(reference.getKey());
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChildReference remove(NodeKey key) {
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            ChildReference existing = this.childReferencesByKey.remove(key);
            if (existing != null) {
                List<NodeKey> nodeKeys = this.childReferenceKeysByName.get(existing.getName());
                assert (nodeKeys != null);
                nodeKeys.remove(key);
            }
            ChildReference childReference = existing;
            return childReference;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("appended: ");
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            Iterator<ChildReference> iter = this.childReferencesByKey.values().iterator();
            if (iter.hasNext()) {
                sb.append(iter.next());
                while (iter.hasNext()) {
                    sb.append(", ");
                    sb.append(iter.next());
                }
            }
        }
        finally {
            lock.unlock();
        }
        return sb;
    }

    @Override
    public boolean allowsSNS() {
        return true;
    }
}

