/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import org.mapdb.Atomic;
import org.mapdb.DB;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;

@Immutable
@ThreadSafe
public final class IndexUpdater {
    private static final String LAST_SUCCESSFUL_UPDATE = "$lastSuccessfulUpdateAt";
    private final DB db;

    protected IndexUpdater(DB db) {
        this.db = db;
    }

    protected void commit() {
        this.writeLatestUpdateTime(System.currentTimeMillis());
        this.db.commit();
    }

    protected Long latestIndexUpdateTime() {
        return this.db.getAtomicLong(LAST_SUCCESSFUL_UPDATE).get();
    }

    private void writeLatestUpdateTime(long updateTime) {
        Atomic.Long atomicLong = this.db.getAtomicLong(LAST_SUCCESSFUL_UPDATE);
        long latestValue = atomicLong.get();
        if (latestValue < updateTime) {
            atomicLong.compareAndSet(latestValue, updateTime);
        }
    }
}

