/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.locking;

import java.util.concurrent.locks.ReentrantLock;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.locking.AbstractLockingService;

@ThreadSafe
public class StandaloneLockingService
extends AbstractLockingService<ReentrantLock> {
    public StandaloneLockingService() {
        this(0L);
    }

    public StandaloneLockingService(long lockTimeoutMillis) {
        super(lockTimeoutMillis);
    }

    @Override
    protected ReentrantLock createLock(String name) {
        return new ReentrantLock();
    }

    @Override
    protected void validateLock(ReentrantLock lock) {
        if (!lock.isHeldByCurrentThread()) {
            if (lock.isLocked()) {
                this.logger.warn((I18nResource)JcrI18n.warnAttemptingToUnlockAnotherLock, new Object[]{Thread.currentThread().getName(), lock});
            } else {
                this.logger.debug("attempting to unlock an already unlocked lock....", new Object[0]);
            }
        }
    }

    @Override
    protected boolean releaseLock(ReentrantLock lock) {
        if (!lock.isHeldByCurrentThread()) {
            this.logger.debug("Cannot release {0} because it is not held by the current thread...", new Object[]{lock});
            return false;
        }
        while (lock.getHoldCount() > 0) {
            lock.unlock();
        }
        return true;
    }
}

