/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.qom.StaticOperand;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.ArrayListMultimap;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.RepositoryIndexes;
import org.modeshape.jcr.api.query.QueryCancelledException;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.CachedNodeSupplier;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.PropertyTypeUtil;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.PseudoColumns;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryEngine;
import org.modeshape.jcr.query.QueryEngineBuilder;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.RowExtractors;
import org.modeshape.jcr.query.engine.IndexPlan;
import org.modeshape.jcr.query.engine.QuerySources;
import org.modeshape.jcr.query.engine.QueryUtil;
import org.modeshape.jcr.query.engine.Results;
import org.modeshape.jcr.query.engine.process.DependentQuery;
import org.modeshape.jcr.query.engine.process.DistinctSequence;
import org.modeshape.jcr.query.engine.process.ExceptSequence;
import org.modeshape.jcr.query.engine.process.HashJoinSequence;
import org.modeshape.jcr.query.engine.process.IntersectSequence;
import org.modeshape.jcr.query.engine.process.JoinSequence;
import org.modeshape.jcr.query.engine.process.SortingSequence;
import org.modeshape.jcr.query.model.And;
import org.modeshape.jcr.query.model.ArithmeticOperand;
import org.modeshape.jcr.query.model.Between;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.Cast;
import org.modeshape.jcr.query.model.ChildCount;
import org.modeshape.jcr.query.model.ChildNode;
import org.modeshape.jcr.query.model.ChildNodeJoinCondition;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.DescendantNode;
import org.modeshape.jcr.query.model.DescendantNodeJoinCondition;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.EquiJoinCondition;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.FullTextSearchScore;
import org.modeshape.jcr.query.model.JoinCondition;
import org.modeshape.jcr.query.model.JoinType;
import org.modeshape.jcr.query.model.Length;
import org.modeshape.jcr.query.model.Limit;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.LiteralValue;
import org.modeshape.jcr.query.model.LowerCase;
import org.modeshape.jcr.query.model.NodeDepth;
import org.modeshape.jcr.query.model.NodeId;
import org.modeshape.jcr.query.model.NodeLocalName;
import org.modeshape.jcr.query.model.NodeName;
import org.modeshape.jcr.query.model.NodePath;
import org.modeshape.jcr.query.model.Not;
import org.modeshape.jcr.query.model.NullOrder;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.query.model.Ordering;
import org.modeshape.jcr.query.model.PropertyExistence;
import org.modeshape.jcr.query.model.PropertyValue;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.model.ReferenceValue;
import org.modeshape.jcr.query.model.Relike;
import org.modeshape.jcr.query.model.SameNode;
import org.modeshape.jcr.query.model.SameNodeJoinCondition;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.SetCriteria;
import org.modeshape.jcr.query.model.SetQuery;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.model.UpperCase;
import org.modeshape.jcr.query.model.Visitors;
import org.modeshape.jcr.query.optimize.Optimizer;
import org.modeshape.jcr.query.optimize.RuleBasedOptimizer;
import org.modeshape.jcr.query.plan.JoinAlgorithm;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.plan.PlanNode;
import org.modeshape.jcr.query.plan.Planner;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.StringFactory;
import org.modeshape.jcr.value.binary.BinaryStore;

@Immutable
public class ScanningQueryEngine
implements QueryEngine {
    protected static final Logger LOGGER = Logger.getLogger((String)"org.modeshape.jcr.query");
    protected final String repositoryName;
    protected final Planner planner;
    protected final Optimizer optimizer;

    public static Builder builder() {
        return new Builder();
    }

    public ScanningQueryEngine(ExecutionContext context, String repositoryName, Planner planner, Optimizer optimizer) {
        assert (planner != null);
        assert (optimizer != null);
        this.repositoryName = repositoryName;
        this.planner = planner;
        this.optimizer = optimizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResults execute(QueryContext queryContext, final QueryCommand query) throws QueryCancelledException, RepositoryException {
        CheckArg.isNotNull((Object)queryContext, (String)"queryContext");
        CheckArg.isNotNull((Object)query, (String)"query");
        final ScanQueryContext context = (ScanQueryContext)queryContext;
        this.checkCancelled(context);
        Visitors.visitAll(query, new Visitors.AbstractVisitor(){

            @Override
            public void visit(BindVariableName obj) {
                if (!context.getVariables().keySet().contains(obj.getBindVariableName())) {
                    context.getProblems().addError(GraphI18n.missingVariableValue, new Object[]{obj.getBindVariableName()});
                }
            }
        });
        boolean trace = LOGGER.isTraceEnabled();
        if (trace) {
            LOGGER.trace("Beginning to process query {3} against workspace(s) {0} in '{1}' repository: {2}", new Object[]{context.getWorkspaceNames(), this.repositoryName, query, context.id()});
        }
        long start = System.nanoTime();
        PlanNode plan = this.planner.createPlan(context, query);
        long duration = Math.abs(System.nanoTime() - start);
        QueryResults.Statistics stats = new QueryResults.Statistics(duration);
        String workspaceName = context.getWorkspaceNames().iterator().next();
        if (trace) {
            LOGGER.trace("Computed canonical query plan for query {0}: {1}", new Object[]{context.id(), plan});
        }
        this.checkCancelled(context);
        QueryResults.Columns resultColumns = null;
        if (!context.getProblems().hasErrors()) {
            start = System.nanoTime();
            PlanNode optimizedPlan = this.optimizer.optimize(context, plan);
            duration = Math.abs(System.nanoTime() - start);
            stats = stats.withOptimizationTime(duration);
            if (trace) {
                LOGGER.trace("Computed optimized query plan for query {0}:\n{1}", new Object[]{context.id(), optimizedPlan});
            }
            start = System.nanoTime();
            optimizedPlan.apply(PlanNode.Traversal.POST_ORDER, new PlanNode.Operation(){

                @Override
                public void apply(PlanNode node) {
                    QueryResults.Columns columns = null;
                    switch (node.getType()) {
                        case PROJECT: 
                        case SOURCE: {
                            columns = ScanningQueryEngine.this.determineProjectedColumns(node, context);
                            assert (columns != null);
                            break;
                        }
                        case JOIN: {
                            QueryResults.Columns leftColumns = context.columnsFor(node.getFirstChild());
                            QueryResults.Columns rightColumns = context.columnsFor(node.getLastChild());
                            columns = leftColumns.with(rightColumns);
                            assert (columns != null);
                            break;
                        }
                        case DEPENDENT_QUERY: {
                            columns = context.columnsFor(node.getLastChild());
                            assert (columns != null);
                            break;
                        }
                        case SET_OPERATION: {
                            QueryResults.Columns leftColumns = context.columnsFor(node.getFirstChild());
                            QueryResults.Columns rightColumns = context.columnsFor(node.getLastChild());
                            if (!ScanningQueryEngine.this.checkUnionCompatible(leftColumns, rightColumns, context, query)) break;
                            columns = leftColumns;
                            assert (columns != null);
                            break;
                        }
                        case INDEX: {
                            break;
                        }
                        default: {
                            assert (node.getChildCount() == 1);
                            columns = context.columnsFor(node.getFirstChild());
                            assert (columns != null);
                            break;
                        }
                    }
                    if (columns != null) {
                        context.addColumnsFor(node, columns);
                    }
                }
            });
            Problems problems = context.getProblems();
            if (problems.hasErrors()) {
                throw new RepositoryException(JcrI18n.problemsWithQuery.text(new Object[]{query, problems.toString()}));
            }
            if (LOGGER.isDebugEnabled() && problems.hasWarnings()) {
                LOGGER.debug("There are several warnings with this query: {0}\n{1}", new Object[]{query, problems.toString()});
            }
            resultColumns = context.columnsFor(optimizedPlan);
            assert (resultColumns != null);
            duration = Math.abs(System.nanoTime() - start);
            stats = stats.withResultsFormulationTime(duration);
            if (trace) {
                LOGGER.trace("Computed output columns for query {0}: {1}", new Object[]{context.id(), resultColumns});
            }
            if (!context.getProblems().hasErrors()) {
                this.checkCancelled(context);
                try {
                    start = System.nanoTime();
                    if (trace) {
                        LOGGER.trace("Start executing query {0}", new Object[]{context.id()});
                    }
                    QueryResults results = this.executeOptimizedQuery(context, query, stats, optimizedPlan);
                    if (trace) {
                        LOGGER.trace("Stopped executing query {0}: {1}", new Object[]{context.id(), stats});
                    }
                    QueryResults queryResults = results;
                    return queryResults;
                }
                finally {
                    duration = Math.abs(System.nanoTime() - start);
                    stats = stats.withExecutionTime(duration);
                }
            }
        }
        this.checkCancelled(context);
        if (resultColumns == null) {
            resultColumns = ResultColumns.EMPTY;
        }
        int width = resultColumns.getColumns().size();
        NodeCache cachedNodes = context.getNodeCache(workspaceName);
        return new Results(resultColumns, stats, NodeSequence.emptySequence(width), cachedNodes, context.getProblems(), null);
    }

    protected boolean checkUnionCompatible(QueryResults.Columns results1, QueryResults.Columns results2, ScanQueryContext context, QueryCommand query) {
        if (results1 == results2) {
            return true;
        }
        if (results1 == null || results2 == null) {
            return false;
        }
        if (results1.hasFullTextSearchScores() != results2.hasFullTextSearchScores()) {
            context.getProblems().addError(JcrI18n.setQueryContainsResultSetsWithDifferentFullTextSearch, new Object[0]);
            return false;
        }
        if (results1.getColumns().size() != results2.getColumns().size()) {
            context.getProblems().addError(JcrI18n.setQueryContainsResultSetsWithDifferentNumberOfColumns, new Object[]{results1.getColumns().size(), results2.getColumns().size()});
            return false;
        }
        int numColumns = results1.getColumns().size();
        boolean noProblems = true;
        for (int i = 0; i != numColumns; ++i) {
            String thatType;
            Column thisColumn = results1.getColumns().get(i);
            Column thatColumn = results2.getColumns().get(i);
            if (!thisColumn.getPropertyName().equalsIgnoreCase(thatColumn.getPropertyName())) {
                return false;
            }
            String thisType = results1.getColumnTypeForProperty(thisColumn.getSelectorName(), thisColumn.getPropertyName());
            if (thisType.equalsIgnoreCase(thatType = results2.getColumnTypeForProperty(thatColumn.getSelectorName(), thatColumn.getPropertyName()))) continue;
            context.getProblems().addError(JcrI18n.setQueryContainsResultSetsWithDifferentColumns, new Object[]{thisColumn, thatColumn});
            noProblems = false;
        }
        return noProblems;
    }

    protected QueryResults.Columns determineProjectedColumns(PlanNode optimizedPlan, ScanQueryContext context) {
        PlanHints hints = context.getHints();
        PlanNode project = optimizedPlan;
        if (project.getType() != PlanNode.Type.PROJECT) {
            project = optimizedPlan.findAtOrBelow(PlanNode.Traversal.LEVEL_ORDER, PlanNode.Type.PROJECT);
        }
        if (project != null) {
            List<Column> columns = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
            List<String> columnTypes = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMN_TYPES, String.class);
            boolean includeFullTextSearchScores = hints.hasFullTextSearch;
            if (!includeFullTextSearchScores) {
                for (PlanNode select : optimizedPlan.findAllAtOrBelow(PlanNode.Type.SELECT)) {
                    Constraint constraint = select.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
                    if (!QueryUtil.includeFullTextScores(constraint)) continue;
                    includeFullTextSearchScores = true;
                    break;
                }
            }
            QueryResults.Columns childColumns = context.columnsFor(project.getFirstChild());
            return new ResultColumns(columns, columnTypes, includeFullTextSearchScores, childColumns);
        }
        if (optimizedPlan.getType() == PlanNode.Type.SOURCE) {
            PlanNode source = optimizedPlan;
            List<Schemata.Column> schemataColumns = source.getPropertyAsList(PlanNode.Property.SOURCE_COLUMNS, Schemata.Column.class);
            ArrayList<Column> columns = new ArrayList<Column>(schemataColumns.size());
            ArrayList<String> columnTypes = new ArrayList<String>(schemataColumns.size());
            SelectorName selector = source.getSelectors().iterator().next();
            for (Schemata.Column schemataColumn : schemataColumns) {
                Column column = new Column(selector, schemataColumn.getName(), schemataColumn.getName());
                columns.add(column);
                columnTypes.add(schemataColumn.getPropertyTypeName());
            }
            return new ResultColumns(columns, columnTypes, hints.hasFullTextSearch, null);
        }
        return ResultColumns.EMPTY;
    }

    private void checkCancelled(QueryContext context) throws QueryCancelledException {
        if (context.isCancelled()) {
            throw new QueryCancelledException();
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public QueryContext createQueryContext(ExecutionContext context, RepositoryCache repositoryCache, Set<String> workspaceNames, Map<String, NodeCache> overriddenNodeCachesByWorkspaceName, Schemata schemata, RepositoryIndexes indexDefns, NodeTypes nodeTypes, BufferManager bufferManager, PlanHints hints, Map<String, Object> variables) {
        return new ScanQueryContext(context, repositoryCache, workspaceNames, overriddenNodeCachesByWorkspaceName, schemata, indexDefns, nodeTypes, bufferManager, hints, null, variables, new HashMap<PlanNode, QueryResults.Columns>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueryResults executeOptimizedQuery(ScanQueryContext context, QueryCommand command, QueryResults.Statistics statistics, PlanNode plan) {
        long nanos = System.nanoTime();
        QueryResults.Columns columns = null;
        NodeSequence rows = null;
        String workspaceName = context.getWorkspaceNames().iterator().next();
        try {
            PlanNode project = plan.findAtOrBelow(PlanNode.Type.PROJECT);
            assert (project != null);
            columns = context.columnsFor(plan);
            assert (columns != null);
            boolean trace = LOGGER.isTraceEnabled();
            if (context.getHints().planOnly) {
                if (trace) {
                    LOGGER.trace("Request for only query plan when executing query {0}", new Object[]{context.id()});
                }
                rows = NodeSequence.emptySequence(columns.getColumns().size());
            } else {
                boolean includeSystemContent = context.getHints().includeSystemContent;
                QuerySources sources = new QuerySources(context.getRepositoryCache(), context.getNodeTypes(), workspaceName, includeSystemContent);
                rows = this.createNodeSequence(command, context, plan, columns, sources);
                long nanos2 = System.nanoTime();
                statistics = statistics.withResultsFormulationTime(Math.abs(nanos2 - nanos));
                nanos = nanos2;
                if (rows == null) {
                    assert (context.getProblems().hasErrors() || context.isCancelled());
                    rows = NodeSequence.emptySequence(columns.getColumns().size());
                }
                if (trace) {
                    LOGGER.trace("The execution function for {0}: {1}", new Object[]{context.id(), rows});
                }
            }
        }
        finally {
            statistics = statistics.withExecutionTime(Math.abs(System.nanoTime() - nanos));
        }
        String planDesc = context.getHints().showPlan ? plan.getString() : null;
        NodeCache cachedNodes = context.getNodeCache(workspaceName);
        return new Results(columns, statistics, rows, cachedNodes, context.getProblems(), planDesc);
    }

    protected NodeSequence createNodeSequence(QueryCommand originalQuery, ScanQueryContext context, PlanNode plan, QueryResults.Columns columns, QuerySources sources) {
        NodeSequence rows = null;
        String workspaceName = sources.getWorkspaceName();
        NodeCache cache = context.getNodeCache(workspaceName);
        TypeSystem types = context.getTypeSystem();
        BufferManager bufferManager = context.getBufferManager();
        switch (plan.getType()) {
            case ACCESS: {
                if (plan.hasProperty(PlanNode.Property.ACCESS_NO_RESULTS)) {
                    rows = NodeSequence.emptySequence(columns.getColumns().size());
                    break;
                }
                assert (plan.getChildCount() == 1);
                rows = this.createNodeSequence(originalQuery, context, plan.getFirstChild(), columns, sources);
                break;
            }
            case DEPENDENT_QUERY: {
                assert (plan.getChildCount() == 2);
                PlanNode indepPlan = plan.getFirstChild();
                QueryResults.Columns indepColumns = context.columnsFor(indepPlan);
                String variableName = indepPlan.getProperty(PlanNode.Property.VARIABLE_NAME, String.class);
                NodeSequence independent = this.createNodeSequence(originalQuery, context, indepPlan, indepColumns, sources);
                Column column = indepColumns.getColumns().get(0);
                boolean allowMultiValued = false;
                String typeName = indepColumns.getColumnTypeForProperty(column.getSelectorName(), column.getPropertyName());
                TypeSystem.TypeFactory<?> type = context.getTypeSystem().getTypeFactory(typeName);
                RowExtractors.ExtractFromRow indepExtractor = this.createExtractFromRow(column.getSelectorName(), column.getPropertyName(), context, indepColumns, sources, type, allowMultiValued);
                PlanNode depPlan = plan.getLastChild();
                QueryResults.Columns depColumns = context.columnsFor(depPlan);
                NodeSequence dependent = this.createNodeSequence(originalQuery, context, depPlan, depColumns, sources);
                rows = new DependentQuery(independent, indepExtractor, type, dependent, variableName, context.getVariables());
                break;
            }
            case DUP_REMOVE: {
                assert (plan.getChildCount() == 1);
                if (plan.getFirstChild().getType() == PlanNode.Type.SORT) {
                    rows = this.createNodeSequence(originalQuery, context, plan.getFirstChild(), columns, sources);
                    break;
                }
                rows = this.createNodeSequence(originalQuery, context, plan.getFirstChild(), columns, sources);
                if (rows.isEmpty() || rows instanceof DistinctSequence) break;
                boolean useHeap = false;
                rows = new DistinctSequence(rows, context.getTypeSystem(), context.getBufferManager(), useHeap);
                break;
            }
            case GROUP: {
                throw new UnsupportedOperationException();
            }
            case JOIN: {
                TypeSystem.TypeFactory<?> rightType;
                assert (plan.getChildCount() == 2);
                PlanNode leftPlan = plan.getFirstChild();
                PlanNode rightPlan = plan.getLastChild();
                QueryResults.Columns leftColumns = context.columnsFor(leftPlan);
                QueryResults.Columns rightColumns = context.columnsFor(rightPlan);
                ScanQueryContext joinQueryContext = context;
                if (context.getHints().isExistsQuery) {
                    PlanHints joinPlanHints = context.getHints().clone();
                    joinPlanHints.isExistsQuery = false;
                    joinQueryContext = context.with(joinPlanHints);
                }
                NodeSequence left = this.createNodeSequence(originalQuery, joinQueryContext, leftPlan, leftColumns, sources);
                NodeSequence right = this.createNodeSequence(originalQuery, joinQueryContext, rightPlan, rightColumns, sources);
                JoinAlgorithm algorithm = plan.getProperty(PlanNode.Property.JOIN_ALGORITHM, JoinAlgorithm.class);
                JoinType joinType = plan.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class);
                JoinCondition joinCondition = plan.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class);
                boolean pack = false;
                boolean useHeap = false;
                if (0L >= right.getRowCount() && right.getRowCount() < 100L) {
                    useHeap = true;
                }
                RowExtractors.ExtractFromRow leftExtractor = null;
                RowExtractors.ExtractFromRow rightExtractor = null;
                JoinSequence.RangeProducer<Path> rangeProducer = null;
                switch (algorithm) {
                    case NESTED_LOOP: 
                    case MERGE: {
                        JoinCondition condition;
                        if (joinCondition instanceof SameNodeJoinCondition) {
                            int rightIndex;
                            int leftIndex;
                            boolean joinReversed;
                            condition = (SameNodeJoinCondition)joinCondition;
                            boolean bl = joinReversed = !leftColumns.getSelectorNames().contains(((SameNodeJoinCondition)condition).getSelector1Name());
                            if (joinReversed) {
                                leftIndex = leftColumns.getSelectorIndex(((SameNodeJoinCondition)condition).getSelector2Name());
                                rightIndex = rightColumns.getSelectorIndex(((SameNodeJoinCondition)condition).getSelector1Name());
                            } else {
                                leftIndex = leftColumns.getSelectorIndex(((SameNodeJoinCondition)condition).getSelector1Name());
                                rightIndex = rightColumns.getSelectorIndex(((SameNodeJoinCondition)condition).getSelector2Name());
                            }
                            String relativePath = ((SameNodeJoinCondition)condition).getSelector2Path();
                            if (relativePath != null) {
                                PathFactory pathFactory = context.getExecutionContext().getValueFactories().getPathFactory();
                                Path relPath = (Path)pathFactory.create(relativePath);
                                if (joinReversed) {
                                    leftExtractor = RowExtractors.extractRelativePath(leftIndex, relPath, cache, types);
                                    rightExtractor = RowExtractors.extractPath(rightIndex, cache, types);
                                    break;
                                }
                                leftExtractor = RowExtractors.extractPath(leftIndex, cache, types);
                                rightExtractor = RowExtractors.extractRelativePath(rightIndex, relPath, cache, types);
                                break;
                            }
                            leftExtractor = RowExtractors.extractNodeKey(leftIndex, cache, types);
                            rightExtractor = RowExtractors.extractNodeKey(rightIndex, cache, types);
                            break;
                        }
                        if (joinCondition instanceof ChildNodeJoinCondition) {
                            int rightIndex;
                            int leftIndex;
                            boolean joinReversed;
                            condition = (ChildNodeJoinCondition)joinCondition;
                            boolean bl = joinReversed = !leftColumns.getSelectorNames().contains(((ChildNodeJoinCondition)condition).getParentSelectorName());
                            if (joinReversed) {
                                leftIndex = leftColumns.getSelectorIndex(((ChildNodeJoinCondition)condition).getChildSelectorName());
                                rightIndex = rightColumns.getSelectorIndex(((ChildNodeJoinCondition)condition).getParentSelectorName());
                                leftExtractor = RowExtractors.extractParentNodeKey(leftIndex, cache, types);
                                rightExtractor = RowExtractors.extractNodeKey(rightIndex, cache, types);
                                break;
                            }
                            leftIndex = leftColumns.getSelectorIndex(((ChildNodeJoinCondition)condition).getParentSelectorName());
                            rightIndex = rightColumns.getSelectorIndex(((ChildNodeJoinCondition)condition).getChildSelectorName());
                            leftExtractor = RowExtractors.extractNodeKey(leftIndex, cache, types);
                            rightExtractor = RowExtractors.extractParentNodeKey(rightIndex, cache, types);
                            break;
                        }
                        if (joinCondition instanceof EquiJoinCondition) {
                            condition = (EquiJoinCondition)joinCondition;
                            boolean joinReversed = !leftColumns.getSelectorNames().contains(((EquiJoinCondition)condition).getSelector1Name());
                            String sel1 = ((EquiJoinCondition)condition).getSelector1Name();
                            String sel2 = ((EquiJoinCondition)condition).getSelector2Name();
                            String prop1 = ((EquiJoinCondition)condition).getProperty1Name();
                            String prop2 = ((EquiJoinCondition)condition).getProperty2Name();
                            if (joinReversed) {
                                leftExtractor = this.createExtractFromRow(sel2, prop2, joinQueryContext, leftColumns, sources, null, true);
                                rightExtractor = this.createExtractFromRow(sel1, prop1, joinQueryContext, rightColumns, sources, null, true);
                                break;
                            }
                            leftExtractor = this.createExtractFromRow(sel1, prop1, joinQueryContext, leftColumns, sources, null, true);
                            rightExtractor = this.createExtractFromRow(sel2, prop2, joinQueryContext, rightColumns, sources, null, true);
                            break;
                        }
                        if (joinCondition instanceof DescendantNodeJoinCondition) {
                            condition = (DescendantNodeJoinCondition)joinCondition;
                            assert (leftColumns.getSelectorNames().contains(((DescendantNodeJoinCondition)condition).getAncestorSelectorName()));
                            String ancestorSelector = ((DescendantNodeJoinCondition)condition).getAncestorSelectorName();
                            String descendantSelector = ((DescendantNodeJoinCondition)condition).getDescendantSelectorName();
                            int ancestorSelectorIndex = leftColumns.getSelectorIndex(ancestorSelector);
                            int descendantSelectorIndex = rightColumns.getSelectorIndex(descendantSelector);
                            leftExtractor = RowExtractors.extractPath(ancestorSelectorIndex, cache, types);
                            rightExtractor = RowExtractors.extractPath(descendantSelectorIndex, cache, types);
                            final PathFactory paths = context.getExecutionContext().getValueFactories().getPathFactory();
                            rangeProducer = new JoinSequence.RangeProducer<Path>(){

                                @Override
                                public JoinSequence.Range<Path> getRange(Path leftPath) {
                                    if (leftPath.isRoot()) {
                                        return new JoinSequence.Range<Object>(leftPath, false, null, true);
                                    }
                                    boolean includeLower = false;
                                    Path.Segment lastSegment = leftPath.getLastSegment();
                                    Path.Segment upperSegment = paths.createSegment(lastSegment.getName(), lastSegment.getIndex() + 1);
                                    Path upperBoundPath = paths.create(leftPath.getParent(), upperSegment);
                                    return new JoinSequence.Range<Path>(leftPath, includeLower, upperBoundPath, false);
                                }
                            };
                            break;
                        }
                        assert (false) : "Unable to use merge algorithm with join conditions: " + joinCondition;
                        throw new UnsupportedOperationException();
                    }
                }
                assert (leftExtractor != null);
                assert (rightExtractor != null);
                TypeSystem.TypeFactory<?> leftType = leftExtractor.getType();
                if (!leftType.equals(rightType = rightExtractor.getType())) {
                    TypeSystem.TypeFactory<?> commonType = context.getTypeSystem().getCompatibleType(leftType, rightType);
                    if (!leftType.equals(commonType)) {
                        leftExtractor = RowExtractors.convert(leftExtractor, commonType);
                    }
                    if (!rightType.equals(commonType)) {
                        rightExtractor = RowExtractors.convert(rightExtractor, commonType);
                    }
                }
                rows = new HashJoinSequence(workspaceName, left, right, leftExtractor, rightExtractor, joinType, context.getBufferManager(), (CachedNodeSupplier)cache, rangeProducer, pack, useHeap);
                NodeSequence.RowFilter filter = null;
                List<Constraint> constraints = plan.getPropertyAsList(PlanNode.Property.JOIN_CONSTRAINTS, Constraint.class);
                if (constraints != null) {
                    for (Constraint constraint : constraints) {
                        NodeSequence.RowFilter constraintFilter = this.createRowFilter(constraint, context, columns, sources);
                        filter = NodeSequence.requireBoth(filter, constraintFilter);
                    }
                }
                rows = NodeSequence.filter(rows, filter);
                break;
            }
            case LIMIT: {
                assert (plan.getChildCount() == 1);
                rows = this.createNodeSequence(originalQuery, context, plan.getFirstChild(), columns, sources);
                Integer rowLimit = plan.getProperty(PlanNode.Property.LIMIT_COUNT, Integer.class);
                Integer offset = plan.getProperty(PlanNode.Property.LIMIT_OFFSET, Integer.class);
                Limit limit = Limit.NONE;
                if (rowLimit != null) {
                    limit = limit.withRowLimit(rowLimit);
                }
                if (offset != null) {
                    limit = limit.withOffset(offset);
                }
                if (limit.isUnlimited()) break;
                rows = NodeSequence.limit(rows, limit);
                break;
            }
            case NULL: {
                rows = NodeSequence.emptySequence(columns.getColumns().size());
                break;
            }
            case PROJECT: {
                PlanNode child = plan.getFirstChild();
                columns = context.columnsFor(child);
                rows = this.createNodeSequence(originalQuery, context, child, columns, sources);
                break;
            }
            case SELECT: {
                assert (plan.getChildCount() == 1);
                rows = this.createNodeSequence(originalQuery, context, plan.getFirstChild(), columns, sources);
                Constraint constraint = plan.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
                NodeSequence.RowFilter filter = this.createRowFilter(constraint, context, columns, sources);
                rows = NodeSequence.filter(rows, filter);
                break;
            }
            case SET_OPERATION: {
                boolean useHeap;
                SetQuery.Operation operation = plan.getProperty(PlanNode.Property.SET_OPERATION, SetQuery.Operation.class);
                boolean all = plan.getProperty(PlanNode.Property.SET_USE_ALL, Boolean.class);
                PlanNode firstPlan = plan.getFirstChild();
                PlanNode secondPlan = plan.getLastChild();
                QueryResults.Columns firstColumns = context.columnsFor(firstPlan);
                QueryResults.Columns secondColumns = context.columnsFor(secondPlan);
                NodeSequence first = this.createNodeSequence(originalQuery, context, firstPlan, firstColumns, sources);
                NodeSequence second = this.createNodeSequence(originalQuery, context, secondPlan, secondColumns, sources);
                boolean bl = useHeap = 0L >= second.getRowCount() && second.getRowCount() < 100L;
                if (first.width() != second.width()) {
                    first = NodeSequence.slice(first, firstColumns);
                    second = NodeSequence.slice(second, secondColumns);
                    assert (first.width() == second.width());
                }
                boolean pack = false;
                switch (operation) {
                    case UNION: {
                        if (first.isEmpty()) {
                            return second;
                        }
                        if (second.isEmpty()) {
                            return first;
                        }
                        rows = NodeSequence.append(first, second);
                        break;
                    }
                    case INTERSECT: {
                        if (first.isEmpty()) {
                            return first;
                        }
                        if (second.isEmpty()) {
                            return second;
                        }
                        rows = new IntersectSequence(workspaceName, first, second, types, bufferManager, cache, pack, useHeap);
                        break;
                    }
                    case EXCEPT: {
                        if (second.isEmpty()) {
                            return first;
                        }
                        rows = new ExceptSequence(workspaceName, first, second, types, bufferManager, cache, pack, useHeap);
                    }
                }
                if (all) break;
                useHeap = false;
                rows = new DistinctSequence(rows, context.getTypeSystem(), context.getBufferManager(), useHeap);
                break;
            }
            case SORT: {
                List<Object> orderBys;
                PlanNode parent;
                assert (plan.getChildCount() == 1);
                PlanNode delegate = plan.getFirstChild();
                boolean allowDuplicates = true;
                if (delegate.getType() == PlanNode.Type.DUP_REMOVE) {
                    delegate = delegate.getFirstChild();
                    allowDuplicates = false;
                }
                if ((parent = plan.getParent()) != null && parent.getType() == PlanNode.Type.DUP_REMOVE) {
                    allowDuplicates = false;
                }
                if ((rows = this.createNodeSequence(originalQuery, context, delegate, columns, sources)).isEmpty() || (orderBys = plan.getPropertyAsList(PlanNode.Property.SORT_ORDER_BY, Object.class)).isEmpty()) break;
                RowExtractors.ExtractFromRow sortExtractor = null;
                boolean pack = false;
                boolean useHeap = false;
                NullOrder nullOrder = null;
                if (orderBys.get(0) instanceof Ordering) {
                    ArrayList<Ordering> orderings = new ArrayList<Ordering>(orderBys.size());
                    for (Object orderBy : orderBys) {
                        orderings.add((Ordering)orderBy);
                    }
                    HashMap<SelectorName, SelectorName> sourceNamesByAlias = new HashMap<SelectorName, SelectorName>();
                    for (PlanNode source : plan.findAllAtOrBelow(PlanNode.Type.SOURCE)) {
                        SelectorName name = source.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class);
                        SelectorName alias = source.getProperty(PlanNode.Property.SOURCE_ALIAS, SelectorName.class);
                        if (alias == null) continue;
                        sourceNamesByAlias.put(alias, name);
                    }
                    if (orderings.size() == 1) {
                        nullOrder = ((Ordering)orderings.get(0)).nullOrder();
                    }
                    sortExtractor = this.createSortingExtractor(orderings, sourceNamesByAlias, (QueryContext)context, columns, sources);
                } else {
                    final TypeSystem.TypeFactory<Reference> keyType = context.getTypeSystem().getReferenceFactory();
                    ArrayList<RowExtractors.ExtractFromRow> extractors = new ArrayList<RowExtractors.ExtractFromRow>();
                    for (Object ordering : orderBys) {
                        SelectorName selectorName = (SelectorName)ordering;
                        final int index = columns.getSelectorIndex(selectorName.name());
                        extractors.add(new RowExtractors.ExtractFromRow(){

                            @Override
                            public TypeSystem.TypeFactory<?> getType() {
                                return keyType;
                            }

                            @Override
                            public Object getValueInRow(NodeSequence.RowAccessor row) {
                                CachedNode node = row.getNode(index);
                                return node != null ? node.getKey() : null;
                            }
                        });
                    }
                    nullOrder = NullOrder.NULLS_LAST;
                    sortExtractor = RowExtractors.extractorWith(extractors);
                }
                if (sortExtractor == null) break;
                rows = new SortingSequence(workspaceName, rows, sortExtractor, bufferManager, cache, pack, useHeap, allowDuplicates, nullOrder);
                break;
            }
            case SOURCE: {
                rows = this.createNodeSequenceForSource(originalQuery, context, plan, columns, sources);
                break;
            }
        }
        return rows;
    }

    protected NodeSequence createNodeSequenceForSource(QueryCommand originalQuery, QueryContext context, PlanNode sourceNode, QueryResults.Columns columns, QuerySources sources) {
        for (PlanNode indexNode : sourceNode.getChildren()) {
            if (indexNode.getType() != PlanNode.Type.INDEX) continue;
            IndexPlan index = indexNode.getProperty(PlanNode.Property.INDEX_SPECIFICATION, IndexPlan.class);
            NodeSequence sequence = this.createNodeSequenceForSource(originalQuery, context, sourceNode, index, columns, sources);
            if (sequence != null) {
                indexNode.setProperty(PlanNode.Property.INDEX_USED, Boolean.TRUE);
                return sequence;
            }
            LOGGER.debug("Skipping disabled index '{0}' from provider '{1}' in workspace(s) {2} for query: {3}", new Object[]{index.getName(), index.getProviderName(), context.getWorkspaceNames(), originalQuery});
        }
        return sources.allNodes(1.0f, -1L);
    }

    protected NodeSequence createNodeSequenceForSource(QueryCommand originalQuery, QueryContext context, PlanNode sourceNode, IndexPlan index, QueryResults.Columns columns, QuerySources sources) {
        if (index.getProviderName() == null) {
            String idStr;
            String name = index.getName();
            String pathStr = (String)index.getParameters().get("path");
            if (pathStr != null) {
                if ("NodeByPath".equals(name)) {
                    PathFactory paths = context.getExecutionContext().getValueFactories().getPathFactory();
                    Path path = (Path)paths.create(pathStr);
                    return sources.singleNode(path, 1.0f);
                }
                if ("ChildrenByPath".equals(name)) {
                    PathFactory paths = context.getExecutionContext().getValueFactories().getPathFactory();
                    Path path = (Path)paths.create(pathStr);
                    return sources.childNodes(path, 1.0f);
                }
                if ("DescendantsByPath".equals(name)) {
                    PathFactory paths = context.getExecutionContext().getValueFactories().getPathFactory();
                    Path path = (Path)paths.create(pathStr);
                    return sources.descendantNodes(path, 1.0f);
                }
            }
            if ((idStr = (String)index.getParameters().get("id")) != null && "NodeById".equals(name)) {
                StringFactory string = context.getExecutionContext().getValueFactories().getStringFactory();
                String id = (String)string.create(idStr);
                String workspaceName = context.getWorkspaceNames().iterator().next();
                return sources.singleNode(workspaceName, id, 1.0f);
            }
        }
        return null;
    }

    protected RowExtractors.ExtractFromRow createSortingExtractor(List<Ordering> orderings, Map<SelectorName, SelectorName> sourceNamesByAlias, QueryContext context, QueryResults.Columns columns, QuerySources sources) {
        if (orderings.size() == 1) {
            return this.createSortingExtractor(orderings.get(0), sourceNamesByAlias, context, columns, sources);
        }
        if (orderings.size() == 2) {
            RowExtractors.ExtractFromRow first = this.createSortingExtractor(orderings.get(0), sourceNamesByAlias, context, columns, sources);
            RowExtractors.ExtractFromRow second = this.createSortingExtractor(orderings.get(1), sourceNamesByAlias, context, columns, sources);
            return RowExtractors.extractorWith(first, second);
        }
        if (orderings.size() == 3) {
            RowExtractors.ExtractFromRow first = this.createSortingExtractor(orderings.get(0), sourceNamesByAlias, context, columns, sources);
            RowExtractors.ExtractFromRow second = this.createSortingExtractor(orderings.get(1), sourceNamesByAlias, context, columns, sources);
            RowExtractors.ExtractFromRow third = this.createSortingExtractor(orderings.get(2), sourceNamesByAlias, context, columns, sources);
            return RowExtractors.extractorWith(first, second, third);
        }
        if (orderings.size() == 4) {
            RowExtractors.ExtractFromRow first = this.createSortingExtractor(orderings.get(0), sourceNamesByAlias, context, columns, sources);
            RowExtractors.ExtractFromRow second = this.createSortingExtractor(orderings.get(1), sourceNamesByAlias, context, columns, sources);
            RowExtractors.ExtractFromRow third = this.createSortingExtractor(orderings.get(2), sourceNamesByAlias, context, columns, sources);
            RowExtractors.ExtractFromRow fourth = this.createSortingExtractor(orderings.get(3), sourceNamesByAlias, context, columns, sources);
            return RowExtractors.extractorWith(first, second, third, fourth);
        }
        ArrayList<RowExtractors.ExtractFromRow> extractors = new ArrayList<RowExtractors.ExtractFromRow>(orderings.size());
        for (Ordering ordering : orderings) {
            extractors.add(this.createSortingExtractor(ordering, sourceNamesByAlias, context, columns, sources));
        }
        return RowExtractors.extractorWith(extractors);
    }

    protected RowExtractors.ExtractFromRow createSortingExtractor(Ordering ordering, Map<SelectorName, SelectorName> sourceNamesByAlias, QueryContext context, QueryResults.Columns columns, QuerySources sources) {
        DynamicOperand operand = ordering.getOperand();
        TypeSystem.TypeFactory<String> defaultType = context.getTypeSystem().getStringFactory();
        RowExtractors.ExtractFromRow extractor = this.createExtractFromRow(operand, context, columns, sources, defaultType, false, false);
        return RowExtractors.extractorWith(extractor, ordering.order(), ordering.nullOrder());
    }

    protected NodeSequence.RowFilter createRowFilter(final Constraint constraint, final QueryContext context, QueryResults.Columns columns, QuerySources sources) {
        assert (constraint != null);
        assert (context != null);
        assert (columns != null);
        assert (sources != null);
        if (constraint instanceof Or) {
            Or orConstraint = (Or)constraint;
            final NodeSequence.RowFilter left = this.createRowFilter(orConstraint.left(), context, columns, sources);
            final NodeSequence.RowFilter right = this.createRowFilter(orConstraint.right(), context, columns, sources);
            return new NodeSequence.RowFilter(){

                @Override
                public boolean isCurrentRowValid(NodeSequence.Batch batch) {
                    return left.isCurrentRowValid(batch) || right.isCurrentRowValid(batch);
                }

                public String toString() {
                    return "(or " + left + "," + right + " )";
                }
            };
        }
        if (constraint instanceof Not) {
            Not notConstraint = (Not)constraint;
            final NodeSequence.RowFilter not = this.createRowFilter(notConstraint.getConstraint(), context, columns, sources);
            return new NodeSequence.RowFilter(){

                @Override
                public boolean isCurrentRowValid(NodeSequence.Batch batch) {
                    return !not.isCurrentRowValid(batch);
                }

                public String toString() {
                    return "(not " + not + " )";
                }
            };
        }
        if (constraint instanceof And) {
            And andConstraint = (And)constraint;
            final NodeSequence.RowFilter left = this.createRowFilter(andConstraint.left(), context, columns, sources);
            final NodeSequence.RowFilter right = this.createRowFilter(andConstraint.right(), context, columns, sources);
            return new NodeSequence.RowFilter(){

                @Override
                public boolean isCurrentRowValid(NodeSequence.Batch batch) {
                    return left.isCurrentRowValid(batch) && right.isCurrentRowValid(batch);
                }

                public String toString() {
                    return "(and " + left + "," + right + " )";
                }
            };
        }
        if (constraint instanceof ChildNode) {
            NodeCache cache;
            ChildNode childConstraint = (ChildNode)constraint;
            PathFactory paths = context.getExecutionContext().getValueFactories().getPathFactory();
            Path parentPath = (Path)paths.create(childConstraint.getParentPath());
            CachedNode parent = sources.getNodeAtPath(parentPath, cache = context.getNodeCache(sources.getWorkspaceName()));
            if (parent == null) {
                return NodeSequence.NO_PASS_ROW_FILTER;
            }
            final NodeKey parentKey = parent.getKey();
            final boolean isParentRoot = parentPath.isRoot();
            String selectorName = childConstraint.getSelectorName();
            final int index = columns.getSelectorIndex(selectorName);
            return new NodeSequence.RowFilter(){

                @Override
                public boolean isCurrentRowValid(NodeSequence.Batch batch) {
                    CachedNode node = batch.getNode(index);
                    if (node == null) {
                        return false;
                    }
                    if (isParentRoot) {
                        return true;
                    }
                    return parentKey.equals(node.getParentKey(cache));
                }

                public String toString() {
                    return "(filter " + Visitors.readable(constraint) + ")";
                }
            };
        }
        if (constraint instanceof DescendantNode) {
            NodeCache cache;
            DescendantNode descendantNode = (DescendantNode)constraint;
            PathFactory paths = context.getExecutionContext().getValueFactories().getPathFactory();
            Path ancestorPath = (Path)paths.create(descendantNode.getAncestorPath());
            CachedNode ancestor = sources.getNodeAtPath(ancestorPath, cache = context.getNodeCache(sources.getWorkspaceName()));
            if (ancestor == null) {
                return NodeSequence.NO_PASS_ROW_FILTER;
            }
            final NodeKey ancestorKey = ancestor.getKey();
            String selectorName = descendantNode.getSelectorName();
            final int index = columns.getSelectorIndex(selectorName);
            return new NodeSequence.RowFilter(){

                @Override
                public boolean isCurrentRowValid(NodeSequence.Batch batch) {
                    CachedNode node = batch.getNode(index);
                    while (node != null) {
                        NodeKey parentKey = node.getParentKey(cache);
                        if (parentKey == null) {
                            return false;
                        }
                        if (ancestorKey.equals(parentKey)) {
                            return true;
                        }
                        node = cache.getNode(parentKey);
                    }
                    return false;
                }

                public String toString() {
                    return "(filter " + Visitors.readable(constraint) + ")";
                }
            };
        }
        if (constraint instanceof SameNode) {
            NodeCache cache;
            SameNode sameNode = (SameNode)constraint;
            PathFactory paths = context.getExecutionContext().getValueFactories().getPathFactory();
            Path path = (Path)paths.create(sameNode.getPath());
            CachedNode node = sources.getNodeAtPath(path, cache = context.getNodeCache(sources.getWorkspaceName()));
            if (node == null) {
                return NodeSequence.NO_PASS_ROW_FILTER;
            }
            final NodeKey nodeKey = node.getKey();
            String selectorName = sameNode.getSelectorName();
            final int index = columns.getSelectorIndex(selectorName);
            return new NodeSequence.RowFilter(){

                @Override
                public boolean isCurrentRowValid(NodeSequence.Batch batch) {
                    CachedNode node = batch.getNode(index);
                    return node != null && nodeKey.equals(node.getKey());
                }

                public String toString() {
                    return "(filter " + Visitors.readable(constraint) + ")";
                }
            };
        }
        if (constraint instanceof PropertyExistence) {
            PropertyExistence propertyExistance = (PropertyExistence)constraint;
            NameFactory names = context.getExecutionContext().getValueFactories().getNameFactory();
            final Name propertyName = (Name)names.create(propertyExistance.getPropertyName());
            String selectorName = propertyExistance.selectorName().name();
            final int index = columns.getSelectorIndex(selectorName);
            final NodeCache cache = context.getNodeCache(sources.getWorkspaceName());
            assert (index >= 0);
            return new NodeSequence.RowFilter(){

                @Override
                public boolean isCurrentRowValid(NodeSequence.Batch batch) {
                    CachedNode node = batch.getNode(index);
                    return node != null && node.hasProperty(propertyName, cache);
                }

                public String toString() {
                    return "(filter " + Visitors.readable(constraint) + ")";
                }
            };
        }
        if (constraint instanceof Between) {
            Between between = (Between)constraint;
            final org.modeshape.jcr.query.model.StaticOperand lower = between.getLowerBound();
            final org.modeshape.jcr.query.model.StaticOperand upper = between.getUpperBound();
            final boolean includeLower = between.isLowerBoundIncluded();
            final boolean includeUpper = between.isUpperBoundIncluded();
            DynamicOperand dynamicOperand = between.getOperand();
            final TypeSystem.TypeFactory<?> defaultType = this.determineType(dynamicOperand, context, columns);
            final RowExtractors.ExtractFromRow operation = this.createExtractFromRow(dynamicOperand, context, columns, sources, defaultType, true, false);
            return new RowFilterSupplier(){

                @Override
                protected NodeSequence.RowFilter createFilter() {
                    Object lowerLiteralValue = ScanningQueryEngine.literalValue(lower, context, defaultType);
                    Object upperLiteralValue = ScanningQueryEngine.literalValue(upper, context, defaultType);
                    TypeSystem.TypeFactory<?> expectedType = operation.getType();
                    final Object lowerValue = expectedType.create(lowerLiteralValue);
                    final Object upperValue = expectedType.create(upperLiteralValue);
                    final Comparator<?> comparator = expectedType.getComparator();
                    if (includeLower) {
                        if (includeUpper) {
                            return new DynamicOperandFilter(operation){

                                @Override
                                protected boolean evaluate(Object leftHandValue) {
                                    if (leftHandValue == null) {
                                        return false;
                                    }
                                    return comparator.compare(leftHandValue, lowerValue) >= 0 && comparator.compare(leftHandValue, upperValue) <= 0;
                                }

                                public String toString() {
                                    return "(filter " + Visitors.readable(constraint) + ")";
                                }
                            };
                        }
                        return new DynamicOperandFilter(operation){

                            @Override
                            protected boolean evaluate(Object leftHandValue) {
                                if (leftHandValue == null) {
                                    return false;
                                }
                                return comparator.compare(leftHandValue, lowerValue) >= 0 && comparator.compare(leftHandValue, upperValue) < 0;
                            }

                            public String toString() {
                                return "(filter " + Visitors.readable(constraint) + ")";
                            }
                        };
                    }
                    assert (!includeLower);
                    if (includeUpper) {
                        return new DynamicOperandFilter(operation){

                            @Override
                            protected boolean evaluate(Object leftHandValue) {
                                if (leftHandValue == null) {
                                    return false;
                                }
                                return comparator.compare(leftHandValue, lowerValue) > 0 && comparator.compare(leftHandValue, upperValue) <= 0;
                            }

                            public String toString() {
                                return "(filter " + Visitors.readable(constraint) + ")";
                            }
                        };
                    }
                    return new DynamicOperandFilter(operation){

                        @Override
                        protected boolean evaluate(Object leftHandValue) {
                            if (leftHandValue == null) {
                                return false;
                            }
                            return comparator.compare(leftHandValue, lowerValue) > 0 && comparator.compare(leftHandValue, upperValue) < 0;
                        }

                        public String toString() {
                            return "(filter " + Visitors.readable(constraint) + ")";
                        }
                    };
                }
            };
        }
        if (constraint instanceof Comparison) {
            Comparison comparison = (Comparison)constraint;
            DynamicOperand dynamicOperand = comparison.getOperand1();
            final Operator operator = comparison.operator();
            final org.modeshape.jcr.query.model.StaticOperand staticOperand = comparison.getOperand2();
            final TypeSystem.TypeFactory<?> actualType = this.determineType(dynamicOperand, context, columns);
            TypeSystem.TypeFactory<Object> expectedType = null;
            RowExtractors.ExtractFromRow op = null;
            if (operator == Operator.LIKE) {
                expectedType = context.getTypeSystem().getStringFactory();
                op = this.createExtractFromRow(dynamicOperand, context, columns, sources, expectedType, true, true);
                if (op.getType() != expectedType) {
                    op = RowExtractors.convert(op, expectedType);
                }
            } else {
                expectedType = actualType;
                op = this.createExtractFromRow(dynamicOperand, context, columns, sources, expectedType, true, false);
            }
            final TypeSystem.TypeFactory<Object> defaultType = expectedType;
            final RowExtractors.ExtractFromRow operation = op;
            return new RowFilterSupplier(){

                @Override
                protected NodeSequence.RowFilter createFilter() {
                    Object literalValue = ScanningQueryEngine.literalValue(staticOperand, context, defaultType);
                    TypeSystem.TypeFactory<?> expectedType = operation.getType();
                    final Object rhs = expectedType.create(literalValue);
                    final Comparator<?> comparator = expectedType.getComparator();
                    switch (operator) {
                        case EQUAL_TO: {
                            return new DynamicOperandFilter(operation){

                                @Override
                                protected boolean evaluate(Object leftHandValue) {
                                    if (leftHandValue == null) {
                                        return false;
                                    }
                                    return comparator.compare(leftHandValue, rhs) == 0;
                                }

                                public String toString() {
                                    return "(filter " + Visitors.readable(constraint) + ")";
                                }
                            };
                        }
                        case NOT_EQUAL_TO: {
                            return new DynamicOperandFilter(operation){

                                @Override
                                protected boolean evaluate(Object leftHandValue) {
                                    if (leftHandValue == null) {
                                        return false;
                                    }
                                    return comparator.compare(leftHandValue, rhs) != 0;
                                }

                                public String toString() {
                                    return "(filter " + Visitors.readable(constraint) + ")";
                                }
                            };
                        }
                        case GREATER_THAN: {
                            return new DynamicOperandFilter(operation){

                                @Override
                                protected boolean evaluate(Object leftHandValue) {
                                    if (leftHandValue == null) {
                                        return false;
                                    }
                                    return comparator.compare(leftHandValue, rhs) > 0;
                                }

                                public String toString() {
                                    return "(filter " + Visitors.readable(constraint) + ")";
                                }
                            };
                        }
                        case GREATER_THAN_OR_EQUAL_TO: {
                            return new DynamicOperandFilter(operation){

                                @Override
                                protected boolean evaluate(Object leftHandValue) {
                                    if (leftHandValue == null) {
                                        return false;
                                    }
                                    return comparator.compare(leftHandValue, rhs) >= 0;
                                }

                                public String toString() {
                                    return "(filter " + Visitors.readable(constraint) + ")";
                                }
                            };
                        }
                        case LESS_THAN: {
                            return new DynamicOperandFilter(operation){

                                @Override
                                protected boolean evaluate(Object leftHandValue) {
                                    if (leftHandValue == null) {
                                        return false;
                                    }
                                    return comparator.compare(leftHandValue, rhs) < 0;
                                }

                                public String toString() {
                                    return "(filter " + Visitors.readable(constraint) + ")";
                                }
                            };
                        }
                        case LESS_THAN_OR_EQUAL_TO: {
                            return new DynamicOperandFilter(operation){

                                @Override
                                protected boolean evaluate(Object leftHandValue) {
                                    if (leftHandValue == null) {
                                        return false;
                                    }
                                    return comparator.compare(leftHandValue, rhs) <= 0;
                                }

                                public String toString() {
                                    return "(filter " + Visitors.readable(constraint) + ")";
                                }
                            };
                        }
                        case LIKE: {
                            final TypeSystem types = context.getTypeSystem();
                            String expression = types.asString(rhs).trim();
                            if ("%".equals(expression)) {
                                return new DynamicOperandFilter(operation){

                                    @Override
                                    protected boolean evaluate(Object leftHandValue) {
                                        return leftHandValue != null;
                                    }

                                    public String toString() {
                                        return "(filter " + Visitors.readable(constraint) + ")";
                                    }
                                };
                            }
                            if (Path.class.isAssignableFrom(actualType.getType())) {
                                final PathFactory paths = context.getExecutionContext().getValueFactories().getPathFactory();
                                expression = QueryUtil.addSnsIndexesToLikeExpression(expression);
                                String regex = QueryUtil.toRegularExpression(expression);
                                final Pattern pattern = Pattern.compile(regex);
                                return new DynamicOperandFilter(operation){

                                    @Override
                                    protected boolean evaluate(Object leftHandValue) {
                                        if (leftHandValue == null) {
                                            return false;
                                        }
                                        Path path = (Path)paths.create(leftHandValue);
                                        String strValue = null;
                                        if (path.isRoot()) {
                                            strValue = "/";
                                        } else {
                                            StringBuilder sb = new StringBuilder();
                                            for (Path.Segment segment : path) {
                                                sb.append('/').append(types.asString(segment.getName()));
                                                sb.append('[').append(segment.getIndex()).append(']');
                                            }
                                            strValue = sb.toString();
                                        }
                                        return pattern.matcher(strValue).matches();
                                    }

                                    public String toString() {
                                        return "(filter " + Visitors.readable(constraint) + ")";
                                    }
                                };
                            }
                            String regex = QueryUtil.toRegularExpression(expression);
                            final Pattern pattern = Pattern.compile(regex);
                            return new DynamicOperandFilter(operation){

                                @Override
                                protected boolean evaluate(Object leftHandValue) {
                                    if (leftHandValue == null) {
                                        return false;
                                    }
                                    String value = types.asString(leftHandValue);
                                    return pattern.matcher(value).matches();
                                }

                                public String toString() {
                                    return "(filter " + Visitors.readable(constraint) + ")";
                                }
                            };
                        }
                    }
                    assert (false) : "Should not get here";
                    return null;
                }
            };
        }
        if (constraint instanceof SetCriteria) {
            final SetCriteria setCriteria = (SetCriteria)constraint;
            DynamicOperand operand = setCriteria.getOperand();
            final TypeSystem.TypeFactory<?> defaultType = this.determineType(operand, context, columns);
            final RowExtractors.ExtractFromRow operation = this.createExtractFromRow(operand, context, columns, sources, defaultType, true, false);
            final boolean trace = LOGGER.isTraceEnabled() && !defaultType.getTypeName().equals("NAME");
            final PathFactory pathFactory = context.getExecutionContext().getValueFactories().getPathFactory();
            return new RowFilterSupplier(){

                @Override
                protected NodeSequence.RowFilter createFilter() {
                    final Set<?> values = ScanningQueryEngine.literalValues(setCriteria, context, defaultType);
                    return new DynamicOperandFilter(operation){

                        @Override
                        protected boolean evaluate(Object leftHandValue) {
                            if (Path.class.isAssignableFrom(defaultType.getType())) {
                                Object object = leftHandValue = leftHandValue instanceof Object[] ? pathFactory.create((Object[])leftHandValue) : pathFactory.create(leftHandValue);
                            }
                            if (leftHandValue instanceof Object[]) {
                                for (Object leftValue : (Object[])leftHandValue) {
                                    if (!values.contains(leftValue)) continue;
                                    if (trace) {
                                        LOGGER.trace("Found '{0}' in values: {1}", new Object[]{leftHandValue, values});
                                    }
                                    return true;
                                }
                                if (trace) {
                                    LOGGER.trace("Failed to find '{0}' in values: {1}", new Object[]{leftHandValue, values});
                                }
                                return false;
                            }
                            if (values.contains(leftHandValue)) {
                                if (trace) {
                                    LOGGER.trace("Found '{0}' in values: {1}", new Object[]{leftHandValue, values});
                                }
                                return true;
                            }
                            if (trace) {
                                LOGGER.trace("Failed to find '{0}' in values: {1}", new Object[]{leftHandValue, values});
                            }
                            return false;
                        }

                        public String toString() {
                            return "(filter " + Visitors.readable(constraint) + ")";
                        }
                    };
                }
            };
        }
        if (constraint instanceof FullTextSearch) {
            Object searchExpression;
            final TypeSystem.TypeFactory<String> strings = context.getTypeSystem().getStringFactory();
            org.modeshape.jcr.query.model.StaticOperand ftsExpression = ((FullTextSearch)constraint).getFullTextSearchExpression();
            final FullTextSearch fts = ftsExpression instanceof BindVariableName ? ((searchExpression = ScanningQueryEngine.literalValue(ftsExpression, context, strings)) != null ? ((FullTextSearch)constraint).withFullTextExpression(searchExpression.toString()) : (FullTextSearch)constraint) : (FullTextSearch)constraint;
            NodeCache cache = context.getNodeCache(sources.getWorkspaceName());
            final BinaryStore binaries = context.getExecutionContext().getBinaryStore();
            String selectorName = fts.getSelectorName();
            String propertyName = fts.getPropertyName();
            int index = columns.getSelectorIndex(selectorName);
            RowExtractors.ExtractFromRow fullTextExtractor = null;
            if (propertyName != null) {
                final RowExtractors.ExtractFromRow propertyValueExtractor = this.createExtractFromRow(selectorName, propertyName, context, columns, sources, strings, true);
                fullTextExtractor = new RowExtractors.ExtractFromRow(){

                    @Override
                    public TypeSystem.TypeFactory<?> getType() {
                        return strings;
                    }

                    @Override
                    public Object getValueInRow(NodeSequence.RowAccessor row) {
                        Object result = propertyValueExtractor.getValueInRow(row);
                        if (result == null) {
                            return null;
                        }
                        StringBuilder fullTextString = new StringBuilder();
                        RowExtractors.extractFullTextFrom(result, strings, binaries, fullTextString);
                        return fullTextString.toString();
                    }
                };
            } else {
                fullTextExtractor = RowExtractors.extractFullText(index, cache, context.getTypeSystem(), binaries);
            }
            RowExtractors.ExtractFromRow extractor = fullTextExtractor;
            return new DynamicOperandFilter(extractor){

                @Override
                protected boolean evaluate(Object leftHandValue) {
                    return fts.getTerm().matches(leftHandValue.toString());
                }
            };
        }
        if (constraint instanceof Relike) {
            Relike relike = (Relike)constraint;
            org.modeshape.jcr.query.model.StaticOperand staticOperand = relike.getOperand1();
            Object literalValue = ScanningQueryEngine.literalValue(staticOperand, context, context.getTypeSystem().getStringFactory());
            if (literalValue == null) {
                return NodeSequence.NO_PASS_ROW_FILTER;
            }
            final String literalStr = literalValue.toString();
            PropertyValue propertyValue = relike.getOperand2();
            NameFactory names = context.getExecutionContext().getValueFactories().getNameFactory();
            final Name propertyName = (Name)names.create(propertyValue.getPropertyName());
            String selectorName = propertyValue.getSelectorName();
            final int index = columns.getSelectorIndex(selectorName);
            final NodeCache cache = context.getNodeCache(sources.getWorkspaceName());
            return new NodeSequence.RowFilter(){

                @Override
                public boolean isCurrentRowValid(NodeSequence.Batch batch) {
                    CachedNode node = batch.getNode(index);
                    if (node == null) {
                        return false;
                    }
                    Property property = node.getProperty(propertyName, cache);
                    if (property == null) {
                        return false;
                    }
                    for (Object value : property) {
                        String regex;
                        Pattern pattern;
                        if (value == null || !(pattern = Pattern.compile(regex = ScanningQueryEngine.toRegularExpression(value.toString()))).matcher(literalStr).matches()) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        assert (false);
        return NodeSequence.PASS_ROW_FILTER;
    }

    protected TypeSystem.TypeFactory<?> determineType(DynamicOperand operand, QueryContext context, QueryResults.Columns columns) {
        TypeSystem types = context.getTypeSystem();
        if (operand instanceof PropertyValue) {
            PropertyValue propValue = (PropertyValue)operand;
            String typeName = columns.getColumnTypeForProperty(propValue.getSelectorName(), propValue.getPropertyName());
            return typeName != null ? types.getTypeFactory(typeName) : types.getStringFactory();
        }
        if (operand instanceof NodeName) {
            return types.getNameFactory();
        }
        if (operand instanceof NodePath) {
            return types.getPathFactory();
        }
        if (operand instanceof Length) {
            return types.getLongFactory();
        }
        if (operand instanceof ChildCount) {
            return types.getLongFactory();
        }
        if (operand instanceof NodeDepth) {
            return types.getLongFactory();
        }
        if (operand instanceof FullTextSearchScore) {
            return types.getDoubleFactory();
        }
        if (operand instanceof LowerCase) {
            return types.getStringFactory();
        }
        if (operand instanceof UpperCase) {
            return types.getStringFactory();
        }
        if (operand instanceof NodeLocalName) {
            return types.getStringFactory();
        }
        if (operand instanceof ReferenceValue) {
            return types.getStringFactory();
        }
        if (operand instanceof ArithmeticOperand) {
            ArithmeticOperand arith = (ArithmeticOperand)operand;
            TypeSystem.TypeFactory<?> leftType = this.determineType(arith.getLeft(), context, columns);
            TypeSystem.TypeFactory<?> rightType = this.determineType(arith.getRight(), context, columns);
            return types.getCompatibleType(leftType, rightType);
        }
        if (operand instanceof Cast) {
            return types.getTypeFactory(((Cast)operand).getDesiredTypeName());
        }
        return types.getStringFactory();
    }

    protected RowExtractors.ExtractFromRow createExtractFromRow(DynamicOperand operand, QueryContext context, QueryResults.Columns columns, final QuerySources sources, TypeSystem.TypeFactory<?> defaultType, boolean allowMultiValued, boolean isLike) {
        assert (operand != null);
        assert (context != null);
        assert (columns != null);
        assert (sources != null);
        if (operand instanceof PropertyValue) {
            PropertyValue propValue = (PropertyValue)operand;
            String propertyName = propValue.getPropertyName();
            String selectorName = propValue.selectorName().name();
            return this.createExtractFromRow(selectorName, propertyName, context, columns, sources, defaultType, allowMultiValued);
        }
        if (operand instanceof ReferenceValue) {
            ReferenceValue refValue = (ReferenceValue)operand;
            String propertyName = refValue.getPropertyName();
            String selectorName = refValue.selectorName().name();
            if (propertyName == null) {
                return this.createExtractReferencesFromRow(selectorName, context, columns, sources, defaultType);
            }
            return this.createExtractFromRow(selectorName, propertyName, context, columns, sources, defaultType, allowMultiValued);
        }
        if (operand instanceof Length) {
            Length length = (Length)operand;
            PropertyValue value = length.getPropertyValue();
            String propertyName = value.getPropertyName();
            String selectorName = value.selectorName().name();
            final RowExtractors.ExtractFromRow getPropValue = this.createExtractFromRow(selectorName, propertyName, context, columns, sources, defaultType, allowMultiValued);
            final TypeSystem.TypeFactory<Long> longType = context.getTypeSystem().getLongFactory();
            return new RowExtractors.ExtractFromRow(){

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    Object typedValue = getPropValue.getValueInRow(row);
                    return getPropValue.getType().length(typedValue);
                }

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return longType;
                }

                public String toString() {
                    return "(length " + getPropValue + ")";
                }
            };
        }
        final TypeSystem.TypeFactory<String> stringFactory = context.getTypeSystem().getStringFactory();
        if (operand instanceof LowerCase) {
            LowerCase lowerCase = (LowerCase)operand;
            final RowExtractors.ExtractFromRow delegate = this.createExtractFromRow(lowerCase.getOperand(), context, columns, sources, defaultType, allowMultiValued, false);
            return new RowExtractors.ExtractFromRow(){

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return stringFactory;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    Object valueInRow = delegate.getValueInRow(row);
                    if (valueInRow == null) {
                        return null;
                    }
                    if (valueInRow instanceof Object[]) {
                        Object[] values = (Object[])valueInRow;
                        Object[] lowerCasedValues = new Object[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            String valueString = (String)stringFactory.create(values[i]);
                            lowerCasedValues[i] = valueString.toLowerCase();
                        }
                        return lowerCasedValues;
                    }
                    return ((String)stringFactory.create(valueInRow)).toLowerCase();
                }

                public String toString() {
                    return "(lowercase " + delegate + ")";
                }
            };
        }
        if (operand instanceof UpperCase) {
            UpperCase upperCase = (UpperCase)operand;
            final RowExtractors.ExtractFromRow delegate = this.createExtractFromRow(upperCase.getOperand(), context, columns, sources, defaultType, allowMultiValued, false);
            return new RowExtractors.ExtractFromRow(){

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return stringFactory;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    Object valueInRow = delegate.getValueInRow(row);
                    if (valueInRow == null) {
                        return null;
                    }
                    if (valueInRow instanceof Object[]) {
                        Object[] values = (Object[])valueInRow;
                        Object[] upperCasedValues = new Object[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            String valueString = (String)stringFactory.create(values[i]);
                            upperCasedValues[i] = valueString.toUpperCase();
                        }
                        return upperCasedValues;
                    }
                    return ((String)stringFactory.create(valueInRow)).toUpperCase();
                }

                public String toString() {
                    return "(uppercase " + delegate + ")";
                }
            };
        }
        if (operand instanceof Cast) {
            Cast cast = (Cast)operand;
            final RowExtractors.ExtractFromRow delegate = this.createExtractFromRow(cast.getOperand(), context, columns, sources, defaultType, allowMultiValued, false);
            String desiredTypeName = cast.getDesiredTypeName();
            final TypeSystem.TypeFactory<?> typeFactory = context.getTypeSystem().getTypeFactory(desiredTypeName);
            final Class<?> desiredType = typeFactory.getType();
            return new RowExtractors.ExtractFromRow(){

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return typeFactory;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    Object valueInRow = delegate.getValueInRow(row);
                    if (valueInRow == null) {
                        return null;
                    }
                    if (valueInRow instanceof Object[]) {
                        Object[] values = (Object[])valueInRow;
                        Object[] convertedValues = new Object[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            Object originalValue = values[i];
                            if (desiredType.isAssignableFrom(originalValue.getClass())) {
                                return values;
                            }
                            Object convertedValue = typeFactory.create(originalValue);
                            convertedValues[i] = convertedValue;
                        }
                        return convertedValues;
                    }
                    if (desiredType.isAssignableFrom(valueInRow.getClass())) {
                        return valueInRow;
                    }
                    return typeFactory.create(valueInRow);
                }

                public String toString() {
                    return "(cast " + delegate + ")";
                }
            };
        }
        if (operand instanceof NodeDepth) {
            final NodeDepth nodeDepth = (NodeDepth)operand;
            final int indexInRow = columns.getSelectorIndex(nodeDepth.getSelectorName());
            final NodeCache cache = context.getNodeCache(sources.getWorkspaceName());
            final TypeSystem.TypeFactory<Long> longType = context.getTypeSystem().getLongFactory();
            return new RowExtractors.ExtractFromRow(){

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return longType;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    CachedNode node = row.getNode(indexInRow);
                    if (node == null) {
                        return null;
                    }
                    return new Long(node.getDepth(cache));
                }

                public String toString() {
                    return "(nodeDepth " + nodeDepth.getSelectorName() + ")";
                }
            };
        }
        if (operand instanceof ChildCount) {
            final ChildCount childCount = (ChildCount)operand;
            final int indexInRow = columns.getSelectorIndex(childCount.getSelectorName());
            final NodeCache cache = context.getNodeCache(sources.getWorkspaceName());
            final TypeSystem.TypeFactory<Long> longType = context.getTypeSystem().getLongFactory();
            return new RowExtractors.ExtractFromRow(){

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return longType;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    CachedNode node = row.getNode(indexInRow);
                    if (node == null) {
                        return null;
                    }
                    return new Long(node.getChildReferences(cache).size());
                }

                public String toString() {
                    return "(childCount " + childCount.getSelectorName() + ")";
                }
            };
        }
        if (operand instanceof NodeId) {
            final NodeId nodeId = (NodeId)operand;
            final int indexInRow = columns.getSelectorIndex(nodeId.getSelectorName());
            NodeCache cache = context.getNodeCache(sources.getWorkspaceName());
            final NodeKey root = cache.getRootKey();
            final TypeSystem.TypeFactory<String> stringType = context.getTypeSystem().getStringFactory();
            return new RowExtractors.ExtractFromRow(){

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return stringType;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    CachedNode node = row.getNode(indexInRow);
                    if (node == null) {
                        return null;
                    }
                    return sources.getIdentifier(node, root);
                }

                public String toString() {
                    return "(nodeId " + nodeId.getSelectorName() + ")";
                }
            };
        }
        if (operand instanceof NodePath) {
            final NodePath nodePath = (NodePath)operand;
            final int indexInRow = columns.getSelectorIndex(nodePath.getSelectorName());
            final NodeCache cache = context.getNodeCache(sources.getWorkspaceName());
            if (isLike) {
                return new RowExtractors.ExtractFromRow(){

                    @Override
                    public TypeSystem.TypeFactory<?> getType() {
                        return stringFactory;
                    }

                    @Override
                    public Object getValueInRow(NodeSequence.RowAccessor row) {
                        CachedNode node = row.getNode(indexInRow);
                        if (node == null) {
                            return null;
                        }
                        Path path = node.getPath(cache);
                        if (path.isRoot()) {
                            return stringFactory.create(path);
                        }
                        StringBuilder sb = new StringBuilder();
                        for (Path.Segment segment : path) {
                            sb.append("/");
                            sb.append((String)stringFactory.create(segment.getName()));
                            sb.append('[').append(segment.getIndex()).append(']');
                        }
                        return sb.toString();
                    }

                    public String toString() {
                        return "(nodePath " + nodePath.getSelectorName() + ")";
                    }
                };
            }
            return new RowExtractors.ExtractFromRow(){

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return stringFactory;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    CachedNode node = row.getNode(indexInRow);
                    if (node == null) {
                        return null;
                    }
                    Path path = node.getPath(cache);
                    return stringFactory.create(path);
                }

                public String toString() {
                    return "(nodePath " + nodePath.getSelectorName() + ")";
                }
            };
        }
        if (operand instanceof NodeName) {
            final NodeName nodeName = (NodeName)operand;
            final int indexInRow = columns.getSelectorIndex(nodeName.getSelectorName());
            final NodeCache cache = context.getNodeCache(sources.getWorkspaceName());
            return new RowExtractors.ExtractFromRow(){

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return stringFactory;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    CachedNode node = row.getNode(indexInRow);
                    if (node == null) {
                        return null;
                    }
                    Name name = node.getName(cache);
                    return stringFactory.create(name);
                }

                public String toString() {
                    return "(nodeName " + nodeName.getSelectorName() + ")";
                }
            };
        }
        if (operand instanceof NodeLocalName) {
            final NodeLocalName nodeName = (NodeLocalName)operand;
            final int indexInRow = columns.getSelectorIndex(nodeName.getSelectorName());
            final NodeCache cache = context.getNodeCache(sources.getWorkspaceName());
            return new RowExtractors.ExtractFromRow(){

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return stringFactory;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    CachedNode node = row.getNode(indexInRow);
                    if (node == null) {
                        return null;
                    }
                    Name name = node.getName(cache);
                    return name.getLocalName();
                }

                public String toString() {
                    return "(localName " + nodeName.getSelectorName() + ")";
                }
            };
        }
        if (operand instanceof FullTextSearchScore) {
            final FullTextSearchScore fts = (FullTextSearchScore)operand;
            final int indexInRow = columns.getSelectorIndex(fts.getSelectorName());
            final TypeSystem.TypeFactory<Double> doubleType = context.getTypeSystem().getDoubleFactory();
            return new RowExtractors.ExtractFromRow(){

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return doubleType;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    return new Double(row.getScore(indexInRow));
                }

                public String toString() {
                    return "(fullTextScore " + fts.getSelectorName() + ")";
                }
            };
        }
        if (operand instanceof ArithmeticOperand) {
            ArithmeticOperand arith = (ArithmeticOperand)operand;
            final RowExtractors.ExtractFromRow leftOp = this.createExtractFromRow(arith.getLeft(), context, columns, sources, defaultType, false, false);
            final RowExtractors.ExtractFromRow rightOp = this.createExtractFromRow(arith.getRight(), context, columns, sources, defaultType, false, false);
            TypeSystem.TypeFactory<?> leftType = leftOp.getType();
            TypeSystem.TypeFactory<?> rightType = rightOp.getType();
            TypeSystem typeSystem = context.getTypeSystem();
            String commonType = typeSystem.getCompatibleType(leftType.getTypeName(), rightType.getTypeName());
            if (typeSystem.getDoubleFactory().getTypeName().equals(commonType)) {
                final TypeSystem.TypeFactory<Double> commonTypeFactory = typeSystem.getDoubleFactory();
                switch (arith.operator()) {
                    case ADD: {
                        return new RowExtractors.ExtractFromRow(){

                            @Override
                            public TypeSystem.TypeFactory<?> getType() {
                                return commonTypeFactory;
                            }

                            @Override
                            public Object getValueInRow(NodeSequence.RowAccessor row) {
                                Double right = (Double)commonTypeFactory.create(rightOp.getValueInRow(row));
                                Double left = (Double)commonTypeFactory.create(leftOp.getValueInRow(row));
                                if (right == null) {
                                    return left;
                                }
                                if (left == null) {
                                    return right;
                                }
                                return left / right;
                            }

                            public String toString() {
                                return "(double + " + leftOp + "," + rightOp + ")";
                            }
                        };
                    }
                    case SUBTRACT: {
                        return new RowExtractors.ExtractFromRow(){

                            @Override
                            public TypeSystem.TypeFactory<?> getType() {
                                return commonTypeFactory;
                            }

                            @Override
                            public Object getValueInRow(NodeSequence.RowAccessor row) {
                                Double right = (Double)commonTypeFactory.create(rightOp.getValueInRow(row));
                                Double left = (Double)commonTypeFactory.create(leftOp.getValueInRow(row));
                                if (right == null) {
                                    return left;
                                }
                                if (left == null) {
                                    left = 0.0;
                                }
                                return left * right;
                            }

                            public String toString() {
                                return "(double - " + leftOp + "," + rightOp + ")";
                            }
                        };
                    }
                    case MULTIPLY: {
                        return new RowExtractors.ExtractFromRow(){

                            @Override
                            public TypeSystem.TypeFactory<?> getType() {
                                return commonTypeFactory;
                            }

                            @Override
                            public Object getValueInRow(NodeSequence.RowAccessor row) {
                                Double right = (Double)commonTypeFactory.create(rightOp.getValueInRow(row));
                                Double left = (Double)commonTypeFactory.create(leftOp.getValueInRow(row));
                                if (right == null || left == null) {
                                    return null;
                                }
                                return left * right;
                            }

                            public String toString() {
                                return "(double x " + leftOp + "," + rightOp + ")";
                            }
                        };
                    }
                    case DIVIDE: {
                        return new RowExtractors.ExtractFromRow(){

                            @Override
                            public TypeSystem.TypeFactory<?> getType() {
                                return commonTypeFactory;
                            }

                            @Override
                            public Object getValueInRow(NodeSequence.RowAccessor row) {
                                Double right = (Double)commonTypeFactory.create(rightOp.getValueInRow(row));
                                Double left = (Double)commonTypeFactory.create(leftOp.getValueInRow(row));
                                if (right == null || left == null) {
                                    return null;
                                }
                                return left / right;
                            }

                            public String toString() {
                                return "(double / " + leftOp + "," + rightOp + ")";
                            }
                        };
                    }
                }
            } else if (typeSystem.getLongFactory().getTypeName().equals(commonType)) {
                final TypeSystem.TypeFactory<Long> commonTypeFactory = typeSystem.getLongFactory();
                switch (arith.operator()) {
                    case ADD: {
                        return new RowExtractors.ExtractFromRow(){

                            @Override
                            public TypeSystem.TypeFactory<?> getType() {
                                return commonTypeFactory;
                            }

                            @Override
                            public Object getValueInRow(NodeSequence.RowAccessor row) {
                                Long right = (Long)commonTypeFactory.create(rightOp.getValueInRow(row));
                                Long left = (Long)commonTypeFactory.create(leftOp.getValueInRow(row));
                                if (right == null) {
                                    return left;
                                }
                                if (left == null) {
                                    return right;
                                }
                                return left / right;
                            }

                            public String toString() {
                                return "(long + " + leftOp + "," + rightOp + ")";
                            }
                        };
                    }
                    case SUBTRACT: {
                        return new RowExtractors.ExtractFromRow(){

                            @Override
                            public TypeSystem.TypeFactory<?> getType() {
                                return commonTypeFactory;
                            }

                            @Override
                            public Object getValueInRow(NodeSequence.RowAccessor row) {
                                Long right = (Long)commonTypeFactory.create(rightOp.getValueInRow(row));
                                Long left = (Long)commonTypeFactory.create(leftOp.getValueInRow(row));
                                if (right == null) {
                                    return left;
                                }
                                if (left == null) {
                                    left = 0L;
                                }
                                return left * right;
                            }

                            public String toString() {
                                return "(long - " + leftOp + "," + rightOp + ")";
                            }
                        };
                    }
                    case MULTIPLY: {
                        return new RowExtractors.ExtractFromRow(){

                            @Override
                            public TypeSystem.TypeFactory<?> getType() {
                                return commonTypeFactory;
                            }

                            @Override
                            public Object getValueInRow(NodeSequence.RowAccessor row) {
                                Long right = (Long)commonTypeFactory.create(rightOp.getValueInRow(row));
                                Long left = (Long)commonTypeFactory.create(leftOp.getValueInRow(row));
                                if (right == null || left == null) {
                                    return null;
                                }
                                return left * right;
                            }

                            public String toString() {
                                return "(long x " + leftOp + "," + rightOp + ")";
                            }
                        };
                    }
                    case DIVIDE: {
                        return new RowExtractors.ExtractFromRow(){

                            @Override
                            public TypeSystem.TypeFactory<?> getType() {
                                return commonTypeFactory;
                            }

                            @Override
                            public Object getValueInRow(NodeSequence.RowAccessor row) {
                                Long right = (Long)commonTypeFactory.create(rightOp.getValueInRow(row));
                                Long left = (Long)commonTypeFactory.create(leftOp.getValueInRow(row));
                                if (right == null || left == null) {
                                    return null;
                                }
                                return left / right;
                            }

                            public String toString() {
                                return "(long / " + leftOp + "," + rightOp + ")";
                            }
                        };
                    }
                }
            }
        }
        assert (false);
        return null;
    }

    protected RowExtractors.ExtractFromRow createExtractFromRow(final String selectorName, final String propertyName, QueryContext context, QueryResults.Columns columns, QuerySources sources, TypeSystem.TypeFactory<?> defaultType, boolean allowMultiValued) {
        TypeSystem.TypeFactory<?> typeFactory;
        String expectedType;
        int indexInRow;
        NodeCache cache;
        Name propName;
        block12: {
            propName = (Name)context.getExecutionContext().getValueFactories().getNameFactory().create(propertyName);
            cache = context.getNodeCache(sources.getWorkspaceName());
            assert (columns != null);
            indexInRow = columns.getSelectorIndex(selectorName);
            if (PseudoColumns.contains(propName, true)) {
                if (PseudoColumns.isScore(propName)) {
                    TypeSystem.TypeFactory<Double> typeFactory2 = context.getTypeSystem().getDoubleFactory();
                    return new PropertyValueExtractor(selectorName, propertyName, typeFactory2){

                        @Override
                        public Object getValueInRow(NodeSequence.RowAccessor row) {
                            return new Double(row.getScore(indexInRow));
                        }
                    };
                }
                if (PseudoColumns.isPath(propName)) {
                    TypeSystem.TypeFactory<Path> typeFactory3 = context.getTypeSystem().getPathFactory();
                    return new PropertyValueExtractor(selectorName, propertyName, typeFactory3){

                        @Override
                        public Object getValueInRow(NodeSequence.RowAccessor row) {
                            CachedNode node = row.getNode(indexInRow);
                            if (node == null) {
                                return null;
                            }
                            return node.getPath(cache);
                        }
                    };
                }
                if (PseudoColumns.isDepth(propName)) {
                    TypeSystem.TypeFactory<Long> typeFactory4 = context.getTypeSystem().getLongFactory();
                    return new PropertyValueExtractor(selectorName, propertyName, typeFactory4){

                        @Override
                        public Object getValueInRow(NodeSequence.RowAccessor row) {
                            CachedNode node = row.getNode(indexInRow);
                            if (node == null) {
                                return null;
                            }
                            return node.getDepth(cache);
                        }
                    };
                }
                if (PseudoColumns.isName(propName)) {
                    TypeSystem.TypeFactory<Name> typeFactory5 = context.getTypeSystem().getNameFactory();
                    return new PropertyValueExtractor(selectorName, propertyName, typeFactory5){

                        @Override
                        public Object getValueInRow(NodeSequence.RowAccessor row) {
                            CachedNode node = row.getNode(indexInRow);
                            if (node == null) {
                                return null;
                            }
                            return node.getName(cache);
                        }
                    };
                }
                if (PseudoColumns.isLocalName(propName)) {
                    TypeSystem.TypeFactory<String> typeFactory6 = context.getTypeSystem().getStringFactory();
                    return new PropertyValueExtractor(selectorName, propertyName, typeFactory6){

                        @Override
                        public Object getValueInRow(NodeSequence.RowAccessor row) {
                            CachedNode node = row.getNode(indexInRow);
                            if (node == null) {
                                return null;
                            }
                            return node.getName(cache).getLocalName();
                        }
                    };
                }
                if (PseudoColumns.isId(propName)) {
                    TypeSystem.TypeFactory<String> typeFactory7 = context.getTypeSystem().getStringFactory();
                    return new PropertyValueExtractor(selectorName, propertyName, typeFactory7){

                        @Override
                        public Object getValueInRow(NodeSequence.RowAccessor row) {
                            CachedNode node = row.getNode(indexInRow);
                            if (node == null) {
                                return null;
                            }
                            return node.getKey().toString();
                        }
                    };
                }
                if (PseudoColumns.isUuid(propName)) {
                    TypeSystem.TypeFactory<String> typeFactory8 = context.getTypeSystem().getStringFactory();
                    final NodeTypes nodeTypes = context.getNodeTypes();
                    return new PropertyValueExtractor(selectorName, propertyName, typeFactory8){

                        @Override
                        public Object getValueInRow(NodeSequence.RowAccessor row) {
                            CachedNode node = row.getNode(indexInRow);
                            if (node == null) {
                                return null;
                            }
                            if (nodeTypes.isReferenceable(node.getPrimaryType(cache), node.getMixinTypes(cache))) {
                                NodeKey key = node.getKey();
                                return key.getIdentifier();
                            }
                            return null;
                        }
                    };
                }
            }
            expectedType = null;
            try {
                expectedType = columns.getColumnTypeForProperty(selectorName, propertyName);
            }
            catch (NoSuchElementException e) {
                if (defaultType != null) break block12;
                throw e;
            }
        }
        TypeSystem.TypeFactory<?> typeFactory9 = typeFactory = expectedType != null ? context.getTypeSystem().getTypeFactory(expectedType) : defaultType;
        if (allowMultiValued) {
            return new RowExtractors.ExtractFromRow(){

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    CachedNode node = row.getNode(indexInRow);
                    if (node == null) {
                        return null;
                    }
                    Property prop = node.getProperty(propName, cache);
                    if (prop == null || prop.isEmpty()) {
                        return null;
                    }
                    if (prop.isSingle()) {
                        return typeFactory.create(prop.getFirstValue());
                    }
                    assert (prop.isMultiple());
                    Object[] result = new Object[prop.size()];
                    int i = -1;
                    for (Object value : prop) {
                        result[++i] = typeFactory.create(value);
                    }
                    return result;
                }

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return typeFactory;
                }

                public String toString() {
                    return "(" + selectorName + "." + propertyName + ")";
                }
            };
        }
        return new RowExtractors.ExtractFromRow(){

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                CachedNode node = row.getNode(indexInRow);
                if (node == null) {
                    return null;
                }
                Property prop = node.getProperty(propName, cache);
                if (prop == null || prop.isEmpty()) {
                    return null;
                }
                return typeFactory.create(prop.getFirstValue());
            }

            @Override
            public TypeSystem.TypeFactory<?> getType() {
                return typeFactory;
            }

            public String toString() {
                return "(" + selectorName + "." + propertyName + ")";
            }
        };
    }

    protected RowExtractors.ExtractFromRow createExtractReferencesFromRow(final String selectorName, QueryContext context, QueryResults.Columns columns, QuerySources sources, TypeSystem.TypeFactory<?> defaultType) {
        final NodeCache cache = context.getNodeCache(sources.getWorkspaceName());
        assert (columns != null);
        final int indexInRow = columns.getSelectorIndex(selectorName);
        final TypeSystem.TypeFactory<String> typeFactory = context.getTypeSystem().getStringFactory();
        final boolean trace = LOGGER.isTraceEnabled();
        return new RowExtractors.ExtractFromRow(){

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                CachedNode node = row.getNode(indexInRow);
                if (node == null) {
                    return null;
                }
                LinkedList values = null;
                Iterator<Property> iter = node.getProperties(cache);
                while (iter.hasNext()) {
                    Property prop = iter.next();
                    if (prop == null || prop.isEmpty() || !prop.isReference() && !prop.isSimpleReference()) continue;
                    if (prop.isSingle()) {
                        Object value = prop.getFirstValue();
                        if (value == null) continue;
                        if (values == null) {
                            values = new LinkedList();
                        }
                        values.add(typeFactory.create(value));
                        continue;
                    }
                    assert (prop.isMultiple());
                    for (Object value : prop) {
                        if (value == null) continue;
                        if (values == null) {
                            values = new LinkedList();
                        }
                        values.add(typeFactory.create(value));
                    }
                }
                if (values == null || values.isEmpty()) {
                    return null;
                }
                if (trace) {
                    LOGGER.trace("Found references in '{0}': {1}", new Object[]{node.getPath(cache), values});
                }
                return values.toArray();
            }

            @Override
            public TypeSystem.TypeFactory<?> getType() {
                return typeFactory;
            }

            public String toString() {
                return "(references " + selectorName + ")";
            }
        };
    }

    protected static Object literalValue(StaticOperand staticOperand, QueryContext context, TypeSystem.TypeFactory<?> type) {
        Object literalValue = null;
        if (staticOperand instanceof BindVariableName) {
            BindVariableName bindVariable = (BindVariableName)staticOperand;
            String variableName = bindVariable.getBindVariableName();
            literalValue = context.getVariables().get(variableName);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Using variable '{0}' value: {1}", new Object[]{variableName, literalValue});
            }
            if (literalValue instanceof Collection || literalValue instanceof Object[]) {
                return literalValue;
            }
            return type.create(literalValue);
        }
        if (staticOperand instanceof LiteralValue) {
            LiteralValue literal = (LiteralValue)staticOperand;
            Value value = literal.getLiteralValue();
            if (value != null) {
                PropertyType propType = PropertyTypeUtil.modePropertyTypeFor(value.getType());
                try {
                    literalValue = context.getExecutionContext().getValueFactories().getValueFactory(propType).create(value.getString());
                }
                catch (RepositoryException e) {
                    throw new SystemFailureException((Throwable)e);
                }
            }
        } else if (staticOperand instanceof Literal) {
            Literal literal = (Literal)staticOperand;
            literalValue = literal.value();
        }
        return type != null ? type.create(literalValue) : null;
    }

    protected static Set<?> literalValues(SetCriteria setCriteria, QueryContext context, TypeSystem.TypeFactory<?> type) {
        HashSet values = new HashSet();
        for (StaticOperand staticOperand : setCriteria.getValues()) {
            if (!(staticOperand instanceof StaticOperand)) continue;
            Object literal = ScanningQueryEngine.literalValue(staticOperand, context, type);
            if (literal instanceof Collection) {
                for (Object v : (Collection)literal) {
                    if (v == null) continue;
                    values.add(type.create(v));
                }
                values.addAll((Collection)literal);
                continue;
            }
            if (literal instanceof Object[]) {
                for (Object v : (Object[])literal) {
                    if (v == null) continue;
                    values.add(type.create(v));
                }
                continue;
            }
            if (literal == null) continue;
            values.add(type.create(literal));
        }
        return values;
    }

    protected static String toWildcardExpression(String likeExpression) {
        return likeExpression.replace('%', '*').replace('_', '?').replaceAll("\\\\(.)", "$1");
    }

    public static String toRegularExpression(String likeExpression) {
        String result = likeExpression.replaceAll("\\\\(.)", "$1");
        result = result.replaceAll("([$.|+()\\[\\\\^\\\\\\\\])", "\\\\$1");
        result = result.replace("*", ".*").replace("?", ".");
        result = result.replace("%", ".*").replace("_", ".");
        return result;
    }

    @ThreadSafe
    static class ScanQueryContext
    extends QueryContext {
        protected final Map<PlanNode, QueryResults.Columns> columnsByPlanNode;

        protected ScanQueryContext(ExecutionContext context, RepositoryCache repositoryCache, Set<String> workspaceNames, Map<String, NodeCache> overriddenNodeCachesByWorkspaceName, Schemata schemata, RepositoryIndexes indexDefns, NodeTypes nodeTypes, BufferManager bufferManager, PlanHints hints, Problems problems, Map<String, Object> variables, Map<PlanNode, QueryResults.Columns> columnsByPlanNode) {
            super(context, repositoryCache, workspaceNames, overriddenNodeCachesByWorkspaceName, schemata, indexDefns, nodeTypes, bufferManager, hints, problems, variables);
            this.columnsByPlanNode = columnsByPlanNode;
        }

        public void addColumnsFor(PlanNode node, QueryResults.Columns columns) {
            this.columnsByPlanNode.put(node, columns);
        }

        public QueryResults.Columns columnsFor(PlanNode node) {
            return this.columnsByPlanNode.get(node);
        }

        @Override
        public ScanQueryContext with(Map<String, Object> variables) {
            return new ScanQueryContext(this.context, this.repositoryCache, (Set<String>)this.workspaceNames, (Map<String, NodeCache>)this.overriddenNodeCachesByWorkspaceName, this.schemata, this.indexDefns, this.nodeTypes, this.bufferManager, this.hints, this.problems, variables, this.columnsByPlanNode);
        }

        @Override
        public ScanQueryContext with(PlanHints hints) {
            return new ScanQueryContext(this.context, this.repositoryCache, (Set<String>)this.workspaceNames, (Map<String, NodeCache>)this.overriddenNodeCachesByWorkspaceName, this.schemata, this.indexDefns, this.nodeTypes, this.bufferManager, hints, this.problems, (Map<String, Object>)this.variables, this.columnsByPlanNode);
        }

        @Override
        public ScanQueryContext with(Problems problems) {
            return new ScanQueryContext(this.context, this.repositoryCache, (Set<String>)this.workspaceNames, (Map<String, NodeCache>)this.overriddenNodeCachesByWorkspaceName, this.schemata, this.indexDefns, this.nodeTypes, this.bufferManager, this.hints, problems, (Map<String, Object>)this.variables, this.columnsByPlanNode);
        }

        @Override
        public ScanQueryContext with(Schemata schemata) {
            return new ScanQueryContext(this.context, this.repositoryCache, (Set<String>)this.workspaceNames, (Map<String, NodeCache>)this.overriddenNodeCachesByWorkspaceName, schemata, this.indexDefns, this.nodeTypes, this.bufferManager, this.hints, this.problems, (Map<String, Object>)this.variables, this.columnsByPlanNode);
        }
    }

    public static final class ResultColumns
    implements QueryResults.Columns {
        private static final long serialVersionUID = 1L;
        protected static final List<Column> NO_COLUMNS = Collections.emptyList();
        protected static final List<String> NO_TYPES = Collections.emptyList();
        protected static final String DEFAULT_SELECTOR_NAME = "Results";
        protected static final ResultColumns EMPTY = new ResultColumns(null, null, false, null);
        private final List<Column> columns;
        private final List<String> columnTypes;
        private final List<String> columnNames;
        private final List<String> selectorNames;
        private final Map<String, Integer> selectorIndexBySelectorName;
        private final Map<String, String> selectorNameByColumnName;
        private final Map<String, String> propertyNameByColumnName;
        private final Map<String, Map<String, ColumnInfo>> columnIndexByPropertyNameBySelectorName;
        private final boolean includeFullTextSearchScores;

        public ResultColumns(List<Column> columns, List<String> columnTypes, boolean includeFullTextSearchScores, QueryResults.Columns precedingColumns) {
            String selectorName;
            Column column;
            int i;
            this.includeFullTextSearchScores = includeFullTextSearchScores;
            this.columns = columns != null ? Collections.unmodifiableList(columns) : NO_COLUMNS;
            this.columnTypes = columnTypes != null ? Collections.unmodifiableList(columnTypes) : NO_TYPES;
            this.selectorIndexBySelectorName = new HashMap<String, Integer>();
            this.columnIndexByPropertyNameBySelectorName = new HashMap<String, Map<String, ColumnInfo>>();
            this.selectorNameByColumnName = new HashMap<String, String>();
            this.propertyNameByColumnName = new HashMap<String, String>();
            HashSet<String> selectors = new HashSet<String>();
            int columnCount = this.columns.size();
            ArrayList<String> names = new ArrayList<String>(columnCount);
            ArrayList<String> selectorNames = new ArrayList<String>(columnCount);
            Set<Column> sameNameColumns = ResultColumns.findColumnsWithSameNames(this.columns);
            int selectorIndex = 0;
            int max = this.columns.size();
            for (i = 0; i != max; ++i) {
                column = this.columns.get(i);
                assert (column != null);
                selectorName = column.selectorName().name();
                if (!selectors.add(selectorName)) continue;
                selectorNames.add(selectorName);
                int index = selectorIndex;
                if (precedingColumns != null && (index = precedingColumns.getSelectorIndex(selectorName)) < 0) {
                    index = selectorIndex;
                }
                this.selectorIndexBySelectorName.put(selectorName, index);
                ++selectorIndex;
            }
            max = this.columns.size();
            for (i = 0; i != max; ++i) {
                column = this.columns.get(i);
                assert (column != null);
                selectorName = column.selectorName().name();
                String columnName = ResultColumns.columnNameFor(column, names, sameNameColumns, selectors);
                assert (columnName != null);
                this.propertyNameByColumnName.put(columnName, column.getPropertyName());
                this.selectorNameByColumnName.put(columnName, selectorName);
                Map<String, ColumnInfo> byPropertyName = this.columnIndexByPropertyNameBySelectorName.get(selectorName);
                if (byPropertyName == null) {
                    byPropertyName = new HashMap<String, ColumnInfo>();
                    this.columnIndexByPropertyNameBySelectorName.put(selectorName, byPropertyName);
                }
                String columnType = this.columnTypes.get(i);
                byPropertyName.put(column.getPropertyName(), new ColumnInfo(i, columnType));
            }
            if (columns != null && selectorNames.isEmpty()) {
                String selectorName2 = DEFAULT_SELECTOR_NAME;
                selectorNames.add(selectorName2);
                this.selectorIndexBySelectorName.put(selectorName2, 0);
            }
            this.selectorNames = Collections.unmodifiableList(selectorNames);
            this.columnNames = Collections.unmodifiableList(names);
        }

        protected static Set<Column> findColumnsWithSameNames(List<Column> columns) {
            ArrayListMultimap columnNames = ArrayListMultimap.create();
            for (Column column : columns) {
                String columnName = column.getColumnName() != null ? column.getColumnName() : column.getPropertyName();
                columnNames.put((Object)columnName, (Object)column);
            }
            HashSet<Column> results = new HashSet<Column>();
            for (Map.Entry entry : columnNames.asMap().entrySet()) {
                if (((Collection)entry.getValue()).size() <= 1) continue;
                results.addAll((Collection)entry.getValue());
            }
            return results;
        }

        protected static String columnNameFor(Column column, List<String> columnNames, Set<Column> columnsWithDuplicateNames, Collection<String> selectorNames) {
            boolean aliased;
            boolean qualified;
            String columnName = column.getColumnName() != null ? column.getColumnName() : column.getPropertyName();
            boolean bl = qualified = columnName != null ? columnName.startsWith(column.getSelectorName() + ".") : false;
            boolean bl2 = columnName != null ? !columnName.equals(column.getPropertyName()) : (aliased = false);
            if (column.getPropertyName() == null || columnNames.contains(columnName) || columnsWithDuplicateNames.contains(column)) {
                columnName = column.selectorName() + "." + columnName;
            } else if (!qualified && !aliased && selectorNames.size() > 1) {
                columnName = column.selectorName() + "." + columnName;
            }
            columnNames.add(columnName);
            return columnName;
        }

        @Override
        public Iterator<Column> iterator() {
            return this.columns.iterator();
        }

        @Override
        public List<? extends Column> getColumns() {
            return this.columns;
        }

        @Override
        public List<String> getColumnNames() {
            return this.columnNames;
        }

        @Override
        public List<String> getColumnTypes() {
            return this.columnTypes;
        }

        @Override
        public String getColumnTypeForProperty(String selectorName, String propertyName) {
            Map<String, ColumnInfo> byPropertyName = this.columnIndexByPropertyNameBySelectorName.get(selectorName);
            if (byPropertyName == null) {
                throw new NoSuchElementException(GraphI18n.selectorDoesNotExistInQuery.text(new Object[]{selectorName}));
            }
            ColumnInfo result = byPropertyName.get(propertyName);
            return result != null ? result.type : null;
        }

        @Override
        public int getSelectorIndex(String selectorName) {
            if (!this.selectorNames.contains(selectorName)) {
                return -1;
            }
            return this.selectorIndexBySelectorName.get(selectorName);
        }

        @Override
        public List<String> getSelectorNames() {
            return this.selectorNames;
        }

        @Override
        public String getPropertyNameForColumnName(String columnName) {
            String result = this.propertyNameByColumnName.get(columnName);
            return result != null ? result : columnName;
        }

        @Override
        public String getSelectorNameForColumnName(String columnName) {
            return this.selectorNameByColumnName.get(columnName);
        }

        @Override
        public boolean hasFullTextSearchScores() {
            return this.includeFullTextSearchScores;
        }

        public int hashCode() {
            return this.getColumns().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ResultColumns) {
                ResultColumns that = (ResultColumns)obj;
                return this.getColumns().equals(that.getColumns());
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ ").append("\n");
            if (this.columnNames != null) {
                boolean first = true;
                for (int i = 0; i != this.columns.size(); ++i) {
                    Column column = this.columns.get(i);
                    String type = this.columnTypes.get(i);
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ").append("\n");
                    }
                    sb.append(Visitors.readable(column)).append("{").append(type.toUpperCase()).append("}");
                }
            }
            sb.append("\n").append(" }");
            return sb.toString();
        }

        @Override
        public QueryResults.Columns with(QueryResults.Columns other) {
            int maxNumberOfColumns = this.getColumns().size() + other.getColumns().size();
            ArrayList<Column> allColumns = new ArrayList<Column>(maxNumberOfColumns);
            ArrayList<String> allTypes = new ArrayList<String>(maxNumberOfColumns);
            HashSet<Column> seen = new HashSet<Column>();
            allColumns.addAll(this.columns);
            allTypes.addAll(this.columnTypes);
            Iterator<String> types = other.getColumnTypes().iterator();
            for (Column column : other) {
                String type = types.next();
                if (!seen.add(column)) continue;
                allColumns.add(column);
                allTypes.add(type);
            }
            boolean fts = this.hasFullTextSearchScores() || other.hasFullTextSearchScores();
            return new ResultColumns(allColumns, allTypes, fts, this);
        }

        protected static final class ColumnInfo {
            protected final int columnIndex;
            protected final String type;

            protected ColumnInfo(int columnIndex, String type) {
                this.columnIndex = columnIndex;
                this.type = type;
            }

            public String toString() {
                return "" + this.columnIndex + "(" + this.type + ")";
            }
        }
    }

    protected static abstract class RowFilterSupplier
    implements NodeSequence.RowFilter {
        private NodeSequence.RowFilter delegate;

        protected RowFilterSupplier() {
        }

        @Override
        public final boolean isCurrentRowValid(NodeSequence.Batch batch) {
            return this.delegate().isCurrentRowValid(batch);
        }

        protected final NodeSequence.RowFilter delegate() {
            if (this.delegate == null) {
                this.delegate = this.createFilter();
            }
            return this.delegate;
        }

        protected abstract NodeSequence.RowFilter createFilter();

        public String toString() {
            return this.delegate().toString();
        }
    }

    protected static abstract class DynamicOperandFilter
    implements NodeSequence.RowFilter {
        private final RowExtractors.ExtractFromRow extractor;

        protected DynamicOperandFilter(RowExtractors.ExtractFromRow extractor) {
            this.extractor = extractor;
        }

        @Override
        public boolean isCurrentRowValid(NodeSequence.Batch batch) {
            Object lhs = this.extractor.getValueInRow(batch);
            if (lhs == null) {
                return false;
            }
            if (lhs instanceof Object[]) {
                for (Object lhsValue : (Object[])lhs) {
                    if (!this.evaluate(lhsValue)) continue;
                    return true;
                }
                return false;
            }
            return this.evaluate(lhs);
        }

        protected abstract boolean evaluate(Object var1);
    }

    protected static abstract class PropertyValueExtractor
    implements RowExtractors.ExtractFromRow {
        private final TypeSystem.TypeFactory<?> typeFactory;
        private final String selectorName;
        private final String propertyName;

        protected PropertyValueExtractor(String selectorName, String propertyName, TypeSystem.TypeFactory<?> typeFactory) {
            this.selectorName = selectorName;
            this.propertyName = propertyName;
            this.typeFactory = typeFactory;
        }

        @Override
        public TypeSystem.TypeFactory<?> getType() {
            return this.typeFactory;
        }

        public String toString() {
            return "(" + Visitors.readable(new PropertyValue(new SelectorName(this.selectorName), this.propertyName)) + ")";
        }
    }

    public static class Builder
    extends QueryEngineBuilder {
        @Override
        public QueryEngine build() {
            return new ScanningQueryEngine(this.context(), this.repositoryName(), this.planner(), this.optimizer());
        }

        @Override
        protected Optimizer defaultOptimizer() {
            return new RuleBasedOptimizer();
        }
    }
}

