/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.query.model.Visitors;

@Immutable
public class PropertyValue
implements DynamicOperand,
javax.jcr.query.qom.PropertyValue {
    private static final long serialVersionUID = 1L;
    private final Set<SelectorName> selectorNames;
    private final String propertyName;
    private final int hc;

    public PropertyValue(SelectorName selectorName, String propertyName) {
        this.selectorNames = SelectorName.nameSetFrom(selectorName);
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        this.propertyName = propertyName;
        this.hc = HashCode.compute((Object[])new Object[]{selectorName, this.propertyName});
    }

    public SelectorName selectorName() {
        return this.selectorNames().iterator().next();
    }

    @Override
    public Set<SelectorName> selectorNames() {
        return this.selectorNames;
    }

    public String getSelectorName() {
        return this.selectorName().getString();
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertyValue) {
            PropertyValue that = (PropertyValue)obj;
            if (this.hc != that.hc) {
                return false;
            }
            return this.selectorNames().equals(that.selectorNames()) && this.propertyName.equals(that.propertyName);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

