/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.DocumentSequence;
import org.modeshape.schematic.document.Json;

@NotThreadSafe
public final class BackupDocumentReader {
    public static final String GZIP_EXTENSION = ".gz";
    public static final String DOCUMENTS_EXTENSION = ".bin";
    private final File parentDirectory;
    private final String filenamePrefix;
    private final Problems problems;
    protected InputStream stream;
    protected DocumentSequence documents;
    protected long fileCount = 0L;
    private File currentFile;

    public BackupDocumentReader(File parentDirectory, String filenamePrefix, Problems problems) {
        CheckArg.isNotNull((Object)parentDirectory, (String)"parentDirectory");
        CheckArg.isNotEmpty((String)filenamePrefix, (String)"filenamePrefix");
        this.parentDirectory = parentDirectory;
        this.filenamePrefix = filenamePrefix;
        this.problems = problems;
    }

    public Document read() {
        try {
            while (true) {
                if (this.stream == null) {
                    this.stream = this.openNextFile();
                    if (this.stream == null) {
                        return null;
                    }
                    this.documents = Json.readMultiple((InputStream)this.stream, (boolean)false);
                }
                try {
                    Document doc = this.documents.nextDocument();
                    if (doc != null) {
                        return doc;
                    }
                }
                catch (IOException doc) {
                    // empty catch block
                }
                this.close(this.stream);
                this.stream = null;
            }
        }
        catch (IOException e) {
            this.problems.addError(JcrI18n.problemsWritingDocumentToBackup, new Object[]{this.currentFile.getAbsolutePath(), e.getMessage()});
            return null;
        }
    }

    protected InputStream openNextFile() throws IOException {
        ++this.fileCount;
        String suffix = StringUtil.justifyRight((String)Long.toString(this.fileCount), (int)6, (char)'0');
        String filename = this.filenamePrefix + "_" + suffix + DOCUMENTS_EXTENSION + GZIP_EXTENSION;
        this.currentFile = new File(this.parentDirectory, filename);
        boolean compressed = true;
        if (!this.currentFile.exists()) {
            filename = this.filenamePrefix + "_" + suffix + DOCUMENTS_EXTENSION;
            this.currentFile = new File(this.parentDirectory, filename);
            if (!this.currentFile.exists()) {
                return null;
            }
            compressed = false;
        }
        if (!this.currentFile.canRead() || !this.currentFile.isFile()) {
            return null;
        }
        InputStream fileStream = new FileInputStream(this.currentFile);
        if (compressed) {
            fileStream = new GZIPInputStream(fileStream);
        }
        return new BufferedInputStream(fileStream);
    }

    protected void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                this.problems.addError(JcrI18n.problemsClosingBackupFiles, new Object[]{this.parentDirectory.getAbsolutePath(), e.getMessage()});
            }
            finally {
                stream = null;
            }
        }
    }

    public void close() {
        this.close(this.stream);
    }
}

