/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.i18n.TextI18n;
import org.modeshape.jcr.api.Logger;

public final class ExtensionLogger
implements Logger {
    private final org.modeshape.common.logging.Logger logger;

    private ExtensionLogger(org.modeshape.common.logging.Logger logger) {
        this.logger = logger;
    }

    public static Logger getLogger(Class<?> clazz) {
        return new ExtensionLogger(org.modeshape.common.logging.Logger.getLogger(clazz));
    }

    public void debug(String message, Object ... params) {
        this.logger.debug(message, params);
    }

    public void debug(Throwable t, String message, Object ... params) {
        this.logger.debug(t, message, params);
    }

    public void error(String message, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((I18nResource)new TextI18n(message), params);
        }
    }

    public void error(Throwable t, String message, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(t, (I18nResource)new TextI18n(message), params);
        }
    }

    public void info(String message, Object ... params) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((I18nResource)new TextI18n(message), params);
        }
    }

    public void info(Throwable t, String message, Object ... params) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(t, (I18nResource)new TextI18n(message), params);
        }
    }

    public void trace(String message, Object ... params) {
        this.logger.trace(message, params);
    }

    public void trace(Throwable t, String message, Object ... params) {
        this.logger.trace(t, message, params);
    }

    public void warn(String message, Object ... params) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((I18nResource)new TextI18n(message), params);
        }
    }

    public void warn(Throwable t, String message, Object ... params) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(t, (I18nResource)new TextI18n(message), params);
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }
}

