/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.locking;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.locking.LockingService;
import org.modeshape.schematic.Lockable;

public class DbLockingService
implements LockingService {
    private static final Random RANDOM = new Random();
    private final Lockable db;
    private final long lockTimeoutMillis;

    public DbLockingService(long lockTimeoutMillis, Lockable db) {
        CheckArg.isNonNegative((long)lockTimeoutMillis, (String)"lockTimeout");
        this.lockTimeoutMillis = lockTimeoutMillis;
        this.db = db;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit, String ... names) throws InterruptedException {
        long start = System.nanoTime();
        boolean result = false;
        long timeInMills = TimeUnit.MILLISECONDS.convert(time, unit);
        while (!(result = this.db.lockForWriting(names)) && TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS) < timeInMills) {
            long sleepDurationMillis = 50 + RANDOM.nextInt(251);
            Thread.sleep(sleepDurationMillis);
        }
        return result;
    }

    @Override
    public boolean tryLock(String ... names) throws InterruptedException {
        return this.tryLock(this.lockTimeoutMillis, TimeUnit.MILLISECONDS, names);
    }

    @Override
    public boolean unlock(String ... names) {
        return true;
    }

    @Override
    public boolean shutdown() {
        return true;
    }
}

