/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.JoinCondition;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.document.NodeCacheIterator;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.spi.index.Index;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.provider.Filter;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.ValueFactories;

public class QuerySources {
    protected final RepositoryCache repo;
    protected final String workspaceName;
    protected final String systemWorkspaceName;
    protected final boolean includeSystemContent;
    protected final NodeCacheIterator.NodeFilter queryableFilter;
    protected final NodeCacheIterator.NodeFilter queryableAndNonSystemFilter;
    protected final NodeTypes nodeTypes;

    public QuerySources(RepositoryCache repository, final NodeTypes nodeTypes, String workspaceName, boolean includeSystemContent) {
        assert (repository != null);
        assert (nodeTypes != null);
        assert (workspaceName != null);
        this.repo = repository;
        this.nodeTypes = nodeTypes;
        this.workspaceName = workspaceName;
        this.includeSystemContent = includeSystemContent;
        this.systemWorkspaceName = includeSystemContent ? this.repo.getSystemWorkspaceName() : null;
        this.queryableFilter = new NodeCacheIterator.NodeFilter(){

            @Override
            public final boolean includeNode(CachedNode node, NodeCache cache) {
                Name nodePrimaryType = node.getPrimaryType(cache);
                Set<Name> mixinTypes = node.getMixinTypes(cache);
                return !node.isExcludedFromSearch(cache) && nodeTypes.isQueryable(nodePrimaryType, mixinTypes);
            }

            public String toString() {
                return "(queryable nodes)";
            }

            @Override
            public boolean continueProcessingChildren(CachedNode node, NodeCache cache) {
                Name nodePrimaryType = node.getPrimaryType(cache);
                Set<Name> mixinTypes = node.getMixinTypes(cache);
                return !node.isExcludedFromSearch(cache) && !nodeTypes.isQueryable(nodePrimaryType, mixinTypes);
            }
        };
        if (!this.includeSystemContent) {
            final String systemWorkspaceKey = this.repo.getSystemWorkspaceKey();
            this.queryableAndNonSystemFilter = new NodeCacheIterator.NodeFilter(){

                @Override
                public final boolean includeNode(CachedNode node, NodeCache cache) {
                    Name nodePrimaryType = node.getPrimaryType(cache);
                    Set<Name> mixinTypes = node.getMixinTypes(cache);
                    return !node.isExcludedFromSearch(cache) && !node.getKey().getWorkspaceKey().equals(systemWorkspaceKey) && nodeTypes.isQueryable(nodePrimaryType, mixinTypes);
                }

                public String toString() {
                    return "(queryable nodes not in workspace)";
                }

                @Override
                public boolean continueProcessingChildren(CachedNode node, NodeCache cache) {
                    Name nodePrimaryType = node.getPrimaryType(cache);
                    Set<Name> mixinTypes = node.getMixinTypes(cache);
                    return !node.isExcludedFromSearch(cache) && !node.getKey().getWorkspaceKey().equals(systemWorkspaceKey) && !nodeTypes.isQueryable(nodePrimaryType, mixinTypes);
                }
            };
        } else {
            this.queryableAndNonSystemFilter = this.queryableFilter;
        }
    }

    public boolean includeSystemContent() {
        return this.includeSystemContent;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public NodeSequence allNodes(float score, long nodeCount) {
        NodeCacheIterator iter = this.nodes(this.workspaceName, null);
        assert (iter != null);
        NodeSequence.Batch mainBatch = NodeSequence.batchOfKeys((Iterator<NodeKey>)iter, nodeCount, score, this.workspaceName, this.repo);
        return NodeSequence.withBatch(mainBatch);
    }

    public NodeSequence singleNode(Path path, float score) {
        WorkspaceCache cache;
        CachedNode node;
        String workspaceName = this.getWorkspaceName(path);
        NodeCacheIterator.NodeFilter nodeFilter = this.nodeFilterForWorkspace(workspaceName);
        if (nodeFilter != null && (node = this.getNodeAtPath(path, cache = this.repo.getWorkspaceCache(workspaceName))) != null && nodeFilter.includeNode(node, cache)) {
            return NodeSequence.withNodes(Collections.singleton(node), score, workspaceName);
        }
        return NodeSequence.emptySequence(1);
    }

    public NodeSequence singleNode(String workspaceName, String identifier, float score) {
        NodeCacheIterator.NodeFilter nodeFilter = this.nodeFilterForWorkspace(workspaceName);
        if (nodeFilter != null) {
            NodeKey key;
            CachedNode node;
            WorkspaceCache cache = this.repo.getWorkspaceCache(workspaceName);
            if (NodeKey.isValidFormat(identifier) && (node = cache.getNode(key = new NodeKey(identifier))) != null && nodeFilter.includeNode(node, cache)) {
                return NodeSequence.withNodes(Collections.singleton(node), score, workspaceName);
            }
            key = cache.getRootKey().withId(identifier);
            node = cache.getNode(key);
            if (node != null && nodeFilter.includeNode(node, cache)) {
                return NodeSequence.withNodes(Collections.singleton(node), score, workspaceName);
            }
        }
        return NodeSequence.emptySequence(1);
    }

    protected String getIdentifier(CachedNode node, NodeKey workspaceRootKey) {
        NodeKey key = node.getKey();
        if (!key.getSourceKey().equals(workspaceRootKey.getSourceKey())) {
            return key.toString();
        }
        return key.getIdentifier();
    }

    public NodeSequence childNodes(Path parentPath, float score) {
        String workspaceName = this.getWorkspaceName(parentPath);
        NodeCacheIterator.NodeFilter nodeFilter = this.nodeFilterForWorkspace(workspaceName);
        if (nodeFilter != null) {
            CompositeNodeFilter compositeFilter = new CompositeNodeFilter(nodeFilter, this.sharedNodesFilter());
            WorkspaceCache cache = this.repo.getWorkspaceCache(workspaceName);
            CachedNode parentNode = this.getNodeAtPath(parentPath, cache);
            if (parentNode != null) {
                ChildReferences childRefs = parentNode.getChildReferences(cache);
                ArrayList<CachedNode> results = new ArrayList<CachedNode>((int)childRefs.size());
                for (ChildReference childRef : childRefs) {
                    CachedNode child = cache.getNode(childRef);
                    if (!compositeFilter.includeNode(child, cache)) continue;
                    results.add(child);
                }
                return NodeSequence.withNodes(results, score, workspaceName);
            }
        }
        return NodeSequence.emptySequence(1);
    }

    public NodeSequence descendantNodes(Path ancestorPath, float score) {
        String workspaceName = this.getWorkspaceName(ancestorPath);
        NodeCacheIterator iter = this.nodes(workspaceName, ancestorPath);
        if (iter != null) {
            if (iter.hasNext()) {
                NodeKey key = iter.next();
                assert (ancestorPath.equals(this.path(workspaceName, key))) : "First node in results does not match the expected path";
            }
            return NodeSequence.withNodeKeys((Iterator<NodeKey>)iter, -1L, score, workspaceName, this.repo);
        }
        return NodeSequence.emptySequence(1);
    }

    public NodeSequence fromIndex(final Index index, final long cardinalityEstimate, final Collection<Constraint> constraints, final Collection<JoinCondition> joinConditions, final Map<String, Object> variables, final Map<String, Object> parameters, final ValueFactories valueFactories, final int batchSize) {
        if (!index.isEnabled()) {
            return null;
        }
        final IndexConstraints indexConstraints = new IndexConstraints(){

            @Override
            public boolean hasConstraints() {
                return !constraints.isEmpty();
            }

            @Override
            public Collection<Constraint> getConstraints() {
                return constraints;
            }

            @Override
            public Map<String, Object> getVariables() {
                return variables;
            }

            @Override
            public ValueFactories getValueFactories() {
                return valueFactories;
            }

            @Override
            public Map<String, Object> getParameters() {
                return parameters;
            }

            @Override
            public Collection<JoinCondition> getJoinConditions() {
                return joinConditions;
            }
        };
        return new NodeSequence(){
            private Filter.Results results;
            private Filter.ResultBatch currentBatch;
            private boolean more = true;
            private long rowCount = 0L;

            @Override
            public int width() {
                return 1;
            }

            @Override
            public long getRowCount() {
                if (!this.more) {
                    return this.rowCount;
                }
                return -1L;
            }

            @Override
            public boolean isEmpty() {
                if (this.rowCount > 0L) {
                    return false;
                }
                if (!this.more) {
                    return true;
                }
                if (this.results == null) {
                    return false;
                }
                this.readBatch();
                return this.rowCount == 0L;
            }

            @Override
            public NodeSequence.Batch nextBatch() {
                if (this.currentBatch == null) {
                    if (!this.more) {
                        this.close();
                        return null;
                    }
                    this.readBatch();
                }
                NodeSequence.Batch nextBatch = NodeSequence.batchOfKeys(this.currentBatch.keys().iterator(), this.currentBatch.scores().iterator(), this.currentBatch.size(), QuerySources.this.workspaceName, QuerySources.this.repo);
                this.currentBatch = null;
                return nextBatch;
            }

            @Override
            public void close() {
                if (this.results != null) {
                    this.results.close();
                    this.results = null;
                }
            }

            protected final void readBatch() {
                if (this.currentBatch != null) {
                    return;
                }
                this.currentBatch = this.getResults().getNextBatch(batchSize);
                this.more = this.currentBatch.hasNext();
                this.rowCount += (long)this.currentBatch.size();
            }

            public String toString() {
                return "(from-index " + index.getName() + " with " + constraints + ")";
            }

            private Filter.Results getResults() {
                if (this.results != null) {
                    return this.results;
                }
                this.results = index.filter(indexConstraints, cardinalityEstimate);
                return this.results;
            }
        };
    }

    protected NodeCacheIterator.NodeFilter sharedNodesFilter() {
        return new NodeCacheIterator.NodeFilter(){
            private final Set<NodeKey> shareableNodeKeys = new HashSet<NodeKey>();

            @Override
            public boolean includeNode(CachedNode node, NodeCache cache) {
                if (QuerySources.this.nodeTypes.isShareable(node.getPrimaryType(cache), node.getMixinTypes(cache))) {
                    NodeKey key = node.getKey();
                    if (this.shareableNodeKeys.contains(key)) {
                        return false;
                    }
                    this.shareableNodeKeys.add(key);
                    return true;
                }
                return true;
            }

            @Override
            public boolean continueProcessingChildren(CachedNode node, NodeCache cache) {
                return !this.shareableNodeKeys.contains(node.getKey());
            }

            public String toString() {
                return "(excludes-sharables)";
            }
        };
    }

    protected NodeCacheIterator nodes(String workspaceName, Path path) {
        NodeCacheIterator.NodeFilter nodeFilterForWorkspace = this.nodeFilterForWorkspace(workspaceName);
        if (nodeFilterForWorkspace == null) {
            return null;
        }
        CompositeNodeFilter compositeFilter = new CompositeNodeFilter(nodeFilterForWorkspace, this.sharedNodesFilter());
        WorkspaceCache cache = this.repo.getWorkspaceCache(workspaceName);
        NodeKey startingNode = null;
        if (path != null) {
            CachedNode node = this.getNodeAtPath(path, cache);
            if (node != null) {
                startingNode = node.getKey();
            }
        } else {
            startingNode = cache.getRootKey();
        }
        if (startingNode != null) {
            return new NodeCacheIterator(cache, startingNode, compositeFilter);
        }
        return null;
    }

    protected NodeCacheIterator.NodeFilter nodeFilterForWorkspace(String workspaceName) {
        if (this.workspaceName.equals(workspaceName)) {
            if (this.includeSystemContent) {
                return this.queryableFilter;
            }
            return this.queryableAndNonSystemFilter;
        }
        return this.includeSystemContent ? this.queryableFilter : null;
    }

    protected CachedNode getNodeAtPath(Path path, NodeCache cache) {
        CachedNode node = cache.getNode(cache.getRootKey());
        for (Path.Segment segment : path) {
            ChildReference childRef = node.getChildReferences(cache).getChild(segment);
            if (childRef == null) {
                return null;
            }
            node = cache.getNode(childRef);
        }
        return node;
    }

    protected String getWorkspaceName(Path path) {
        if (this.includeSystemContent && path.size() > 1 && JcrLexicon.SYSTEM.equals(path.getSegment(0).getName())) {
            return this.systemWorkspaceName;
        }
        return this.workspaceName;
    }

    private Path path(String workspaceName, NodeKey key) {
        WorkspaceCache cache = this.repo.getWorkspaceCache(workspaceName);
        return cache.getNode(key).getPath(cache);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("QuerySources(");
        sb.append("repo='").append(this.repo).append("'");
        sb.append(" workspace='").append(this.workspaceName).append("'");
        if (this.includeSystemContent) {
            sb.append(" system='").append(this.systemWorkspaceName).append("'");
        }
        sb.append(')');
        return sb.toString();
    }

    protected static class CompositeNodeFilter
    implements NodeCacheIterator.NodeFilter {
        private final List<NodeCacheIterator.NodeFilter> filters;

        protected CompositeNodeFilter(NodeCacheIterator.NodeFilter ... filters) {
            this.filters = Arrays.asList(filters);
        }

        @Override
        public boolean includeNode(CachedNode node, NodeCache cache) {
            for (NodeCacheIterator.NodeFilter filter : this.filters) {
                if (filter.includeNode(node, cache)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean continueProcessingChildren(CachedNode node, NodeCache cache) {
            for (NodeCacheIterator.NodeFilter filter : this.filters) {
                if (filter.continueProcessingChildren(node, cache)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.filters.isEmpty() ? "" : this.filters.toString();
        }
    }
}

