/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.txn;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.txn.LocalTransactionManager;

@Immutable
@ThreadSafe
public class LocalTransaction
implements Transaction {
    private final List<Synchronization> synchronizations = new ArrayList<Synchronization>();
    private final AtomicInteger status = new AtomicInteger(0);
    private final String id = UUID.randomUUID().toString();

    protected LocalTransaction() {
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        try {
            this.validateThreadOwnership();
            if (this.markedForRollback()) {
                this.rollback();
                throw new RollbackException("Transaction was marked for rollback");
            }
            if (!this.isActive()) {
                throw new SystemException("Illegal transaction status:" + this.status);
            }
            this.synchronizations.stream().forEach(Synchronization::beforeCompletion);
            this.status.compareAndSet(0, 3);
            this.synchronizations.stream().forEach(sync -> sync.afterCompletion(this.status.get()));
        }
        finally {
            LocalTransactionManager.clear();
        }
    }

    private void validateThreadOwnership() {
        LocalTransaction txForThread;
        LocalTransaction localTransaction = txForThread = LocalTransactionManager.hasActiveTransaction() ? LocalTransactionManager.transactionForThread() : null;
        if (!this.equals(txForThread)) {
            throw new IllegalStateException("Current thread does not own the transaction");
        }
    }

    private boolean markedForRollback() {
        return this.status.get() == 1;
    }

    private boolean isActive() {
        return this.status.get() == 0;
    }

    public void rollback() throws IllegalStateException, SystemException {
        try {
            this.validateThreadOwnership();
            if (!this.isActive() && !this.markedForRollback()) {
                throw new SystemException("Illegal transaction status:" + this.status);
            }
            this.synchronizations.stream().forEach(Synchronization::beforeCompletion);
            this.status.set(4);
            this.synchronizations.stream().forEach(sync -> sync.afterCompletion(this.status.get()));
        }
        finally {
            LocalTransactionManager.clear();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (!this.isActive()) {
            throw new IllegalStateException("Current status is invalid" + this.status.get());
        }
        this.status.compareAndSet(0, 1);
    }

    public int getStatus() throws SystemException {
        return this.status.get();
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        throw new UnsupportedOperationException("Local transactions do not support XA resources...");
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        throw new UnsupportedOperationException("Local transactions do not support XA resources...");
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        this.synchronizations.add(sync);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalTransaction that = (LocalTransaction)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

