/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.txn;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.schematic.TransactionListener;

public class Transactions {
    private static final ThreadLocal<NestableThreadLocalTransaction> LOCAL_TRANSACTION = new ThreadLocal();
    private static final Set<String> ACTIVE_TRACE_SYNCHRONIZATIONS = new HashSet<String>();
    protected final TransactionManager txnMgr;
    protected final Logger logger = Logger.getLogger(Transactions.class);
    private final TransactionListener listener;
    private final ConcurrentMap<javax.transaction.Transaction, SynchronizedTransaction> transactionTable;

    public Transactions(TransactionManager txnMgr, TransactionListener listener) {
        this.txnMgr = txnMgr;
        this.listener = listener;
        this.transactionTable = new ConcurrentHashMap<javax.transaction.Transaction, SynchronizedTransaction>();
    }

    public boolean isCurrentlyInTransaction() throws SystemException {
        return this.txnMgr.getTransaction() != null;
    }

    public String currentTransactionId() {
        try {
            javax.transaction.Transaction txn = this.txnMgr.getTransaction();
            return txn != null ? txn.toString() : null;
        }
        catch (SystemException e) {
            return null;
        }
    }

    public TransactionManager getTransactionManager() {
        return this.txnMgr;
    }

    public Transaction begin() throws NotSupportedException, SystemException, RollbackException {
        NestableThreadLocalTransaction localTx = LOCAL_TRANSACTION.get();
        if (localTx != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Found active ModeShape transaction '{0}' ", new Object[]{localTx});
            }
            return localTx.begin();
        }
        javax.transaction.Transaction txn = this.txnMgr.getTransaction();
        if (txn != null && txn.getStatus() != 0) {
            this.logger.warn((I18nResource)JcrI18n.warnRogueTransaction, new Object[]{txn});
            this.txnMgr.suspend();
            txn = null;
        }
        if (txn == null) {
            this.txnMgr.begin();
            localTx = new NestableThreadLocalTransaction(this.txnMgr).begin();
            return this.logTransactionInformation(localTx);
        }
        SynchronizedTransaction synchronizedTransaction = (SynchronizedTransaction)this.transactionTable.get(txn);
        if (synchronizedTransaction != null) {
            return this.logTransactionInformation(synchronizedTransaction);
        }
        synchronizedTransaction = new SynchronizedTransaction(this.txnMgr, txn);
        this.transactionTable.put(txn, synchronizedTransaction);
        txn.registerSynchronization((Synchronization)synchronizedTransaction);
        return this.logTransactionInformation(synchronizedTransaction);
    }

    private Transaction logTransactionInformation(Transaction transaction) throws SystemException {
        if (!this.logger.isTraceEnabled()) {
            return transaction;
        }
        this.logger.trace("Created & stored new ModeShape synchronized transaction '{0}' ", new Object[]{transaction});
        javax.transaction.Transaction txn = this.txnMgr.getTransaction();
        assert (txn != null);
        String id = txn.toString();
        if (!ACTIVE_TRACE_SYNCHRONIZATIONS.contains(id)) {
            if (transaction instanceof SynchronizedTransaction) {
                this.logger.trace("Found user transaction {0}", new Object[]{txn});
            } else {
                this.logger.trace("Begin transaction {0}", new Object[]{id});
            }
            try {
                txn.registerSynchronization((Synchronization)new TransactionTracer(id));
            }
            catch (RollbackException e) {
                return new RollbackOnlyTransaction();
            }
        } else {
            this.logger.trace("Tracer already registered for transaction {0}", new Object[]{id});
        }
        return transaction;
    }

    public Transaction currentTransaction() {
        Transaction localTx = LOCAL_TRANSACTION.get();
        if (localTx != null) {
            return localTx;
        }
        try {
            javax.transaction.Transaction txn = this.txnMgr.getTransaction();
            if (txn == null) {
                return null;
            }
            return (Transaction)this.transactionTable.get(txn);
        }
        catch (SystemException e) {
            this.logger.debug((Throwable)e, "Cannot determine if there is an active transaction or not", new Object[0]);
            return null;
        }
    }

    public void commit() throws HeuristicRollbackException, RollbackException, HeuristicMixedException, SystemException {
        Transaction transaction = this.currentTransaction();
        if (transaction == null) {
            throw new IllegalStateException("No active transaction");
        }
        transaction.commit();
    }

    public void rollback() throws SystemException {
        Transaction transaction = this.currentTransaction();
        if (transaction == null) {
            throw new IllegalStateException("No active transaction");
        }
        transaction.rollback();
    }

    public void updateCache(WorkspaceCache workspace, ChangeSet changes, Transaction transaction) {
        if (changes == null || changes.isEmpty()) {
            return;
        }
        if (transaction instanceof SynchronizedTransaction) {
            transaction.uponCommit(() -> workspace.changed(changes));
            if (workspace instanceof TransactionalWorkspaceCache) {
                ((TransactionalWorkspaceCache)workspace).changedWithinTransaction(changes);
            }
        } else if (!(transaction instanceof RollbackOnlyTransaction)) {
            workspace.changed(changes);
        }
    }

    public javax.transaction.Transaction suspend() throws SystemException {
        return this.txnMgr.suspend();
    }

    public void resume(javax.transaction.Transaction transaction) throws SystemException {
        if (transaction != null && this.txnMgr.getTransaction() == null) {
            try {
                this.txnMgr.resume(transaction);
            }
            catch (InvalidTransactionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected final class TransactionTracer
    implements Synchronization {
        private String txnId;

        protected TransactionTracer(String id) {
            this.txnId = id;
            ACTIVE_TRACE_SYNCHRONIZATIONS.add(id);
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            ACTIVE_TRACE_SYNCHRONIZATIONS.remove(this.txnId);
            switch (status) {
                case 3: {
                    Transactions.this.logger.trace("Commit transaction '{0}'", new Object[]{this.txnId});
                    break;
                }
                case 4: {
                    Transactions.this.logger.trace("Roll back transaction '{0}'", new Object[]{this.txnId});
                    break;
                }
            }
        }
    }

    protected class RollbackOnlyTransaction
    implements Transaction {
        protected RollbackOnlyTransaction() {
        }

        @Override
        public String id() {
            return "";
        }

        @Override
        public int status() {
            return 1;
        }

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }

        @Override
        public void uponCompletion(TransactionFunction function) {
        }

        @Override
        public void uponCommit(TransactionFunction function) {
        }
    }

    protected final class SynchronizedTransaction
    extends BaseTransaction
    implements Synchronization {
        private final javax.transaction.Transaction transaction;

        protected SynchronizedTransaction(TransactionManager txnMgr, javax.transaction.Transaction transaction) {
            super(txnMgr);
            this.transaction = transaction;
            this.started();
        }

        @Override
        public void commit() {
            if (Transactions.this.logger.isTraceEnabled()) {
                Transactions.this.logger.trace("'{0}' ignoring commit call coming from ModeShape.", new Object[]{this.id});
            }
        }

        @Override
        public void rollback() {
            if (Transactions.this.logger.isTraceEnabled()) {
                Transactions.this.logger.trace("'{0}' ignoring rollback call coming from ModeShape.", new Object[]{this.id});
            }
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            if (Transactions.this.logger.isTraceEnabled()) {
                Transactions.this.logger.trace("Synchronization for '{0}' notified after completion with status '{1}'", new Object[]{this.id, status});
            }
            try {
                if (3 == status) {
                    Transactions.this.listener.txCommitted(this.id);
                    this.executeFunctionsUponCommit();
                } else if (4 == status) {
                    Transactions.this.listener.txRolledback(this.id);
                }
            }
            finally {
                try {
                    this.executeFunctionsUponCompletion();
                }
                finally {
                    Transactions.this.transactionTable.remove(this.transaction);
                }
            }
        }
    }

    protected class NestableThreadLocalTransaction
    extends TraceableSimpleTransaction {
        private AtomicInteger nestedLevel;

        protected NestableThreadLocalTransaction(TransactionManager txnMgr) {
            super(txnMgr);
            this.nestedLevel = new AtomicInteger(0);
            LOCAL_TRANSACTION.set(this);
        }

        @Override
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            try {
                super.rollback();
            }
            finally {
                this.cleanup();
            }
        }

        @Override
        public void commit() throws RollbackException, SecurityException, IllegalStateException, SystemException {
            if (this.nestedLevel.getAndDecrement() == 1) {
                try {
                    super.commit();
                }
                finally {
                    this.cleanup();
                }
            } else {
                Transactions.this.logger.trace("Not committing transaction because it's nested within another transaction. Only the top level transaction should commit", new Object[0]);
            }
        }

        protected void cleanup() {
            LOCAL_TRANSACTION.remove();
            this.nestedLevel = null;
        }

        protected NestableThreadLocalTransaction begin() {
            this.nestedLevel.incrementAndGet();
            return this;
        }
    }

    protected abstract class TraceableSimpleTransaction
    extends SimpleTransaction {
        protected TraceableSimpleTransaction(TransactionManager txnMgr) {
            super(txnMgr);
        }

        @Override
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            if (Transactions.this.logger.isTraceEnabled()) {
                Transactions.this.logger.trace("Rolling back transaction '{0}'", new Object[]{this.id});
            }
            super.rollback();
        }

        @Override
        public void commit() throws RollbackException, SecurityException, IllegalStateException, SystemException {
            if (Transactions.this.logger.isTraceEnabled()) {
                super.commit();
                Transactions.this.logger.trace("Committed transaction '{0}'", new Object[]{this.id});
            } else {
                super.commit();
            }
        }
    }

    protected abstract class SimpleTransaction
    extends BaseTransaction {
        protected SimpleTransaction(TransactionManager txnMgr) {
            super(txnMgr);
            this.started();
        }

        @Override
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            boolean canRollback = this.canRollback();
            try {
                if (canRollback) {
                    this.txnMgr.rollback();
                }
            }
            finally {
                if (canRollback) {
                    Transactions.this.listener.txRolledback(this.id);
                    this.executeFunctionsUponCompletion();
                }
            }
        }

        @Override
        public void commit() throws RollbackException, SecurityException, IllegalStateException, SystemException {
            try {
                this.txnMgr.commit();
                Transactions.this.listener.txCommitted(this.id);
                this.executeFunctionsUponCommit();
            }
            catch (HeuristicMixedException | HeuristicRollbackException | RollbackException e) {
                Transactions.this.listener.txRolledback(this.id);
                throw new RollbackException(e.getMessage());
            }
            catch (SystemException e) {
                Transactions.this.listener.txRolledback(this.id);
                throw e;
            }
            finally {
                this.executeFunctionsUponCompletion();
            }
        }

        protected boolean canRollback() {
            try {
                switch (super.status()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            catch (SystemException e) {
                return false;
            }
        }
    }

    protected abstract class BaseTransaction
    implements Transaction {
        protected final TransactionManager txnMgr;
        protected final String id;
        private final LinkedHashSet<TransactionFunction> uponCompletionFunctions = new LinkedHashSet();
        private final LinkedHashSet<TransactionFunction> uponCommitFunctions = new LinkedHashSet();

        protected BaseTransaction(TransactionManager txnMgr) {
            this.txnMgr = txnMgr;
            this.id = UUID.randomUUID().toString();
        }

        protected void started() {
            Transactions.this.listener.txStarted(this.id);
        }

        @Override
        public void uponCompletion(TransactionFunction function) {
            this.uponCompletionFunctions.add(function);
        }

        @Override
        public void uponCommit(TransactionFunction function) {
            this.uponCommitFunctions.add(function);
        }

        @Override
        public int status() throws SystemException {
            return this.txnMgr.getStatus();
        }

        @Override
        public String id() {
            return this.id;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[");
            sb.append("id='").append(this.id).append('\'');
            sb.append(']');
            return sb.toString();
        }

        protected void executeFunctionsUponCompletion() {
            try {
                this.uponCompletionFunctions.forEach(TransactionFunction::execute);
            }
            finally {
                this.uponCompletionFunctions.clear();
            }
        }

        protected void executeFunctionsUponCommit() {
            try {
                this.uponCommitFunctions.forEach(TransactionFunction::execute);
            }
            finally {
                this.uponCommitFunctions.clear();
            }
        }
    }

    public static interface TransactionFunction {
        public void execute();
    }

    public static interface Transaction {
        public String id();

        public int status() throws SystemException;

        public void uponCompletion(TransactionFunction var1);

        public void uponCommit(TransactionFunction var1);

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException;

        public void rollback() throws IllegalStateException, SecurityException, SystemException;
    }
}

