/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.util.DateTimeUtil;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.IoException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.AbstractValueFactory;
import org.modeshape.jcr.value.basic.ModeShapeDateTime;

@Immutable
public class ModeShapeDateTimeValueFactory
extends AbstractValueFactory<DateTime>
implements DateTimeFactory {
    public ModeShapeDateTimeValueFactory(TextDecoder decoder, ValueFactories factories) {
        super(PropertyType.DATE, decoder, factories);
    }

    @Override
    public DateTimeFactory with(ValueFactories valueFactories) {
        return this.valueFactories == valueFactories ? this : new ModeShapeDateTimeValueFactory(super.getDecoder(), valueFactories);
    }

    @Override
    public DateTime create(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new ModeShapeDateTime(value.trim());
        }
        catch (DateTimeParseException err) {
            try {
                Long longValue = Long.parseLong(value);
                return new ModeShapeDateTime(longValue);
            }
            catch (NumberFormatException e) {
                throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), DateTime.class.getSimpleName(), value}), err);
            }
        }
    }

    @Override
    public DateTime create(String value, TextDecoder decoder) {
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public DateTime create(int value) {
        return this.create((long)value);
    }

    @Override
    public DateTime create(long value) {
        return new ModeShapeDateTime(value);
    }

    @Override
    public DateTime create(boolean value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Date.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(float value) {
        return this.create((long)value);
    }

    @Override
    public DateTime create(double value) {
        return this.create((long)value);
    }

    @Override
    public DateTime create(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return this.create(value.longValue());
    }

    @Override
    public DateTime create(Calendar value) {
        if (value == null) {
            return null;
        }
        return new ModeShapeDateTime(value);
    }

    @Override
    public DateTime create(Date value) {
        if (value == null) {
            return null;
        }
        return new ModeShapeDateTime(value);
    }

    @Override
    public DateTime create(DateTime value) throws ValueFormatException {
        return value;
    }

    @Override
    public DateTime create(Name value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Name.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(Path value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(Path.Segment value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.Segment.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(Reference value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Reference.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(URI value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), URI.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(UUID value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), UUID.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(NodeKey value) throws ValueFormatException {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), NodeKey.class.getSimpleName(), value}));
    }

    @Override
    public DateTime create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public DateTime create(BinaryValue value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public DateTime create(InputStream stream) throws IoException {
        return this.create(this.getStringValueFactory().create(stream));
    }

    @Override
    public DateTime create() {
        return new ModeShapeDateTime();
    }

    @Override
    public DateTime createUtc() {
        return new ModeShapeDateTime(ZonedDateTime.now(DateTimeUtil.UTC));
    }

    @Override
    public DateTime create(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondsOfSecond) {
        return new ModeShapeDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisecondsOfSecond);
    }

    @Override
    public DateTime create(DateTime original, long offsetInMillis) {
        assert (original != null);
        if (offsetInMillis == 0L) {
            return original;
        }
        long newMillis = original.getMilliseconds() + offsetInMillis;
        return new ModeShapeDateTime(newMillis, original.getTimeZoneId());
    }

    public DateTime[] createEmptyArray(int length) {
        return new DateTime[length];
    }
}

