/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.modeshape.common.text.QuoteEncoder;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.filesystem.FileSystemConnector;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.cache.DocumentStoreException;
import org.modeshape.jcr.spi.federation.ExtraPropertiesStore;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;

class LegacySidecarExtraPropertyStore
implements ExtraPropertiesStore {
    protected static final String PROPERTY_PATTERN_STRING = "([\\S]+)\\s*[(](\\w+)[)]\\s*([\\[]?)?([^\\]]+)[\\]]?";
    protected static final Pattern PROPERTY_PATTERN = Pattern.compile("([\\S]+)\\s*[(](\\w+)[)]\\s*([\\[]?)?([^\\]]+)[\\]]?");
    protected static final String STRING_VALUE_PATTERN_STRING = "\\\"((((?<=\\\\)\\\")|[^\"])*)\\\"";
    protected static final Pattern STRING_VALUE_PATTERN = Pattern.compile("\\\"((((?<=\\\\)\\\")|[^\"])*)\\\"");
    protected static final String VALUE_PATTERN_STRING = "([^\\s,]+)\\s*[,]*\\s*";
    protected static final Pattern VALUE_PATTERN = Pattern.compile("([^\\s,]+)\\s*[,]*\\s*");
    public static final String DEFAULT_EXTENSION = ".modeshape";
    public static final String DEFAULT_RESOURCE_EXTENSION = ".content.modeshape";
    private final FileSystemConnector connector;
    private final NamespaceRegistry registry;
    private final PropertyFactory propertyFactory;
    private final ValueFactories factories;
    private final ValueFactory<String> stringFactory;
    private final TextEncoder encoder = new XmlNameEncoder();
    private final TextDecoder decoder = new XmlNameEncoder();
    private final QuoteEncoder quoter = new QuoteEncoder();

    protected LegacySidecarExtraPropertyStore(FileSystemConnector connector) {
        this.connector = connector;
        this.registry = this.connector.registry();
        this.propertyFactory = this.connector.getContext().getPropertyFactory();
        this.factories = this.connector.getContext().getValueFactories();
        this.stringFactory = this.factories.getStringFactory();
    }

    protected String getExclusionPattern() {
        return "(.+)\\.(content\\.)?modeshape$";
    }

    @Override
    public Map<Name, Property> getProperties(String id) {
        return this.load(id, this.sidecarFile(id));
    }

    @Override
    public void storeProperties(String id, Map<Name, Property> properties) {
        this.write(id, this.sidecarFile(id), properties);
    }

    @Override
    public void updateProperties(String id, Map<Name, Property> properties) {
        File sidecar = this.sidecarFile(id);
        Map<Name, Property> existing = this.load(id, sidecar);
        if (existing == null || existing.isEmpty()) {
            this.write(id, sidecar, properties);
        } else {
            for (Map.Entry<Name, Property> entry : properties.entrySet()) {
                Name name = entry.getKey();
                Property property = entry.getValue();
                if (property == null) {
                    existing.remove(name);
                    continue;
                }
                existing.put(name, property);
            }
            this.write(id, sidecar, existing);
        }
    }

    @Override
    public boolean removeProperties(String id) {
        File file = this.sidecarFile(id);
        if (!file.exists()) {
            return false;
        }
        file.delete();
        return true;
    }

    protected File sidecarFile(String id) {
        File actualFile = this.connector.fileFor(id);
        String extension = DEFAULT_EXTENSION;
        if (this.connector.isContentNode(id)) {
            extension = DEFAULT_RESOURCE_EXTENSION;
        }
        return new File(actualFile.getAbsolutePath() + extension);
    }

    protected Map<Name, Property> load(String id, File propertiesFile) {
        if (!propertiesFile.exists() || !propertiesFile.canRead()) {
            return NO_PROPERTIES;
        }
        try {
            String content = IoUtil.read((File)propertiesFile);
            HashMap<Name, Property> result = new HashMap<Name, Property>();
            for (String line : StringUtil.splitLines((String)content)) {
                Property property = this.parse(line, result);
                if (property == null) continue;
                result.put(property.getName(), property);
            }
            return result;
        }
        catch (Throwable e) {
            throw new DocumentStoreException(id, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(String id, File propertiesFile, Map<Name, Property> properties) {
        if (properties.isEmpty()) {
            if (propertiesFile.exists()) {
                propertiesFile.delete();
            }
            return;
        }
        try {
            Writer fileWriter = null;
            try {
                Property uuid;
                Property mixinTypes;
                Property primaryType = properties.get(JcrLexicon.PRIMARY_TYPE);
                if (primaryType != null) {
                    fileWriter = new FileWriter(propertiesFile);
                    this.write(primaryType, fileWriter);
                }
                if ((mixinTypes = properties.get(JcrLexicon.MIXIN_TYPES)) != null) {
                    if (fileWriter == null) {
                        fileWriter = new FileWriter(propertiesFile);
                    }
                    this.write(mixinTypes, fileWriter);
                }
                if ((uuid = properties.get(JcrLexicon.UUID)) != null) {
                    if (fileWriter == null) {
                        fileWriter = new FileWriter(propertiesFile);
                    }
                    this.write(uuid, fileWriter);
                }
                for (Property property : properties.values()) {
                    if (property == null || property == primaryType || property == mixinTypes || property == uuid) continue;
                    if (fileWriter == null) {
                        fileWriter = new FileWriter(propertiesFile);
                    }
                    this.write(property, fileWriter);
                }
            }
            finally {
                if (fileWriter != null) {
                    fileWriter.close();
                } else {
                    propertiesFile.delete();
                }
            }
        }
        catch (Throwable e) {
            throw new DocumentStoreException(id, e);
        }
    }

    protected void write(Property property, Writer stream) throws IOException, RepositoryException {
        String name = this.stringFactory.create(property.getName());
        stream.append(this.encoder.encode(name));
        if (property.isEmpty()) {
            stream.append('\n');
            stream.flush();
            return;
        }
        stream.append(" (");
        PropertyType type = PropertyType.discoverType(property.getFirstValue());
        stream.append(type.getName().toLowerCase());
        stream.append(") ");
        if (property.isMultiple()) {
            stream.append('[');
        }
        boolean first = true;
        boolean quote = type == PropertyType.STRING;
        for (Object value : property) {
            if (first) {
                first = false;
            } else {
                stream.append(", ");
            }
            String str = null;
            if (value instanceof Binary) {
                byte[] bytes = IoUtil.readBytes((InputStream)((Binary)value).getStream());
                str = StringUtil.getHexString((byte[])bytes);
            } else {
                str = this.stringFactory.create(value);
            }
            if (quote) {
                stream.append('\"');
                stream.append(this.quoter.encode(str));
                stream.append('\"');
                continue;
            }
            stream.append(str);
        }
        if (property.isMultiple()) {
            stream.append(']');
        }
        stream.append('\n');
        stream.flush();
    }

    protected Property parse(String line, Map<Name, Property> result) throws RepositoryException {
        if (line.length() == 0) {
            return null;
        }
        char firstChar = line.charAt(0);
        if (firstChar == '#') {
            return null;
        }
        if (firstChar == ' ') {
            return null;
        }
        Matcher matcher = PROPERTY_PATTERN.matcher(line);
        NameFactory nameFactory = this.factories.getNameFactory();
        if (!matcher.matches()) {
            Name name = (Name)nameFactory.create(this.decoder.decode(line));
            return this.propertyFactory.create(name);
        }
        String nameString = this.decoder.decode(matcher.group(1));
        String typeString = matcher.group(2);
        String valuesString = matcher.group(4);
        Name name = null;
        try {
            name = (Name)this.factories.getNameFactory().create(nameString);
        }
        catch (ValueFormatException e) {
            if (nameString.indexOf(58) < nameString.lastIndexOf(58)) {
                LinkedHashSet<String> prefixes = new LinkedHashSet<String>();
                prefixes.add("jcr");
                for (String prefix : this.registry.getPrefixes()) {
                    prefixes.add(prefix);
                }
                for (String prefix : prefixes) {
                    int index = nameString.lastIndexOf(prefix + ":");
                    if (index <= 0) continue;
                    name = (Name)nameFactory.create(nameString.substring(0, index));
                    result.put(name, this.propertyFactory.create(name));
                    name = (Name)nameFactory.create(nameString.substring(index));
                }
            }
            throw e;
        }
        PropertyType type = PropertyType.valueFor(typeString);
        Pattern pattern = VALUE_PATTERN;
        ValueFactory<?> valueFactory = this.factories.getValueFactory(type);
        boolean binary = false;
        boolean decode = false;
        if (type == PropertyType.STRING) {
            pattern = STRING_VALUE_PATTERN;
            decode = true;
        } else if (type == PropertyType.BINARY) {
            binary = true;
        }
        Matcher valuesMatcher = pattern.matcher(valuesString);
        ArrayList values = new ArrayList();
        while (valuesMatcher.find()) {
            String valueString = valuesMatcher.group(1);
            if (binary) {
                byte[] binaryValue = StringUtil.fromHexString((String)valueString);
                Object value = valueFactory.create(binaryValue);
                values.add(value);
                continue;
            }
            if (decode) {
                valueString = this.quoter.decode(valueString);
            }
            Object value = valueFactory.create(valueString);
            values.add(value);
        }
        if (values.isEmpty()) {
            return null;
        }
        return this.propertyFactory.create(name, type, values.size() > 1 ? values : values.get(0));
    }

    @Override
    public boolean contains(String id) {
        File file = this.sidecarFile(id);
        return file.exists();
    }
}

