/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.modeshape.common.collection.Multimap;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrValueFactory;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.xml.NodeImportDestination;
import org.modeshape.jcr.xml.NodeImportXmlHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class InitialContentImporter {
    private static final Logger LOGGER = Logger.getLogger(InitialContentImporter.class);
    private final JcrRepository.RunningState repository;
    private final RepositoryConfiguration.InitialContent initialContentConfig;

    InitialContentImporter(RepositoryConfiguration.InitialContent initialContentConfig, JcrRepository.RunningState repository) {
        this.initialContentConfig = initialContentConfig;
        this.repository = repository;
    }

    protected void initialize() {
        RepositoryCache repositoryCache = this.repository.repositoryCache();
        if (!repositoryCache.isInitializingRepository()) {
            return;
        }
        Set<String> workspaceNames = repositoryCache.getWorkspaceNames();
        if (workspaceNames.isEmpty()) {
            return;
        }
        this.repository.localDocumentStore().runInTransaction(() -> {
            for (String workspace : workspaceNames) {
                this.importInitialContent(workspace);
            }
            return null;
        }, 0, "repository:info");
    }

    protected void importInitialContent(String workspaceName) throws RepositoryException {
        if (!this.initialContentConfig.hasInitialContentFile(workspaceName)) {
            return;
        }
        RepositoryCache repositoryCache = this.repository.repositoryCache();
        WorkspaceCache wsCache = repositoryCache.getWorkspaceCache(workspaceName);
        if (!wsCache.isEmpty()) {
            LOGGER.debug("Skipping import of initial content into workspace {0} as it is not empty", new Object[]{workspaceName});
            return;
        }
        InputStream stream = this.getInitialContentFileStream(workspaceName);
        if (stream == null) {
            return;
        }
        this.doImport(workspaceName, stream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doImport(String workspaceName, InputStream initialContentFileStream) throws RepositoryException {
        JcrSession internalSession = this.repository.loginInternalSession(workspaceName);
        ImportDestination importDestination = new ImportDestination(internalSession);
        NodeImportXmlHandler handler = new NodeImportXmlHandler(importDestination);
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.parse(new InputSource(initialContentFileStream));
            internalSession.save();
        }
        catch (SAXException e) {
            try {
                if (e.getCause() instanceof RepositoryException) {
                    throw (RepositoryException)e.getCause();
                }
                throw new RepositoryException(JcrI18n.errorWhileParsingInitialContentFile.text(new Object[]{e.getMessage()}), (Throwable)e);
                catch (IOException e2) {
                    throw new RepositoryException(JcrI18n.errorWhileReadingInitialContentFile.text(new Object[]{e2.getMessage()}), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    initialContentFileStream.close();
                }
                catch (IOException e3) {
                    LOGGER.debug("Cannot close initial content file initialContentFileStream", new Object[]{e3});
                }
                internalSession.logout();
                throw throwable;
            }
        }
        try {
            initialContentFileStream.close();
        }
        catch (IOException e) {
            LOGGER.debug("Cannot close initial content file initialContentFileStream", new Object[]{e});
        }
        internalSession.logout();
    }

    private InputStream getInitialContentFileStream(String workspaceName) {
        String initialContentFileString = this.initialContentConfig.getInitialContentFile(workspaceName);
        InputStream stream = IoUtil.getResourceAsStream((String)initialContentFileString, (ClassLoader)this.repository.environment().getClassLoader(this, new String[0]), null);
        if (stream == null) {
            this.repository.warn(JcrI18n.cannotLoadInitialContentFile, initialContentFileString);
        }
        return stream;
    }

    private class ImportDestination
    implements NodeImportDestination {
        private final JcrSession session;

        protected ImportDestination(JcrSession session) {
            this.session = session;
        }

        @Override
        public ExecutionContext getExecutionContext() {
            return this.session.context();
        }

        @Override
        public void submit(LinkedHashMap<Path, NodeImportXmlHandler.ImportElement> parseResults) throws RepositoryException {
            ArrayList<NodeImportXmlHandler.ImportElement> elementsWithReferences = new ArrayList<NodeImportXmlHandler.ImportElement>();
            JcrValueFactory valueFactory = this.session.getValueFactory();
            for (Path nodePath : parseResults.keySet()) {
                LOGGER.debug("Importing node at path {0}", new Object[]{nodePath});
                NodeImportXmlHandler.ImportElement element = parseResults.get(nodePath);
                Path parentPath = nodePath.getParent();
                AbstractJcrNode parentNode = this.session.node(parentPath);
                AbstractJcrNode newNode = null;
                String newNodeRelativePath = nodePath.getLastSegment().getName().toString();
                newNode = StringUtil.isBlank((String)element.getType()) ? parentNode.addNode(newNodeRelativePath) : parentNode.addNode(newNodeRelativePath, element.getType());
                for (String mixin : element.getMixins()) {
                    newNode.addMixin(mixin);
                }
                for (String propertyName : element.getProperties().keySet()) {
                    PropertyType propertyType = element.getPropertyType(propertyName);
                    if (this.isReference(propertyType)) {
                        elementsWithReferences.add(element);
                        continue;
                    }
                    Collection propertyValues = element.getProperties().get((Object)propertyName);
                    if (propertyValues.size() == 1) {
                        InputStream inputStream;
                        String stringValue = (String)propertyValues.iterator().next();
                        if (this.isBinary(propertyType) && (inputStream = this.readBinaryStream(stringValue)) != null) {
                            newNode.setProperty(propertyName, inputStream);
                            continue;
                        }
                        newNode.setProperty(propertyName, stringValue, propertyType.jcrType());
                        continue;
                    }
                    String[] stringValues = propertyValues.toArray(new String[propertyValues.size()]);
                    if (this.isBinary(propertyType)) {
                        boolean allValuesRead = true;
                        Value[] binaryValues = new Value[propertyValues.size()];
                        for (int i = 0; i < stringValues.length; ++i) {
                            String stringValue = stringValues[i];
                            InputStream inputStream = this.readBinaryStream(stringValue);
                            if (inputStream == null) {
                                allValuesRead = false;
                                break;
                            }
                            binaryValues[i] = valueFactory.createValue(inputStream);
                        }
                        if (allValuesRead) {
                            newNode.setProperty(propertyName, binaryValues);
                            continue;
                        }
                    }
                    newNode.setProperty(propertyName, stringValues, propertyType.jcrType());
                }
            }
            if (!elementsWithReferences.isEmpty()) {
                this.setReferenceProperties(elementsWithReferences);
            }
        }

        private boolean isReference(PropertyType propertyType) {
            return PropertyType.REFERENCE == propertyType || PropertyType.WEAKREFERENCE == propertyType || PropertyType.SIMPLEREFERENCE == propertyType;
        }

        private boolean isBinary(PropertyType propertyType) {
            return PropertyType.BINARY == propertyType;
        }

        private InputStream readBinaryStream(String resourcePath) {
            File file = new File(resourcePath);
            if (file.exists() && file.canRead()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            return InitialContentImporter.class.getClassLoader().getResourceAsStream(resourcePath);
        }

        private void setReferenceProperties(List<NodeImportXmlHandler.ImportElement> elementsWithReferences) throws RepositoryException {
            for (NodeImportXmlHandler.ImportElement element : elementsWithReferences) {
                AbstractJcrNode node = this.session.node(element.getPath());
                Multimap<String, String> properties = element.getProperties();
                for (String propertyName : properties.keySet()) {
                    PropertyType propertyType = element.getPropertyType(propertyName);
                    if (!this.isReference(propertyType)) continue;
                    this.setReferenceProperty(node, propertyName, properties.get((Object)propertyName), propertyType);
                }
            }
        }

        private void setReferenceProperty(Node node, String propertyName, Collection<String> values, PropertyType referenceType) throws RepositoryException {
            ArrayList<JcrValue> referenceValues = new ArrayList<JcrValue>();
            for (String absPath : values) {
                AbstractJcrNode referredNode = this.session.getNode(absPath);
                JcrValue reference = null;
                switch (referenceType) {
                    case REFERENCE: {
                        reference = this.session.getValueFactory().createValue(referredNode, false);
                        break;
                    }
                    case WEAKREFERENCE: {
                        reference = this.session.getValueFactory().createValue(referredNode, true);
                        break;
                    }
                    case SIMPLEREFERENCE: {
                        reference = this.session.getValueFactory().createSimpleReference(referredNode);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid reference type:" + (Object)((Object)referenceType));
                    }
                }
                referenceValues.add(reference);
            }
            if (referenceValues.size() == 1) {
                node.setProperty(propertyName, (Value)referenceValues.get(0));
            } else {
                node.setProperty(propertyName, referenceValues.toArray(new Value[referenceValues.size()]));
            }
        }
    }
}

