/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.EnumSet;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.RepositoryStatistics;
import org.modeshape.jcr.api.monitor.DurationActivity;
import org.modeshape.jcr.api.monitor.DurationMetric;
import org.modeshape.jcr.api.monitor.History;
import org.modeshape.jcr.api.monitor.RepositoryMonitor;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.api.monitor.Window;

public class JcrRepositoryMonitor
implements RepositoryMonitor {
    private final JcrSession session;
    private final boolean permitted;

    protected JcrRepositoryMonitor(JcrSession session) throws RepositoryException {
        this.session = session;
        this.permitted = session.hasPermission("/", "monitor");
    }

    protected final RepositoryStatistics statistics() {
        return this.session.repository().getRepositoryStatistics();
    }

    public Set<ValueMetric> getAvailableValueMetrics() {
        return this.permitted ? this.statistics().getAvailableValueMetrics() : EnumSet.noneOf(ValueMetric.class);
    }

    public Set<DurationMetric> getAvailableDurationMetrics() {
        return this.permitted ? this.statistics().getAvailableDurationMetrics() : EnumSet.noneOf(DurationMetric.class);
    }

    public Set<Window> getAvailableWindows() {
        return this.permitted ? this.statistics().getAvailableWindows() : EnumSet.noneOf(Window.class);
    }

    public History getHistory(ValueMetric metric, Window windowInTime) throws AccessDeniedException {
        if (!this.permitted) {
            throw new AccessDeniedException();
        }
        return this.statistics().getHistory(metric, windowInTime);
    }

    public History getHistory(DurationMetric metric, Window windowInTime) throws AccessDeniedException {
        if (!this.permitted) {
            throw new AccessDeniedException();
        }
        return this.statistics().getHistory(metric, windowInTime);
    }

    public DurationActivity[] getLongestRunning(DurationMetric metric) throws AccessDeniedException {
        if (!this.permitted) {
            throw new AccessDeniedException();
        }
        return this.statistics().getLongestRunning(metric);
    }
}

