/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.NavigableSet;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DB;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.modeshape.jcr.index.local.IndexValues;
import org.modeshape.jcr.index.local.LocalMapIndex;

class LocalUniqueIndex<T>
extends LocalMapIndex<T, T> {
    static <T> LocalUniqueIndex<T> create(String name, String workspaceName, DB db, IndexValues.Converter<T> converter, BTreeKeySerializer<T> valueSerializer, Serializer<T> rawSerializer) {
        return new LocalUniqueIndex<T>(name, workspaceName, db, converter, valueSerializer, rawSerializer);
    }

    protected LocalUniqueIndex(String name, String workspaceName, DB db, IndexValues.Converter<T> converter, BTreeKeySerializer<T> valueSerializer, Serializer<T> rawSerializer) {
        super(name, workspaceName, db, converter, valueSerializer, rawSerializer);
    }

    @Override
    public void add(String nodeKey, String propertyName, T value) {
        this.logger.trace("Adding node '{0}' to '{1}' index with value '{2}'", new Object[]{nodeKey, this.name, value});
        this.keysByValue.put(value, (Object)nodeKey);
    }

    @Override
    public void remove(String nodeKey, String propertyName, T value) {
        for (Object key : Fun.filter((NavigableSet)this.valuesByKey, (Object)nodeKey)) {
            if (this.comparator.compare(value, key) != 0) continue;
            this.logger.trace("Removing node '{0}' from '{1}' index with value '{2}'", new Object[]{nodeKey, this.name, value});
            this.keysByValue.remove(key);
        }
    }

    @Override
    public void remove(String nodeKey) {
        for (Object key : Fun.filter((NavigableSet)this.valuesByKey, (Object)nodeKey)) {
            this.logger.trace("Removing node '{0}' from '{1}' index with value '{2}'", new Object[]{nodeKey, this.name, key});
            this.keysByValue.remove(key);
        }
    }
}

