/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.locking;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.locking.AbstractLockingService;

@ThreadSafe
public class StandaloneLockingService
extends AbstractLockingService<NodeLock> {
    public StandaloneLockingService() {
        this(0L);
    }

    public StandaloneLockingService(long lockTimeoutMillis) {
        super(lockTimeoutMillis);
    }

    @Override
    protected NodeLock createLock(String name) {
        return new NodeLock();
    }

    @Override
    protected boolean releaseLock(NodeLock lock) {
        lock.unlock();
        return true;
    }

    protected static class NodeLock
    extends AbstractQueuedSynchronizer
    implements Lock {
        @Override
        public void lock() {
            this.acquire(1);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.acquireInterruptibly(1);
        }

        @Override
        protected boolean tryAcquire(int arg) {
            if (this.isHeldExclusively()) {
                return true;
            }
            if (this.compareAndSetState(0, arg)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() > 0 && Thread.currentThread() == this.getExclusiveOwnerThread();
        }

        @Override
        public boolean tryLock() {
            return this.tryAcquire(1);
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.tryAcquireNanos(1, unit.toNanos(time));
        }

        @Override
        public void unlock() {
            this.release(0);
        }

        @Override
        protected boolean tryRelease(int arg) {
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        @Override
        public Condition newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }
    }
}

