/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.mimetype;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.mimetype.MimeTypeDetector;
import org.modeshape.schematic.annotation.ThreadSafe;

@ThreadSafe
public final class DefaultMimeTypeDetector
implements MimeTypeDetector {
    private final Map<String, String> mimeTypes = this.loadMimeTypes();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> loadMimeTypes() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(DefaultMimeTypeDetector.class.getResourceAsStream("mimetypes.properties")));){
            HashMap<String, String> result = new HashMap<String, String>();
            reader.lines().forEach(line -> {
                String[] parts = line.split("\\s");
                if (parts.length >= 2) {
                    String mimeType = parts[0];
                    for (int i = 1; i < parts.length; ++i) {
                        String extension = parts[i].trim();
                        if (StringUtil.isBlank((String)extension)) continue;
                        result.put(extension, mimeType);
                    }
                }
            });
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String mimeTypeOf(String name, Binary binaryValue) throws RepositoryException, IOException {
        if (name == null) {
            return null;
        }
        int lastDotIdx = name.lastIndexOf(46);
        String extension = lastDotIdx > 0 && lastDotIdx + 1 < name.length() ? name.substring(lastDotIdx + 1) : name;
        return this.mimeTypes.get(extension);
    }
}

