/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.mimetype.tika;

import java.io.InputStream;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypes;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.mimetype.tika.TikaMimeTypeDetector;

@Immutable
@ThreadSafe
public final class TikaContentDetector
extends TikaMimeTypeDetector {
    private DefaultDetector detector;

    public TikaContentDetector(Environment environment) {
        super(environment);
    }

    @Override
    protected void initDetector(ClassLoader loader) {
        try {
            this.detector = new DefaultDetector(MimeTypes.getDefaultMimeTypes((ClassLoader)loader));
            if (this.logger.isDebugEnabled()) {
                for (Detector detector : this.detector.getDetectors()) {
                    this.logger.debug(" - Found TIKA detector: " + detector.getClass().getName(), new Object[0]);
                }
            }
        }
        catch (Throwable t) {
            throw new SystemFailureException(JcrI18n.unableToInitializeMimeTypeDetector.text(new Object[]{t.getMessage()}), t);
        }
    }

    @Override
    protected String detect(InputStream inputStream, Metadata metadata) {
        MediaType detectedMimeType;
        block16: {
            detectedMimeType = null;
            try {
                if (inputStream != null) {
                    try (TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)inputStream);){
                        detectedMimeType = this.detector.detect((InputStream)tikaInputStream, metadata);
                        break block16;
                    }
                }
                detectedMimeType = this.detector.detect(null, metadata);
            }
            catch (Exception e) {
                this.logger.debug((Throwable)e, "Unable to extract mime-type", new Object[0]);
                return null;
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("MIME type for '" + metadata.get("resourceName") + "' ==> " + detectedMimeType, new Object[0]);
        }
        return detectedMimeType.toString();
    }
}

