/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.jcr.query.model.JoinCondition;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.query.model.Visitors;

@Immutable
public class DescendantNodeJoinCondition
implements JoinCondition,
javax.jcr.query.qom.DescendantNodeJoinCondition {
    private static final long serialVersionUID = 1L;
    private final SelectorName descendantSelectorName;
    private final SelectorName ancestorSelectorName;
    private final int hc;

    public DescendantNodeJoinCondition(SelectorName ancestorSelectorName, SelectorName descendantSelectorName) {
        CheckArg.isNotNull((Object)descendantSelectorName, (String)"descendantSelectorName");
        CheckArg.isNotNull((Object)ancestorSelectorName, (String)"ancestorSelectorName");
        this.descendantSelectorName = descendantSelectorName;
        this.ancestorSelectorName = ancestorSelectorName;
        this.hc = HashCode.compute((Object[])new Object[]{this.descendantSelectorName, this.ancestorSelectorName});
    }

    public final SelectorName descendantSelectorName() {
        return this.descendantSelectorName;
    }

    public final SelectorName ancestorSelectorName() {
        return this.ancestorSelectorName;
    }

    public String getAncestorSelectorName() {
        return this.ancestorSelectorName.getString();
    }

    public String getDescendantSelectorName() {
        return this.descendantSelectorName.getString();
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DescendantNodeJoinCondition) {
            DescendantNodeJoinCondition that = (DescendantNodeJoinCondition)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.descendantSelectorName.equals(that.descendantSelectorName)) {
                return false;
            }
            return this.ancestorSelectorName.equals(that.ancestorSelectorName);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

