/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.Database;
import org.modeshape.jcr.value.binary.FileSystemBinaryStore;
import org.modeshape.jcr.value.binary.StoredBinaryValue;
import org.modeshape.jcr.value.binary.TransientBinaryStore;

@ThreadSafe
public class DatabaseBinaryStore
extends AbstractBinaryStore {
    private static final boolean ALIVE = true;
    private static final boolean UNUSED = false;
    private final String driverClass;
    private final String connectionURL;
    private final String username;
    private final String password;
    private final String datasourceJNDILocation;
    private DataSource dataSource;
    private final FileSystemBinaryStore cache;
    private Database database;

    public DatabaseBinaryStore(String driverClass, String connectionURL, String username, String password) {
        this.driverClass = driverClass;
        this.connectionURL = connectionURL;
        this.username = username;
        this.password = password;
        this.datasourceJNDILocation = null;
        this.cache = TransientBinaryStore.get();
    }

    public DatabaseBinaryStore(String datasourceJNDILocation) {
        this.driverClass = null;
        this.connectionURL = null;
        this.username = null;
        this.password = null;
        this.datasourceJNDILocation = datasourceJNDILocation;
        this.cache = TransientBinaryStore.get();
    }

    @Override
    public void start() {
        if (!StringUtil.isBlank((String)this.datasourceJNDILocation)) {
            this.lookupDataSource();
        } else {
            this.initManagedDS();
        }
        try (Connection connection = this.newConnection();){
            this.database = new Database(connection);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BinaryValue storeValue(InputStream stream, boolean markAsUnused) throws BinaryStoreException {
        BinaryValue temp = this.cache.storeValue(stream, markAsUnused);
        BinaryKey key = new BinaryKey(temp.getKey().toString());
        try {
            BinaryValue binaryValue = this.dbCall(connection -> {
                connection.setAutoCommit(false);
                if (this.database.contentExists(key, true, connection)) {
                    return new StoredBinaryValue(this, key, temp.getSize());
                }
                if (this.database.contentExists(key, false, connection)) {
                    if (!markAsUnused) {
                        this.database.restoreContent(connection, Collections.singletonList(key));
                    }
                } else {
                    try (InputStream is = temp.getStream();){
                        this.database.insertContent(key, is, temp.getSize(), connection);
                        if (markAsUnused) {
                            this.database.markUnused(Collections.singletonList(key), connection);
                        }
                    }
                }
                return new StoredBinaryValue(this, key, temp.getSize());
            });
            return binaryValue;
        }
        catch (BinaryStoreException e) {
            if (e.getCause() instanceof SQLException) {
                BinaryValue binaryValue = this.dbCall(connection -> {
                    if (this.database.contentExists(key, !markAsUnused, connection)) {
                        return new StoredBinaryValue(this, key, temp.getSize());
                    }
                    throw e;
                });
                return binaryValue;
            }
            throw e;
        }
        finally {
            this.cache.markAsUnused(temp.getKey());
        }
    }

    @Override
    public InputStream getInputStream(BinaryKey key) throws BinaryStoreException {
        Connection connection = this.newConnection();
        try {
            InputStream inputStream = this.database.readContent(key, connection);
            if (inputStream == null) {
                throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{key, this.database.getTableName()}));
            }
            return inputStream;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public void markAsUsed(Iterable<BinaryKey> keys) throws BinaryStoreException {
        this.dbCall(connection -> {
            connection.setAutoCommit(false);
            this.database.restoreContent(connection, keys);
            return null;
        });
    }

    @Override
    public void markAsUnused(Iterable<BinaryKey> keys) throws BinaryStoreException {
        this.dbCall(connection -> {
            connection.setAutoCommit(false);
            this.database.markUnused(keys, connection);
            return null;
        });
    }

    @Override
    public void removeValuesUnusedLongerThan(long minimumAge, TimeUnit unit) throws BinaryStoreException {
        this.dbCall(connection -> {
            long deadline = System.currentTimeMillis() - unit.toMillis(minimumAge);
            this.database.removeExpiredContent(deadline, connection);
            return null;
        });
    }

    @Override
    protected String getStoredMimeType(BinaryValue source) throws BinaryStoreException {
        return this.dbCall(connection -> {
            connection.setAutoCommit(false);
            BinaryKey key = source.getKey();
            if (!this.database.contentExists(key, true, connection) && !this.database.contentExists(key, false, connection)) {
                throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{key, this.database.getTableName()}));
            }
            return this.database.getMimeType(key, connection);
        });
    }

    @Override
    protected void storeMimeType(BinaryValue source, String mimeType) throws BinaryStoreException {
        this.dbCall(connection -> {
            this.database.setMimeType(source.getKey(), mimeType, connection);
            return null;
        });
    }

    @Override
    public String getExtractedText(BinaryValue source) throws BinaryStoreException {
        return this.dbCall(connection -> {
            connection.setAutoCommit(false);
            BinaryKey key = source.getKey();
            if (!this.database.contentExists(key, true, connection) && !this.database.contentExists(key, false, connection)) {
                throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{key, this.database.getTableName()}));
            }
            return this.database.getExtractedText(key, connection);
        });
    }

    @Override
    public void storeExtractedText(BinaryValue source, String extractedText) throws BinaryStoreException {
        this.dbCall(connection -> {
            this.database.setExtractedText(source.getKey(), extractedText, connection);
            return null;
        });
    }

    @Override
    public Iterable<BinaryKey> getAllBinaryKeys() throws BinaryStoreException {
        return this.dbCall(connection -> this.database.getBinaryKeys(connection));
    }

    @Override
    public void shutdown() {
        if (this.dataSource instanceof HikariDataSource) {
            ((HikariDataSource)this.dataSource).close();
        }
    }

    private Connection newConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void lookupDataSource() {
        try {
            InitialContext context = new InitialContext();
            this.dataSource = (DataSource)context.lookup(this.datasourceJNDILocation);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    private void initManagedDS() {
        this.logger.debug("Attempting to connect to '{0}' with '{1}' for username '{2}' and password '{3}'", new Object[]{this.connectionURL, this.driverClass, this.username, this.password});
        HikariDataSource hikariDS = new HikariDataSource();
        hikariDS.setJdbcUrl(this.connectionURL);
        hikariDS.setDriverClassName(this.driverClass);
        hikariDS.setUsername(this.username);
        hikariDS.setPassword(this.password);
        this.dataSource = hikariDS;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T> T dbCall(DBCallable<T> callable) throws BinaryStoreException {
        try {
            Throwable throwable = null;
            try (Connection connection = this.newConnection();){
                T t;
                boolean autoCommit = true;
                try {
                    connection.setTransactionIsolation(2);
                    T result = callable.execute(connection);
                    autoCommit = connection.getAutoCommit();
                    if (!autoCommit) {
                        connection.commit();
                    }
                    t = result;
                }
                catch (Throwable t2) {
                    try {
                        if (!autoCommit) {
                            connection.rollback();
                        }
                        throw t2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                return t;
            }
        }
        catch (BinaryStoreException bse) {
            throw bse;
        }
        catch (Exception e) {
            throw new BinaryStoreException(e);
        }
    }

    @FunctionalInterface
    private static interface DBCallable<T> {
        public T execute(Connection var1) throws Exception;
    }
}

