/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import javax.jcr.Binary;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.mimetype.MimeTypeDetector;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.AbstractBinary;

public abstract class ExternalBinaryValue
extends AbstractBinary {
    private transient MimeTypeDetector mimeTypeDetector;
    private transient String nameHint;
    private final String id;
    private String mimeType;
    private long size;
    private boolean detectedMimeType = false;
    private String sourceName;

    protected ExternalBinaryValue(BinaryKey key, String sourceName, String id, long size, String nameHint, MimeTypeDetector mimeTypeDetector) {
        super(key);
        assert (id != null);
        this.id = id;
        this.sourceName = sourceName;
        this.size = size;
        this.nameHint = nameHint;
        this.mimeTypeDetector = mimeTypeDetector;
    }

    public String getId() {
        return this.id;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    protected void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    protected boolean hasMimeType() {
        return this.mimeType != null;
    }

    public String getMimeType() {
        if (!this.detectedMimeType && this.mimeTypeDetector != null) {
            try {
                this.mimeType = this.mimeTypeDetector.mimeTypeOf(this.nameHint, (Binary)this);
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass()).debug("Unable to compute MIME Type for external binary with id {0}", new Object[]{this.getId()});
                throw new RuntimeException(t);
            }
            finally {
                this.detectedMimeType = true;
            }
        }
        return this.mimeType;
    }

    public String getMimeType(String name) {
        return this.getMimeType();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalBinaryValue");
        sb.append("(sourceName='").append(this.sourceName).append('\'');
        sb.append(", id='").append(this.getId()).append('\'');
        sb.append(')');
        return sb.toString();
    }
}

