/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.UUID;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Bson;
import org.infinispan.schematic.document.Code;
import org.infinispan.schematic.document.CodeWithScope;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Null;
import org.infinispan.schematic.document.ObjectId;
import org.infinispan.schematic.document.Symbol;
import org.infinispan.schematic.document.Timestamp;
import org.infinispan.schematic.internal.document.BsonUtils;
import org.infinispan.schematic.internal.document.DocumentEditor;
import org.infinispan.schematic.internal.document.DocumentValueFactory;

public class DefaultDocumentValueFactory
implements DocumentValueFactory,
Serializable {
    public static final DocumentValueFactory INSTANCE = new DefaultDocumentValueFactory();
    private static final long serialVersionUID = 1L;

    @Override
    public String createString(String value) {
        return value;
    }

    @Override
    public Integer createInt(int value) {
        return value;
    }

    @Override
    public Long createLong(long value) {
        return value;
    }

    @Override
    public Boolean createBoolean(boolean value) {
        return value;
    }

    @Override
    public Double createDouble(double value) {
        return value;
    }

    @Override
    public Date createDate(String iso) throws ParseException {
        if (iso == null || iso.length() < 20) {
            return null;
        }
        int indexOfLastChar = iso.length() - 1;
        char lastChar = iso.charAt(indexOfLastChar);
        iso = lastChar == 'Z' || lastChar == 'z' ? iso.substring(0, indexOfLastChar) + "GMT+00:00" : iso.substring(0, 22) + "GMT" + iso.substring(22);
        return Bson.getDateParsingFormatter().parse(iso);
    }

    @Override
    public Date createDate(long millis) {
        return new Date(millis);
    }

    @Override
    public Timestamp createTimestamp(int time, int inc) {
        return new Timestamp(time, inc);
    }

    @Override
    public ObjectId createObjectId(String hex) {
        return BsonUtils.readObjectId(hex);
    }

    @Override
    public ObjectId createObjectId(byte[] bytes) {
        return BsonUtils.readObjectId(bytes);
    }

    @Override
    public ObjectId createObjectId(int time, int machine, int process, int inc) {
        return new ObjectId(time, machine, process, inc);
    }

    @Override
    public Symbol createSymbol(String value) {
        return new Symbol(value);
    }

    @Override
    public Pattern createRegex(String pattern, String flags) {
        return this.createRegex(pattern, BsonUtils.regexFlagsFrom(flags));
    }

    @Override
    public Pattern createRegex(String pattern, int flags) {
        return Pattern.compile(pattern, flags);
    }

    @Override
    public Object createNull() {
        return Null.getInstance();
    }

    @Override
    public Binary createBinary(byte type, byte[] data) {
        return new Binary(type, data);
    }

    @Override
    public UUID createUuid(String uuid) {
        return UUID.fromString(uuid);
    }

    @Override
    public UUID createUuid(long part1, long part2) {
        return new UUID(part1, part2);
    }

    @Override
    public Code createCode(String code) {
        return new Code(code);
    }

    @Override
    public CodeWithScope createCode(String code, Document scope) {
        if (scope instanceof DocumentEditor) {
            scope = ((DocumentEditor)scope).unwrap();
        }
        return new CodeWithScope(code, scope);
    }
}

