/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.util.Collection;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.internal.SchematicDelta;
import org.infinispan.schematic.internal.SchematicEntryDelta;
import org.infinispan.schematic.internal.delta.DocumentObserver;
import org.infinispan.schematic.internal.document.AbstractExternalizerTest;
import org.infinispan.schematic.internal.document.BasicArray;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.schematic.internal.document.DefaultDocumentValueFactory;
import org.infinispan.schematic.internal.document.DocumentValueFactory;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.schematic.internal.document.ObservableDocumentEditor;
import org.infinispan.schematic.internal.document.Paths;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OperationExternalizerTest
extends AbstractExternalizerTest {
    private String key;
    private SchematicDelta delta;
    private ObservableDocumentEditor docEditor;
    private MutableDocument doc;
    private DocumentValueFactory valueFactory = new DefaultDocumentValueFactory();
    private boolean print;

    @Before
    public void beforeEach() {
        this.key = "doc1";
        this.doc = new BasicDocument();
        this.delta = new SchematicEntryDelta(this.key);
        this.docEditor = new ObservableDocumentEditor(this.doc, Paths.rootPath(), (DocumentObserver)this.delta, this.valueFactory);
        this.print = false;
    }

    protected void resetEditor() {
        this.delta = new SchematicEntryDelta(this.key);
        this.docEditor = new ObservableDocumentEditor(this.doc, Paths.rootPath(), (DocumentObserver)this.delta, this.valueFactory);
    }

    protected Collection<?> values(Object ... values) {
        HashSet<Object> result = new HashSet<Object>();
        for (Object value : values) {
            result.add(value);
        }
        return result;
    }

    @Test
    public void shouldRoundTripSettingStringValue() throws Exception {
        this.docEditor.setString("foo", "value");
        this.assertOperationsAreMarshallable();
    }

    @Test
    public void shouldRoundTripSettingDocumentValue() throws Exception {
        this.docEditor.setDocument("foo").setString("nested", "value");
        this.assertOperationsAreMarshallable();
    }

    @Test
    public void shouldRoundTripRemovingDocumentField() throws Exception {
        this.docEditor.setDocument("foo").setString("nested", "value").setNumber("nested2", 13);
        this.assertOperationsAreMarshallable();
        this.docEditor.getDocument("foo").remove("nested");
        this.docEditor.getDocument("foo").remove("non-existant");
        this.assertOperationsAreMarshallable();
    }

    @Test
    public void shouldRoundTripSettingArray() throws Exception {
        this.docEditor.setArray("foo", (Array)new BasicArray(new Object[]{"value1", "value2"}));
        this.assertOperationsAreMarshallable();
    }

    @Test
    public void shouldRoundTripAddingValueToArray() throws Exception {
        this.docEditor.setArray("foo", (Array)new BasicArray(new Object[]{"value1", "value2"}));
        this.docEditor.getArray("foo").addNumber(3L);
        this.assertOperationsAreMarshallable();
        Assert.assertThat((Object)this.doc.getArray("foo").size(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldRoundTripAddingValueMultipleTimesToArray() throws Exception {
        this.docEditor.setArray("foo", (Array)new BasicArray(new Object[]{"value1", "value2"}));
        this.docEditor.getArray("foo").addNumber(3L).addNumber(3L).addNumber(5L).addNumber(3L);
        this.assertOperationsAreMarshallable();
        Assert.assertThat((Object)this.doc.getArray("foo").size(), (Matcher)Is.is((Object)6));
    }

    @Test
    public void shouldRoundTripAddingValueToArrayIfValueAbsent() throws Exception {
        this.docEditor.setArray("foo", (Array)new BasicArray(new Object[]{"value1", "value2"}));
        this.docEditor.getArray("foo").addNumber(3L).addNumberIfAbsent(3L).addNumberIfAbsent(5L);
        this.assertOperationsAreMarshallable();
        Assert.assertThat((Object)this.doc.getArray("foo").size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldRoundTripRetainingValuesInArray() throws Exception {
        this.docEditor.setArray("foo", (Array)new BasicArray(new Object[]{"value1", "value2", "value3", 4}));
        this.assertOperationsAreMarshallable();
        Assert.assertThat((Object)this.doc.getArray("foo").size(), (Matcher)Is.is((Object)4));
        this.docEditor.getArray("foo").retainAll(this.values("value1", 4));
        this.assertOperationsAreMarshallable();
        Assert.assertThat((Object)this.doc.getArray("foo").size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(this.doc.getArray("foo").get(0), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat(this.doc.getArray("foo").get(1), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldRoundTripClearingArray() throws Exception {
        this.docEditor.setArray("foo", (Array)new BasicArray(new Object[]{"value1", "value2"}));
        this.docEditor.getArray("foo").addNumber(3L).addNumberIfAbsent(3L).addNumberIfAbsent(5L);
        this.assertOperationsAreMarshallable();
        Assert.assertThat((Object)this.doc.getArray("foo").size(), (Matcher)Is.is((Object)4));
        this.docEditor.getArray("foo").clear();
        this.assertOperationsAreMarshallable();
    }

    @Test
    public void shouldRoundTripSettingArrayUsingArrayEditor() throws Exception {
        this.docEditor.setArray("foo").addString("value1").addString("value2");
        this.assertOperationsAreMarshallable();
    }

    protected void assertOperationsAreMarshallable() throws Exception {
        if (this.print) {
            System.out.println("delta: " + this.delta);
        }
        byte[] bytes = this.marshall(this.delta);
        SchematicDelta newDelta = (SchematicDelta)this.unmarshall(bytes);
        Assert.assertThat((Object)newDelta, (Matcher)Is.is((Object)this.delta));
        if (this.print) {
            System.out.println("document: " + this.doc);
        }
        this.resetEditor();
    }
}

