/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.DocumentSequence;
import org.infinispan.schematic.document.Immutable;
import org.infinispan.schematic.document.Json;
import org.infinispan.schematic.document.NotThreadSafe;
import org.infinispan.schematic.document.Null;
import org.infinispan.schematic.document.ParsingException;
import org.infinispan.schematic.document.ThreadSafe;
import org.infinispan.schematic.internal.document.BasicArray;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.schematic.internal.document.DefaultDocumentValueFactory;
import org.infinispan.schematic.internal.document.DocumentValueFactory;
import org.infinispan.util.Base64;

@ThreadSafe
@Immutable
public class JsonReader {
    protected static final DocumentValueFactory VALUE_FACTORY = new DefaultDocumentValueFactory();
    protected static final ValueMatcher SIMPLE_VALUE_MATCHER = new SimpleValueMatcher(VALUE_FACTORY);
    protected static final ValueMatcher DATE_VALUE_MATCHER = new DateValueMatcher(VALUE_FACTORY);
    public static final boolean DEFAULT_INTROSPECT = true;

    public Document read(URL url) throws ParsingException {
        try {
            return this.read(url.openStream(), true);
        }
        catch (IOException e) {
            throw new ParsingException(e.getMessage(), (Throwable)e, 0, 0);
        }
    }

    public Document read(InputStream stream) throws ParsingException {
        return this.read(stream, true);
    }

    public Document read(InputStream stream, Charset charset) throws ParsingException {
        return this.read(stream, charset, true);
    }

    public Document read(Reader reader) throws ParsingException {
        return this.read(reader, true);
    }

    public Document read(String json) throws ParsingException {
        return this.read(json, true);
    }

    public Document read(InputStream stream, boolean introspectStringValues) throws ParsingException {
        return this.read(stream, Json.UTF8, introspectStringValues);
    }

    public Document read(InputStream stream, Charset charset, boolean introspectStringValues) throws ParsingException {
        return this.read(new InputStreamReader(stream, charset), introspectStringValues);
    }

    public Document read(Reader reader, boolean introspectStringValues) throws ParsingException {
        ValueMatcher matcher = introspectStringValues ? DATE_VALUE_MATCHER : SIMPLE_VALUE_MATCHER;
        return new Parser(new Tokenizer(reader), VALUE_FACTORY, matcher).parseDocument();
    }

    public Document read(String json, boolean introspectStringValues) throws ParsingException {
        return this.read(new StringReader(json), introspectStringValues);
    }

    public DocumentSequence readMultiple(InputStream stream) {
        return this.readMultiple(stream, true);
    }

    public DocumentSequence readMultiple(InputStream stream, boolean introspectStringValues) {
        return this.readMultiple(new InputStreamReader(stream, Json.UTF8), introspectStringValues);
    }

    public DocumentSequence readMultiple(Reader reader) {
        return this.readMultiple(reader, true);
    }

    public DocumentSequence readMultiple(Reader reader, boolean introspectStringValues) {
        final Tokenizer tokenizer = new Tokenizer(reader);
        ValueMatcher matcher = introspectStringValues ? DATE_VALUE_MATCHER : SIMPLE_VALUE_MATCHER;
        final Parser parser = new Parser(tokenizer, VALUE_FACTORY, matcher);
        return new DocumentSequence(){

            @Override
            public Document nextDocument() throws ParsingException {
                if (tokenizer.isFinished()) {
                    return null;
                }
                Document doc = parser.parseDocument(false);
                return doc;
            }
        };
    }

    public static Number parseNumber(String value) {
        char c = value.charAt(0);
        if (c >= '0' && c <= '9' || c == '.' || c == '-' || c == '+') {
            char two;
            if (c == '0' && value.length() > 2 && ((two = value.charAt(1)) == 'x' || two == 'X')) {
                try {
                    int integer = Integer.parseInt(value.substring(2), 16);
                    return new Integer(integer);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            try {
                int intValue;
                if (value.indexOf(46) > -1 || value.indexOf(69) > -1 || value.indexOf(101) > -1) {
                    return Double.parseDouble(value);
                }
                Long longObj = new Long(value);
                long longValue = longObj;
                if (longValue == (long)(intValue = longObj.intValue())) {
                    return new Integer(intValue);
                }
                return longObj;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotThreadSafe
    public static class Tokenizer {
        private final Reader reader;
        private int lineNumber;
        private int columnNumber;
        private boolean finished;
        private boolean hasPrevious;
        private char previous;
        private StringBuilder stringBuilder = new StringBuilder(128);

        public Tokenizer(Reader reader) {
            this.reader = reader;
        }

        public boolean isFinished() {
            return this.finished;
        }

        protected char next() throws ParsingException {
            char c = '\u0000';
            if (this.hasPrevious) {
                this.hasPrevious = false;
                c = this.previous;
            } else {
                try {
                    int x = this.reader.read();
                    if (x <= 0) {
                        this.finished = true;
                        c = '\u0000';
                    } else {
                        c = (char)x;
                    }
                }
                catch (IOException e) {
                    throw this.error("Error reading at line " + this.lineNumber + ", column " + this.columnNumber + ": " + e.getLocalizedMessage(), e);
                }
            }
            if (this.previous == '\r') {
                ++this.lineNumber;
                this.columnNumber = c == '\n' ? 0 : 1;
            } else if (c == '\n') {
                ++this.lineNumber;
                this.columnNumber = 0;
            } else {
                ++this.columnNumber;
            }
            this.previous = c;
            return c;
        }

        public String next(int characterCount) throws ParsingException {
            StringBuilder sb = this.stringBuilder();
            for (int i = 0; i != characterCount; ++i) {
                sb.append(this.next());
            }
            return this.complete(sb);
        }

        protected final StringBuilder stringBuilder() {
            StringBuilder stringBuilder = this.stringBuilder != null ? this.stringBuilder : new StringBuilder(128);
            this.stringBuilder = null;
            stringBuilder.delete(0, stringBuilder.length());
            return stringBuilder;
        }

        protected final String complete(StringBuilder sb) {
            assert (sb != null);
            assert (this.stringBuilder == null);
            this.stringBuilder = sb;
            return sb.toString();
        }

        public char nextUsefulChar() throws ParsingException {
            char next;
            while ((next = this.next()) != '\u0000' && (next == ' ' || next == '\t' || next == '\n' || next == '\r')) {
            }
            return next;
        }

        public char peek() throws ParsingException {
            if (this.hasPrevious) {
                return this.previous;
            }
            char next = this.nextUsefulChar();
            this.hasPrevious = true;
            this.previous = next;
            --this.columnNumber;
            return next;
        }

        public String nextString() throws ParsingException {
            char c = this.nextUsefulChar();
            switch (c) {
                case '\"': 
                case '\'': {
                    return this.nextString(c);
                }
            }
            throw this.error("Expecting a field name at line " + this.lineNumber + ", column " + this.columnNumber + ". Check for a missing comma.");
        }

        public String nextString(char endQuote) throws ParsingException {
            StringBuilder sb = this.stringBuilder();
            char c = '\u0000';
            block15: while (true) {
                c = this.next();
                switch (c) {
                    case '\u0000': 
                    case '\n': 
                    case '\r': {
                        throw this.error("The string was not terminated before the end of line or end of document, at line " + this.lineNumber + ", column " + this.columnNumber);
                    }
                    case '\\': {
                        c = this.next();
                        switch (c) {
                            case '\"': 
                            case '\'': 
                            case '/': 
                            case '\\': {
                                break;
                            }
                            case 'b': {
                                c = '\b';
                                break;
                            }
                            case 'f': {
                                c = '\f';
                                break;
                            }
                            case 'n': {
                                c = '\n';
                                break;
                            }
                            case 'r': {
                                c = '\r';
                                break;
                            }
                            case 't': {
                                c = '\t';
                                break;
                            }
                            case 'u': {
                                char[] hex = new char[]{this.next(), this.next(), this.next(), this.next()};
                                String code = new String(hex, 0, 4);
                                try {
                                    c = (char)Integer.parseInt(code, 16);
                                    break;
                                }
                                catch (NumberFormatException e) {
                                    sb.append('\\').append('u').append(code);
                                    continue block15;
                                }
                            }
                            default: {
                                sb.append('\\');
                            }
                        }
                        sb.append(c);
                        continue block15;
                    }
                }
                if (c == endQuote) {
                    return this.complete(sb);
                }
                sb.append(c);
            }
        }

        public void nextFieldDelim() throws ParsingException {
            try {
                switch (this.nextUsefulChar()) {
                    case ':': 
                    case '=': {
                        if (this.peek() != '>') break;
                        this.next();
                    }
                }
            }
            catch (ParsingException e) {
                throw this.error("Expecting a field delimiter (either ':', '=' or '=>') at line " + this.lineNumber + ", column " + this.columnNumber);
            }
        }

        public boolean nextDocumentDelim() throws ParsingException {
            switch (this.nextUsefulChar()) {
                case ',': 
                case ';': {
                    switch (this.peek()) {
                        case ',': 
                        case ':': {
                            return this.nextDocumentDelim();
                        }
                        case '}': {
                            this.next();
                            return true;
                        }
                    }
                    return false;
                }
                case '}': {
                    return true;
                }
            }
            return false;
        }

        public String nextNumber() throws ParsingException {
            char c = this.peek();
            if (c == '\u0000') {
                return null;
            }
            StringBuilder sb = this.stringBuilder();
            while (c > ' ' && "{}[]:\"=#/\\',;".indexOf(c) <= -1 && c != '\u0000') {
                sb.append(this.next());
                c = this.peek();
            }
            return this.complete(sb);
        }

        public String nextWord() throws ParsingException {
            char c = this.peek();
            StringBuilder sb = this.stringBuilder();
            while (Character.isLetterOrDigit(c)) {
                sb.append(this.next());
                c = this.peek();
            }
            return this.complete(sb);
        }

        public ParsingException error(String message) {
            return new ParsingException(message, this.lineNumber, this.columnNumber);
        }

        public ParsingException error(String message, Throwable t) {
            return new ParsingException(message, t, this.lineNumber, this.columnNumber);
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        public int columnNumber() {
            return this.columnNumber;
        }
    }

    @NotThreadSafe
    public static class DateValueMatcher
    extends SimpleValueMatcher {
        public DateValueMatcher(DocumentValueFactory values) {
            super(values);
        }

        @Override
        public Object parseValue(String value) {
            if (value != null) {
                Date date;
                if (value.length() > 2 && (date = this.parseDateFromLiteral(value)) != null) {
                    return date;
                }
                value = this.unescapeValue(value);
            }
            return value;
        }

        protected String unescapeValue(String value) {
            if (value == null || value.length() == 0) {
                return value;
            }
            StringBuilder sb = new StringBuilder(value.length());
            StringCharacterIterator iter = new StringCharacterIterator(value);
            char c = iter.first();
            while (c != '\uffff') {
                block1 : switch (c) {
                    case '\\': {
                        char next = iter.next();
                        switch (next) {
                            case '\uffff': {
                                sb.append(c);
                                break block1;
                            }
                            case '\b': 
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case '/': 
                            case '\\': {
                                sb.append(next);
                                break block1;
                            }
                            case 'u': {
                                char first = iter.next();
                                char second = iter.next();
                                char third = iter.next();
                                char fourth = iter.next();
                                String string = "" + first + second + third + fourth;
                                try {
                                    char uni = (char)Integer.parseInt(string, 16);
                                    sb.append(uni);
                                }
                                catch (NumberFormatException e) {
                                    sb.append("\\u").append(string);
                                }
                                break block1;
                            }
                        }
                        sb.append(c);
                        sb.append(next);
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                c = iter.next();
            }
            return sb.toString();
        }

        protected Date parseDateFromLiteral(String value) {
            char f = value.charAt(0);
            if (Character.isDigit(f)) {
                return this.evaluateDate(value);
            }
            if (value.startsWith("\\/Date(") && value.endsWith(")\\/")) {
                String millisOrIso = value.substring(7, value.length() - 3).trim();
                return this.evaluateDate(millisOrIso);
            }
            if (value.startsWith("/Date(") && value.endsWith(")/")) {
                String millisOrIso = value.substring(6, value.length() - 2).trim();
                return this.evaluateDate(millisOrIso);
            }
            return null;
        }

        protected Date evaluateDate(String millisOrIso) {
            try {
                return this.values.createDate(millisOrIso);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    @NotThreadSafe
    public static class SimpleValueMatcher
    implements ValueMatcher {
        protected final DocumentValueFactory values;

        public SimpleValueMatcher(DocumentValueFactory values) {
            this.values = values;
        }

        @Override
        public Object parseValue(String value) {
            return value;
        }
    }

    @NotThreadSafe
    public static interface ValueMatcher {
        public Object parseValue(String var1);
    }

    @NotThreadSafe
    public static class Parser {
        private final DocumentValueFactory values;
        private final Tokenizer tokens;
        private final ValueMatcher valueMatcher;

        public Parser(Tokenizer tokenizer, DocumentValueFactory values, ValueMatcher valueMatcher) {
            this.tokens = tokenizer;
            this.values = values;
            this.valueMatcher = valueMatcher;
        }

        public Document parseDocument() throws ParsingException {
            return this.parseDocument(null, true);
        }

        public Document parseDocument(boolean failIfNotValidDocument) throws ParsingException {
            return this.parseDocument(null, failIfNotValidDocument);
        }

        protected BasicDocument newDocument() {
            return new BasicDocument();
        }

        protected Document parseDocument(AtomicBoolean hasReservedFieldNames, boolean failIfNotValidDocument) throws ParsingException {
            if (this.tokens.nextUsefulChar() != '{') {
                if (failIfNotValidDocument) {
                    throw this.tokens.error("JSON documents must begin with a '{' character");
                }
                return null;
            }
            BasicDocument doc = this.newDocument();
            do {
                String fieldName = null;
                switch (this.tokens.peek()) {
                    case '\u0000': {
                        throw this.tokens.error("JSON documents must end with a '}' character");
                    }
                    case '}': {
                        this.tokens.next();
                        return doc;
                    }
                }
                fieldName = this.tokens.nextString();
                this.tokens.nextFieldDelim();
                Object value = this.parseValue();
                doc.put(fieldName, value);
                if (hasReservedFieldNames == null || !this.isReservedFieldName(fieldName)) continue;
                hasReservedFieldNames.set(true);
            } while (!this.tokens.nextDocumentDelim());
            return doc;
        }

        protected final boolean isReservedFieldName(String fieldName) {
            return fieldName.length() != 0 && fieldName.charAt(0) == '$';
        }

        public BasicArray parseArray() throws ParsingException {
            if (this.tokens.nextUsefulChar() != '[') {
                throw this.tokens.error("JSON arrays must begin with a '[' character");
            }
            BasicArray array = new BasicArray();
            block5: while (true) {
                char c = this.tokens.peek();
                switch (c) {
                    case '\u0000': {
                        throw this.tokens.error("JSON arrays must end with a ']' character");
                    }
                    case ']': {
                        this.tokens.next();
                        return array;
                    }
                    case ',': {
                        this.tokens.next();
                        continue block5;
                    }
                }
                Object value = this.parseValue();
                array.addValue(value);
            }
        }

        public Object parseValue() throws ParsingException {
            char c = this.tokens.peek();
            switch (c) {
                case '\u0000': {
                    return null;
                }
                case '{': {
                    AtomicBoolean hasReservedFieldNames = new AtomicBoolean();
                    Document doc = this.parseDocument(hasReservedFieldNames, true);
                    if (!hasReservedFieldNames.get()) {
                        return doc;
                    }
                    return this.processDocumentWithReservedFieldNames(doc);
                }
                case '[': {
                    return this.parseArray();
                }
                case '\"': 
                case '\'': {
                    String literal = this.tokens.nextString();
                    Object value = this.valueMatcher.parseValue(literal);
                    return value != null ? value : literal;
                }
                case 'd': 
                case 'n': {
                    String newToken = this.tokens.nextWord();
                    if (!"new".equalsIgnoreCase(newToken) && !"date".equalsIgnoreCase(newToken)) break;
                    return this.parseFunction();
                }
            }
            String number = this.tokens.nextNumber();
            return number != null ? this.parseValue(number, this.tokens.lineNumber(), this.tokens.columnNumber()) : number;
        }

        public Object parseValue(String value, int lineNumber, int columnNumber) throws ParsingException {
            if (value.length() == 0) {
                return value;
            }
            if ("true".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            if ("null".equalsIgnoreCase(value)) {
                return Null.getInstance();
            }
            Number number = this.parseNumber(value);
            if (number != null) {
                return number;
            }
            return this.parseUnknownValue(value, lineNumber, columnNumber);
        }

        protected Number parseNumber(String value) {
            return JsonReader.parseNumber(value);
        }

        protected Object parseUnknownValue(String value, int lineNumber, int columnNumber) throws ParsingException {
            return value;
        }

        public Object parseFunction() throws ParsingException {
            int line = this.tokens.lineNumber();
            int col = this.tokens.columnNumber();
            String functionName = this.tokens.nextString();
            FunctionCall function = new FunctionCall(functionName, line, col);
            char c = this.tokens.nextUsefulChar();
            if (c != '(') {
                throw this.tokens.error("Expected '(' after function name \"" + functionName + "\" and at line " + this.tokens.lineNumber() + ", column " + this.tokens.columnNumber());
            }
            while (true) {
                line = this.tokens.lineNumber();
                col = this.tokens.columnNumber();
                Object parameter = this.parseValue();
                if (parameter == null) break;
                function.add(parameter, line, col);
            }
            Object value = this.evaluateFunction(function);
            return value != null ? value : this.evaluateUnknownFunction(function);
        }

        public Object evaluateFunction(FunctionCall function) throws ParsingException {
            int numParams = function.size();
            if ("date".equalsIgnoreCase(function.getFunctionName())) {
                if (numParams > 0) {
                    FunctionParameter param1 = function.get(0);
                    Object value = param1.getValue();
                    if (value instanceof Long) {
                        Long millis = (Long)value;
                        return this.values.createDate(millis);
                    }
                    if (value instanceof Integer) {
                        Integer millis = (Integer)value;
                        return this.values.createDate(millis.longValue());
                    }
                    if (value instanceof String) {
                        String valueStr = (String)value;
                        try {
                            return this.values.createDate(valueStr);
                        }
                        catch (ParseException e) {
                            throw this.tokens.error("Expecting the \"new Date(...)\" parameter to be a valid number of milliseconds or ISO date string, but found \"" + param1.getValue() + "\" at line " + param1.getLineNumber() + ", column " + param1.getColumnNumber());
                        }
                    }
                }
                throw this.tokens.error("The date function requires one parameter at line " + function.getLineNumber() + ", column " + function.getColumnNumber());
            }
            return null;
        }

        protected Object evaluateUnknownFunction(FunctionCall function) throws ParsingException {
            return function.toString();
        }

        protected Object processDocumentWithReservedFieldNames(Document doc) {
            if (doc == null) {
                return null;
            }
            Object value = null;
            int numFields = doc.size();
            if (numFields == 0) {
                return doc;
            }
            try {
                if (numFields == 1) {
                    value = doc.get("$oid");
                    if (!Null.matches(value)) {
                        String bytesInBase16 = value.toString();
                        return this.values.createObjectId(bytesInBase16);
                    }
                    value = doc.get("$date");
                    if (!Null.matches(value)) {
                        if (value instanceof Date) {
                            return value;
                        }
                        String isoDate = value.toString();
                        try {
                            return this.values.createDate(isoDate);
                        }
                        catch (ParseException e) {
                            Long millis = Long.parseLong(isoDate);
                            return this.values.createDate(millis);
                        }
                    }
                    value = doc.get("$regex");
                    if (!Null.matches(value)) {
                        String pattern = value.toString();
                        return this.values.createRegex(pattern, null);
                    }
                    value = doc.get("$uuid");
                    if (!Null.matches(value)) {
                        return this.values.createUuid(value.toString());
                    }
                    value = doc.get("$code");
                    if (!Null.matches(value)) {
                        String code = value.toString();
                        return this.values.createCode(code);
                    }
                } else if (numFields == 2) {
                    value = doc.get("$ts");
                    if (!Null.matches(value)) {
                        int time = doc.getInteger("$ts");
                        int inc = doc.getInteger("$inc");
                        return this.values.createTimestamp(time, inc);
                    }
                    value = doc.get("$regex");
                    if (!Null.matches(value)) {
                        String pattern = value.toString();
                        String options = doc.getString("$options");
                        return this.values.createRegex(pattern, options);
                    }
                    value = doc.get("$code");
                    if (!Null.matches(value)) {
                        String code = value.toString();
                        Document scope = doc.getDocument("$scope");
                        return scope != null ? this.values.createCode(code, scope) : this.values.createCode(code);
                    }
                    value = doc.get("$type");
                    if (!Null.matches(value)) {
                        char c = value.toString().charAt(0);
                        byte type = 0;
                        switch (c) {
                            case '0': {
                                type = 0;
                                break;
                            }
                            case '1': {
                                type = 1;
                                break;
                            }
                            case '2': {
                                type = 2;
                                break;
                            }
                            case '3': {
                                type = 3;
                                break;
                            }
                            case '5': {
                                type = 5;
                                break;
                            }
                            case '8': {
                                c = value.toString().charAt(1);
                                if (c != '0') break;
                                type = -128;
                            }
                        }
                        String data = doc.getString("$base64");
                        return this.values.createBinary(type, Base64.decode((String)data));
                    }
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            return doc;
        }

        @Immutable
        protected static class FunctionParameter {
            private final Object value;
            private final int lineNumber;
            private final int columnNumber;

            public FunctionParameter(Object value, int lineNumber, int columnNumber) {
                this.value = value;
                this.lineNumber = lineNumber;
                this.columnNumber = columnNumber;
            }

            public Object getValue() {
                return this.value;
            }

            public int getLineNumber() {
                return this.lineNumber;
            }

            public int getColumnNumber() {
                return this.columnNumber;
            }

            public String toString() {
                return Json.write(this.value);
            }
        }

        protected static class FunctionCall
        implements Iterable<FunctionParameter> {
            private final String functionName;
            private final List<FunctionParameter> parameters = new LinkedList<FunctionParameter>();
            private final int lineNumber;
            private final int columnNumber;

            public FunctionCall(String functionName, int lineNumber, int columnNumber) {
                this.functionName = functionName;
                this.lineNumber = lineNumber;
                this.columnNumber = columnNumber;
            }

            public String getFunctionName() {
                return this.functionName;
            }

            public void add(Object parameter, int lineNumber, int columnNumber) {
                this.parameters.add(new FunctionParameter(parameter, lineNumber, columnNumber));
            }

            @Override
            public Iterator<FunctionParameter> iterator() {
                return this.parameters.iterator();
            }

            public FunctionParameter get(int index) {
                return this.parameters.get(index);
            }

            public int size() {
                return this.parameters.size();
            }

            public int getLineNumber() {
                return this.lineNumber;
            }

            public int getColumnNumber() {
                return this.columnNumber;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder(this.functionName);
                sb.append('(');
                boolean first = true;
                for (FunctionParameter parameter : this.parameters) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(parameter.getValue());
                }
                sb.append(')');
                return sb.toString();
            }
        }
    }
}

