/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import java.io.InputStream;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.schematic.SchemaValidationTest;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.TestUtil;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.internal.CacheSchematicDb;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CacheSchematicDbTest {
    private CacheSchematicDb db;
    private AdvancedCache<String, SchematicEntry> cache;
    private EmbeddedCacheManager cm;

    @Before
    public void beforeTest() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.invocationBatching().enable().transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        this.cm = new DefaultCacheManager(configurationBuilder.build());
        this.cache = (AdvancedCache)this.cm.getCache("documents");
        this.db = new CacheSchematicDb(this.cache);
    }

    @After
    public void afterTest() {
        TestUtil.killCacheContainers(new CacheContainer[]{this.cm});
        this.cache = null;
        this.db = null;
    }

    protected static InputStream resource(String resourcePath) {
        InputStream result = SchemaValidationTest.class.getClassLoader().getResourceAsStream(resourcePath);
        assert (result != null) : "Could not find resource \"" + resourcePath + "\"";
        return result;
    }

    @Test
    public void shouldStoreDocumentWithUnusedKeyAndWithNullMetadata() {
        BasicDocument doc = new BasicDocument();
        doc.put((Object)"k1", (Object)"value1");
        doc.put((Object)"k2", (Object)2);
        String key = "can be anything";
        this.db.put(key, (Document)doc);
        SchematicEntry entry = this.db.get(key);
        assert (entry != null) : "Should have found the entry";
        Document read = entry.getContent();
        assert (read != null);
        assert ("value1".equals(read.getString("k1")));
        assert (2 == read.getInteger("k2"));
    }
}

