/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.document;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Code;
import org.infinispan.schematic.document.CodeWithScope;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.MaxKey;
import org.infinispan.schematic.document.MinKey;
import org.infinispan.schematic.document.Null;
import org.infinispan.schematic.document.ObjectId;
import org.infinispan.schematic.document.Symbol;
import org.infinispan.schematic.document.Timestamp;
import org.infinispan.schematic.internal.document.BsonReader;
import org.infinispan.schematic.internal.document.BsonWriter;

public class Bson {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final ThreadLocal<SoftReference<DateFormat>> dateFormatter = new ThreadLocal();
    protected static final String DATE_FORMAT_FOR_PARSING = "yyyy-MM-dd'T'HH:mm:ssz";
    private static final ThreadLocal<SoftReference<DateFormat>> dateFormatterForParsing = new ThreadLocal();
    public static final byte END_OF_DOCUMENT = 0;
    public static final byte END_OF_STRING = 0;
    private static final BsonWriter SHARED_WRITER = new BsonWriter();
    private static final BsonReader SHARED_READER = new BsonReader();

    public static DateFormat getDateFormatter() {
        DateFormat formatter;
        SoftReference<DateFormat> ref = dateFormatter.get();
        DateFormat dateFormat = formatter = ref != null ? ref.get() : null;
        if (formatter == null) {
            formatter = new SimpleDateFormat(DATE_FORMAT);
            formatter.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
            dateFormatter.set(new SoftReference<DateFormat>(formatter));
        }
        return formatter;
    }

    public static DateFormat getDateParsingFormatter() {
        DateFormat formatter;
        SoftReference<DateFormat> ref = dateFormatterForParsing.get();
        DateFormat dateFormat = formatter = ref != null ? ref.get() : null;
        if (formatter == null) {
            formatter = new SimpleDateFormat(DATE_FORMAT_FOR_PARSING);
            formatter.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
            dateFormatterForParsing.set(new SoftReference<DateFormat>(formatter));
        }
        return formatter;
    }

    protected static BsonWriter getBsonWriter() {
        return SHARED_WRITER;
    }

    public static void write(Document bson, OutputStream stream) throws IOException {
        Bson.getBsonWriter().write((Object)bson, stream);
    }

    public static void write(Document bson, ObjectOutput output) throws IOException {
        Bson.getBsonWriter().write((Object)bson, output);
    }

    public static byte[] write(Object object) throws IOException {
        return Bson.getBsonWriter().write(object);
    }

    protected static BsonReader getReader() {
        return SHARED_READER;
    }

    public static Document read(InputStream stream) throws IOException {
        return SHARED_READER.read(stream);
    }

    public static Document read(DataInput input) throws IOException {
        return SHARED_READER.read(input);
    }

    public static int getTypeForValue(Object value) {
        if (value == null) {
            return 10;
        }
        if (value instanceof String) {
            return 2;
        }
        if (value instanceof Symbol) {
            return 14;
        }
        if (value instanceof Integer) {
            return 16;
        }
        if (value instanceof Long) {
            return 18;
        }
        if (value instanceof Double) {
            return 1;
        }
        if (value instanceof List) {
            return 4;
        }
        if (value instanceof Document) {
            return 3;
        }
        if (value instanceof Boolean) {
            return 8;
        }
        if (value instanceof Binary) {
            return 5;
        }
        if (value instanceof ObjectId) {
            return 7;
        }
        if (value instanceof Date) {
            return 9;
        }
        if (value instanceof Null) {
            return 10;
        }
        if (value instanceof Pattern) {
            return 11;
        }
        if (value instanceof Symbol) {
            return 12;
        }
        if (value instanceof Code) {
            return 13;
        }
        if (value instanceof CodeWithScope) {
            return 15;
        }
        if (value instanceof Timestamp) {
            return 17;
        }
        if (value instanceof MinKey) {
            return -1;
        }
        if (value instanceof MaxKey) {
            return 127;
        }
        return 6;
    }

    public static final class BinaryType {
        public static final byte GENERAL = 0;
        public static final byte FUNCTION = 1;
        @Deprecated
        public static final byte BINARY = 2;
        public static final byte UUID = 3;
        public static final byte MD5 = 5;
        public static final byte USER_DEFINED = -128;
    }

    public static final class Type {
        public static final byte DOUBLE = 1;
        public static final byte STRING = 2;
        public static final byte DOCUMENT = 3;
        public static final byte ARRAY = 4;
        public static final byte BINARY = 5;
        public static final byte UNDEFINED = 6;
        public static final byte OBJECTID = 7;
        public static final byte BOOLEAN = 8;
        public static final byte DATETIME = 9;
        public static final byte NULL = 10;
        public static final byte REGEX = 11;
        public static final byte DBPOINTER = 12;
        public static final byte JAVASCRIPT = 13;
        public static final byte SYMBOL = 14;
        public static final byte JAVASCRIPT_WITH_SCOPE = 15;
        public static final byte INT32 = 16;
        public static final byte TIMESTAMP = 17;
        public static final byte INT64 = 18;
        public static final byte MINKEY = -1;
        public static final byte MAXKEY = 127;
    }
}

