/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.delta;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.HashCode;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.ArrayOperation;
import org.infinispan.schematic.internal.document.MutableArray;
import org.infinispan.schematic.internal.document.MutableDocument;

@SerializeWith(value=Externalizer.class)
public class RetainAllValuesOperation
extends ArrayOperation {
    protected final Collection<?> values;
    protected transient List<Array.Entry> removedEntries;

    public RetainAllValuesOperation(Path parentPath, Collection<?> values) {
        super(parentPath, HashCode.compute(parentPath, values));
        this.values = values;
    }

    @Override
    public RetainAllValuesOperation clone() {
        return new RetainAllValuesOperation(this.getParentPath(), this.cloneValues(this.values));
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.removedEntries != null) {
            MutableArray array = this.mutableParent(delegate);
            for (Array.Entry entry : this.removedEntries) {
                array.add(entry.getIndex(), entry.getValue());
            }
        }
    }

    public Collection<?> getRetainedValues() {
        return this.values;
    }

    public List<Array.Entry> getRemovedEntries() {
        return this.removedEntries;
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        this.removedEntries = array.retainAllValues(this.values);
    }

    public String toString() {
        return "Retain at '" + this.parentPath + "' the values: " + this.values;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RetainAllValuesOperation) {
            RetainAllValuesOperation other = (RetainAllValuesOperation)obj;
            return this.equalsIfNotNull(this.values, other.values) && this.equalsIfNotNull(this.getParentPath(), other.getParentPath());
        }
        return false;
    }

    public static final class Externalizer
    extends SchematicExternalizer<RetainAllValuesOperation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, RetainAllValuesOperation put) throws IOException {
            output.writeObject(put.parentPath);
            output.writeObject(put.values);
        }

        public RetainAllValuesOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Path path = (Path)input.readObject();
            Collection values = (Collection)input.readObject();
            return new RetainAllValuesOperation(path, values);
        }

        @Override
        public Integer getId() {
            return 1611;
        }

        @Override
        public Set<Class<? extends RetainAllValuesOperation>> getTypeClasses() {
            return Collections.singleton(RetainAllValuesOperation.class);
        }
    }
}

