/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.document;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.Test;
import org.modeshape.schematic.internal.document.BasicArray;
import org.modeshape.schematic.internal.document.BasicDocument;
import org.modeshape.schematic.internal.document.CompactJsonWriterTest;
import org.modeshape.schematic.internal.document.PrettyJsonWriter;

public class PrettyJsonWriterTest
extends CompactJsonWriterTest {
    @Override
    @Test
    public void shouldCorrectlyWriteSimpleBsonObject() {
        this.writer = new PrettyJsonWriter();
        BasicDocument top = new BasicDocument();
        top.put((Object)"firstName", (Object)"Jack");
        top.put((Object)"lastName", (Object)"Riley");
        top.put((Object)"age", (Object)31);
        String actual = this.writer.write((Object)top);
        String expected = "{\n  \"firstName\" : \"Jack\",\n  \"lastName\" : \"Riley\",\n  \"age\" : 31\n}";
        this.assertSame(expected, actual);
    }

    @Override
    @Test
    public void shouldCorrectlyWriteSimpleBsonObjectWithNullValue() {
        this.writer = new PrettyJsonWriter();
        BasicDocument top = new BasicDocument();
        top.put((Object)"firstName", (Object)"Jack");
        top.put((Object)"lastName", null);
        top.put((Object)"age", (Object)31);
        String actual = this.writer.write((Object)top);
        String expected = "{\n  \"firstName\" : \"Jack\",\n  \"lastName\" : null,\n  \"age\" : 31\n}";
        this.assertSame(expected, actual);
    }

    @Override
    @Test
    public void shouldCorrectlyWriteBsonObjectWithNestedObjectValue() {
        this.writer = new PrettyJsonWriter();
        BasicDocument address = new BasicDocument();
        address.put((Object)"street", (Object)"100 Main St.");
        address.put((Object)"city", (Object)"Springfield");
        BasicDocument top = new BasicDocument();
        top.put((Object)"firstName", (Object)"Jack");
        top.put((Object)"lastName", (Object)"Riley");
        top.put((Object)"address", (Object)address);
        String actual = this.writer.write((Object)top);
        String expected = "{\n  \"firstName\" : \"Jack\",\n  \"lastName\" : \"Riley\",\n  \"address\" : {\n    \"street\" : \"100 Main St.\",\n    \"city\" : \"Springfield\"\n  }\n}";
        this.assertSame(expected, actual);
    }

    @Test
    public void shouldCorrectlyWriteDocumentToStream() throws IOException {
        this.writer = new PrettyJsonWriter();
        BasicDocument address = new BasicDocument();
        address.put((Object)"street", (Object)"100 Main St.");
        address.put((Object)"city", (Object)"Springfield");
        BasicDocument top = new BasicDocument();
        top.put((Object)"firstName", (Object)"Jack");
        top.put((Object)"lastName", (Object)"Riley");
        top.put((Object)"address", (Object)address);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writer.write((Object)top, (OutputStream)baos);
        String actual = baos.toString();
        String expected = "{\n  \"firstName\" : \"Jack\",\n  \"lastName\" : \"Riley\",\n  \"address\" : {\n    \"street\" : \"100 Main St.\",\n    \"city\" : \"Springfield\"\n  }\n}";
        this.assertSame(expected, actual);
    }

    @Test
    public void shouldCorrectlyWriteBsonObjectWithNestedArrayValue() {
        this.writer = new PrettyJsonWriter();
        BasicArray emails = new BasicArray();
        emails.put("0", (Object)"jriley@example.com");
        emails.put("1", (Object)"jriley@foobar.com");
        BasicDocument top = new BasicDocument();
        top.put((Object)"firstName", (Object)"Jack");
        top.put((Object)"lastName", (Object)"Riley");
        top.put((Object)"emails", (Object)emails);
        String actual = this.writer.write((Object)top);
        String expected = "{\n  \"firstName\" : \"Jack\",\n  \"lastName\" : \"Riley\",\n  \"emails\" : [\n    \"jriley@example.com\",\n    \"jriley@foobar.com\"\n  ]\n}";
        this.assertSame(expected, actual);
    }

    @Override
    @Test
    public void shouldCorrectlyWriteListValue() {
        this.writer = new PrettyJsonWriter();
        this.testWritingList("[ ]", new Object[0]);
        this.testWritingList("[\n  \"value1\"\n]", "value1");
        this.testWritingList("[\n  \"value1\",\n  null,\n  \"value3\"\n]", "value1", null, "value3");
        this.testWritingList("[\n  \"value1\",\n  \"value2\",\n  \"value3\"\n]", "value1", "value2", "value3");
        this.testWritingList("[\n  \"value1\",\n  \"value2\",\n  4\n]", "value1", "value2", 4L);
    }
}

