/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.schema;

import java.io.InputStream;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.schematic.DocumentLibrary;
import org.modeshape.schematic.SchemaLibrary;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.Json;
import org.modeshape.schematic.internal.InMemoryDocumentLibrary;
import org.modeshape.schematic.internal.document.Paths;
import org.modeshape.schematic.internal.schema.Problems;
import org.modeshape.schematic.internal.schema.SchemaDocument;
import org.modeshape.schematic.internal.schema.SchemaDocumentCache;
import org.modeshape.schematic.internal.schema.ValidationResult;
import org.modeshape.schematic.internal.schema.Validator;

public class SchemaValidationTest {
    private static DocumentLibrary docs;
    private SchemaDocumentCache schemaDocs;
    private SchemaLibrary.Results results;

    @BeforeClass
    public static void beforeAll() throws Exception {
        docs = new InMemoryDocumentLibrary("tests");
        docs.put("http://json-schema.org/draft-03/schema#", Json.read((InputStream)SchemaValidationTest.resource("json/schema/draft-03/schema.json")));
        docs.put("json/spec-example-doc.json", Json.read((InputStream)SchemaValidationTest.resource("json/spec-example-doc.json")));
        docs.put("json/schema/spec-example.json", Json.read((InputStream)SchemaValidationTest.resource("json/schema/spec-example.json")));
        docs.put("json/sample-repo-config.json", Json.read((InputStream)SchemaValidationTest.resource("json/sample-repo-config.json")));
        docs.put("json/empty.json", Json.read((InputStream)SchemaValidationTest.resource("json/empty.json")));
        docs.put("json/schema/repository-config-schema.json", Json.read((InputStream)SchemaValidationTest.resource("json/schema/repository-config-schema.json")));
        docs.put("json/schema/enum-example.json", Json.read((InputStream)SchemaValidationTest.resource("json/schema/enum-example.json")));
        docs.put("json/enum-example-doc.json", Json.read((InputStream)SchemaValidationTest.resource("json/enum-example-doc.json")));
    }

    protected static InputStream resource(String resourcePath) {
        InputStream result = SchemaValidationTest.class.getClassLoader().getResourceAsStream(resourcePath);
        assert (result != null) : "Could not find resource \"" + resourcePath + "\"";
        return result;
    }

    @Before
    public void beforeEach() {
        this.schemaDocs = new SchemaDocumentCache(docs, null);
    }

    protected void assertNoProblems(SchemaLibrary.Results results) {
        if (results.hasProblems()) {
            System.out.println(results);
            assert (false);
        }
    }

    protected SchemaLibrary.Results validate(String documentUri, String schemaUri) {
        Document doc = docs.get(documentUri);
        ValidationResult problems = new ValidationResult();
        SchemaDocument schema = this.schemaDocs.get(schemaUri, (Problems)problems);
        if (schema != null) {
            schema.getValidator().validate(null, null, doc, Paths.rootPath(), (Problems)problems, (Validator.SchemaDocumentResolver)this.schemaDocs);
        }
        return problems;
    }

    @Test
    public void shouldBeAbleToValidateDocumentUsingSimpleSchemaDocument() throws Exception {
        this.results = this.validate("json/spec-example-doc.json", "json/schema/spec-example.json");
        this.assertNoProblems(this.results);
    }

    @Test
    public void shouldBeAbleToValidateSampleDocumentUsingSchemaDocument() throws Exception {
        this.results = this.validate("json/sample-repo-config.json", "json/schema/repository-config-schema.json");
        this.assertNoProblems(this.results);
    }

    @Test
    public void shouldBeAbleToValidateDocumentUsingCaseInsensitiveEnums() throws Exception {
        this.results = this.validate("json/enum-example-doc.json", "json/schema/enum-example.json");
        this.assertNoProblems(this.results);
    }

    @Test
    public void shouldNotBeAbleToValidateEmptyDocumentUsingSchemaDocument() throws Exception {
        this.results = this.validate("json/empty.json", "json/schema/repository-config-schema.json");
        assert (this.results.errorCount() == 1);
    }
}

