/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.delta;

import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.HashCode;
import org.modeshape.schematic.internal.delta.Operation;
import org.modeshape.schematic.internal.document.MutableDocument;

public class PutIfAbsentOperation
extends Operation {
    protected final String fieldName;
    protected final Object newValue;
    private transient boolean absent = false;

    public PutIfAbsentOperation(Path parentPath, String fieldName, Object newValue) {
        super(parentPath, HashCode.compute(parentPath, fieldName, newValue));
        this.fieldName = fieldName;
        this.newValue = newValue;
    }

    @Override
    public PutIfAbsentOperation clone() {
        return new PutIfAbsentOperation(this.getParentPath(), this.fieldName, this.cloneValue(this.newValue));
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isApplied() {
        return this.absent;
    }

    @Override
    public void rollback(MutableDocument delegate) {
        MutableDocument parent = this.mutableParent(delegate);
        assert (parent != null);
        if (this.absent) {
            parent.remove(this.fieldName);
        }
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableDocument parent = this.mutableParent(delegate);
        assert (parent != null);
        if (!parent.containsField(this.fieldName)) {
            parent.put(this.fieldName, this.newValue);
            this.absent = true;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PutIfAbsentOperation) {
            PutIfAbsentOperation other = (PutIfAbsentOperation)obj;
            return this.equalsIfNotNull(this.fieldName, other.fieldName) && this.absent == other.absent && this.equalsIfNotNull(this.newValue, other.newValue) && this.getParentPath().equals(other.getParentPath());
        }
        return false;
    }

    public String toString() {
        return "Put-if-absent at '" + this.parentPath + "' the '" + this.fieldName + "' field value '" + this.newValue + "'";
    }
}

