/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.delta;

import java.util.Collection;
import java.util.List;
import org.modeshape.schematic.document.Array;
import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.HashCode;
import org.modeshape.schematic.internal.delta.ArrayOperation;
import org.modeshape.schematic.internal.document.MutableArray;
import org.modeshape.schematic.internal.document.MutableDocument;

public class RetainAllValuesOperation
extends ArrayOperation {
    protected final Collection<?> values;
    protected transient List<Array.Entry> removedEntries;

    public RetainAllValuesOperation(Path parentPath, Collection<?> values) {
        super(parentPath, HashCode.compute(parentPath, values));
        this.values = values;
    }

    @Override
    public RetainAllValuesOperation clone() {
        return new RetainAllValuesOperation(this.getParentPath(), this.cloneValues(this.values));
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.removedEntries != null) {
            MutableArray array = this.mutableParent(delegate);
            for (Array.Entry entry : this.removedEntries) {
                array.add(entry.getIndex(), entry.getValue());
            }
        }
    }

    public Collection<?> getRetainedValues() {
        return this.values;
    }

    public List<Array.Entry> getRemovedEntries() {
        return this.removedEntries;
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        this.removedEntries = array.retainAllValues(this.values);
    }

    public String toString() {
        return "Retain at '" + this.parentPath + "' the values: " + this.values;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RetainAllValuesOperation) {
            RetainAllValuesOperation other = (RetainAllValuesOperation)obj;
            return this.equalsIfNotNull(this.values, other.values) && this.equalsIfNotNull(this.getParentPath(), other.getParentPath());
        }
        return false;
    }
}

