/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.delta;

import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.HashCode;
import org.modeshape.schematic.internal.delta.ArrayOperation;
import org.modeshape.schematic.internal.document.MutableArray;
import org.modeshape.schematic.internal.document.MutableDocument;

public class SetValueOperation
extends ArrayOperation {
    protected final Object value;
    protected final int index;
    protected transient Object oldValue;

    public SetValueOperation(Path parentPath, Object value, int index) {
        super(parentPath, HashCode.compute(parentPath, value, index));
        this.value = value;
        this.index = index;
    }

    @Override
    public SetValueOperation clone() {
        return new SetValueOperation(this.getParentPath(), this.cloneValue(this.value), this.index);
    }

    @Override
    public void rollback(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        if (this.oldValue != null) {
            array.set(this.index, this.oldValue);
        } else {
            array.remove(this.index);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        this.oldValue = array.setValue(this.index, this.value);
    }

    public String toString() {
        return "Set at '" + this.parentPath + "' the value '" + this.value + "' (at index " + this.index + ")";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SetValueOperation) {
            SetValueOperation other = (SetValueOperation)obj;
            return this.equalsIfNotNull(this.value, other.value) && this.index == other.index && this.equalsIfNotNull(this.getParentPath(), other.getParentPath());
        }
        return false;
    }
}

