/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.document;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.modeshape.schematic.document.Array;
import org.modeshape.schematic.document.Changes;
import org.modeshape.schematic.document.Editor;
import org.modeshape.schematic.internal.delta.AddValueIfAbsentOperation;
import org.modeshape.schematic.internal.delta.AddValueOperation;
import org.modeshape.schematic.internal.delta.ClearOperation;
import org.modeshape.schematic.internal.delta.Operation;
import org.modeshape.schematic.internal.delta.PutIfAbsentOperation;
import org.modeshape.schematic.internal.delta.PutOperation;
import org.modeshape.schematic.internal.delta.RemoveAllValuesOperation;
import org.modeshape.schematic.internal.delta.RemoveAtIndexOperation;
import org.modeshape.schematic.internal.delta.RemoveOperation;
import org.modeshape.schematic.internal.delta.RemoveValueOperation;
import org.modeshape.schematic.internal.delta.RetainAllValuesOperation;
import org.modeshape.schematic.internal.delta.SetValueOperation;
import org.modeshape.schematic.internal.document.BasicArray;
import org.modeshape.schematic.internal.document.MutableDocument;
import org.modeshape.schematic.internal.document.ObservableDocumentEditor;
import org.modeshape.schematic.internal.document.Paths;

public class IncrementalDocumentEditor
extends ObservableDocumentEditor
implements Editor {
    private static final long serialVersionUID = 1L;
    private final transient List<Operation> operations;

    public IncrementalDocumentEditor(MutableDocument document, List<Operation> operations) {
        super(document, Paths.rootPath(), operations::add, null);
        this.operations = operations;
    }

    @Override
    public Changes getChanges() {
        return new DocumentChanges(this.operations != null ? this.operations : Collections.emptyList());
    }

    @Override
    public void apply(Changes changes) {
        this.apply(changes.clone(), null);
    }

    private static Array.Entry newEntry(int index, Object value) {
        return new BasicArray.BasicEntry(index, value);
    }

    @Override
    public void apply(Changes changes, Editor.Observer observer) {
        if (changes.isEmpty()) {
            return;
        }
        MutableDocument mutable = this.asMutableDocument();
        for (Operation operation : (DocumentChanges)changes) {
            Operation op;
            operation.replay(mutable);
            if (observer == null) continue;
            if (operation instanceof SetValueOperation) {
                op = (SetValueOperation)operation;
                observer.setArrayValue(op.getParentPath(), IncrementalDocumentEditor.newEntry(((SetValueOperation)op).getIndex(), ((SetValueOperation)op).getValue()));
                continue;
            }
            if (operation instanceof AddValueOperation) {
                op = (AddValueOperation)operation;
                if (((AddValueOperation)op).getActualIndex() == -1) continue;
                observer.addArrayValue(op.getParentPath(), IncrementalDocumentEditor.newEntry(((AddValueOperation)op).getActualIndex(), ((AddValueOperation)op).getValue()));
                continue;
            }
            if (operation instanceof AddValueIfAbsentOperation) {
                op = (AddValueIfAbsentOperation)operation;
                if (!((AddValueIfAbsentOperation)op).isAdded()) continue;
                observer.addArrayValue(op.getParentPath(), IncrementalDocumentEditor.newEntry(((AddValueOperation)op).getIndex(), ((AddValueOperation)op).getValue()));
                continue;
            }
            if (operation instanceof RemoveValueOperation) {
                op = (RemoveValueOperation)operation;
                if (((RemoveValueOperation)op).getActualIndex() == -1) continue;
                observer.removeArrayValue(op.getParentPath(), IncrementalDocumentEditor.newEntry(((RemoveValueOperation)op).getActualIndex(), ((RemoveValueOperation)op).getRemovedValue()));
                continue;
            }
            if (operation instanceof RemoveAtIndexOperation) {
                op = (RemoveAtIndexOperation)operation;
                observer.removeArrayValue(op.getParentPath(), IncrementalDocumentEditor.newEntry(((RemoveAtIndexOperation)op).getIndex(), ((RemoveAtIndexOperation)op).getRemovedValue()));
                continue;
            }
            if (operation instanceof RetainAllValuesOperation) {
                op = (RetainAllValuesOperation)operation;
                for (Array.Entry entry : ((RetainAllValuesOperation)op).getRemovedEntries()) {
                    observer.removeArrayValue(op.getParentPath(), entry);
                }
                continue;
            }
            if (operation instanceof RemoveAllValuesOperation) {
                op = (RemoveAllValuesOperation)operation;
                for (Array.Entry entry : ((RemoveAllValuesOperation)op).getRemovedEntries()) {
                    observer.removeArrayValue(op.getParentPath(), entry);
                }
                continue;
            }
            if (operation instanceof ClearOperation) {
                op = (ClearOperation)operation;
                observer.clear(op.getParentPath());
                continue;
            }
            if (operation instanceof PutOperation) {
                op = (PutOperation)operation;
                observer.put(op.getParentPath(), ((PutOperation)op).getFieldName(), ((PutOperation)op).getNewValue());
                continue;
            }
            if (operation instanceof PutIfAbsentOperation) {
                op = (PutIfAbsentOperation)operation;
                if (!((PutIfAbsentOperation)op).isApplied()) continue;
                observer.put(op.getParentPath(), ((PutIfAbsentOperation)op).getFieldName(), ((PutIfAbsentOperation)op).getNewValue());
                continue;
            }
            if (!(operation instanceof RemoveOperation) || !((RemoveOperation)(op = (RemoveOperation)operation)).isRemoved()) continue;
            observer.remove(op.getParentPath(), ((RemoveOperation)op).getFieldName());
        }
    }

    protected static class DocumentChanges
    implements Changes,
    Iterable<Operation> {
        private final List<Operation> operations;

        protected DocumentChanges(List<Operation> operations) {
            this.operations = operations;
        }

        @Override
        public DocumentChanges clone() {
            List<Operation> newOps = this.operations.stream().map(Operation::clone).collect(Collectors.toList());
            return new DocumentChanges(newOps);
        }

        @Override
        public Iterator<Operation> iterator() {
            return this.operations.iterator();
        }

        @Override
        public boolean isEmpty() {
            return this.operations.isEmpty();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<Operation> iter = this.operations.iterator();
            if (iter.hasNext()) {
                sb.append(iter.next());
                while (iter.hasNext()) {
                    sb.append("\n").append(iter.next());
                }
            }
            return sb.toString();
        }
    }
}

