/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.document;

import java.util.Map;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableArray;
import org.modeshape.schematic.document.EditableDocument;
import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.delta.DocumentObserver;
import org.modeshape.schematic.internal.delta.PutIfAbsentOperation;
import org.modeshape.schematic.internal.delta.PutOperation;
import org.modeshape.schematic.internal.delta.RemoveOperation;
import org.modeshape.schematic.internal.document.BasicDocument;
import org.modeshape.schematic.internal.document.DocumentEditor;
import org.modeshape.schematic.internal.document.DocumentValueFactory;
import org.modeshape.schematic.internal.document.MutableArray;
import org.modeshape.schematic.internal.document.MutableDocument;
import org.modeshape.schematic.internal.document.ObservableArrayEditor;

public class ObservableDocumentEditor
extends DocumentEditor {
    private static final long serialVersionUID = 1L;
    private final transient Path path;
    private final transient DocumentObserver observer;

    public ObservableDocumentEditor(MutableDocument document, Path path, DocumentObserver observer, DocumentValueFactory factory) {
        super(document, factory);
        this.path = path;
        this.observer = observer;
    }

    @Override
    protected Object doSetValue(String name, Object newValue) {
        Object oldValue = super.doSetValue(name, newValue);
        this.observer.addOperation(new PutOperation(this.path, name, this.copy(oldValue), this.copy(newValue)));
        return oldValue;
    }

    @Override
    protected Object doSetValueIfAbsent(String name, Object value) {
        Object oldValue = super.doSetValue(name, value);
        this.observer.addOperation(new PutIfAbsentOperation(this.path, name, this.copy(value)));
        return oldValue;
    }

    @Override
    protected void doSetAllValues(Document values) {
        if (values != null && !values.isEmpty()) {
            for (Document.Field field : values.fields()) {
                this.doSetValue(field.getName(), field.getValue());
            }
        }
    }

    @Override
    protected void doSetAllValues(Map<? extends String, ?> values) {
        if (values != null && !values.isEmpty()) {
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                this.doSetValue(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Object remove(String name) {
        Object oldValue = super.remove(name);
        this.observer.addOperation(new RemoveOperation(this.path, name, this.copy(oldValue)));
        return oldValue;
    }

    protected Object copy(Object value) {
        if (value instanceof MutableArray) {
            return ((MutableArray)value).clone();
        }
        if (value instanceof MutableDocument) {
            return ((MutableDocument)value).clone();
        }
        return value;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.observer.addOperation(new PutOperation(this.path.parent(), this.path.getLast(), this.copy(this.unwrap()), new BasicDocument()));
    }

    @Override
    protected EditableDocument createEditableDocument(MutableDocument document, String fieldName, DocumentValueFactory factory) {
        return new ObservableDocumentEditor(document, this.path.with(fieldName), this.observer, factory);
    }

    @Override
    protected EditableArray createEditableArray(MutableArray array, String fieldName, DocumentValueFactory factory) {
        return new ObservableArrayEditor(array, this.path.with(fieldName), this.observer, factory);
    }
}

