/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.mp3;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.mp3.Mp3Metadata;

public class Mp3MetadataSequencer
extends Sequencer {
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.registerNodeTypes("mp3.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(new String[]{"audio/mpeg"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        try {
            Mp3Metadata metadata = null;
            InputStream stream = binaryValue.getStream();
            try {
                metadata = Mp3Metadata.instance(stream);
            }
            finally {
                stream.close();
            }
            Node sequencedNode = outputNode;
            if (outputNode.isNew()) {
                outputNode.setPrimaryType("mp3:metadata");
            } else {
                sequencedNode = outputNode.addNode("mp3:metadata", "mp3:metadata");
            }
            sequencedNode.setProperty("mp3:title", metadata.getTitle());
            sequencedNode.setProperty("mp3:author", metadata.getAuthor());
            sequencedNode.setProperty("mp3:album", metadata.getAlbum());
            sequencedNode.setProperty("mp3:year", metadata.getYear());
            sequencedNode.setProperty("mp3:comment", metadata.getComment());
            return true;
        }
        catch (Exception e) {
            this.getLogger().error((Throwable)e, "Cannot sequence mp3 content ", new Object[0]);
            return false;
        }
    }

    public static final class MimeTypeConstants {
        public static final String MP3 = "audio/mpeg";
    }
}

