/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.ValueFactory;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.msoffice.MSOfficeMetadata;
import org.modeshape.sequencer.msoffice.excel.ExcelMetadata;
import org.modeshape.sequencer.msoffice.excel.ExcelMetadataReader;
import org.modeshape.sequencer.msoffice.excel.ExcelSheetMetadata;
import org.modeshape.sequencer.msoffice.powerpoint.PowerPointMetadataReader;
import org.modeshape.sequencer.msoffice.powerpoint.PowerpointMetadata;
import org.modeshape.sequencer.msoffice.powerpoint.SlideMetadata;
import org.modeshape.sequencer.msoffice.word.WordMetadata;
import org.modeshape.sequencer.msoffice.word.WordMetadataReader;

public class MSOfficeMetadataSequencer
extends Sequencer {
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        this.registerNodeTypes("msoffice.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(new String[]{"application/vnd.ms-excel", "application/vnd.ms-powerpoint", "application/vnd.ms-word", "application/msword"});
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = (Binary)inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        String inputFileName = this.getInputFileName(inputProperty);
        String mimeType = binaryValue.getMimeType(inputFileName);
        Node sequencedNode = outputNode;
        if (outputNode.isNew()) {
            outputNode.setPrimaryType("msoffice:metadata");
        } else {
            sequencedNode = outputNode.addNode("msoffice:metadata", "msoffice:metadata");
        }
        sequencedNode.setProperty("jcr:mimeType", mimeType);
        if (this.isPowerpoint(mimeType)) {
            this.sequencePowerpoint(sequencedNode, context.valueFactory(), binaryValue.getStream());
            return true;
        }
        if (this.isWord(mimeType)) {
            this.sequenceWord(sequencedNode, context.valueFactory(), binaryValue.getStream());
            return true;
        }
        if (this.isExcel(mimeType)) {
            this.sequenceExcel(sequencedNode, context.valueFactory(), binaryValue.getStream());
            return true;
        }
        this.getLogger().warn("Unknown mimetype: {0} for microsoft office", new Object[]{mimeType});
        return false;
    }

    private String getInputFileName(Property inputProperty) throws RepositoryException {
        return inputProperty.getParent().getParent().getName();
    }

    private boolean isExcel(String mimeType) {
        return "application/vnd.ms-excel".equalsIgnoreCase(mimeType);
    }

    private void sequenceExcel(Node sequencedNode, ValueFactory valueFactory, InputStream stream) throws IOException, RepositoryException {
        ExcelMetadata excelMetadata = ExcelMetadataReader.instance(stream);
        this.recordMetadata(sequencedNode, valueFactory, excelMetadata.getMetadata());
        sequencedNode.setProperty("msoffice:full_content", excelMetadata.getText());
        for (ExcelSheetMetadata sheetMetadata : excelMetadata.getSheets()) {
            Node sheet = sequencedNode.addNode("msoffice:sheet", "msoffice:xlssheet");
            sheet.setProperty("msoffice:sheet_name", sheetMetadata.getName());
            sheet.setProperty("msoffice:text", sheetMetadata.getText());
        }
    }

    private boolean isWord(String mimeType) {
        return "application/vnd.ms-word".equalsIgnoreCase(mimeType) || "application/msword".equalsIgnoreCase(mimeType);
    }

    private void sequenceWord(Node rootNode, ValueFactory valueFactory, InputStream stream) throws RepositoryException, IOException {
        WordMetadata wordMetadata = WordMetadataReader.instance(stream);
        this.recordMetadata(rootNode, valueFactory, wordMetadata.getMetadata());
        for (WordMetadata.WordHeading headingMetadata : wordMetadata.getHeadings()) {
            Node heading = rootNode.addNode("msoffice:heading", "msoffice:heading");
            heading.setProperty("msoffice:heading_name", headingMetadata.getText());
            heading.setProperty("msoffice:heading_level", (long)headingMetadata.getHeaderLevel());
        }
    }

    private boolean isPowerpoint(String mimeType) {
        return "application/vnd.ms-powerpoint".equalsIgnoreCase(mimeType);
    }

    private void sequencePowerpoint(Node rootNode, ValueFactory valueFactory, InputStream stream) throws IOException, RepositoryException {
        PowerpointMetadata deck = PowerPointMetadataReader.instance(stream);
        this.recordMetadata(rootNode, valueFactory, deck.getMetadata());
        for (SlideMetadata slideMetadata : deck.getSlides()) {
            Node slide = rootNode.addNode("msoffice:slide", "msoffice:pptslide");
            slide.setProperty("msoffice:title", slideMetadata.getTitle());
            slide.setProperty("msoffice:text", slideMetadata.getText());
            slide.setProperty("msoffice:notes", slideMetadata.getNotes());
            slide.setProperty("msoffice:thumbnail", (javax.jcr.Binary)valueFactory.createBinary(slideMetadata.getThumbnail()));
        }
    }

    private void recordMetadata(Node rootNode, ValueFactory valueFactory, MSOfficeMetadata metadata) throws RepositoryException {
        rootNode.setProperty("msoffice:title", metadata.getTitle());
        rootNode.setProperty("msoffice:subject", metadata.getSubject());
        rootNode.setProperty("msoffice:author", metadata.getAuthor());
        rootNode.setProperty("msoffice:keywords", metadata.getKeywords());
        rootNode.setProperty("msoffice:comment", metadata.getComment());
        rootNode.setProperty("msoffice:template", metadata.getTemplate());
        rootNode.setProperty("msoffice:saved", valueFactory.createValue(metadata.getLastSaved()));
        rootNode.setProperty("msoffice:revision", metadata.getRevision());
        rootNode.setProperty("msoffice:total_editing_time", metadata.getTotalEditingTime().longValue());
        rootNode.setProperty("msoffice:last_printed", valueFactory.createValue(metadata.getLastPrinted()));
        rootNode.setProperty("msoffice:created", valueFactory.createValue(metadata.getCreated()));
        rootNode.setProperty("msoffice:pages", (long)metadata.getPages());
        rootNode.setProperty("msoffice:words", (long)metadata.getWords());
        rootNode.setProperty("msoffice:characters", (long)metadata.getCharacters());
        rootNode.setProperty("msoffice:creating_application", metadata.getCreatingApplication());
        byte[] thumbnail = metadata.getThumbnail();
        if (thumbnail != null) {
            rootNode.setProperty("msoffice:thumbnail", (javax.jcr.Binary)valueFactory.createBinary(thumbnail));
        }
    }

    public static final class MimeTypeConstants {
        public static final String MICROSOFT_APPLICATION_MS_WORD = "application/msword";
        public static final String MICROSOFT_WORD = "application/vnd.ms-word";
        public static final String MICROSOFT_EXCEL = "application/vnd.ms-excel";
        public static final String MICROSOFT_POWERPOINT = "application/vnd.ms-powerpoint";
    }
}

