/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.ValueFactory;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.msoffice.MSOfficeMetadata;
import org.modeshape.sequencer.msoffice.excel.ExcelMetadata;
import org.modeshape.sequencer.msoffice.excel.ExcelMetadataReader;
import org.modeshape.sequencer.msoffice.excel.ExcelSheetMetadata;
import org.modeshape.sequencer.msoffice.powerpoint.PowerPointMetadataReader;
import org.modeshape.sequencer.msoffice.powerpoint.PowerpointMetadata;
import org.modeshape.sequencer.msoffice.powerpoint.SlideMetadata;
import org.modeshape.sequencer.msoffice.word.WordMetadata;
import org.modeshape.sequencer.msoffice.word.WordMetadataReader;

public class MSOfficeMetadataSequencer
extends Sequencer {
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        this.registerNodeTypes("msoffice.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(new String[]{"application/vnd.ms-excel", "application/vnd.ms-powerpoint", "application/vnd.ms-word", "application/msword"});
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = (Binary)inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        String inputFileName = this.getInputFileName(inputProperty);
        String mimeType = binaryValue.getMimeType(inputFileName);
        Node sequencedNode = outputNode;
        if (outputNode.isNew()) {
            outputNode.setPrimaryType("msoffice:metadata");
        } else {
            sequencedNode = outputNode.addNode("msoffice:metadata", "msoffice:metadata");
        }
        this.setProperty(sequencedNode, "jcr:mimeType", mimeType);
        if (this.isPowerpoint(mimeType)) {
            try (InputStream stream = binaryValue.getStream();){
                this.sequencePowerpoint(sequencedNode, context.valueFactory(), stream);
                boolean bl = true;
                return bl;
            }
        }
        if (this.isWord(mimeType)) {
            try (InputStream stream = binaryValue.getStream();){
                this.sequenceWord(sequencedNode, context.valueFactory(), stream);
                boolean bl = true;
                return bl;
            }
        }
        if (this.isExcel(mimeType)) {
            try (InputStream stream = binaryValue.getStream();){
                this.sequenceExcel(sequencedNode, context.valueFactory(), stream);
                boolean bl = true;
                return bl;
            }
        }
        this.getLogger().warn("Unknown mimetype: {0} for microsoft office", new Object[]{mimeType});
        return false;
    }

    private String getInputFileName(Property inputProperty) throws RepositoryException {
        return inputProperty.getParent().getParent().getName();
    }

    private boolean isExcel(String mimeType) {
        return "application/vnd.ms-excel".equalsIgnoreCase(mimeType);
    }

    private void sequenceExcel(Node sequencedNode, ValueFactory valueFactory, InputStream stream) throws IOException, RepositoryException {
        ExcelMetadata excelMetadata = ExcelMetadataReader.instance(stream);
        this.recordMetadata(sequencedNode, valueFactory, excelMetadata.getMetadata());
        this.setProperty(sequencedNode, "msoffice:full_content", excelMetadata.getText());
        for (ExcelSheetMetadata sheetMetadata : excelMetadata.getSheets()) {
            Node sheet = sequencedNode.addNode("msoffice:sheet", "msoffice:xlssheet");
            this.setProperty(sheet, "msoffice:sheet_name", sheetMetadata.getName());
            this.setProperty(sheet, "msoffice:text", sheetMetadata.getText());
        }
    }

    private boolean isWord(String mimeType) {
        return "application/vnd.ms-word".equalsIgnoreCase(mimeType) || "application/msword".equalsIgnoreCase(mimeType);
    }

    private void sequenceWord(Node rootNode, ValueFactory valueFactory, InputStream stream) throws RepositoryException, IOException {
        WordMetadata wordMetadata = WordMetadataReader.instance(stream);
        this.recordMetadata(rootNode, valueFactory, wordMetadata.getMetadata());
        for (WordMetadata.WordHeading headingMetadata : wordMetadata.getHeadings()) {
            Node heading = rootNode.addNode("msoffice:heading", "msoffice:heading");
            this.setProperty(heading, "msoffice:heading_name", headingMetadata.getText());
            this.setProperty(heading, "msoffice:heading_level", headingMetadata.getHeaderLevel());
        }
    }

    private boolean isPowerpoint(String mimeType) {
        return "application/vnd.ms-powerpoint".equalsIgnoreCase(mimeType);
    }

    private void sequencePowerpoint(Node rootNode, ValueFactory valueFactory, InputStream stream) throws IOException, RepositoryException {
        PowerpointMetadata deck = PowerPointMetadataReader.instance(stream);
        this.recordMetadata(rootNode, valueFactory, deck.getMetadata());
        for (SlideMetadata slideMetadata : deck.getSlides()) {
            Node slide = rootNode.addNode("msoffice:slide", "msoffice:pptslide");
            this.setProperty(slide, "msoffice:title", slideMetadata.getTitle());
            this.setProperty(slide, "msoffice:text", slideMetadata.getText());
            this.setProperty(slide, "msoffice:notes", slideMetadata.getNotes());
            this.setProperty(slide, "msoffice:thumbnail", valueFactory.createBinary(slideMetadata.getThumbnail()));
        }
    }

    private void recordMetadata(Node rootNode, ValueFactory valueFactory, MSOfficeMetadata metadata) throws RepositoryException {
        this.setProperty(rootNode, "msoffice:title", metadata.getTitle());
        this.setProperty(rootNode, "msoffice:subject", metadata.getSubject());
        this.setProperty(rootNode, "msoffice:author", metadata.getAuthor());
        this.setProperty(rootNode, "msoffice:keywords", metadata.getKeywords());
        this.setProperty(rootNode, "msoffice:comment", metadata.getComment());
        this.setProperty(rootNode, "msoffice:template", metadata.getTemplate());
        this.setProperty(rootNode, "msoffice:saved", valueFactory.createValue(metadata.getLastSaved()));
        this.setProperty(rootNode, "msoffice:revision", metadata.getRevision());
        this.setProperty(rootNode, "msoffice:total_editing_time", metadata.getTotalEditingTime());
        this.setProperty(rootNode, "msoffice:last_printed", valueFactory.createValue(metadata.getLastPrinted()));
        this.setProperty(rootNode, "msoffice:created", valueFactory.createValue(metadata.getCreated()));
        this.setProperty(rootNode, "msoffice:pages", metadata.getPages());
        this.setProperty(rootNode, "msoffice:words", metadata.getWords());
        this.setProperty(rootNode, "msoffice:characters", metadata.getCharacters());
        this.setProperty(rootNode, "msoffice:creating_application", metadata.getCreatingApplication());
        this.setProperty(rootNode, "msoffice:thumbnail", valueFactory.createBinary(metadata.getThumbnail()));
    }

    private void setProperty(Node node, String propertyName, String value) throws RepositoryException {
        if (value != null) {
            node.setProperty(propertyName, value);
        }
    }

    private void setProperty(Node node, String propertyName, Value value) throws RepositoryException {
        if (value != null) {
            node.setProperty(propertyName, value);
        }
    }

    private void setProperty(Node node, String propertyName, Binary value) throws RepositoryException {
        if (value != null) {
            node.setProperty(propertyName, (javax.jcr.Binary)value);
        }
    }

    private void setProperty(Node node, String propertyName, Long value) throws RepositoryException {
        if (value != null) {
            node.setProperty(propertyName, value.longValue());
        }
    }

    private void setProperty(Node node, String propertyName, Integer value) throws RepositoryException {
        if (value != null) {
            node.setProperty(propertyName, value.longValue());
        }
    }

    public static final class MimeTypeConstants {
        public static final String MICROSOFT_APPLICATION_MS_WORD = "application/msword";
        public static final String MICROSOFT_WORD = "application/vnd.ms-word";
        public static final String MICROSOFT_EXCEL = "application/vnd.ms-excel";
        public static final String MICROSOFT_POWERPOINT = "application/vnd.ms-powerpoint";
    }
}

