/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice.powerpoint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.modeshape.sequencer.msoffice.powerpoint.PowerpointMetadata;
import org.modeshape.sequencer.msoffice.powerpoint.SlideMetadata;

public class PowerPointMetadataReader {
    public static PowerpointMetadata instance(InputStream stream) throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem(stream);
        HSLFSlideShow rawSlideShow = new HSLFSlideShow((NPOIFSFileSystem)fs);
        List<SlideMetadata> slidesMetadata = rawSlideShow.getSlides().stream().map(slide -> PowerPointMetadataReader.processSlide(rawSlideShow, slide)).collect(Collectors.toList());
        PowerpointMetadata deck = new PowerpointMetadata();
        deck.setSlides(slidesMetadata);
        deck.setMetadata(new HSLFSlideShowImpl(fs).getSummaryInformation());
        return deck;
    }

    private static SlideMetadata processSlide(HSLFSlideShow rawSlideShow, HSLFSlide slide) {
        SlideMetadata slideMetadata = new SlideMetadata();
        String title = slide.getTitle();
        slideMetadata.setTitle(title);
        slideMetadata.setNotes(PowerPointMetadataReader.collectText(slide.getNotes().getTextParagraphs(), title));
        slideMetadata.setText(PowerPointMetadataReader.collectText(slide.getTextParagraphs(), title));
        Dimension pgsize = rawSlideShow.getPageSize();
        BufferedImage img = new BufferedImage(pgsize.width, pgsize.height, 1);
        Graphics2D graphics = img.createGraphics();
        graphics.setPaint(Color.white);
        graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, pgsize.width, pgsize.height));
        slide.draw(graphics);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", out);
            slideMetadata.setThumbnail(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return slideMetadata;
    }

    private static String collectText(List<List<HSLFTextParagraph>> paragraphs, String title) {
        return paragraphs.stream().flatMap(Collection::stream).flatMap(paragraph -> paragraph.getTextRuns().stream()).map(HSLFTextRun::getRawText).filter(rawText -> !title.equals(rawText)).collect(Collectors.joining());
    }
}

