/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.sequencer.teiid.VdbModel;
import org.modeshape.sequencer.teiid.model.ModelObjectHandler;
import org.modeshape.sequencer.teiid.model.ModelReader;
import org.modeshape.sequencer.teiid.model.ReferenceResolver;
import org.modeshape.sequencer.teiid.xmi.XmiElement;

public final class CoreModelObjectHandler
extends ModelObjectHandler {
    private static final String[] IGNORED_MODEL_ANNOTATION_TAG_PREFIXES = new String[]{"connection", "connectionProfile", "translator"};
    private final List<String> meds = new ArrayList<String>();

    private boolean isIgnoredTag(String nsPrefix) throws Exception {
        CheckArg.isNotEmpty((String)nsPrefix, (String)"nsPrefix");
        for (String prefix : IGNORED_MODEL_ANNOTATION_TAG_PREFIXES) {
            if (!prefix.equals(nsPrefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void process(XmiElement element, Node modelNode) throws Exception {
        CheckArg.isNotNull((Object)element, (String)"element");
        CheckArg.isNotNull((Object)modelNode, (String)"node");
        CheckArg.isEquals((Object)element.getNamespaceUri(), (String)"namespace URI", (Object)"http://www.metamatrix.com/metamodels/Core", (String)"relational URI");
        LOGGER.debug("==== CoreModelObjectHandler:process:element={0}", new Object[]{element.getName()});
        String type = element.getName();
        if ("ModelAnnotation".equals(type)) {
            this.setProperty(modelNode, "xmi:uuid", element.getUuid());
            this.getResolver().record(element.getUuid(), modelNode);
            ModelReader reader = this.getReader();
            this.setProperty(modelNode, "mmcore:modelType", reader.getModelType());
            this.setProperty(modelNode, "mmcore:primaryMetamodelUri", reader.getPrimaryMetamodelUri());
            this.setProperty(modelNode, "mmcore:description", reader.getDescription());
            this.setProperty(modelNode, "mmcore:nameInSource", reader.getNameInSource());
            modelNode.setProperty("mmcore:maxSetSize", reader.getMaxSetSize());
            modelNode.setProperty("mmcore:visible", reader.isVisible());
            modelNode.setProperty("mmcore:supportsDistinct", reader.supportsDistinct());
            modelNode.setProperty("mmcore:supportsJoin", reader.supportsJoin());
            modelNode.setProperty("mmcore:supportsOrderBy", reader.supportsOrderBy());
            modelNode.setProperty("mmcore:supportsOuterJoin", reader.supportsOuterJoin());
            modelNode.setProperty("mmcore:supportsWhereAll", reader.supportsWhereAll());
            this.setProperty(modelNode, "mmcore:producerName", reader.getProducerName());
            this.setProperty(modelNode, "mmcore:producerVersion", reader.getProducerVersion());
            this.setProperty(modelNode, "mmcore:originalFile", reader.getPath());
            if (this.getVdbModel() != null) {
                VdbModel vdbModel = this.getVdbModel();
                modelNode.setProperty("vdb:visible", vdbModel.isVisible());
                modelNode.setProperty("vdb:checksum", vdbModel.getChecksum());
                modelNode.setProperty("vdb:builtIn", vdbModel.isBuiltIn());
                this.setProperty(modelNode, "vdb:description", vdbModel.getDescription());
                this.setProperty(modelNode, "vdb:pathInVdb", vdbModel.getPathInVdb());
                this.setProperty(modelNode, "vdb:sourceTranslator", vdbModel.getSourceTranslator());
                this.setProperty(modelNode, "vdb:sourceName", vdbModel.getSourceName());
                this.setProperty(modelNode, "vdb:sourceJndiName", vdbModel.getSourceJndiName());
                for (Map.Entry<String, String> entry : vdbModel.getProperties().entrySet()) {
                    this.setProperty(modelNode, entry.getKey(), entry.getValue());
                }
                if (!vdbModel.getProblems().isEmpty()) {
                    Node markersGroupNode = modelNode.addNode("vdb:markers", "vdb:markers");
                    for (VdbModel.ValidationMarker marker : vdbModel.getProblems()) {
                        Node markerNode = markersGroupNode.addNode("vdb:marker", "vdb:marker");
                        this.setProperty(markerNode, "vdb:path", marker.getPath());
                        this.setProperty(markerNode, "vdb:message", marker.getMessage());
                        this.setProperty(markerNode, "vdb:severity", marker.getSeverity().toString());
                        LOGGER.debug("added validation marker at path {0} and with severity of {1}", new Object[]{marker.getPath(), marker.getSeverity()});
                    }
                }
            }
            block2: for (XmiElement modelImport : reader.getModelImports()) {
                Node importNode = this.addNode(modelNode, modelImport, "http://www.metamatrix.com/metamodels/Core", "mmcore:import");
                this.setProperty(importNode, "mmcore:modelType", modelImport.getAttributeValue("modelType", "http://www.metamatrix.com/metamodels/Core"));
                this.setProperty(importNode, "mmcore:primaryMetamodelUri", modelImport.getAttributeValue("primaryMetamodelUri", "http://www.metamatrix.com/metamodels/Core"));
                this.setProperty(importNode, "mmcore:modelLocation", modelImport.getAttributeValue("modelLocation", "http://www.metamatrix.com/metamodels/Core"));
                if (this.getVdbModel() == null) continue;
                for (String importPath : this.getVdbModel().getImports()) {
                    if (!importPath.endsWith(modelImport.getAttributeValue("modelLocation", "http://www.metamatrix.com/metamodels/Core"))) continue;
                    this.setProperty(importNode, "mmcore:path", importPath);
                    continue block2;
                }
            }
            LOGGER.debug("[end writing model annotation]", new Object[0]);
        } else if ("AnnotationContainer".equals(type)) {
            for (XmiElement annotation : element.getChildren()) {
                String keywordsValue;
                if (!"annotations".equals(annotation.getName())) continue;
                String uuid = annotation.getAttributeValue("annotatedObject", "http://www.metamatrix.com/metamodels/Core");
                if (StringUtil.isBlank((String)uuid)) {
                    for (XmiElement child : annotation.getChildren()) {
                        if (!"annotatedObject".equals(child.getName())) continue;
                        uuid = child.getAttributeValue("href", "http://www.metamatrix.com/metamodels/Core");
                        break;
                    }
                }
                if (StringUtil.isBlank((String)(uuid = this.getResolver().resolveInternalReference(uuid)))) {
                    LOGGER.debug("annotated object UUID is blank", new Object[0]);
                    continue;
                }
                Node node = this.getResolver().getNode(uuid);
                ReferenceResolver.UnresolvedReference unresolved = node == null ? this.getResolver().addUnresolvedReference(uuid) : null;
                String description = annotation.getAttributeValue("description", "http://www.metamatrix.com/metamodels/Core");
                if (!StringUtil.isBlank((String)description)) {
                    if (node != null) {
                        node.addMixin("mmcore:annotated");
                        this.setProperty(node, "mmcore:description", description);
                    } else if (unresolved != null) {
                        unresolved.addMixin("mmcore:annotated");
                        unresolved.addProperty("mmcore:description", description, false);
                    }
                }
                if (!StringUtil.isBlank((String)(keywordsValue = annotation.getAttributeValue("keywords", "http://www.metamatrix.com/metamodels/Core")))) {
                    if (node != null && !node.isNodeType("mmcore:annotated")) {
                        node.addMixin("mmcore:annotated");
                    } else if (unresolved != null) {
                        unresolved.addMixin("mmcore:annotated");
                    }
                    for (String keyword : keywordsValue.split("\\s")) {
                        if (node != null) {
                            this.addPropertyValue(node, "mmcore:keywords", keyword);
                            continue;
                        }
                        if (unresolved == null) continue;
                        unresolved.addProperty("mmcore:keywords", keyword, true);
                    }
                }
                for (XmiElement child : annotation.getChildren()) {
                    boolean hasTags = false;
                    if ("tags".equals(child.getName())) {
                        boolean addProperty = false;
                        String key = child.getAttributeValue("key", "http://www.metamatrix.com/metamodels/Core");
                        if (StringUtil.isBlank((String)key)) continue;
                        String[] parts = key.split(":", 2);
                        if (parts.length == 1) {
                            addProperty = true;
                        } else {
                            String nsPrefix = parts[0];
                            if (!this.isIgnoredTag(nsPrefix) && !this.meds.contains(nsPrefix)) {
                                if ("modelExtensionDefinition".equals(nsPrefix)) {
                                    this.registerMed(parts[1]);
                                } else {
                                    addProperty = true;
                                }
                            }
                        }
                        if (addProperty) {
                            if (!hasTags) {
                                hasTags = true;
                                if (node != null) {
                                    node.addMixin("mmcore:tags");
                                } else if (unresolved != null) {
                                    unresolved.addMixin("mmcore:tags");
                                }
                            }
                            String value = child.getAttributeValue("value", "http://www.metamatrix.com/metamodels/Core");
                            if (node != null) {
                                node.setProperty(key, value);
                                continue;
                            }
                            if (unresolved == null) continue;
                            unresolved.addProperty(key, value, false);
                            continue;
                        }
                        if (node != null) {
                            LOGGER.debug("tag '{0}' not added as property of node '{1}'", new Object[]{key, node.getName()});
                            continue;
                        }
                        if (unresolved == null) continue;
                        LOGGER.debug("tag '{0}' not added as property of node '{1}'", new Object[]{key, unresolved.getUuid()});
                        continue;
                    }
                    LOGGER.debug("Unexpected element processing an annotation: {0}", new Object[]{child.getName()});
                }
            }
        } else {
            LOGGER.debug("**** core type of '{0}' was not processed", new Object[]{type});
        }
    }

    private void registerMed(String medPrefix) {
        assert (medPrefix != null);
        this.meds.add(medPrefix);
        LOGGER.debug("registered MED '{0}'", new Object[]{medPrefix});
    }
}

