/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.model;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.sequencer.teiid.model.ModelObjectHandler;
import org.modeshape.sequencer.teiid.model.ReferenceResolver;
import org.modeshape.sequencer.teiid.xmi.XmiElement;

public final class RelationalModelObjectHandler
extends ModelObjectHandler {
    @Override
    protected void process(XmiElement element, Node parentNode) throws Exception {
        CheckArg.isNotNull((Object)element, (String)"element");
        CheckArg.isNotNull((Object)parentNode, (String)"node");
        CheckArg.isEquals((Object)element.getNamespaceUri(), (String)"namespace URI", (Object)"http://www.metamatrix.com/metamodels/Relational", (String)"relational URI");
        LOGGER.debug("==== RelationalModelObjectHandler:process:element={0}", new Object[]{element.getName()});
        String type = element.getName();
        if ("BaseTable".equals(type)) {
            Node tableNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:baseTable");
            this.processTable(element, tableNode);
        } else if ("accessPatterns".equals(type) || "AccessPattern".equals(type)) {
            Node accessPatternNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:accessPattern");
            this.processAccessPattern(element, accessPatternNode);
        } else if ("Catalog".equals(type)) {
            Node catalogNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:catalog");
            this.processCatalog(element, catalogNode);
        } else if ("indexes".equals(type) || "Index".equals(type)) {
            Node indexNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:index");
            this.processIndex(element, indexNode);
        } else if ("columns".equals(type)) {
            Node columnNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:column");
            this.processColumn(element, columnNode);
        } else if ("foreignKeys".equals(type)) {
            Node foreignKeyNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:foreignKey");
            this.processForeignKey(element, foreignKeyNode);
        } else if ("primaryKey".equals(type)) {
            Node primaryKeyNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:primaryKey");
            this.processUniqueKey(element, primaryKeyNode);
        } else if ("parameters".equals(type)) {
            Node procedureParameterNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:procedureParameter");
            this.processProcedureParameter(element, procedureParameterNode);
        } else if ("result".equals(type)) {
            Node procedureResultNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:procedureResult");
            this.processColumnSet(element, procedureResultNode);
        } else if ("procedures".equals(type) || "Procedure".equals(type)) {
            Node procedureNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:procedure");
            this.processProcedure(element, procedureNode);
        } else if ("schemas".equals(type) || "Schema".equals(type)) {
            Node schemaNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:schema");
            this.processSchema(element, schemaNode);
        } else if ("tables".equals(type)) {
            Node tableNode = null;
            String xsiType = element.getAttributeValue("type", "http://www.w3.org/2001/XMLSchema-instance");
            String[] parts = xsiType.split(":");
            if (parts.length == 2 && "BaseTable".equals(parts[1])) {
                tableNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:baseTable");
                this.processTable(element, tableNode);
            } else if (parts.length == 2 && "View".equals(parts[1])) {
                tableNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:view");
                this.processTable(element, tableNode);
            } else {
                LOGGER.debug("**** relational '{0}' type + of '{1}' was not processed", new Object[]{"tables", xsiType});
            }
        } else if ("type".equals(type)) {
            this.processType(element, parentNode);
        } else if ("uniqueConstraints".equals(type)) {
            Node uniqueConstraintNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:uniqueConstraint");
            this.processUniqueKey(element, uniqueConstraintNode);
        } else if ("view".equals(type)) {
            Node viewNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/Relational", "relational:view");
            this.processTable(element, viewNode);
        } else {
            LOGGER.debug("**** relational type of '{0}' was not processed", new Object[]{type});
        }
    }

    private void processAccessPattern(XmiElement accessPatternElement, Node accessPatternNode) throws Exception {
        this.processRelationalEntity(accessPatternElement, accessPatternNode);
        this.processColumnsAttribute(accessPatternElement, accessPatternNode);
    }

    private void processAccessPatternsAttribute(XmiElement columnElement, Node columnNode) throws Exception {
        String accessPatterns = columnElement.getAttributeValue("columns", "http://www.metamatrix.com/metamodels/Relational");
        if (!StringUtil.isBlank((String)accessPatterns)) {
            ReferenceResolver resolver = this.getResolver();
            ValueFactory valueFactory = columnNode.getSession().getValueFactory();
            for (String accessPatternRef : accessPatterns.split("\\s")) {
                String accessPatternUuid = resolver.resolveInternalReference(accessPatternRef);
                Node accessPatternNode = resolver.getNode(accessPatternUuid);
                ReferenceResolver.UnresolvedReference unresolved = null;
                if (accessPatternNode == null) {
                    unresolved = resolver.addUnresolvedReference(accessPatternUuid);
                    unresolved.addReferencerReference(columnElement.getUuid(), "relational:accessPatterns");
                } else {
                    if (!accessPatternNode.isNodeType("mix:referenceable")) {
                        accessPatternNode.addMixin("mix:referenceable");
                    }
                    Value weakReference = valueFactory.createValue(accessPatternNode, true);
                    this.addPropertyValue(columnNode, "relational:accessPatterns", weakReference);
                }
                this.addPropertyValue(columnNode, "relational:accessPatternHrefs", accessPatternRef);
                this.addPropertyValue(columnNode, "relational:accessPatternXmiUuids", accessPatternUuid);
                if (accessPatternNode != null) {
                    this.addPropertyValue(columnNode, "relational:accessPatternNames", accessPatternNode.getName());
                    continue;
                }
                if (unresolved != null) {
                    unresolved.addResolvedName(columnElement.getUuid(), "relational:accessPatternNames");
                    continue;
                }
                assert (false);
            }
        }
    }

    private void processCatalog(XmiElement catalogElement, Node catalogNode) throws Exception {
        this.processRelationalEntity(catalogElement, catalogNode);
        this.processChildren(catalogElement, catalogNode, new String[0]);
    }

    private void processChildren(XmiElement element, Node parentNode, String ... childTypes) throws Exception {
        List<String> types = null;
        if (childTypes != null) {
            types = Arrays.asList(childTypes);
        }
        for (XmiElement kid : element.getChildren()) {
            if (types == null || types.isEmpty()) {
                this.process(kid, parentNode);
                continue;
            }
            if (!types.contains(kid.getName())) continue;
            this.process(kid, parentNode);
        }
    }

    private void processColumn(XmiElement columnElement, Node columnNode) throws Exception {
        this.processRelationalEntity(columnElement, columnNode);
        this.setProperty(columnNode, "relational:nativeType", columnElement.getAttributeValue("nativeType", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:length", columnElement.getAttributeValue("length", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:fixedLength", columnElement.getAttributeValue("fixedLength", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:precision", columnElement.getAttributeValue("precision", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:scale", columnElement.getAttributeValue("scale", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:nullable", columnElement.getAttributeValue("nullable", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:autoIncremented", columnElement.getAttributeValue("autoIncremented", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:defaultValue", columnElement.getAttributeValue("defaultValue", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:minimumValue", columnElement.getAttributeValue("minimumValue", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:maximumValue", columnElement.getAttributeValue("maximumValue", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:format", columnElement.getAttributeValue("format", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:characterSetName", columnElement.getAttributeValue("characterSetName", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:collationName", columnElement.getAttributeValue("collationName", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:selectable", columnElement.getAttributeValue("selectable", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:updateable", columnElement.getAttributeValue("updateable", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:caseSensitive", columnElement.getAttributeValue("caseSensitive", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:searchability", columnElement.getAttributeValue("searchability", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:currency", columnElement.getAttributeValue("currency", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:radix", columnElement.getAttributeValue("radix", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:signed", columnElement.getAttributeValue("signed", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:distinctValueCount", columnElement.getAttributeValue("distinctValueCount", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(columnNode, "relational:nullValueCount", columnElement.getAttributeValue("nullValueCount", "http://www.metamatrix.com/metamodels/Relational"));
        this.processUniqueKeysAttribute(columnElement, columnNode);
        this.processIndexesAttribute(columnElement, columnNode);
        this.processForeignKeysAttribute(columnElement, columnNode);
        this.processAccessPatternsAttribute(columnElement, columnNode);
        this.processChildren(columnElement, columnNode, "type");
    }

    private void processColumnsAttribute(XmiElement element, Node node) throws Exception {
        String columns = element.getAttributeValue("columns", "http://www.metamatrix.com/metamodels/Relational");
        if (!StringUtil.isBlank((String)columns)) {
            ReferenceResolver resolver = this.getResolver();
            ValueFactory valueFactory = node.getSession().getValueFactory();
            for (String columnRef : columns.split("\\s")) {
                String columnUuid = resolver.resolveInternalReference(columnRef);
                Node columnNode = resolver.getNode(columnUuid);
                ReferenceResolver.UnresolvedReference unresolved = null;
                if (columnNode == null) {
                    unresolved = resolver.addUnresolvedReference(columnUuid);
                    unresolved.addReferencerReference(element.getUuid(), "relational:columns");
                } else {
                    if (!columnNode.isNodeType("mix:referenceable")) {
                        columnNode.addMixin("mix:referenceable");
                    }
                    Value weakReference = valueFactory.createValue(columnNode, true);
                    this.addPropertyValue(node, "relational:columns", weakReference);
                }
                this.addPropertyValue(node, "relational:columnXmiUuids", columnUuid);
                if (columnNode != null) {
                    this.addPropertyValue(node, "relational:columnNames", columnNode.getName());
                    continue;
                }
                if (unresolved != null) {
                    unresolved.addResolvedName(element.getUuid(), "relational:columnNames");
                    continue;
                }
                assert (false);
            }
        }
    }

    private void processColumnSet(XmiElement columnSetElement, Node columnSetNode) throws Exception {
        this.processRelationalEntity(columnSetElement, columnSetNode);
        this.processChildren(columnSetElement, columnSetNode, "columns");
    }

    private void processForeignKey(XmiElement foreignKeyElement, Node foreignKeyNode) throws Exception {
        this.processRelationalEntity(foreignKeyElement, foreignKeyNode);
        this.setProperty(foreignKeyNode, "relational:foreignKeyMultiplicity", foreignKeyElement.getAttributeValue("foreignKeyMultiplicity", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(foreignKeyNode, "relational:primaryKeyMultiplicity", foreignKeyElement.getAttributeValue("primaryKeyMultiplicity", "http://www.metamatrix.com/metamodels/Relational"));
        this.processColumnsAttribute(foreignKeyElement, foreignKeyNode);
        this.processUniqueKeysAttribute(foreignKeyElement, foreignKeyNode);
    }

    private void processForeignKeysAttribute(XmiElement element, Node node) throws Exception {
        String foreignKeys = element.getAttributeValue("foreignKeys", "http://www.metamatrix.com/metamodels/Relational");
        if (!StringUtil.isBlank((String)foreignKeys)) {
            ReferenceResolver resolver = this.getResolver();
            ValueFactory valueFactory = node.getSession().getValueFactory();
            for (String foreignKeyRef : foreignKeys.split("\\s")) {
                String foreignKeyUuid = resolver.resolveInternalReference(foreignKeyRef);
                Node foreignKeyNode = resolver.getNode(foreignKeyUuid);
                ReferenceResolver.UnresolvedReference unresolved = null;
                if (foreignKeyNode == null) {
                    unresolved = resolver.addUnresolvedReference(foreignKeyUuid);
                    unresolved.addReferencerReference(element.getUuid(), "relational:foreignKeys");
                } else {
                    if (!foreignKeyNode.isNodeType("mix:referenceable")) {
                        foreignKeyNode.addMixin("mix:referenceable");
                    }
                    Value weakReference = valueFactory.createValue(foreignKeyNode, true);
                    this.addPropertyValue(node, "relational:foreignKeys", weakReference);
                }
                this.addPropertyValue(node, "relational:foreignKeyXmiUuids", foreignKeyUuid);
                this.addPropertyValue(node, "relational:foreignKeyHrefs", foreignKeyRef);
                if (foreignKeyNode != null) {
                    this.addPropertyValue(node, "relational:uniqueKeyNames", foreignKeyNode.getName());
                    continue;
                }
                if (unresolved != null) {
                    unresolved.addResolvedName(element.getUuid(), "relational:foreignKeyNames");
                    continue;
                }
                assert (false);
            }
        }
    }

    private void processIndex(XmiElement indexElement, Node indexNode) throws Exception {
        this.processRelationalEntity(indexElement, indexNode);
        this.setProperty(indexNode, "relational:filterCondition", indexElement.getAttributeValue("filterCondition", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(indexNode, "relational:nullable", indexElement.getAttributeValue("nullable", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(indexNode, "relational:autoUpdate", indexElement.getAttributeValue("autoUpdate", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(indexNode, "relational:unique", indexElement.getAttributeValue("unique", "http://www.metamatrix.com/metamodels/Relational"));
        this.processColumnsAttribute(indexElement, indexNode);
    }

    private void processIndexesAttribute(XmiElement columnElement, Node columnNode) throws Exception {
        String indexes = columnElement.getAttributeValue("indexes", "http://www.metamatrix.com/metamodels/Relational");
        if (!StringUtil.isBlank((String)indexes)) {
            ReferenceResolver resolver = this.getResolver();
            ValueFactory valueFactory = columnNode.getSession().getValueFactory();
            for (String indexRef : indexes.split("\\s")) {
                String indexUuid = resolver.resolveInternalReference(indexRef);
                Node indexNode = resolver.getNode(indexUuid);
                ReferenceResolver.UnresolvedReference unresolved = null;
                if (indexNode == null) {
                    unresolved = resolver.addUnresolvedReference(indexUuid);
                    unresolved.addReferencerReference(columnElement.getUuid(), "relational:indexes");
                } else {
                    if (!indexNode.isNodeType("mix:referenceable")) {
                        indexNode.addMixin("mix:referenceable");
                    }
                    Value weakReference = valueFactory.createValue(indexNode, true);
                    this.addPropertyValue(columnNode, "relational:indexes", weakReference);
                }
                this.addPropertyValue(columnNode, "relational:indexXmiUuids", indexUuid);
                this.addPropertyValue(columnNode, "relational:indexHrefs", indexRef);
                if (indexNode != null) {
                    this.addPropertyValue(columnNode, "relational:indexNames", indexNode.getName());
                    continue;
                }
                if (unresolved != null) {
                    unresolved.addResolvedName(columnElement.getUuid(), "relational:indexNames");
                    continue;
                }
                assert (false);
            }
        }
    }

    private void processProcedure(XmiElement procedureElement, Node procedureNode) throws Exception {
        this.processRelationalEntity(procedureElement, procedureNode);
        this.setProperty(procedureNode, "relational:function", procedureElement.getAttributeValue("function", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(procedureNode, "relational:updateCount", procedureElement.getAttributeValue("updateCount", "http://www.metamatrix.com/metamodels/Relational"));
        this.processChildren(procedureElement, procedureNode, "parameters", "result");
    }

    private void processProcedureParameter(XmiElement procedureParameterElement, Node procedureParameterNode) throws Exception {
        this.processRelationalEntity(procedureParameterElement, procedureParameterNode);
        this.setProperty(procedureParameterNode, "relational:direction", procedureParameterElement.getAttributeValue("direction", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(procedureParameterNode, "relational:defaultValue", procedureParameterElement.getAttributeValue("defaultValue", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(procedureParameterNode, "relational:nativeType", procedureParameterElement.getAttributeValue("nativeType", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(procedureParameterNode, "relational:length", procedureParameterElement.getAttributeValue("length", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(procedureParameterNode, "relational:precision", procedureParameterElement.getAttributeValue("precision", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(procedureParameterNode, "relational:scale", procedureParameterElement.getAttributeValue("scale", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(procedureParameterNode, "relational:nullable", procedureParameterElement.getAttributeValue("nullable", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(procedureParameterNode, "relational:radix", procedureParameterElement.getAttributeValue("radix", "http://www.metamatrix.com/metamodels/Relational"));
        this.processChildren(procedureParameterElement, procedureParameterNode, "type");
    }

    private void processRelationalEntity(XmiElement element, Node node) throws Exception {
        this.processXmiReferenceable(element, node);
        this.setProperty(node, "relational:nameInSource", element.getAttributeValue("nameInSource", "http://www.metamatrix.com/metamodels/Relational"));
    }

    private void processSchema(XmiElement schemaElement, Node schemaNode) throws Exception {
        this.processRelationalEntity(schemaElement, schemaNode);
        this.processChildren(schemaElement, schemaNode, new String[0]);
    }

    private void processTable(XmiElement tableElement, Node tableNode) throws Exception {
        this.processColumnSet(tableElement, tableNode);
        this.setProperty(tableNode, "relational:system", tableElement.getAttributeValue("system", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(tableNode, "relational:cardinality", tableElement.getAttributeValue("cardinality", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(tableNode, "relational:supportsUpdate", tableElement.getAttributeValue("supportsUpdate", "http://www.metamatrix.com/metamodels/Relational"));
        this.setProperty(tableNode, "relational:materialized", tableElement.getAttributeValue("materialized", "http://www.metamatrix.com/metamodels/Relational"));
        this.processChildren(tableElement, tableNode, "primaryKey", "foreignKeys", "AccessPattern", "accessPatterns");
    }

    private void processType(XmiElement typeElement, Node parentNode) throws Exception {
        String href = typeElement.getAttributeValue("href", "http://www.metamatrix.com/metamodels/Relational");
        if (!StringUtil.isBlank((String)href)) {
            this.setProperty(parentNode, "relational:typeHref", href);
            String typeName = ReferenceResolver.STANDARD_DATA_TYPE_URLS_TO_NAMES.get(href);
            if (!StringUtil.isBlank((String)typeName)) {
                this.setProperty(parentNode, "relational:typeName", typeName);
                String uuid = ReferenceResolver.STANDARD_DATA_TYPE_UUIDS_BY_NAMES.get(typeName);
                Node typeNode = this.getResolver().getNode(uuid);
                if (typeNode == null) {
                    if (typeElement.getUuid() != null) {
                        ReferenceResolver.UnresolvedReference unresolved = this.getResolver().addUnresolvedReference(uuid);
                        unresolved.addReferencerReference(typeElement.getUuid(), "relational:type");
                    }
                } else {
                    parentNode.setProperty("relational:type", parentNode.getSession().getValueFactory().createValue(typeNode, true));
                }
                this.setProperty(parentNode, "relational:typeXmiUuid", uuid);
            }
        }
    }

    private void processUniqueKey(XmiElement uniqueKeyElement, Node uniqueKeyNode) throws Exception {
        assert (uniqueKeyElement != null);
        assert (uniqueKeyNode != null);
        this.getResolver();
        uniqueKeyNode.getSession().getValueFactory();
        this.processRelationalEntity(uniqueKeyElement, uniqueKeyNode);
        this.processColumnsAttribute(uniqueKeyElement, uniqueKeyNode);
        this.processForeignKeysAttribute(uniqueKeyElement, uniqueKeyNode);
    }

    private void processUniqueKeysAttribute(XmiElement element, Node node) throws Exception {
        String uniqueKeys = element.getAttributeValue("uniqueKeys", "http://www.metamatrix.com/metamodels/Relational");
        if (!StringUtil.isBlank((String)uniqueKeys)) {
            ReferenceResolver resolver = this.getResolver();
            ValueFactory valueFactory = node.getSession().getValueFactory();
            for (String uniqueKeyRef : uniqueKeys.split("\\s")) {
                String uniqueKeyUuid = resolver.resolveInternalReference(uniqueKeyRef);
                Node uniqueKeyNode = resolver.getNode(uniqueKeyUuid);
                ReferenceResolver.UnresolvedReference unresolved = null;
                if (uniqueKeyNode == null) {
                    unresolved = resolver.addUnresolvedReference(uniqueKeyUuid);
                    unresolved.addReferencerReference(element.getUuid(), "relational:uniqueKeys");
                } else {
                    if (!uniqueKeyNode.isNodeType("mix:referenceable")) {
                        uniqueKeyNode.addMixin("mix:referenceable");
                    }
                    Value weakReference = valueFactory.createValue(uniqueKeyNode, true);
                    this.addPropertyValue(node, "relational:uniqueKeys", weakReference);
                }
                this.addPropertyValue(node, "relational:uniqueKeyXmiUuids", uniqueKeyUuid);
                this.addPropertyValue(node, "relational:uniqueKeyHrefs", uniqueKeyRef);
                if (uniqueKeyNode != null) {
                    this.addPropertyValue(node, "relational:uniqueKeyNames", uniqueKeyNode.getName());
                    continue;
                }
                if (unresolved != null) {
                    unresolved.addResolvedName(element.getUuid(), "relational:uniqueKeyNames");
                    continue;
                }
                assert (false);
            }
        }
    }

    private void processXmiReferenceable(XmiElement element, Node node) throws Exception {
        this.setProperty(node, "xmi:uuid", element.getUuid());
    }
}

