/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.teiid.ImportVdb;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.VdbDataRole;
import org.modeshape.sequencer.teiid.VdbEntry;
import org.modeshape.sequencer.teiid.VdbModel;
import org.modeshape.sequencer.teiid.VdbTranslator;

public class VdbManifest
implements Comparable<VdbManifest> {
    static final Logger LOGGER = Logger.getLogger(VdbManifest.class);
    private final String name;
    private String description;
    private String connectionType = "BY_VERSION";
    private final Map<String, String> properties = new HashMap<String, String>();
    private int version = 1;
    private final List<VdbDataRole> dataRoles = new ArrayList<VdbDataRole>();
    private final List<VdbEntry> entries = new ArrayList<VdbEntry>();
    private final List<VdbModel> models = new ArrayList<VdbModel>();
    private final List<VdbTranslator> translators = new ArrayList<VdbTranslator>();
    private final List<ImportVdb> importVdbs = new ArrayList<ImportVdb>();

    public static VdbManifest read(InputStream stream, Sequencer.Context context) throws Exception {
        return new Reader().read(stream, context);
    }

    public VdbManifest(String name) {
        CheckArg.isNotEmpty((String)name, (String)"name");
        this.name = name;
    }

    @Override
    public int compareTo(VdbManifest that) {
        CheckArg.isNotNull((Object)that, (String)"that");
        if (this == that) {
            return 0;
        }
        return this.name.compareTo(that.name);
    }

    public List<VdbDataRole> getDataRoles() {
        return this.dataRoles;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public List<VdbEntry> getEntries() {
        return this.entries;
    }

    public List<ImportVdb> getImportVdbs() {
        return this.importVdbs;
    }

    public VdbModel getModel(String path) {
        CheckArg.isNotEmpty((String)path, (String)"path");
        for (VdbModel model : this.getModels()) {
            if (!path.equals(model.getPathInVdb())) continue;
            return model;
        }
        return null;
    }

    public List<VdbModel> getModels() {
        return this.models;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<VdbTranslator> getTranslators() {
        return this.translators;
    }

    public int getVersion() {
        return this.version;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public Iterable<VdbModel> modelsInDependencyOrder() {
        if (!this.models.isEmpty()) {
            Collections.sort(this.models);
        }
        return this.models;
    }

    public void setDescription(String description) {
        this.description = description != null ? description : "";
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public String toString() {
        return this.name + " v" + this.version + " (\"" + this.description + "\")";
    }

    protected static class Reader {
        protected Reader() {
        }

        private VdbDataRole parseDataRole(XMLStreamReader streamReader) throws Exception {
            assert ("data-role".equals(streamReader.getLocalName()));
            VdbDataRole dataRole = this.processDataRoleAttributes(streamReader);
            assert (dataRole != null) : "data role should not be null";
            while (streamReader.hasNext()) {
                int eventType = streamReader.next();
                if (streamReader.isStartElement()) {
                    String elementName = streamReader.getLocalName();
                    if ("description".equals(elementName)) {
                        String description = streamReader.getElementText();
                        dataRole.setDescription(description);
                        continue;
                    }
                    if ("permission".equals(elementName)) {
                        VdbDataRole.Permission permission = this.parsePermission(streamReader, dataRole);
                        assert (permission != null) : "permission is null";
                        dataRole.getPermissions().add(permission);
                        continue;
                    }
                    if ("mapped-role-name".equals(elementName)) {
                        String roleName = streamReader.getElementText();
                        dataRole.getMappedRoleNames().add(roleName);
                        continue;
                    }
                    LOGGER.debug("**** unexpected data role element={0}", new Object[]{elementName});
                    continue;
                }
                if (streamReader.isEndElement() && "data-role".equals(streamReader.getLocalName())) break;
                if (streamReader.isCharacters()) {
                    if (StringUtil.isBlank((String)streamReader.getText())) continue;
                    LOGGER.debug("**** unhandled data role event type CHARACTERS={0}", new Object[]{streamReader.getText()});
                    continue;
                }
                if (streamReader.isEndElement()) {
                    LOGGER.debug("**** unhandled data role event type END_ELEMENT={0}", new Object[]{streamReader.getLocalName()});
                    continue;
                }
                LOGGER.debug("**** unhandled data role event type={0}", new Object[]{eventType});
            }
            assert (dataRole != null) : "dataRole is null";
            return dataRole;
        }

        private VdbEntry parseEntry(XMLStreamReader streamReader) throws Exception {
            assert ("entry".equals(streamReader.getLocalName()));
            VdbEntry entry = this.processEntryAttributes(streamReader);
            assert (entry != null) : "entry path is null";
            while (streamReader.hasNext()) {
                int eventType = streamReader.next();
                if (streamReader.isStartElement()) {
                    String elementName = streamReader.getLocalName();
                    if ("description".equals(elementName)) {
                        String description = streamReader.getElementText();
                        entry.setDescription(description);
                        continue;
                    }
                    if ("property".equals(elementName)) {
                        Map.Entry<String, String> property = this.processPropertyAttributes(streamReader);
                        assert (property != null) : "entry property is null";
                        entry.getProperties().put(property.getKey(), property.getValue());
                        continue;
                    }
                    LOGGER.debug("**** unexpected entry element={0}", new Object[]{elementName});
                    continue;
                }
                if (streamReader.isEndElement() && "entry".equals(streamReader.getLocalName())) break;
                if (streamReader.isCharacters()) {
                    if (StringUtil.isBlank((String)streamReader.getText())) continue;
                    LOGGER.debug("**** unhandled entry event type CHARACTERS={0}", new Object[]{streamReader.getText()});
                    continue;
                }
                if (streamReader.isEndElement()) {
                    LOGGER.debug("**** unhandled entry event type END_ELEMENT={0}", new Object[]{streamReader.getLocalName()});
                    continue;
                }
                LOGGER.debug("**** unhandled entry event type={0}", new Object[]{eventType});
            }
            return entry;
        }

        private VdbModel parseModel(XMLStreamReader streamReader) throws Exception {
            assert ("model".equals(streamReader.getLocalName()));
            VdbModel model = this.processModelAttributes(streamReader);
            assert (model != null) : "model is null";
            while (streamReader.hasNext()) {
                int eventType = streamReader.next();
                if (streamReader.isStartElement()) {
                    String elementName = streamReader.getLocalName();
                    if ("validation-error".equals(elementName)) {
                        this.processValidationErrorAttributes(streamReader, model);
                        continue;
                    }
                    if ("source".equals(elementName)) {
                        this.processModelSourceAttributes(streamReader, model);
                        continue;
                    }
                    if ("property".equals(elementName)) {
                        Map.Entry<String, String> property = this.processPropertyAttributes(streamReader);
                        assert (property != null) : "model property is null";
                        if ("imports".equals(property.getKey())) {
                            model.addImport(property.getValue());
                            continue;
                        }
                        if ("checksum".equals(property.getKey())) {
                            model.setChecksum(Long.parseLong(property.getValue()));
                            continue;
                        }
                        if ("builtIn".equals(property.getKey())) {
                            model.setBuiltIn(Boolean.parseBoolean(property.getValue()));
                            continue;
                        }
                        model.getProperties().put(property.getKey(), property.getValue());
                        continue;
                    }
                    if ("description".equals(elementName)) {
                        String description = streamReader.getElementText();
                        model.setDescription(description);
                        continue;
                    }
                    if ("metadata".equals(elementName)) {
                        if (streamReader.getAttributeCount() == 1) {
                            model.setMetadataType(streamReader.getAttributeValue(0));
                        }
                        String metadata = streamReader.getElementText().trim();
                        model.setModelDefinition(metadata.replaceAll("\\s{2,}", " "));
                        continue;
                    }
                    LOGGER.debug("**** unexpected model element={0}", new Object[]{elementName});
                    continue;
                }
                if (streamReader.isEndElement()) {
                    if ("source".equals(streamReader.getLocalName())) continue;
                    if ("model".equals(streamReader.getLocalName())) break;
                    LOGGER.debug("**** unhandled model event type END_ELEMENT={0}", new Object[]{streamReader.getLocalName()});
                    continue;
                }
                if (streamReader.isCharacters()) {
                    if (StringUtil.isBlank((String)streamReader.getText())) continue;
                    LOGGER.debug("**** unhandled model event type CHARACTERS={0}", new Object[]{streamReader.getText()});
                    continue;
                }
                LOGGER.debug("**** unhandled model event type={0}", new Object[]{eventType});
            }
            return model;
        }

        private VdbDataRole.Mask parseMask(XMLStreamReader streamReader, VdbDataRole dataRole) throws Exception {
            assert ("mask".equals(streamReader.getLocalName()));
            assert (dataRole != null) : "data role is null";
            VdbDataRole.Mask mask = dataRole.new VdbDataRole.Mask();
            HashMap<String, String> attributes = new HashMap<String, String>();
            int size = streamReader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                QName name = streamReader.getAttributeName(i);
                String value = streamReader.getAttributeValue(i);
                attributes.put(name.getLocalPart(), value);
                LOGGER.debug("mask attribute name={0}, value={1}", new Object[]{name.getLocalPart(), value});
            }
            String order = (String)attributes.get("order");
            if (!StringUtil.isBlank((String)order)) {
                mask.setOrder(Integer.parseInt(order));
            }
            attributes.remove("order");
            if (LOGGER.isDebugEnabled()) {
                for (Map.Entry entry : attributes.entrySet()) {
                    LOGGER.debug("**** unexpected data role permission mask attribute:name={0}", new Object[]{entry.getKey()});
                }
            }
            mask.setRule(streamReader.getElementText());
            return mask;
        }

        private VdbDataRole.Condition parseCondition(XMLStreamReader streamReader, VdbDataRole dataRole) throws Exception {
            assert ("condition".equals(streamReader.getLocalName()));
            assert (dataRole != null) : "data role is null";
            VdbDataRole.Condition condition = dataRole.new VdbDataRole.Condition();
            HashMap<String, String> attributes = new HashMap<String, String>();
            int size = streamReader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                QName name = streamReader.getAttributeName(i);
                String value = streamReader.getAttributeValue(i);
                attributes.put(name.getLocalPart(), value);
                LOGGER.debug("condition attribute name={0}, value={1}", new Object[]{name.getLocalPart(), value});
            }
            String constraint = (String)attributes.get("constraint");
            if (!StringUtil.isBlank((String)constraint)) {
                condition.setConstraint(Boolean.parseBoolean(constraint));
            }
            attributes.remove("constraint");
            if (LOGGER.isDebugEnabled()) {
                for (Map.Entry entry : attributes.entrySet()) {
                    LOGGER.debug("**** unexpected data role permission condition attribute:name={0}", new Object[]{entry.getKey()});
                }
            }
            condition.setRule(streamReader.getElementText());
            return condition;
        }

        private VdbDataRole.Permission parsePermission(XMLStreamReader streamReader, VdbDataRole dataRole) throws Exception {
            assert ("permission".equals(streamReader.getLocalName()));
            assert (dataRole != null) : "data role is null";
            if (LOGGER.isDebugEnabled()) {
                int size = streamReader.getAttributeCount();
                for (int i = 0; i < size; ++i) {
                    QName name = streamReader.getAttributeName(i);
                    String value = streamReader.getAttributeValue(i);
                    LOGGER.debug("**** unexpected data role permission attribute name={0}, value={1}", new Object[]{name.getLocalPart(), value});
                }
            }
            VdbDataRole.Permission permission = null;
            boolean alter = false;
            boolean create = false;
            boolean delete = false;
            boolean execute = false;
            boolean read = false;
            String resourceName = null;
            boolean update = false;
            boolean language = false;
            ArrayList<VdbDataRole.Condition> conditions = new ArrayList<VdbDataRole.Condition>();
            ArrayList<VdbDataRole.Mask> masks = new ArrayList<VdbDataRole.Mask>();
            while (streamReader.hasNext()) {
                int eventType = streamReader.next();
                if (streamReader.isStartElement()) {
                    String elementName = streamReader.getLocalName();
                    if ("resource-name".equals(elementName)) {
                        resourceName = streamReader.getElementText();
                        continue;
                    }
                    if ("allow-alter".equals(elementName)) {
                        alter = Boolean.parseBoolean(streamReader.getElementText());
                        continue;
                    }
                    if ("allow-create".equals(elementName)) {
                        create = Boolean.parseBoolean(streamReader.getElementText());
                        continue;
                    }
                    if ("allow-delete".equals(elementName)) {
                        delete = Boolean.parseBoolean(streamReader.getElementText());
                        continue;
                    }
                    if ("allow-execute".equals(elementName)) {
                        execute = Boolean.parseBoolean(streamReader.getElementText());
                        continue;
                    }
                    if ("allow-read".equals(elementName)) {
                        read = Boolean.parseBoolean(streamReader.getElementText());
                        continue;
                    }
                    if ("allow-update".equals(elementName)) {
                        update = Boolean.parseBoolean(streamReader.getElementText());
                        continue;
                    }
                    if ("allow-language".equals(elementName)) {
                        language = Boolean.parseBoolean(streamReader.getElementText());
                        continue;
                    }
                    if ("condition".equals(elementName)) {
                        VdbDataRole.Condition condition = this.parseCondition(streamReader, dataRole);
                        assert (condition != null) : "condition is null";
                        conditions.add(condition);
                        continue;
                    }
                    if ("mask".equals(elementName)) {
                        VdbDataRole.Mask mask = this.parseMask(streamReader, dataRole);
                        assert (mask != null) : "mask is null";
                        masks.add(mask);
                        continue;
                    }
                    LOGGER.debug("**** unexpected data role permission element={0}", new Object[]{elementName});
                    continue;
                }
                if (streamReader.isEndElement() && "permission".equals(streamReader.getLocalName())) {
                    if (StringUtil.isBlank((String)resourceName)) {
                        throw new Exception(TeiidI18n.missingPermissionResourceName.text(new Object[0]));
                    }
                    VdbDataRole vdbDataRole = dataRole;
                    vdbDataRole.getClass();
                    permission = vdbDataRole.new VdbDataRole.Permission(resourceName);
                    permission.allowAlter(alter);
                    permission.allowCreate(create);
                    permission.allowDelete(delete);
                    permission.allowExecute(execute);
                    permission.allowRead(read);
                    permission.allowUpdate(update);
                    permission.allowLanguage(language);
                    permission.setConditions(conditions);
                    permission.setMasks(masks);
                    break;
                }
                if (streamReader.isCharacters()) {
                    if (StringUtil.isBlank((String)streamReader.getText())) continue;
                    LOGGER.debug("**** unhandled data role permission event type CHARACTERS={0}", new Object[]{streamReader.getText()});
                    continue;
                }
                if (streamReader.isEndElement()) {
                    LOGGER.debug("**** unhandled data role permission event type END_ELEMENT={0}", new Object[]{streamReader.getLocalName()});
                    continue;
                }
                LOGGER.debug("**** unhandled data role permission event type={0}", new Object[]{eventType});
            }
            return permission;
        }

        private VdbTranslator parseTranslator(XMLStreamReader streamReader) throws Exception {
            assert ("translator".equals(streamReader.getLocalName()));
            VdbTranslator translator = this.processTranslatorAttributes(streamReader);
            assert (translator != null) : "translator is null";
            while (streamReader.hasNext()) {
                int eventType = streamReader.next();
                if (streamReader.isStartElement()) {
                    String elementName = streamReader.getLocalName();
                    if ("property".equals(elementName)) {
                        Map.Entry<String, String> property = this.processPropertyAttributes(streamReader);
                        assert (property != null) : "translator property is null";
                        translator.getProperties().put(property.getKey(), property.getValue());
                        continue;
                    }
                    LOGGER.debug("**** unexpected data role element={0}", new Object[]{elementName});
                    continue;
                }
                if (streamReader.isEndElement() && "translator".equals(streamReader.getLocalName())) break;
                if (streamReader.isCharacters()) {
                    if (StringUtil.isBlank((String)streamReader.getText())) continue;
                    LOGGER.debug("**** unhandled translator event type CHARACTERS={0}", new Object[]{streamReader.getText()});
                    continue;
                }
                if (streamReader.isEndElement()) {
                    LOGGER.debug("**** unhandled translator event type END_ELEMENT={0}", new Object[]{streamReader.getLocalName()});
                    continue;
                }
                LOGGER.debug("**** unhandled translator event type={0}", new Object[]{eventType});
            }
            return translator;
        }

        private VdbManifest parseVdb(XMLStreamReader streamReader) throws Exception {
            assert ("vdb".equals(streamReader.getLocalName()));
            VdbManifest manifest = this.processVdbAttributes(streamReader);
            assert (manifest != null) : "manifest is null";
            while (streamReader.hasNext()) {
                streamReader.next();
                if (streamReader.isStartElement()) {
                    String elementName = streamReader.getLocalName();
                    if ("description".equals(elementName)) {
                        String description = streamReader.getElementText();
                        manifest.setDescription(description);
                        continue;
                    }
                    if ("model".equals(elementName)) {
                        VdbModel model = this.parseModel(streamReader);
                        assert (model != null) : "model is null";
                        manifest.getModels().add(model);
                        continue;
                    }
                    if ("property".equals(elementName)) {
                        Map.Entry<String, String> property = this.processPropertyAttributes(streamReader);
                        assert (property != null) : "VDB property is null";
                        manifest.getProperties().put(property.getKey(), property.getValue());
                        continue;
                    }
                    if ("translator".equals(elementName)) {
                        VdbTranslator translator = this.parseTranslator(streamReader);
                        assert (translator != null) : "translator is null";
                        manifest.getTranslators().add(translator);
                        continue;
                    }
                    if ("data-role".equals(elementName)) {
                        VdbDataRole dataRole = this.parseDataRole(streamReader);
                        assert (dataRole != null) : "dataRole is null";
                        manifest.getDataRoles().add(dataRole);
                        continue;
                    }
                    if ("entry".equals(elementName)) {
                        VdbEntry entry = this.parseEntry(streamReader);
                        assert (entry != null) : "entry is null";
                        manifest.getEntries().add(entry);
                        continue;
                    }
                    if ("import-vdb".equals(elementName)) {
                        ImportVdb importVdb = this.processImportVdbAttributes(streamReader);
                        assert (importVdb != null) : "importVdb is null";
                        manifest.getImportVdbs().add(importVdb);
                        continue;
                    }
                    LOGGER.debug("**** unexpected VDB element={0}", new Object[]{elementName});
                    continue;
                }
                if (!streamReader.isEndElement() || !"vdb".equals(streamReader.getLocalName())) continue;
                break;
            }
            return manifest;
        }

        private VdbDataRole processDataRoleAttributes(XMLStreamReader streamReader) throws Exception {
            String grantAll;
            String allowCreateTempTables;
            assert ("data-role".equals(streamReader.getLocalName()));
            HashMap<String, String> attributes = new HashMap<String, String>();
            int size = streamReader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                QName name = streamReader.getAttributeName(i);
                String value = streamReader.getAttributeValue(i);
                attributes.put(name.getLocalPart(), value);
                LOGGER.debug("data-role attribute name={0}, value={1}", new Object[]{name.getLocalPart(), value});
            }
            String name = (String)attributes.get("name");
            if (StringUtil.isBlank((String)name)) {
                throw new Exception(TeiidI18n.missingDataRoleName.text(new Object[0]));
            }
            VdbDataRole dataRole = new VdbDataRole(name);
            attributes.remove("name");
            String anyAuthenticated = (String)attributes.get("any-authenticated");
            if (!StringUtil.isBlank((String)anyAuthenticated)) {
                dataRole.setAnyAuthenticated(Boolean.parseBoolean(anyAuthenticated));
                attributes.remove("any-authenticated");
            }
            if (!StringUtil.isBlank((String)(allowCreateTempTables = (String)attributes.get("allow-create-temporary-tables")))) {
                dataRole.setAllowCreateTempTables(Boolean.parseBoolean(allowCreateTempTables));
                attributes.remove("allow-create-temporary-tables");
            }
            if (!StringUtil.isBlank((String)(grantAll = (String)attributes.get("grant-all")))) {
                dataRole.setGrantAll(Boolean.parseBoolean(grantAll));
                attributes.remove("grant-all");
            }
            if (LOGGER.isDebugEnabled()) {
                for (Map.Entry entry : attributes.entrySet()) {
                    LOGGER.debug("**** unexpected data role attribute:name={0}", new Object[]{entry.getKey()});
                }
            }
            return dataRole;
        }

        private VdbEntry processEntryAttributes(XMLStreamReader streamReader) throws Exception {
            assert ("entry".equals(streamReader.getLocalName()));
            HashMap<String, String> attributes = new HashMap<String, String>();
            int size = streamReader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                QName name = streamReader.getAttributeName(i);
                String value = streamReader.getAttributeValue(i);
                attributes.put(name.getLocalPart(), value);
                LOGGER.debug("entry attribute name={0}, value={1}", new Object[]{name.getLocalPart(), value});
            }
            String path = (String)attributes.get("path");
            if (StringUtil.isBlank((String)path)) {
                throw new Exception(TeiidI18n.missingEntryPath.text(new Object[0]));
            }
            VdbEntry entry = new VdbEntry(path);
            attributes.remove("path");
            if (LOGGER.isDebugEnabled()) {
                for (Map.Entry attrib : attributes.entrySet()) {
                    LOGGER.debug("**** unexpected entry attribute:name={0}", new Object[]{attrib.getKey()});
                }
            }
            return entry;
        }

        private ImportVdb processImportVdbAttributes(XMLStreamReader streamReader) throws Exception {
            assert ("import-vdb".equals(streamReader.getLocalName()));
            HashMap<String, String> attributes = new HashMap<String, String>();
            int size = streamReader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                QName name = streamReader.getAttributeName(i);
                String value = streamReader.getAttributeValue(i);
                attributes.put(name.getLocalPart(), value);
                LOGGER.debug("import VDB attribute name={0}, value={1}", new Object[]{name.getLocalPart(), value});
            }
            String name = (String)attributes.get("name");
            String version = (String)attributes.get("version");
            if (StringUtil.isBlank((String)name) || StringUtil.isBlank((String)version)) {
                throw new Exception(TeiidI18n.missingImportVdbNameOrVersion.text(new Object[0]));
            }
            ImportVdb importVdb = new ImportVdb((String)attributes.get("name"), Integer.parseInt((String)attributes.get("version")));
            attributes.remove("name");
            attributes.remove("version");
            String importDataPolicies = (String)attributes.get("import-data-policies");
            if (!StringUtil.isBlank((String)importDataPolicies)) {
                importVdb.setImportDataPolicies(Boolean.parseBoolean(importDataPolicies));
                attributes.remove("import-data-policies");
            }
            if (LOGGER.isDebugEnabled()) {
                for (Map.Entry entry : attributes.entrySet()) {
                    LOGGER.debug("**** unexpected import VDB attribute:name={0}", new Object[]{entry.getKey()});
                }
            }
            return importVdb;
        }

        private VdbModel processModelAttributes(XMLStreamReader streamReader) throws Exception {
            assert ("model".equals(streamReader.getLocalName()));
            HashMap<String, String> attributes = new HashMap<String, String>();
            int size = streamReader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                QName name = streamReader.getAttributeName(i);
                String value = streamReader.getAttributeValue(i);
                attributes.put(name.getLocalPart(), value);
                LOGGER.debug("model attribute name={0}, value={1}", new Object[]{name.getLocalPart(), value});
            }
            String name = (String)attributes.get("name");
            String type = (String)attributes.get("type");
            String path = (String)attributes.get("path");
            if (!StringUtil.isBlank((String)path)) {
                path = path.replaceFirst("^/", "");
            }
            VdbModel model = new VdbModel(name, type, path);
            attributes.remove("name");
            attributes.remove("type");
            attributes.remove("path");
            String visible = (String)attributes.get("visible");
            if (!StringUtil.isBlank((String)visible)) {
                model.setVisible(Boolean.parseBoolean(visible));
                attributes.remove("visible");
            }
            if (LOGGER.isDebugEnabled()) {
                for (Map.Entry entry : attributes.entrySet()) {
                    LOGGER.debug("**** unexpected model attribute:name={0}", new Object[]{entry.getKey()});
                }
            }
            return model;
        }

        private void processModelSourceAttributes(XMLStreamReader streamReader, VdbModel model) throws Exception {
            assert ("source".equals(streamReader.getLocalName()));
            HashMap<String, String> attributes = new HashMap<String, String>();
            int size = streamReader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                QName name = streamReader.getAttributeName(i);
                String value = streamReader.getAttributeValue(i);
                attributes.put(name.getLocalPart(), value);
                LOGGER.debug("model source attribute name={0}, value={1}", new Object[]{name.getLocalPart(), value});
            }
            String sourceName = (String)attributes.get("name");
            String sourceTranslator = (String)attributes.get("translator-name");
            VdbModel vdbModel = model;
            vdbModel.getClass();
            VdbModel.Source source = new VdbModel.Source(vdbModel, sourceName, sourceTranslator);
            attributes.remove("name");
            attributes.remove("translator-name");
            String jndiName = (String)attributes.get("connection-jndi-name");
            if (!StringUtil.isBlank((String)jndiName)) {
                source.setJndiName(jndiName);
                attributes.remove("connection-jndi-name");
            }
            model.addSource(source);
            if (LOGGER.isDebugEnabled()) {
                for (Map.Entry entry : attributes.entrySet()) {
                    LOGGER.debug("**** unexpected model source attribute:name={0}", new Object[]{entry.getKey()});
                }
            }
            assert (streamReader.next() == 2 && "source".equals(streamReader.getLocalName()));
        }

        private Map.Entry<String, String> processPropertyAttributes(XMLStreamReader streamReader) throws Exception {
            assert ("property".equals(streamReader.getLocalName()));
            if (streamReader.getAttributeCount() == 2) {
                String propName = null;
                String propValue = null;
                QName qname = streamReader.getAttributeName(0);
                String name = qname.getLocalPart();
                String value = streamReader.getAttributeValue(0);
                if ("name".equals(name)) {
                    propName = value;
                } else if ("value".equals(name)) {
                    propValue = value;
                }
                qname = streamReader.getAttributeName(1);
                name = qname.getLocalPart();
                value = streamReader.getAttributeValue(1);
                if ("value".equals(name)) {
                    propValue = value;
                } else if ("name".equals(name)) {
                    propName = value;
                }
                if (StringUtil.isBlank((String)propName) || StringUtil.isBlank((String)propValue)) {
                    throw new Exception(TeiidI18n.missingPropertyNameOrValue.text(new Object[0]));
                }
                LOGGER.debug("adding property name={0}, value={1}", new Object[]{propName, propValue});
                int eventType = streamReader.next();
                assert (eventType == 2) : "**** unexpected PROPERTY END_ELEMENT of " + eventType;
                return new AbstractMap.SimpleEntry<String, String>(propName, propValue);
            }
            throw new Exception(TeiidI18n.invalidNumberOfPropertyAttributes.text(new Object[]{streamReader.getAttributeCount()}));
        }

        private VdbTranslator processTranslatorAttributes(XMLStreamReader streamReader) throws Exception {
            assert ("translator".equals(streamReader.getLocalName()));
            HashMap<String, String> attributes = new HashMap<String, String>();
            int size = streamReader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                QName name = streamReader.getAttributeName(i);
                String value = streamReader.getAttributeValue(i);
                attributes.put(name.getLocalPart(), value);
                LOGGER.debug("translator attribute name={0}, value={1}", new Object[]{name.getLocalPart(), value});
            }
            String name = (String)attributes.get("name");
            String type = (String)attributes.get("type");
            if (StringUtil.isBlank((String)name) || StringUtil.isBlank((String)type)) {
                throw new Exception(TeiidI18n.missingTranslatorNameOrType.text(new Object[0]));
            }
            VdbTranslator translator = new VdbTranslator(name, type);
            attributes.remove("name");
            attributes.remove("type");
            String description = (String)attributes.get("description");
            if (!StringUtil.isBlank((String)description)) {
                translator.setDescription(description);
                attributes.remove("description");
            }
            if (LOGGER.isDebugEnabled()) {
                for (Map.Entry entry : attributes.entrySet()) {
                    LOGGER.debug("**** unexpected translator attribute:name={0}", new Object[]{entry.getKey()});
                }
            }
            return translator;
        }

        private void processValidationErrorAttributes(XMLStreamReader streamReader, VdbModel model) throws Exception {
            assert ("validation-error".equals(streamReader.getLocalName()));
            HashMap<String, String> attributes = new HashMap<String, String>();
            int size = streamReader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                QName name = streamReader.getAttributeName(i);
                String value = streamReader.getAttributeValue(i);
                attributes.put(name.getLocalPart(), value);
                LOGGER.debug("model validation error attribute name={0}, value={1}", new Object[]{name.getLocalPart(), value});
            }
            String severity = (String)attributes.get("severity");
            attributes.remove("severity");
            String path = (String)attributes.get("path");
            attributes.remove("path");
            String message = streamReader.getElementText();
            model.addProblem(severity, path, message);
            if (LOGGER.isDebugEnabled()) {
                for (Map.Entry entry : attributes.entrySet()) {
                    LOGGER.debug("**** unexpected model validation error attribute:name={0}", new Object[]{entry.getKey()});
                }
            }
        }

        private VdbManifest processVdbAttributes(XMLStreamReader streamReader) throws Exception {
            String connectionType;
            assert ("vdb".equals(streamReader.getLocalName()));
            HashMap<String, String> attributes = new HashMap<String, String>();
            int size = streamReader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                QName name = streamReader.getAttributeName(i);
                String value = streamReader.getAttributeValue(i);
                attributes.put(name.getLocalPart(), value);
                LOGGER.debug("VDB attribute name={0}, value={1}", new Object[]{name.getLocalPart(), value});
            }
            String name = (String)attributes.get("name");
            if (StringUtil.isBlank((String)name)) {
                throw new Exception(TeiidI18n.missingVdbName.text(new Object[0]));
            }
            VdbManifest manifest = new VdbManifest(name);
            attributes.remove("name");
            String version = (String)attributes.get("version");
            if (!StringUtil.isBlank((String)version)) {
                try {
                    manifest.setVersion(Integer.parseInt(version));
                }
                catch (NumberFormatException e) {
                    LOGGER.error((Throwable)e, (I18nResource)TeiidI18n.invalidVdbVersion, new Object[]{name, version});
                }
                attributes.remove("version");
            }
            if (!StringUtil.isBlank((String)(connectionType = (String)attributes.get("connection-type")))) {
                manifest.setConnectionType(connectionType);
                attributes.remove("connection-type");
            }
            if (LOGGER.isDebugEnabled()) {
                for (Map.Entry entry : attributes.entrySet()) {
                    LOGGER.debug("**** unexpected VDB attribute:name={0}", new Object[]{entry.getKey()});
                }
            }
            return manifest;
        }

        public VdbManifest read(InputStream stream, Sequencer.Context context) throws Exception {
            VdbManifest manifest = null;
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader streamReader = factory.createXMLStreamReader(stream);
            if (streamReader.hasNext() && streamReader.next() == 1) {
                String elementName = streamReader.getLocalName();
                if ("vdb".equals(elementName)) {
                    manifest = this.parseVdb(streamReader);
                    assert (manifest != null) : "manifest is null";
                } else {
                    LOGGER.debug("**** unhandled vdb read element ****", new Object[0]);
                }
            }
            return manifest;
        }
    }
}

