/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.teiid.ImportVdb;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.VdbDataRole;
import org.modeshape.sequencer.teiid.VdbEntry;
import org.modeshape.sequencer.teiid.VdbManifest;
import org.modeshape.sequencer.teiid.VdbModel;
import org.modeshape.sequencer.teiid.VdbTranslator;
import org.modeshape.sequencer.teiid.model.ModelSequencer;
import org.modeshape.sequencer.teiid.model.ReferenceResolver;

public class VdbSequencer
extends Sequencer {
    protected static final Logger LOGGER = Logger.getLogger(VdbSequencer.class);
    private static final String MANIFEST_FILE = "META-INF/vdb.xml";
    private static final Pattern VERSION_REGEX = Pattern.compile("(.*)[.]\\s*[+-]?([0-9]+)\\s*$");
    private ModelSequencer modelSequencer;
    private ReferenceResolver resolver;

    public static String extractVersionInfomation(String fileNameWithoutExtension, AtomicInteger version) {
        Matcher matcher = VERSION_REGEX.matcher(fileNameWithoutExtension);
        if (matcher.matches()) {
            fileNameWithoutExtension = matcher.group(1);
            version.set(Integer.parseInt(matcher.group(2)));
        }
        return fileNameWithoutExtension.replaceAll("[.]*$", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        LOGGER.debug("VdbSequencer.execute called:outputNode name='{0}', path='{1}'", new Object[]{outputNode.getName(), outputNode.getPath()});
        javax.jcr.Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        try (ZipInputStream vdbStream = new ZipInputStream(binaryValue.getStream());){
            VdbManifest manifest = null;
            ZipEntry entry = null;
            while ((entry = vdbStream.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entryName.endsWith(MANIFEST_FILE)) {
                    manifest = this.readManifest(binaryValue, vdbStream, outputNode, context);
                    continue;
                }
                if (!entry.isDirectory() && this.modelSequencer.hasModelFileExtension(entryName)) {
                    Node modelNode;
                    boolean sequenced;
                    LOGGER.debug("----before reading model '{0}'", new Object[]{entryName});
                    if (manifest == null) {
                        throw new Exception("VDB manifest file has not been read");
                    }
                    VdbModel vdbModel = manifest.getModel(entryName);
                    if (vdbModel == null) {
                        throw new Exception("Model '" + entryName + "' was not found");
                    }
                    int index = entryName.lastIndexOf(47) + 1;
                    if (index != -1 && index < entryName.length()) {
                        entryName = entryName.substring(index);
                    }
                    if (!(sequenced = this.modelSequencer.sequenceVdbModel(vdbStream, modelNode = outputNode.addNode(entryName, "vdb:model"), vdbModel, context))) {
                        modelNode.remove();
                        LOGGER.debug(">>>>model NOT sequenced '{0}'\n\n", new Object[]{entryName});
                        continue;
                    }
                    LOGGER.debug(">>>>done sequencing model '{0}'\n\n", new Object[]{entryName});
                    continue;
                }
                LOGGER.debug("----ignoring resource '{0}'", new Object[]{entryName});
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(TeiidI18n.errorReadingVdbFile.text(new Object[]{inputProperty.getPath(), e.getMessage()}), e);
        }
    }

    protected VdbManifest readManifest(javax.jcr.Binary binaryValue, InputStream inputStream, Node outputNode, Sequencer.Context context) throws Exception {
        LOGGER.debug("----before reading vdb.xml", new Object[0]);
        VdbManifest manifest = VdbManifest.read(inputStream, context);
        assert (manifest != null) : "manifest is null";
        outputNode.setPrimaryType("vdb:virtualDatabase");
        outputNode.addMixin("mix:referenceable");
        outputNode.setProperty("vdb:version", (long)manifest.getVersion());
        outputNode.setProperty("vdb:originalFile", outputNode.getPath());
        outputNode.setProperty("mode:sha1", ((Binary)binaryValue).getHexHash());
        this.setProperty(outputNode, "vdb:name", manifest.getName());
        this.setProperty(outputNode, "vdb:description", manifest.getDescription());
        this.setProperty(outputNode, "vdb:connectionType", manifest.getConnectionType());
        this.sequenceImportVdbs(manifest, outputNode);
        this.sequenceTranslators(manifest, outputNode);
        this.sequenceDataRoles(manifest, outputNode);
        this.sequenceEntries(manifest, outputNode);
        this.sequenceProperties(manifest, outputNode);
        this.sequenceDeclarativeModels(manifest, outputNode);
        LOGGER.debug(">>>>done reading vdb.xml\n\n", new Object[0]);
        return manifest;
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        LOGGER.debug("enter initialize", new Object[0]);
        this.registerNodeTypes("xmi.cnd", nodeTypeManager, true);
        LOGGER.debug("xmi.cnd loaded", new Object[0]);
        this.registerNodeTypes("med.cnd", nodeTypeManager, true);
        LOGGER.debug("med.cnd loaded", new Object[0]);
        this.registerNodeTypes("mmcore.cnd", nodeTypeManager, true);
        LOGGER.debug("mmcore.cnd loaded", new Object[0]);
        this.registerNodeTypes("vdb.cnd", nodeTypeManager, true);
        LOGGER.debug("vdb.cnd loaded", new Object[0]);
        this.resolver = new ReferenceResolver();
        this.modelSequencer = new ModelSequencer(this.resolver);
        this.modelSequencer.initialize(registry, nodeTypeManager);
        LOGGER.debug("exit initialize", new Object[0]);
    }

    private void sequenceDataRoles(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<VdbDataRole> dataRolesGroup = manifest.getDataRoles();
        if (!dataRolesGroup.isEmpty()) {
            Node dataRolesGroupNode = outputNode.addNode("vdb:dataRoles", "vdb:dataRoles");
            for (VdbDataRole dataRole : dataRolesGroup) {
                List<VdbDataRole.Permission> permissionsGroup;
                Node dataRoleNode = dataRolesGroupNode.addNode(dataRole.getName(), "vdb:dataRole");
                this.setProperty(dataRoleNode, "vdb:description", dataRole.getDescription());
                dataRoleNode.setProperty("vdb:anyAuthenticated", dataRole.isAnyAuthenticated());
                dataRoleNode.setProperty("vdb:allowCreateTemporaryTables", dataRole.isAllowCreateTempTables());
                dataRoleNode.setProperty("vdb:grantAll", dataRole.isGrantAll());
                List<String> roleNames = dataRole.getMappedRoleNames();
                if (!roleNames.isEmpty()) {
                    dataRoleNode.setProperty("vdb:mappedRoleNames", roleNames.toArray(new String[roleNames.size()]));
                }
                if ((permissionsGroup = dataRole.getPermissions()).isEmpty()) continue;
                Node permissionsGroupNode = dataRoleNode.addNode("vdb:permissions", "vdb:permissions");
                for (VdbDataRole.Permission permission : permissionsGroup) {
                    List<VdbDataRole.Mask> masks;
                    Node permissionNode = permissionsGroupNode.addNode(permission.getResourceName(), "vdb:permission");
                    permissionNode.setProperty("vdb:allowAlter", permission.canAlter());
                    permissionNode.setProperty("vdb:allowCreate", permission.canCreate());
                    permissionNode.setProperty("vdb:allowDelete", permission.canDelete());
                    permissionNode.setProperty("vdb:allowExecute", permission.canExecute());
                    permissionNode.setProperty("vdb:allowRead", permission.canRead());
                    permissionNode.setProperty("vdb:allowUpdate", permission.canUpdate());
                    permissionNode.setProperty("vdb:allowLanguage", permission.useLanguage());
                    List<VdbDataRole.Condition> conditions = permission.getConditions();
                    if (!conditions.isEmpty()) {
                        Node conditionsGroupNode = permissionNode.addNode("vdb:conditions", "vdb:conditions");
                        for (VdbDataRole.Condition condition : conditions) {
                            Node conditionNode = conditionsGroupNode.addNode(condition.getRule(), "vdb:condition");
                            conditionNode.setProperty("vdb:constraint", condition.isConstraint());
                        }
                    }
                    if ((masks = permission.getMasks()).isEmpty()) continue;
                    Node masksGroupNode = permissionNode.addNode("vdb:masks", "vdb:masks");
                    for (VdbDataRole.Mask mask : masks) {
                        Node maskNode = masksGroupNode.addNode(mask.getRule(), "vdb:mask");
                        maskNode.setProperty("vdb:order", (long)mask.getOrder());
                    }
                }
            }
        }
    }

    private void sequenceDeclarativeModels(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        for (VdbModel model : manifest.getModels()) {
            if (!model.isDeclarative()) continue;
            LOGGER.debug(">>>>writing declarative model '{0}'", new Object[]{model.getName()});
            Node modelNode = outputNode.addNode(model.getName(), "vdb:declarativeModel");
            this.setProperty(modelNode, "vdb:description", model.getDescription());
            modelNode.setProperty("vdb:visible", model.isVisible());
            this.setProperty(modelNode, "vdb:pathInVdb", model.getPathInVdb());
            this.setProperty(modelNode, "mmcore:modelType", model.getType());
            this.setProperty(modelNode, "vdb:metadataType", model.getMetadataType());
            this.setProperty(modelNode, "vdb:modelDefinition", model.getModelDefinition());
            List<VdbModel.Source> sources = model.getSources();
            if (sources.isEmpty()) continue;
            Node modelSourcesGroupNode = modelNode.addNode("vdb:sources", "vdb:sources");
            for (VdbModel.Source source : sources) {
                Node sourceNode = modelSourcesGroupNode.addNode(source.getName(), "vdb:source");
                sourceNode.setProperty("vdb:sourceTranslator", source.getTranslator());
                sourceNode.setProperty("vdb:sourceJndiName", source.getJndiName());
            }
        }
    }

    private void sequenceEntries(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<VdbEntry> entriesGroup = manifest.getEntries();
        if (!entriesGroup.isEmpty()) {
            Node entriesGroupNode = outputNode.addNode("vdb:entries", "vdb:entries");
            for (VdbEntry entry : entriesGroup) {
                Node entryNode = entriesGroupNode.addNode("vdb:entry", "vdb:entry");
                this.setProperty(entryNode, "vdb:path", entry.getPath());
                this.setProperty(entryNode, "vdb:description", entry.getDescription());
                Map<String, String> props = entry.getProperties();
                if (props.isEmpty()) continue;
                for (Map.Entry<String, String> prop : props.entrySet()) {
                    this.setProperty(entryNode, prop.getKey(), prop.getValue());
                }
            }
        }
    }

    private void sequenceImportVdbs(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<ImportVdb> importVdbsGroup = manifest.getImportVdbs();
        if (!importVdbsGroup.isEmpty()) {
            Node importVdbsGroupNode = outputNode.addNode("vdb:importVdbs", "vdb:importVdbs");
            for (ImportVdb importVdb : importVdbsGroup) {
                Node importVdbNode = importVdbsGroupNode.addNode(importVdb.getName(), "vdb:importVdb");
                importVdbNode.setProperty("vdb:version", (long)importVdb.getVersion());
                importVdbNode.setProperty("vdb:importDataPolicies", importVdb.isImportDataPolicies());
            }
        }
    }

    private void sequenceProperties(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        Map<String, String> props = manifest.getProperties();
        if (!props.isEmpty()) {
            for (Map.Entry<String, String> prop : props.entrySet()) {
                if ("preview".equals(prop.getKey())) {
                    outputNode.setProperty("vdb:preview", Boolean.parseBoolean(prop.getValue()));
                    continue;
                }
                this.setProperty(outputNode, prop.getKey(), prop.getValue());
            }
        }
    }

    private void sequenceTranslators(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<VdbTranslator> translatorsGroup = manifest.getTranslators();
        if (!translatorsGroup.isEmpty()) {
            Node translatorsGroupNode = outputNode.addNode("vdb:translators", "vdb:translators");
            for (VdbTranslator translator : translatorsGroup) {
                Node translatorNode = translatorsGroupNode.addNode(translator.getName(), "vdb:translator");
                this.setProperty(translatorNode, "vdb:type", translator.getType());
                this.setProperty(translatorNode, "vdb:description", translator.getDescription());
                Map<String, String> props = translator.getProperties();
                if (props.isEmpty()) continue;
                for (Map.Entry<String, String> prop : props.entrySet()) {
                    this.setProperty(translatorNode, prop.getKey(), prop.getValue());
                }
            }
        }
    }

    private void setProperty(Node node, String name, String value) throws Exception {
        assert (node != null);
        assert (!StringUtil.isBlank((String)name));
        if (!StringUtil.isBlank((String)value)) {
            node.setProperty(name, value);
        }
    }
}

