/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.video;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.video.StreamMetadata;
import org.modeshape.sequencer.video.VideoMetadata;

public class VideoMetadataSequencer
extends Sequencer {
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.registerNodeTypes("video.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(VideoMetadata.MIME_TYPE_STRINGS);
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = (Binary)inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        String mimeType = binaryValue.getMimeType();
        Node sequencedNode = this.getMetadataNode(outputNode);
        this.setPropertyIfMetadataPresent(sequencedNode, "jcr:mimeType", mimeType);
        return this.processBasicMetadata(sequencedNode, binaryValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processBasicMetadata(Node sequencedNode, Binary binaryValue) {
        VideoMetadata metadata = null;
        try (InputStream stream = binaryValue.getStream();){
            metadata = new VideoMetadata(stream);
            if (!metadata.check()) return false;
            this.setPropertyIfMetadataPresent(sequencedNode, "video:duration", metadata.getDuration());
            this.setPropertyIfMetadataPresent(sequencedNode, "video:bitrate", metadata.getBitrate());
            this.setPropertyIfMetadataPresent(sequencedNode, "video:title", metadata.getTitle());
            this.setPropertyIfMetadataPresent(sequencedNode, "video:comment", metadata.getComment());
            this.setPropertyIfMetadataPresent(sequencedNode, "video:encoder", metadata.getEncoder());
            int suffix = 0;
            for (StreamMetadata streamMetadata : metadata.getStreams()) {
                Node streamNode = sequencedNode.addNode("video:stream" + String.valueOf(suffix), "video:stream");
                this.processStreamMetadata(streamNode, streamMetadata);
                ++suffix;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.getLogger().error((Throwable)e, "Couldn't process the stream.", new Object[0]);
        }
        return false;
    }

    private boolean processStreamMetadata(Node streamNode, StreamMetadata stream) throws RepositoryException {
        this.setPropertyIfMetadataPresent(streamNode, "video:streamType", stream.getStreamType());
        this.setPropertyIfMetadataPresent(streamNode, "video:codec", stream.getCodec());
        this.setPropertyIfMetadataPresent(streamNode, "video:bitrate", stream.getBitrate());
        this.setPropertyIfMetadataPresent(streamNode, "video:framerate", stream.getFramerate());
        this.setPropertyIfMetadataPresent(streamNode, "video:samplerate", stream.getSamplerate());
        this.setPropertyIfMetadataPresent(streamNode, "video:channels", stream.getChannels());
        this.setPropertyIfMetadataPresent(streamNode, "video:width", stream.getWidth());
        this.setPropertyIfMetadataPresent(streamNode, "video:height", stream.getHeight());
        return true;
    }

    private Node getMetadataNode(Node outputNode) throws RepositoryException {
        if (outputNode.isNew()) {
            outputNode.setPrimaryType("video:metadata");
            return outputNode;
        }
        return outputNode.addNode("video:metadata", "video:metadata");
    }

    private void setPropertyIfMetadataPresent(Node node, String propertyName, Object value) throws RepositoryException {
        if (value == null) {
            return;
        }
        if (value instanceof String && !StringUtil.isBlank((String)((String)value))) {
            node.setProperty(propertyName, (String)value);
        } else if (value instanceof Boolean) {
            node.setProperty(propertyName, ((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            node.setProperty(propertyName, ((Double)value).doubleValue());
        } else if (value instanceof Number) {
            node.setProperty(propertyName, ((Number)value).longValue());
        } else if (value instanceof Calendar) {
            node.setProperty(propertyName, (Calendar)value);
        } else if (value instanceof byte[]) {
            ByteArrayInputStream is = new ByteArrayInputStream((byte[])value);
            javax.jcr.Binary binaryProperty = node.getSession().getValueFactory().createBinary((InputStream)is);
            node.setProperty(propertyName, binaryProperty);
        } else if (value instanceof List) {
            ValueFactory vf = node.getSession().getValueFactory();
            List<Value> values = ((List)value).stream().filter(val -> val instanceof String).map(val -> vf.createValue((String)val)).collect(Collectors.toList());
            if (!values.isEmpty()) {
                node.setProperty(propertyName, values.toArray(new Value[values.size()]));
            }
        } else {
            this.getLogger().warn("The value of the property {0} has unknown type and couldn't be saved.", new Object[]{propertyName});
        }
    }
}

